/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.ui;

import com.intellij.ui.AbstractExpandableItemsHandler;
import com.intellij.ui.CellRendererPanel;
import com.intellij.ui.ClientProperty;
import com.intellij.ui.ExpandableItemsHandler;
import com.intellij.ui.SeparatorWithText;
import com.intellij.ui.components.panels.OpaquePanel;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.CellRendererPane;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;

public abstract class MultiSeparatorListCellRenderer<Item>
extends CellRendererPanel
implements ListCellRenderer<Item> {
    protected final OpaquePanel mySeparatorsPanel = new OpaquePanel();
    private final List<SeparatorWithText> mySeparators = new ArrayList<SeparatorWithText>();
    private final Container myValidationParent = new CellRendererPane();

    public MultiSeparatorListCellRenderer(JList<? extends Item> list) {
        this.setLayout(new BoxLayout((Container)((Object)this), 1));
        list.add(this.myValidationParent);
        this.mySeparatorsPanel.setLayout((LayoutManager)new BoxLayout((Container)this.mySeparatorsPanel, 1));
    }

    protected abstract JComponent getItemCellRendererComponent(JList<? extends Item> var1, Item var2, int var3, boolean var4, boolean var5);

    protected abstract Collection<Object> getSeparatorsAbove(int var1);

    protected abstract void configureSeparator(@NotNull SeparatorWithText var1, @NotNull Object var2);

    @Override
    public Component getListCellRendererComponent(JList<? extends Item> list, Item value, int index, boolean isSelected, boolean cellHasFocus) {
        Collection<Object> separators = this.getSeparatorsAbove(index);
        JComponent itemComponent = this.getItemCellRendererComponent(list, value, index, isSelected, cellHasFocus);
        this.rebuildChildren(separators, itemComponent);
        this.setPreferredSize(null);
        this.validate();
        boolean forExpansion = list != null && ClientProperty.isTrue(list, (Object)ExpandableItemsHandler.EXPANDED_RENDERER);
        Boolean value1 = forExpansion ? Boolean.valueOf(true) : null;
        itemComponent.putClientProperty(ExpandableItemsHandler.USE_RENDERER_BOUNDS, value1);
        if (forExpansion) {
            Rectangle bounds = list.getCellBounds(index, index);
            bounds.setSize(this.getPreferredSize().width, bounds.height);
            AbstractExpandableItemsHandler.setRelativeBounds((Component)((Object)this), (Rectangle)bounds, (Component)itemComponent, (Container)this.myValidationParent);
            return itemComponent;
        }
        return this;
    }

    @NotNull
    protected SeparatorWithText createSeparator() {
        SeparatorWithText separator = new SeparatorWithText();
        separator.setCaptionCentered(false);
        SeparatorWithText separatorWithText = separator;
        if (separatorWithText == null) {
            MultiSeparatorListCellRenderer.$$$reportNull$$$0(0);
        }
        return separatorWithText;
    }

    private void rebuildChildren(@NotNull Collection<Object> separators, @NotNull JComponent itemComponent) {
        if (separators == null) {
            MultiSeparatorListCellRenderer.$$$reportNull$$$0(1);
        }
        if (itemComponent == null) {
            MultiSeparatorListCellRenderer.$$$reportNull$$$0(2);
        }
        int separatorCount = separators.size();
        while (this.mySeparators.size() < separatorCount) {
            this.mySeparators.add(this.createSeparator());
        }
        int i = 0;
        for (Object object : separators) {
            this.configureSeparator(this.mySeparators.get(i), object);
            ++i;
        }
        if (separators.isEmpty() && this.getComponentCount() == 1 && this.getComponent(0) == itemComponent) {
            return;
        }
        this.mySeparatorsPanel.removeAll();
        this.removeAll();
        for (SeparatorWithText separatorWithText : this.mySeparators.subList(0, separatorCount)) {
            this.mySeparatorsPanel.add((Component)separatorWithText);
        }
        if (separatorCount != 0) {
            this.add((Component)this.mySeparatorsPanel);
        }
        this.add(itemComponent);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/view/ui/MultiSeparatorListCellRenderer";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "separators";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "itemComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createSeparator";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/view/ui/MultiSeparatorListCellRenderer";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "rebuildChildren";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2 -> new IllegalArgumentException(string);
        };
    }
}

