/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dsm.actions;

import com.intellij.dsm.actions.AbstractDsmAction;
import com.intellij.dsm.actions.DsmUIUtil;
import com.intellij.dsm.model.DsmModel;
import com.intellij.dsm.model.DsmModelImpl;
import com.intellij.dsm.model.DsmModelUtil;
import com.intellij.dsm.model.DsmTreeStructure;
import com.intellij.dsm.ui.DsmDataKeys;
import com.intellij.dsm.ui.DsmSelection;
import com.intellij.dsm.ui.DsmTable;
import com.intellij.dsm.ui.DsmView;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import java.lang.invoke.LambdaMetafactory;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Predicate;
import org.gga.graph.Subgraph;
import org.gga.graph.maps.DataGraph;
import org.jetbrains.annotations.NotNull;

public final class LimitDependenciesAction<N>
extends AbstractDsmAction<N>
implements DumbAware {
    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            LimitDependenciesAction.$$$reportNull$$$0(0);
        }
        this.onAction(e);
    }

    private void onAction(AnActionEvent e) {
        Collection selection = this.getSelection(e);
        assert (selection != null);
        DsmModel dsmModel = this.getModel(e);
        assert (dsmModel != null);
        DsmTable table = this.getTable(e);
        assert (table != null);
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        HashSet includedNodes = new HashSet();
        block4: for (DsmSelection s : selection) {
            switch (s.type) {
                case CELL: {
                    DsmModelUtil.collectLeafData(s.node1, includedNodes);
                    DsmModelUtil.collectLeafData(s.node2, includedNodes);
                    continue block4;
                }
                case ROW: {
                    DsmModelUtil.collectLeafData(s.node1, includedNodes);
                    continue block4;
                }
            }
            assert (false);
        }
        DataGraph graph = dsmModel.getGraph();
        DataGraph newGraph = (DataGraph)Subgraph.subgraph(graph, (Predicate<Object>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$onAction$0(java.util.Set java.lang.Object ), (Ljava/lang/Object;)Z)(includedNodes)).first;
        String name = LimitDependenciesAction.getNewName(selection);
        DsmTreeStructure oldTreeStructure = dsmModel.getTreeStructure();
        DsmUIUtil.showView(project, new DsmView(new DsmModelImpl(newGraph, oldTreeStructure.createNewStructure(newGraph), dsmModel.getNodeClass()), table.getSettings()), name);
    }

    @NlsSafe
    private static <N> String getNewName(Collection<DsmSelection<N>> selection) {
        TreeSet<String> names = new TreeSet<String>();
        block4: for (DsmSelection<N> s : selection) {
            switch (s.type) {
                case CELL: {
                    names.add(DsmModelUtil.getShortName(s.node1));
                    names.add(DsmModelUtil.getShortName(s.node2));
                    continue block4;
                }
                case ROW: {
                    names.add(DsmModelUtil.getShortName(s.node1));
                    continue block4;
                }
            }
            assert (false);
        }
        String s = StringUtil.join(names, (String)", ");
        int l = 40;
        return s.length() > 40 ? StringUtil.first((String)s, (int)40, (boolean)true) : s;
    }

    @Override
    protected boolean isEnabled(AnActionEvent e) {
        if (!super.isEnabled(e)) {
            return false;
        }
        Collection selection = (Collection)e.getData(DsmDataKeys.SELECTION);
        return selection != null && !selection.isEmpty();
    }

    private static /* synthetic */ boolean lambda$onAction$0(Set includedNodes, Object n) {
        return includedNodes.contains(n);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/dsm/actions/LimitDependenciesAction", "actionPerformed"));
    }
}

