/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dsm.model.classes;

import com.intellij.analysis.AnalysisScope;
import com.intellij.analysis.BaseClassesAnalysisAction;
import com.intellij.dsm.DsmBundle;
import com.intellij.dsm.model.DsmModel;
import com.intellij.dsm.model.DsmModelImpl;
import com.intellij.dsm.model.classes.ClassNode;
import com.intellij.dsm.model.classes.ClassesTopToBottomTreeStructure;
import com.intellij.dsm.model.classes.DependencyVisitor;
import com.intellij.dsm.settings.DsmViewSettings;
import com.intellij.java.analysis.bytecode.ClassFileAnalyzer;
import com.intellij.java.analysis.bytecode.JvmBytecodeAnalysis;
import com.intellij.java.analysis.bytecode.JvmBytecodeReferenceProcessor;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.compiler.CompilerPaths;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModuleFileIndex;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.SmartList;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.atomic.LongAdder;
import java.util.stream.Stream;
import javax.swing.SwingUtilities;
import org.gga.graph.impl.DataGraphImpl;
import org.gga.graph.maps.DataGraph;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JavaModuleSourceRootTypes;

public final class ClassesDsmModelBuilder {
    private static final Logger LOG = Logger.getInstance(ClassesDsmModelBuilder.class);
    @NonNls
    static final String CLASS_SUFFIX = ".class";
    private final Project myProject;
    private final AnalysisScope myScope;
    private final boolean myShowExternalDependencies;
    private final ProgressIndicator myProgressIndicator;

    public ClassesDsmModelBuilder(@NotNull Project project, @NotNull AnalysisScope scope, boolean showExternalDependencies, @NotNull ProgressIndicator indicator) {
        if (project == null) {
            ClassesDsmModelBuilder.$$$reportNull$$$0(0);
        }
        if (scope == null) {
            ClassesDsmModelBuilder.$$$reportNull$$$0(1);
        }
        if (indicator == null) {
            ClassesDsmModelBuilder.$$$reportNull$$$0(2);
        }
        this.myProject = project;
        this.myScope = scope;
        this.myShowExternalDependencies = showExternalDependencies;
        this.myProgressIndicator = indicator;
    }

    @Nullable
    public DsmModel<ClassNode> build(@NotNull DsmViewSettings settings) {
        int totalClassCount;
        long timestamp;
        if (settings == null) {
            ClassesDsmModelBuilder.$$$reportNull$$$0(3);
        }
        if (this.myProject.isDisposed()) {
            return null;
        }
        ConcurrentHashMap<Module, List<Path>> classFiles = new ConcurrentHashMap<Module, List<Path>>();
        try {
            timestamp = System.currentTimeMillis();
            totalClassCount = this.collectClassFiles(classFiles);
            LOG.info("DSM: Collecting classes took " + (System.currentTimeMillis() - timestamp) + " ms");
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
            SwingUtilities.invokeLater(() -> Messages.showErrorDialog((Project)this.myProject, (String)e.getMessage(), (String)DsmBundle.message("io.error.occurred", new Object[0])));
            return null;
        }
        if (totalClassCount == 0) {
            SwingUtilities.invokeLater(() -> Messages.showErrorDialog((Project)this.myProject, (String)DsmBundle.message("no.class.files.were.found.n.dsm.analysis.can.t.be.performed", new Object[0]), (String)DsmBundle.message("no.classes.found", new Object[0])));
            return null;
        }
        this.myProgressIndicator.setIndeterminate(false);
        this.myProgressIndicator.setText(DsmBundle.message("analyzing.class.files", new Object[0]));
        timestamp = System.currentTimeMillis();
        LongAdder progress = new LongAdder();
        ConcurrentLinkedDeque results = new ConcurrentLinkedDeque();
        Stream stream = Registry.is((String)"dsm.analyze.class.files.in.parallel") ? classFiles.entrySet().parallelStream() : classFiles.entrySet().stream();
        stream.forEach(entry -> {
            List files = (List)entry.getValue();
            if (files.isEmpty()) {
                return;
            }
            DependencyVisitor v = new DependencyVisitor();
            ClassFileAnalyzer analyzer = JvmBytecodeAnalysis.getInstance().createReferenceAnalyzer((JvmBytecodeReferenceProcessor)v);
            v.setCurrentModule((Module)entry.getKey());
            for (Path file : files) {
                this.myProgressIndicator.checkCanceled();
                this.myProgressIndicator.setText2(file.toString());
                try {
                    analyzer.processFile(file);
                }
                catch (Exception e) {
                    LOG.error("failure processing " + String.valueOf(file), (Throwable)e);
                }
                finally {
                    progress.increment();
                    double value = progress.sum();
                    this.myProgressIndicator.setFraction(0.3 + 0.7 * (value / (double)totalClassCount));
                }
            }
            results.add(v.getDependencies().getMap());
        });
        HashMap depMap = new HashMap();
        for (Map result : results) {
            depMap.putAll(result);
        }
        LOG.info("DSM: Analyzing class files took " + (System.currentTimeMillis() - timestamp) + " ms");
        timestamp = System.currentTimeMillis();
        this.myProgressIndicator.setIndeterminate(true);
        this.myProgressIndicator.setText(DsmBundle.message("building.dependency.matrix", new Object[0]));
        DataGraph<ClassNode, Integer> depGraph = this.computeGraph(depMap);
        ClassesTopToBottomTreeStructure nodesTreeStructure = new ClassesTopToBottomTreeStructure(depGraph, settings, this.myProject);
        LOG.info("DSM: Building graph took " + (System.currentTimeMillis() - timestamp) + " ms");
        return new DsmModelImpl<ClassNode>(depGraph, nodesTreeStructure, ClassNode.class);
    }

    private DataGraph<ClassNode, Integer> computeGraph(Map<ClassNode, ? extends Object2IntMap<String>> depMap) {
        Module module;
        DataGraphImpl<ClassNode, Integer> result;
        HashSet<String> multipleClasses = new HashSet<String>();
        HashMap<String, Module> moduleMap = new HashMap<String, Module>();
        if (this.myShowExternalDependencies) {
            HashSet<String> classes = new HashSet<String>();
            for (Map.Entry<ClassNode, ? extends Object2IntMap<String>> entry : depMap.entrySet()) {
                ClassNode classNode = entry.getKey();
                classes.add(classNode.className);
                Object2IntMap<String> deps = entry.getValue();
                classes.addAll((Collection<String>)deps.keySet());
            }
            result = new DataGraphImpl(classes.size(), true);
        } else {
            result = new DataGraphImpl<ClassNode, Integer>(depMap.size(), true);
        }
        int v = 0;
        for (ClassNode classNode : depMap.keySet()) {
            String className = classNode.className;
            module = classNode.getModule();
            assert (module != null);
            if (moduleMap.containsKey(className)) {
                moduleMap.remove(className);
                multipleClasses.add(className);
            } else if (!multipleClasses.contains(className)) {
                moduleMap.put(className, module);
            }
            result.setNode(v, classNode);
            ++v;
        }
        for (Map.Entry entry : depMap.entrySet()) {
            ClassNode node = (ClassNode)entry.getKey();
            module = node.getModule();
            assert (module != null);
            ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)module);
            ModuleFileIndex moduleFileIndex = moduleRootManager.getFileIndex();
            Object2IntMap deps = (Object2IntMap)entry.getValue();
            for (String toName : deps.keySet()) {
                ClassNode node2;
                Module toModule = (Module)moduleMap.get(toName);
                if (toModule == null) {
                    if (!this.myShowExternalDependencies && !multipleClasses.contains(toName)) continue;
                    toModule = (Module)ReadAction.compute(() -> {
                        PsiClass aClass = JavaPsiFacade.getInstance((Project)this.myProject).findClass(toName, module.getModuleScope(this.myScope.isIncludeTestSource()));
                        return aClass == null ? null : ModuleUtilCore.findModuleForPsiElement((PsiElement)aClass);
                    });
                }
                if (toModule != null) {
                    node2 = new ClassNode(toName, toModule);
                } else {
                    if (!this.myShowExternalDependencies) continue;
                    OrderEntry orderEntry = (OrderEntry)ReadAction.compute(() -> {
                        GlobalSearchScope scope = module.getModuleWithDependenciesAndLibrariesScope(this.myScope.isIncludeTestSource());
                        PsiClass aClass = JavaPsiFacade.getInstance((Project)this.myProject).findClass(toName, scope);
                        return aClass != null ? moduleFileIndex.getOrderEntryForFile(aClass.getContainingFile().getVirtualFile()) : null;
                    });
                    if (orderEntry == null) {
                        throw new NullPointerException(toName);
                    }
                    node2 = new ClassNode(toName, orderEntry);
                }
                if (result.getIndex(node2) == -1) {
                    result.setNode(v, node2);
                    ++v;
                }
                result.insert(node, node2, deps.getInt((Object)toName));
            }
        }
        return result;
    }

    private int collectClassFiles(Map<Module, List<Path>> module2classFiles) {
        LongAdder totalFiles = new LongAdder();
        this.myProgressIndicator.setIndeterminate(false);
        this.myProgressIndicator.setText(DsmBundle.message("collecting.class.files", new Object[0]));
        Set<Module> modules = BaseClassesAnalysisAction.getScopeModules(this.myScope);
        int total = modules.size();
        Stream stream = Registry.is((String)"dsm.collect.class.files.in.parallel") ? modules.parallelStream() : modules.stream();
        stream.forEach(module -> {
            String tests;
            SourcesFinder finder = new SourcesFinder((Module)module);
            if (!finder.hasSourceRoots()) {
                return;
            }
            String production = CompilerPaths.getModuleOutputPath((Module)module, (boolean)false);
            ArrayList<Path> classFiles = new ArrayList<Path>();
            if (production != null) {
                totalFiles.add(this.collectClassFiles("", Path.of(production, new String[0]), false, finder, classFiles));
            }
            if (this.myScope.isIncludeTestSource() && (tests = CompilerPaths.getModuleOutputPath((Module)module, (boolean)true)) != null && !tests.equals(production)) {
                totalFiles.add(this.collectClassFiles("", Path.of(tests, new String[0]), true, finder, classFiles));
            }
            module2classFiles.put((Module)module, (List<Path>)classFiles);
            double finished = module2classFiles.size();
            this.myProgressIndicator.setFraction(finished / (double)total * 0.3);
        });
        return (int)totalFiles.sum();
    }

    private int collectClassFiles(String relativePath, Path file, boolean isTests, SourcesFinder finder, List<Path> container) {
        int collected;
        block11: {
            String path;
            Boolean inScopeFile;
            collected = 0;
            if (Files.isDirectory(file, new LinkOption[0])) {
                try (DirectoryStream<Path> children = Files.newDirectoryStream(file);){
                    for (Path child : children) {
                        String newPath = relativePath.isEmpty() ? child.getFileName().toString() : relativePath + "/" + String.valueOf(child.getFileName());
                        collected += this.collectClassFiles(newPath, child, isTests, finder, container);
                    }
                    break block11;
                }
                catch (IOException e) {
                    LOG.error((Throwable)e);
                    return 0;
                }
            }
            if (relativePath.endsWith(CLASS_SUFFIX) && (inScopeFile = (Boolean)ReadAction.compute(() -> this.lambda$collectClassFiles$6(finder, path = relativePath.substring(0, relativePath.length() - CLASS_SUFFIX.length()), isTests))).booleanValue()) {
                container.add(file);
                ++collected;
            }
        }
        return collected;
    }

    private /* synthetic */ Boolean lambda$collectClassFiles$6(SourcesFinder finder, String path, boolean isTests) throws RuntimeException {
        VirtualFile srcFile = finder.findSourceFile(path, isTests);
        return srcFile != null && this.myScope.contains(srcFile);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
        }
        objectArray2[1] = "com/intellij/dsm/model/classes/ClassesDsmModelBuilder";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "build";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class SourcesFinder {
        private final Module myModule;
        private final Collection<Pair<VirtualFile, String>> myProductionRoots = new SmartList();
        private final Collection<Pair<VirtualFile, String>> myTestRoots = new SmartList();
        private final GlobalSearchScope myProductionScope;
        private final GlobalSearchScope myTestScope;

        SourcesFinder(Module module) {
            this.myModule = module;
            this.myProductionScope = this.myModule.getModuleScope(false);
            this.myTestScope = this.myModule.getModuleScope(true).intersectWith(GlobalSearchScope.notScope((GlobalSearchScope)this.myProductionScope));
            ModuleRootManager rootManager = ModuleRootManager.getInstance((Module)module);
            for (ContentEntry entry : rootManager.getContentEntries()) {
                for (SourceFolder folder : entry.getSourceFolders(JavaModuleSourceRootTypes.SOURCES)) {
                    VirtualFile srcRoot = folder.getFile();
                    if (srcRoot == null) continue;
                    Collection<Pair<VirtualFile, String>> container = folder.isTestSource() ? this.myTestRoots : this.myProductionRoots;
                    Object prefix = folder.getPackagePrefix().replace('.', '/');
                    if (!((String)prefix).isEmpty() && !((String)prefix).endsWith("/")) {
                        prefix = (String)prefix + "/";
                    }
                    container.add((Pair<VirtualFile, String>)Pair.create((Object)srcRoot, (Object)prefix));
                }
            }
        }

        boolean hasSourceRoots() {
            return !this.myProductionRoots.isEmpty() || !this.myTestRoots.isEmpty();
        }

        VirtualFile findSourceFile(String relativePath, boolean inTests) {
            VirtualFile srcFile;
            Collection<Pair<VirtualFile, String>> roots;
            Collection<Pair<VirtualFile, String>> collection = roots = inTests ? this.myTestRoots : this.myProductionRoots;
            if (roots.isEmpty()) {
                return null;
            }
            int idx = relativePath.lastIndexOf("/");
            String parentDirPath = idx >= 0 ? relativePath.substring(0, idx) : "";
            String className = idx >= 0 ? relativePath.substring(idx + 1) : relativePath;
            for (Pair<VirtualFile, String> root : roots) {
                VirtualFile parentDir;
                String prefix = (String)root.second;
                String dirPath = parentDirPath;
                if (!prefix.isEmpty()) {
                    if (!parentDirPath.startsWith(prefix)) continue;
                    dirPath = parentDirPath.substring(prefix.length());
                }
                if ((parentDir = ((VirtualFile)root.first).findFileByRelativePath(dirPath)) == null || (srcFile = SourcesFinder.findFileByClassName(parentDir, className)) == null) continue;
                return srcFile;
            }
            JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)this.myModule.getProject());
            GlobalSearchScope scope = inTests ? this.myTestScope : this.myProductionScope;
            String qName = relativePath.replace('/', '.');
            while (true) {
                int dollarIndex;
                PsiClass aClass;
                if ((aClass = facade.findClass(qName, scope)) != null) {
                    PsiFile containingFile = aClass.getOriginalElement().getContainingFile();
                    VirtualFile virtualFile = srcFile = containingFile != null ? containingFile.getVirtualFile() : null;
                    if (srcFile != null) {
                        return srcFile;
                    }
                }
                if ((dollarIndex = qName.lastIndexOf("$")) < 0) break;
                qName = qName.substring(0, dollarIndex);
            }
            return null;
        }

        @Nullable
        private static VirtualFile findFileByClassName(VirtualFile parent, String className) {
            String name = className;
            while (true) {
                for (VirtualFile file : parent.getChildren()) {
                    if (file.isDirectory() || !FileUtilRt.pathsEqual((String)name, (String)file.getNameWithoutExtension())) continue;
                    return file;
                }
                int dollarIndex = name.lastIndexOf("$");
                if (dollarIndex < 0) break;
                name = name.substring(0, dollarIndex);
            }
            return null;
        }
    }
}

