/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dsm.model.classes;

import com.intellij.dsm.model.DsmTreeStructure;
import com.intellij.dsm.model.classes.ClassNode;
import com.intellij.dsm.model.classes.FlattenPackagesSplitter;
import com.intellij.dsm.model.classes.ModuleGroupSplitter;
import com.intellij.dsm.model.classes.ModuleSplitter;
import com.intellij.dsm.model.classes.PackagesSplitter;
import com.intellij.dsm.model.classes.TopToBottomTreeStructure;
import com.intellij.dsm.settings.DsmViewSettings;
import com.intellij.openapi.module.ModuleGrouper;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import javax.swing.Icon;
import org.gga.graph.maps.DataGraph;
import org.jetbrains.annotations.NotNull;

public final class ClassesTopToBottomTreeStructure
extends TopToBottomTreeStructure<ClassNode> {
    private final DsmViewSettings mySettings;
    private final Project myProject;

    ClassesTopToBottomTreeStructure(@NotNull DataGraph<ClassNode, Integer> dataGraph, @NotNull DsmViewSettings settings, Project project) {
        if (dataGraph == null) {
            ClassesTopToBottomTreeStructure.$$$reportNull$$$0(0);
        }
        if (settings == null) {
            ClassesTopToBottomTreeStructure.$$$reportNull$$$0(1);
        }
        super(dataGraph);
        this.mySettings = settings;
        this.myProject = project;
        this.updateSplitters();
    }

    private void updateSplitters() {
        ArrayList<TopToBottomTreeStructure.TreeSplitter<ClassNode>> splitters = new ArrayList<TopToBottomTreeStructure.TreeSplitter<ClassNode>>();
        splitters.add(new ModuleGroupSplitter(this.isGroupByModuleGroups() ? ModuleGrouper.instanceFor((Project)this.myProject) : null));
        if (this.isGroupByModules()) {
            splitters.add(new ModuleSplitter(this.isGroupByModuleGroups() ? ModuleGrouper.instanceFor((Project)this.myProject) : null));
        }
        if (this.isGroupByPackages()) {
            if (this.isFlattenPackages()) {
                splitters.add(new FlattenPackagesSplitter());
            } else {
                splitters.add(new PackagesSplitter());
            }
        }
        this.setTreeSplitters(splitters.toArray(new TopToBottomTreeStructure.TreeSplitter[0]));
    }

    public boolean isGroupByModuleGroups() {
        return this.mySettings.isGroupByModuleGroups();
    }

    public void setGroupByModuleGroups(boolean groupByModuleGroups) {
        this.mySettings.setGroupByModuleGroups(groupByModuleGroups);
        this.updateSplitters();
    }

    public boolean isGroupByModules() {
        return this.mySettings.isGroupByModules();
    }

    public void setGroupByModules(boolean groupByModules) {
        this.mySettings.setGroupByModules(groupByModules);
        this.updateSplitters();
    }

    public boolean isFlattenPackages() {
        return this.mySettings.isFlattenPackages();
    }

    public void setFlattenPackages(boolean flattenPackages) {
        this.mySettings.setFlattenPackages(flattenPackages);
        this.updateSplitters();
    }

    public boolean isGroupByPackages() {
        return this.mySettings.isGroupByPackages();
    }

    public void setGroupByPackages(boolean groupByPackages) {
        this.mySettings.setGroupByPackages(groupByPackages);
        this.updateSplitters();
    }

    @Override
    protected String getLeafShortName(ClassNode classNode) {
        return this.isGroupByPackages() ? classNode.getShortClassName() : classNode.className;
    }

    @Override
    @NotNull
    protected String getLeafFullName(ClassNode classNode) {
        String string = classNode.className;
        if (string == null) {
            ClassesTopToBottomTreeStructure.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    protected Icon getLeafIcon(ClassNode classNode) {
        return classNode.getIcon();
    }

    @Override
    @NotNull
    public DsmTreeStructure<ClassNode> createNewStructure(DataGraph<ClassNode, Integer> dataGraph) {
        return new ClassesTopToBottomTreeStructure(dataGraph, this.mySettings.createCopy(), this.myProject);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataGraph";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/dsm/model/classes/ClassesTopToBottomTreeStructure";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/dsm/model/classes/ClassesTopToBottomTreeStructure";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getLeafFullName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

