/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dsm.model.classes;

import com.intellij.dsm.model.DsmModelUtil;
import com.intellij.dsm.model.DsmTreeStructure;
import com.intellij.dsm.model.classes.AbstractDsmTreeStructure;
import com.intellij.dsm.model.classes.NodeImpl;
import com.intellij.dsm.model.classes.NodePartitioner;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import javax.swing.Icon;
import org.gga.graph.maps.DataGraph;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Unmodifiable;

public abstract class TopToBottomTreeStructure<N>
extends AbstractDsmTreeStructure<N> {
    TreeSplitter<N>[] myTreeSplitters = new TreeSplitter[0];

    protected TopToBottomTreeStructure(DataGraph<N, Integer> dataGraph) {
        super(dataGraph);
    }

    public void setTreeSplitters(TreeSplitter<N>[] treeSplitters) {
        this.fireBeforeTreeStructureChange();
        this.myTreeSplitters = treeSplitters;
        this.resetTreeStructure();
        this.fireAfterTreeStructureChange();
    }

    @Override
    protected DsmTreeStructure.TreeNode<N> createRoot() {
        return new TreeNodeImpl<Object>(null, 0, this, n -> true, null);
    }

    protected abstract String getLeafShortName(N var1);

    @NotNull
    protected abstract String getLeafFullName(N var1);

    protected Icon getLeafIcon(N n) {
        return null;
    }

    public static interface TreeSplitter<N> {
        public @Unmodifiable List<Pair<Predicate<N>, NodeData>> split(DataGraph<N, Integer> var1, Predicate<N> var2, NodeData var3);
    }

    private static final class TreeNodeImpl<N>
    extends NodeImpl<N> {
        private NodeImpl<N>[] myChildren;
        private DsmTreeStructure.TreeNode<N>[] myRawChildren;
        private final TopToBottomTreeStructure<N> myTreeStructure;
        private final Predicate<N> myMemberFunction;
        private final int mySplitterIndex;
        private final NodeData myNodeData;

        TreeNodeImpl(DsmTreeStructure.TreeNode<N> parent, int splitterIndex, TopToBottomTreeStructure<N> treeStructure, Predicate<N> memberFunction, NodeData nodeData) {
            super(parent);
            this.mySplitterIndex = splitterIndex;
            this.myNodeData = nodeData;
            this.myTreeStructure = treeStructure;
            this.myMemberFunction = memberFunction;
        }

        @Override
        public boolean isLeaf() {
            return false;
        }

        @Override
        public N getLeafData() {
            throw new UnsupportedOperationException("Method getLeafData not implemented in " + String.valueOf(this.getClass()));
        }

        @Override
        public int getLeafIndex() {
            throw new UnsupportedOperationException("Method getLeafIndex not implemented in " + String.valueOf(this.getClass()));
        }

        @Override
        public DsmTreeStructure.TreeNode<N>[] getChildren() {
            if (this.myChildren != null) {
                return this.myChildren;
            }
            this.myChildren = NodePartitioner.partition((NodeImpl[])this.computeChildren(this.mySplitterIndex, this.myMemberFunction), this.myTreeStructure.getGraph(), (NodeImpl)this);
            return this.myChildren;
        }

        private boolean areNoChildrenLost() {
            DataGraph graph = this.myTreeStructure.getGraph();
            int rawCount = 0;
            for (int i = 0; i < graph.V(); ++i) {
                Object n = graph.getNode(i);
                if (!this.myMemberFunction.test(n)) continue;
                ++rawCount;
            }
            return DsmModelUtil.countLeaves(this) == rawCount;
        }

        private NodeImpl<N>[] computeChildren(int splitterIndex, Predicate<N> memberFunction) {
            ArrayList<NodeImpl> result = new ArrayList<NodeImpl>();
            if (splitterIndex >= this.myTreeStructure.myTreeSplitters.length) {
                DataGraph graph = this.myTreeStructure.getGraph();
                for (int i = 0; i < graph.V(); ++i) {
                    Object n = graph.getNode(i);
                    if (!memberFunction.test(n)) continue;
                    result.add(new LeafNodeImpl<N>(this, this.myTreeStructure, i));
                }
            } else {
                List split = this.myTreeStructure.myTreeSplitters[splitterIndex].split(this.myTreeStructure.getGraph(), memberFunction, this.myNodeData);
                for (Pair pair : split) {
                    Predicate children = (Predicate)pair.first;
                    NodeData nodeData = (NodeData)pair.second;
                    if (nodeData != null) {
                        result.add(new TreeNodeImpl<N>(this, splitterIndex, this.myTreeStructure, children, nodeData));
                        continue;
                    }
                    Object[] nodes = this.computeChildren(this.mySplitterIndex + 1, children);
                    ContainerUtil.addAll(result, (Object[])nodes);
                }
            }
            return result.toArray(new NodeImpl[0]);
        }

        @Override
        public DsmTreeStructure.TreeNode<N>[] getRawChildren() {
            if (this.myChildren != null) {
                return this.myChildren;
            }
            if (this.myRawChildren != null) {
                return this.myRawChildren;
            }
            ArrayList<LeafNodeImpl<N>> result = new ArrayList<LeafNodeImpl<N>>();
            DataGraph graph = this.myTreeStructure.getGraph();
            for (int i = 0; i < graph.V(); ++i) {
                Object n = graph.getNode(i);
                if (!this.myMemberFunction.test(n)) continue;
                result.add(new LeafNodeImpl<N>(this, this.myTreeStructure, i));
            }
            this.myRawChildren = result.toArray(new DsmTreeStructure.TreeNode[0]);
            return this.myRawChildren;
        }

        @Override
        public String getShortName() {
            return this.myNodeData.getShortName();
        }

        @Override
        public String getFullName() {
            return this.myNodeData == null ? null : this.myNodeData.getFullName();
        }

        @Override
        public Couple<Integer> getCycle() {
            return null;
        }

        @Override
        public Icon getIcon() {
            return this.myNodeData.getIcon();
        }
    }

    public static class NodeData {
        private final String myShortName;
        private final String myFullName;
        private final Icon myIcon;

        public NodeData(String shortName, String fullName, Icon icon) {
            this.myShortName = shortName;
            this.myFullName = fullName;
            this.myIcon = icon;
        }

        @NlsSafe
        public String getShortName() {
            return this.myShortName;
        }

        @NlsSafe
        public String getFullName() {
            return this.myFullName;
        }

        public Icon getIcon() {
            return this.myIcon;
        }
    }

    private static final class LeafNodeImpl<N>
    extends NodeImpl<N> {
        private final TopToBottomTreeStructure<N> myTreeStructure;
        private final int myLeafIndex;

        LeafNodeImpl(DsmTreeStructure.TreeNode<N> parent, TopToBottomTreeStructure<N> treeStructure, int leafIndex) {
            super(parent);
            this.myTreeStructure = treeStructure;
            this.myLeafIndex = leafIndex;
        }

        @Override
        public boolean isLeaf() {
            return true;
        }

        @Override
        public N getLeafData() {
            return this.myTreeStructure.getGraph().getNode(this.getLeafIndex());
        }

        @Override
        public int getLeafIndex() {
            return this.myLeafIndex;
        }

        @Override
        public DsmTreeStructure.TreeNode<N>[] getChildren() {
            throw new UnsupportedOperationException("Method getChildren not implemented in " + String.valueOf(this.getClass()));
        }

        @Override
        public DsmTreeStructure.TreeNode<N>[] getRawChildren() {
            throw new UnsupportedOperationException("Method getRawChildren not implemented in " + String.valueOf(this.getClass()));
        }

        @Override
        public String getShortName() {
            return this.myTreeStructure.getLeafShortName(this.getLeafData());
        }

        @Override
        public String getFullName() {
            return this.myTreeStructure.getLeafFullName(this.getLeafData());
        }

        @Override
        public Couple<Integer> getCycle() {
            return null;
        }

        @Override
        public Icon getIcon() {
            return this.myTreeStructure.getLeafIcon(this.getLeafData());
        }
    }
}

