/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dsm.ui;

import com.intellij.dsm.model.DsmTreeStructure;
import com.intellij.dsm.ui.DsmSelection;
import com.intellij.dsm.ui.DsmSelectionModel;
import com.intellij.dsm.ui.DsmTableImpl;
import com.intellij.ui.SpeedSearchBase;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class DsmTableSpeedSearch<N>
extends SpeedSearchBase<DsmTableImpl<N>> {
    private DsmTableSpeedSearch(DsmTableImpl<N> component) {
        super(component, null);
    }

    static <N> void installOn(DsmTableImpl<N> component) {
        DsmTableSpeedSearch<N> search = new DsmTableSpeedSearch<N>(component);
        search.setupListeners();
    }

    protected int getSelectedIndex() {
        Collection selection = ((DsmTableImpl)this.getComponent()).getSelectionModel().getSelection();
        DsmSelection firstItem = (DsmSelection)ContainerUtil.getFirstItem(selection);
        if (firstItem == null || firstItem.node1.isEmpty()) {
            return -1;
        }
        return ArrayUtil.indexOf((Object[])this.getAllElements(), (Object)ContainerUtil.getFirstItem(firstItem.node1));
    }

    protected Object @NotNull [] getAllElements() {
        DsmTableImpl table = (DsmTableImpl)this.getComponent();
        List rows = table.myCache.myRows;
        LinkedHashSet<DsmTreeStructure.TreeNode<N>> nodes = new LinkedHashSet<DsmTreeStructure.TreeNode<N>>();
        for (DsmTreeStructure.TreeNode row : rows) {
            this.addNodeAndParents(row, nodes);
        }
        Object[] objectArray = nodes.toArray();
        if (objectArray == null) {
            DsmTableSpeedSearch.$$$reportNull$$$0(0);
        }
        return objectArray;
    }

    private void addNodeAndParents(DsmTreeStructure.TreeNode<N> node, Set<DsmTreeStructure.TreeNode<N>> nodes) {
        DsmTreeStructure.TreeNode<N> parent = node.getParent();
        if (parent == null) {
            return;
        }
        this.addNodeAndParents(parent, nodes);
        nodes.add(node);
    }

    @Nullable
    protected String getElementText(Object element) {
        return ((DsmTreeStructure.TreeNode)element).getShortName();
    }

    protected void selectElement(Object element, String selectedText) {
        if (element == null) {
            return;
        }
        DsmTreeStructure.TreeNode selected = (DsmTreeStructure.TreeNode)element;
        Object2IntMap indices = ((DsmTableImpl)this.getComponent()).myCache.rowIndices;
        DsmTreeStructure.TreeNode startNode = selected;
        int startIndex = indices.getInt((Object)selected);
        while (!startNode.isLeaf() && startIndex < 0) {
            DsmTreeStructure.TreeNode<N>[] children = startNode.getChildren();
            startNode = children[0];
            startIndex = indices.getInt(startNode);
        }
        DsmTreeStructure.TreeNode endNode = selected;
        int endIndex = indices.getInt((Object)selected);
        while (!endNode.isLeaf() && endIndex < 0) {
            DsmTreeStructure.TreeNode<N>[] children = endNode.getChildren();
            endNode = children[children.length - 1];
            endIndex = indices.getInt(endNode);
        }
        assert (startIndex >= 0 && endIndex >= 0);
        DsmSelectionModel selectionModel = ((DsmTableImpl)this.getComponent()).getSelectionModel();
        selectionModel.clear();
        selectionModel.addSelection(DsmSelection.createRowSelection(Collections.singleton(selected), startIndex, endIndex));
        ((DsmTableImpl)this.getComponent()).scrollRowToVisible(selected);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dsm/ui/DsmTableSpeedSearch", "getAllElements"));
    }
}

