/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.turboComplete.analysis.usage;

import com.intellij.platform.ml.impl.turboComplete.CompletionKind;
import com.intellij.turboComplete.analysis.usage.KindStatistics;
import com.intellij.turboComplete.analysis.usage.KindUsageTracker;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0019\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0002H\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000bR\u000e\u0010\f\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/turboComplete/analysis/usage/KindGenerationInRawTracker;", "Lcom/intellij/turboComplete/analysis/usage/KindUsageTracker;", "Lcom/intellij/turboComplete/analysis/usage/KindStatistics;", "kind", "Lcom/intellij/platform/ml/impl/turboComplete/CompletionKind;", "maxPeriod", "", "<init>", "(Lcom/intellij/platform/ml/impl/turboComplete/CompletionKind;Ljava/lang/Integer;)V", "getKind", "()Lcom/intellij/platform/ml/impl/turboComplete/CompletionKind;", "Ljava/lang/Integer;", "generatedCorrectInRow", "generatedNotCorrectInRow", "trackGenerated", "", "correct", "", "getSummary", "intellij.turboComplete"})
public final class KindGenerationInRawTracker
implements KindUsageTracker<KindStatistics> {
    @NotNull
    private final CompletionKind kind;
    @Nullable
    private final Integer maxPeriod;
    private int generatedCorrectInRow;
    private int generatedNotCorrectInRow;

    public KindGenerationInRawTracker(@NotNull CompletionKind kind, @Nullable Integer maxPeriod) {
        Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
        this.kind = kind;
        this.maxPeriod = maxPeriod;
    }

    @Override
    @NotNull
    public CompletionKind getKind() {
        return this.kind;
    }

    @Override
    public void trackGenerated(boolean correct) {
        if (correct) {
            ++this.generatedCorrectInRow;
            this.generatedNotCorrectInRow = 0;
        } else {
            this.generatedCorrectInRow = 0;
            ++this.generatedNotCorrectInRow;
        }
    }

    @Override
    @NotNull
    public KindStatistics getSummary() {
        KindStatistics kindStatistics;
        Integer n = this.maxPeriod;
        if (n != null) {
            int it = ((Number)n).intValue();
            boolean bl = false;
            kindStatistics = new KindStatistics(Math.min(it, this.generatedCorrectInRow), Math.min(it, this.generatedNotCorrectInRow));
        } else {
            kindStatistics = new KindStatistics(this.generatedCorrectInRow, this.generatedNotCorrectInRow);
        }
        return kindStatistics;
    }
}

