/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.turboComplete.analysis.usage;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupEvent;
import com.intellij.codeInsight.lookup.LookupEx;
import com.intellij.codeInsight.lookup.LookupListener;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.editor.Editor;
import com.intellij.platform.ml.impl.turboComplete.CompletionKind;
import com.intellij.platform.ml.impl.turboComplete.KindVariety;
import com.intellij.platform.ml.impl.turboComplete.SuggestionGenerator;
import com.intellij.turboComplete.analysis.PipelineListener;
import com.intellij.turboComplete.analysis.usage.CombinedKindUsageStatistics;
import com.intellij.turboComplete.analysis.usage.CombinedKindUsageTracker;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Service
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001:\u0002\u0014\u0015B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0006J\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u000e2\u0006\u0010\u0011\u001a\u00020\u0012J\u0010\u0010\u0013\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0006H\u0002R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/turboComplete/analysis/usage/KindVarietyUsageTracker;", "", "<init>", "()V", "kindStatisticsPerVariety", "", "Lcom/intellij/platform/ml/impl/turboComplete/CompletionKind;", "Lcom/intellij/turboComplete/analysis/usage/CombinedKindUsageTracker;", "recentPeriodLength", "", "kindStatistics", "Lcom/intellij/turboComplete/analysis/usage/CombinedKindUsageStatistics;", "kind", "trackedKinds", "", "variety", "Lcom/intellij/platform/ml/impl/turboComplete/KindVariety;", "parameters", "Lcom/intellij/codeInsight/completion/CompletionParameters;", "kindStatisticsTracker", "UsagePipelineListener", "UsageLookupListener", "intellij.turboComplete"})
@SourceDebugExtension(value={"SMAP\nKindVarietyUsageTracker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KindVarietyUsageTracker.kt\ncom/intellij/turboComplete/analysis/usage/KindVarietyUsageTracker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,63:1\n774#2:64\n865#2,2:65\n774#2:67\n865#2,2:68\n382#3,7:70\n*S KotlinDebug\n*F\n+ 1 KindVarietyUsageTracker.kt\ncom/intellij/turboComplete/analysis/usage/KindVarietyUsageTracker\n*L\n28#1:64\n28#1:65,2\n32#1:67\n32#1:68,2\n36#1:70,7\n*E\n"})
public final class KindVarietyUsageTracker {
    @NotNull
    private final Map<CompletionKind, CombinedKindUsageTracker> kindStatisticsPerVariety = new LinkedHashMap();
    private final int recentPeriodLength;

    public KindVarietyUsageTracker() {
        this.recentPeriodLength = 30;
    }

    @NotNull
    public final CombinedKindUsageStatistics kindStatistics(@NotNull CompletionKind kind) {
        Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
        return this.kindStatisticsPerVariety.getOrDefault(kind, new CombinedKindUsageTracker(kind, this.recentPeriodLength, this.recentPeriodLength)).getSummary();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<CompletionKind> trackedKinds(@NotNull KindVariety variety) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)variety, (String)"variety");
        Iterable $this$filter$iv = this.kindStatisticsPerVariety.keySet();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            CompletionKind it = (CompletionKind)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getVariety(), (Object)variety)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<CompletionKind> trackedKinds(@NotNull CompletionParameters parameters) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        Iterable $this$filter$iv = this.kindStatisticsPerVariety.keySet();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            CompletionKind it = (CompletionKind)element$iv$iv;
            boolean bl = false;
            if (!it.getVariety().kindsCorrespondToParameters(parameters)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final CombinedKindUsageTracker kindStatisticsTracker(CompletionKind kind) {
        Object object;
        void $this$getOrPut$iv;
        Map<CompletionKind, CombinedKindUsageTracker> map = this.kindStatisticsPerVariety;
        CompletionKind key$iv = kind;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            CombinedKindUsageTracker answer$iv = new CombinedKindUsageTracker(kind, this.recentPeriodLength, this.recentPeriodLength);
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return (CombinedKindUsageTracker)object;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/turboComplete/analysis/usage/KindVarietyUsageTracker$UsageLookupListener;", "Lcom/intellij/codeInsight/lookup/LookupListener;", "<init>", "()V", "itemSelected", "", "event", "Lcom/intellij/codeInsight/lookup/LookupEvent;", "intellij.turboComplete"})
    @SourceDebugExtension(value={"SMAP\nKindVarietyUsageTracker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KindVarietyUsageTracker.kt\ncom/intellij/turboComplete/analysis/usage/KindVarietyUsageTracker$UsageLookupListener\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,63:1\n40#2,3:64\n216#3,2:67\n*S KotlinDebug\n*F\n+ 1 KindVarietyUsageTracker.kt\ncom/intellij/turboComplete/analysis/usage/KindVarietyUsageTracker$UsageLookupListener\n*L\n55#1:64,3\n58#1:67,2\n*E\n"})
    public static final class UsageLookupListener
    implements LookupListener {
        public void itemSelected(@NotNull LookupEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            boolean $i$f$service = false;
            Class<KindVarietyUsageTracker> serviceClass$iv = KindVarietyUsageTracker.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            KindVarietyUsageTracker tracker = (KindVarietyUsageTracker)object;
            LookupElement lookupElement = event.getItem();
            if (lookupElement == null || (lookupElement = SuggestionGenerator.Companion.getSuggestionGenerator(lookupElement)) == null) {
                return;
            }
            LookupElement correctSuggestionGenerator = lookupElement;
            Map $this$forEach$iv = tracker.kindStatisticsPerVariety;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry element$iv;
                Map.Entry entry = element$iv = iterator.next();
                boolean bl = false;
                CompletionKind kind = (CompletionKind)entry.getKey();
                CombinedKindUsageTracker kindStatisticsTracker = (CombinedKindUsageTracker)entry.getValue();
                kindStatisticsTracker.trackGenerated(Intrinsics.areEqual((Object)kind, (Object)correctSuggestionGenerator.getKind()));
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/intellij/turboComplete/analysis/usage/KindVarietyUsageTracker$UsagePipelineListener;", "Lcom/intellij/turboComplete/analysis/PipelineListener;", "<init>", "()V", "onInitialize", "", "parameters", "Lcom/intellij/codeInsight/completion/CompletionParameters;", "onGeneratorCollected", "suggestionGenerator", "Lcom/intellij/platform/ml/impl/turboComplete/SuggestionGenerator;", "intellij.turboComplete"})
    @SourceDebugExtension(value={"SMAP\nKindVarietyUsageTracker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KindVarietyUsageTracker.kt\ncom/intellij/turboComplete/analysis/usage/KindVarietyUsageTracker$UsagePipelineListener\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,63:1\n40#2,3:64\n*S KotlinDebug\n*F\n+ 1 KindVarietyUsageTracker.kt\ncom/intellij/turboComplete/analysis/usage/KindVarietyUsageTracker$UsagePipelineListener\n*L\n47#1:64,3\n*E\n"})
    public static final class UsagePipelineListener
    implements PipelineListener {
        public void onInitialize(@NotNull CompletionParameters parameters) {
            block0: {
                Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
                LookupEx lookupEx = LookupManager.getActiveLookup((Editor)parameters.getEditor());
                if (lookupEx == null) break block0;
                lookupEx.addLookupListener((LookupListener)new UsageLookupListener());
            }
        }

        public void onGeneratorCollected(@NotNull SuggestionGenerator suggestionGenerator) {
            Intrinsics.checkNotNullParameter((Object)suggestionGenerator, (String)"suggestionGenerator");
            boolean $i$f$service = false;
            Class<KindVarietyUsageTracker> serviceClass$iv = KindVarietyUsageTracker.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            ((KindVarietyUsageTracker)object).kindStatisticsTracker(suggestionGenerator.getKind()).trackCreated();
        }
    }
}

