/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.cloud.model.bootstrap;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.spring.SpringAutodetectedModelsSearcher;
import com.intellij.spring.boot.application.SpringBootApplicationService;
import com.intellij.spring.boot.cloud.library.SpringCloudLibraryUtil;
import com.intellij.spring.boot.library.SpringBootLibraryUtil;
import com.intellij.spring.contexts.model.SpringLocalModelUtils;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.model.utils.SpringModelUtils;
import com.intellij.spring.profiles.SpringProfilesService;
import com.intellij.spring.spi.SpringSpiManager;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0016\u00a8\u0006\n"}, d2={"Lcom/intellij/spring/boot/cloud/model/bootstrap/SpringBootBootstrapAutodetectedModelsSearcher;", "Lcom/intellij/spring/SpringAutodetectedModelsSearcher;", "<init>", "()V", "getAutodetectedModels", "", "Lcom/intellij/spring/contexts/model/SpringModel;", "module", "Lcom/intellij/openapi/module/Module;", "contextModule", "intellij.spring.boot.cloud"})
public final class SpringBootBootstrapAutodetectedModelsSearcher
implements SpringAutodetectedModelsSearcher {
    @NotNull
    public Set<SpringModel> getAutodetectedModels(@NotNull Module module, @NotNull Module contextModule) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)contextModule, (String)"contextModule");
        if (!SpringBootLibraryUtil.hasSpringBootLibrary((Module)module) || !SpringCloudLibraryUtil.hasSpringCloudCommons(module) || SpringBootApplicationService.getInstance().getSpringApplications(module).isEmpty()) {
            return SetsKt.emptySet();
        }
        List bootstrapConfigs = SpringSpiManager.getInstance((Module)module).getClassesListValue(false, "org.springframework.cloud.bootstrap.BootstrapConfiguration");
        Set set = new HashSet(bootstrapConfigs);
        Project project = module.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Set set2 = SpringLocalModelUtils.getLocalAnnotationModels((Module)contextModule, (Set)set, (Set)SpringProfilesService.Companion.getInstance(project).getActiveProfiles(module));
        Intrinsics.checkNotNullExpressionValue((Object)set2, (String)"getLocalAnnotationModels(...)");
        Set models = set2;
        return models.isEmpty() ? SetsKt.emptySet() : SetsKt.setOf((Object)SpringModelUtils.getInstance().getCombinedSpringModel(models, module));
    }
}

