/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.process.mediator.common;

import com.intellij.execution.process.mediator.common.QuotaOptions;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0003\b\t\nB\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0012\u0010\u0004\u001a\u00020\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u0082\u0001\u0003\u000b\f\r\u00a8\u0006\u000e"}, d2={"Lcom/intellij/execution/process/mediator/common/QuotaState;", "", "<init>", "()V", "options", "Lcom/intellij/execution/process/mediator/common/QuotaOptions;", "getOptions", "()Lcom/intellij/execution/process/mediator/common/QuotaOptions;", "New", "Active", "Expired", "Lcom/intellij/execution/process/mediator/common/QuotaState$Active;", "Lcom/intellij/execution/process/mediator/common/QuotaState$Expired;", "Lcom/intellij/execution/process/mediator/common/QuotaState$New;", "intellij.execution.process.mediator.common"})
public abstract class QuotaState {
    private QuotaState() {
    }

    @NotNull
    public abstract QuotaOptions getOptions();

    public /* synthetic */ QuotaState(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\f\u001a\u00020\u0005J\u0006\u0010\r\u001a\u00020\u000eJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u000e2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0019"}, d2={"Lcom/intellij/execution/process/mediator/common/QuotaState$Active;", "Lcom/intellij/execution/process/mediator/common/QuotaState;", "options", "Lcom/intellij/execution/process/mediator/common/QuotaOptions;", "elapsedMs", "", "<init>", "(Lcom/intellij/execution/process/mediator/common/QuotaOptions;J)V", "getOptions", "()Lcom/intellij/execution/process/mediator/common/QuotaOptions;", "getElapsedMs", "()J", "remaining", "isExpired", "", "component1", "component2", "copy", "equals", "other", "", "hashCode", "", "toString", "", "intellij.execution.process.mediator.common"})
    public static final class Active
    extends QuotaState {
        @NotNull
        private final QuotaOptions options;
        private final long elapsedMs;

        public Active(@NotNull QuotaOptions options, long elapsedMs) {
            Intrinsics.checkNotNullParameter((Object)options, (String)"options");
            super(null);
            this.options = options;
            this.elapsedMs = elapsedMs;
        }

        @Override
        @NotNull
        public QuotaOptions getOptions() {
            return this.options;
        }

        public final long getElapsedMs() {
            return this.elapsedMs;
        }

        public final long remaining() {
            return this.getOptions().isUnlimited() ? Long.MAX_VALUE : this.getOptions().getTimeLimitMs() - this.elapsedMs;
        }

        public final boolean isExpired() {
            return this.remaining() <= 0L;
        }

        @NotNull
        public final QuotaOptions component1() {
            return this.options;
        }

        public final long component2() {
            return this.elapsedMs;
        }

        @NotNull
        public final Active copy(@NotNull QuotaOptions options, long elapsedMs) {
            Intrinsics.checkNotNullParameter((Object)options, (String)"options");
            return new Active(options, elapsedMs);
        }

        public static /* synthetic */ Active copy$default(Active active, QuotaOptions quotaOptions, long l, int n, Object object) {
            if ((n & 1) != 0) {
                quotaOptions = active.options;
            }
            if ((n & 2) != 0) {
                l = active.elapsedMs;
            }
            return active.copy(quotaOptions, l);
        }

        @NotNull
        public String toString() {
            return "Active(options=" + this.options + ", elapsedMs=" + this.elapsedMs + ")";
        }

        public int hashCode() {
            int result = this.options.hashCode();
            result = result * 31 + Long.hashCode(this.elapsedMs);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Active)) {
                return false;
            }
            Active active = (Active)other;
            if (!Intrinsics.areEqual((Object)this.options, (Object)active.options)) {
                return false;
            }
            return this.elapsedMs == active.elapsedMs;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/execution/process/mediator/common/QuotaState$Expired;", "Lcom/intellij/execution/process/mediator/common/QuotaState;", "<init>", "()V", "options", "Lcom/intellij/execution/process/mediator/common/QuotaOptions;", "getOptions", "()Lcom/intellij/execution/process/mediator/common/QuotaOptions;", "intellij.execution.process.mediator.common"})
    public static final class Expired
    extends QuotaState {
        @NotNull
        public static final Expired INSTANCE = new Expired();

        private Expired() {
            super(null);
        }

        @Override
        @NotNull
        public QuotaOptions getOptions() {
            return QuotaOptions.Companion.getEXCEEDED();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lcom/intellij/execution/process/mediator/common/QuotaState$New;", "Lcom/intellij/execution/process/mediator/common/QuotaState;", "options", "Lcom/intellij/execution/process/mediator/common/QuotaOptions;", "<init>", "(Lcom/intellij/execution/process/mediator/common/QuotaOptions;)V", "getOptions", "()Lcom/intellij/execution/process/mediator/common/QuotaOptions;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "intellij.execution.process.mediator.common"})
    public static final class New
    extends QuotaState {
        @NotNull
        private final QuotaOptions options;

        public New(@NotNull QuotaOptions options) {
            Intrinsics.checkNotNullParameter((Object)options, (String)"options");
            super(null);
            this.options = options;
        }

        @Override
        @NotNull
        public QuotaOptions getOptions() {
            return this.options;
        }

        @NotNull
        public final QuotaOptions component1() {
            return this.options;
        }

        @NotNull
        public final New copy(@NotNull QuotaOptions options) {
            Intrinsics.checkNotNullParameter((Object)options, (String)"options");
            return new New(options);
        }

        public static /* synthetic */ New copy$default(New new_, QuotaOptions quotaOptions, int n, Object object) {
            if ((n & 1) != 0) {
                quotaOptions = new_.options;
            }
            return new_.copy(quotaOptions);
        }

        @NotNull
        public String toString() {
            return "New(options=" + this.options + ")";
        }

        public int hashCode() {
            return this.options.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof New)) {
                return false;
            }
            New new_ = (New)other;
            return Intrinsics.areEqual((Object)this.options, (Object)new_.options);
        }
    }
}

