/*
 * Decompiled with CFR 0.152.
 */
package org.angular2.inspections.quickfixes;

import com.intellij.codeInsight.template.Template;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSThisExpression;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptClass;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.util.JSClassUtils;
import com.intellij.lang.javascript.validation.fixes.CreateJSFunctionIntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointersKt;
import com.intellij.psi.SmartPsiElementPointer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.angular2.entities.source.Angular2SourceUtil;
import org.angular2.inspections.quickfixes.Angular2FixesTemplateUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J*\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0014J,\u0010\u0012\u001a\u0004\u0018\u00010\u00032\b\u0010\u0013\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u0016H\u0014J\b\u0010\u0017\u001a\u00020\u0016H\u0014J \u0010\u0018\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0003\u0012\u0006\u0012\u0004\u0018\u00010\r0\u00192\u0006\u0010\f\u001a\u00020\rH\u0014J2\u0010\u001a\u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\r2\b\u0010 \u001a\u0004\u0018\u00010\r2\u0006\u0010\u0013\u001a\u00020\u0003H\u0014J(\u0010!\u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0013\u001a\u00020\u00032\u0006\u0010\"\u001a\u00020\u00162\u0006\u0010#\u001a\u00020$H\u0014R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lorg/angular2/inspections/quickfixes/CreateComponentMethodIntentionAction;", "Lcom/intellij/lang/javascript/validation/fixes/CreateJSFunctionIntentionAction;", "methodExpression", "Lcom/intellij/lang/javascript/psi/JSReferenceExpression;", "<init>", "(Lcom/intellij/lang/javascript/psi/JSReferenceExpression;)V", "myRefExpressionPointer", "Lcom/intellij/psi/SmartPsiElementPointer;", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "psiElement", "Lcom/intellij/psi/PsiElement;", "file", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "beforeStartTemplateAction", "referenceExpression", "anchor", "isStaticContext", "", "skipParentIfClass", "calculateAnchors", "Lcom/intellij/openapi/util/Pair;", "writeFunctionAndName", "template", "Lcom/intellij/codeInsight/template/Template;", "createdMethodName", "", "anchorParent", "clazz", "addAccessModifier", "staticContext", "targetClass", "Lcom/intellij/lang/javascript/psi/ecmal4/JSClass;", "intellij.angular"})
public final class CreateComponentMethodIntentionAction
extends CreateJSFunctionIntentionAction {
    @NotNull
    private final SmartPsiElementPointer<JSReferenceExpression> myRefExpressionPointer;

    public CreateComponentMethodIntentionAction(@NotNull JSReferenceExpression methodExpression) {
        Intrinsics.checkNotNullParameter((Object)methodExpression, (String)"methodExpression");
        super(methodExpression.getReferenceName(), true, false);
        this.myRefExpressionPointer = SmartPointersKt.createSmartPointer((PsiElement)((PsiElement)methodExpression));
    }

    protected void applyFix(@NotNull Project project, @NotNull PsiElement psiElement, @NotNull PsiFile file, @Nullable Editor editor) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)psiElement, (String)"psiElement");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        TypeScriptClass typeScriptClass = Angular2SourceUtil.findComponentClass(psiElement);
        Intrinsics.checkNotNull((Object)typeScriptClass);
        TypeScriptClass componentClass = typeScriptClass;
        this.doApplyFix(project, (PsiElement)componentClass, componentClass.getContainingFile(), null);
    }

    @Nullable
    protected JSReferenceExpression beforeStartTemplateAction(@Nullable JSReferenceExpression referenceExpression, @NotNull Editor editor, @NotNull PsiElement anchor, boolean isStaticContext) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)anchor, (String)"anchor");
        return referenceExpression;
    }

    protected boolean skipParentIfClass() {
        return false;
    }

    @NotNull
    protected Pair<JSReferenceExpression, PsiElement> calculateAnchors(@NotNull PsiElement psiElement) {
        Intrinsics.checkNotNullParameter((Object)psiElement, (String)"psiElement");
        Pair pair = Pair.create((Object)this.myRefExpressionPointer.getElement(), (Object)psiElement.getLastChild());
        Intrinsics.checkNotNullExpressionValue((Object)pair, (String)"create(...)");
        return pair;
    }

    protected void writeFunctionAndName(@NotNull Template template, @NotNull String createdMethodName, @NotNull PsiElement anchorParent, @Nullable PsiElement clazz, @NotNull JSReferenceExpression referenceExpression) {
        String string;
        Intrinsics.checkNotNullParameter((Object)template, (String)"template");
        Intrinsics.checkNotNullParameter((Object)createdMethodName, (String)"createdMethodName");
        Intrinsics.checkNotNullParameter((Object)anchorParent, (String)"anchorParent");
        Intrinsics.checkNotNullParameter((Object)referenceExpression, (String)"referenceExpression");
        if (referenceExpression.getQualifier() instanceof JSThisExpression) {
            string = referenceExpression.getReferenceName();
            if (string == null) {
                string = createdMethodName;
            }
        } else {
            string = createdMethodName;
        }
        String actualName = string;
        template.addTextSegment(JSClassUtils.createClassFunctionName((String)actualName, (PsiElement)anchorParent));
    }

    protected void addAccessModifier(@NotNull Template template, @NotNull JSReferenceExpression referenceExpression, boolean staticContext, @NotNull JSClass targetClass) {
        Intrinsics.checkNotNullParameter((Object)template, (String)"template");
        Intrinsics.checkNotNullParameter((Object)referenceExpression, (String)"referenceExpression");
        Intrinsics.checkNotNullParameter((Object)targetClass, (String)"targetClass");
        Angular2FixesTemplateUtil.INSTANCE.addClassMemberModifiers(template, staticContext, targetClass);
    }
}

