/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.messaging.providers;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.MetaAnnotationUtil;
import com.intellij.codeInsight.daemon.ImplicitUsageProvider;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

final class SpringMessagingImplicitUsageProvider
implements ImplicitUsageProvider {
    private static final List<String> REGULAR_COMPONENT_ANNOTATIONS = List.of("org.springframework.stereotype.Service", "org.springframework.stereotype.Component");
    private static final List<String> ANNOTATIONS = List.of("org.springframework.messaging.handler.annotation.MessageMapping", "org.springframework.messaging.simp.annotation.SubscribeMapping", "org.springframework.messaging.handler.annotation.MessageExceptionHandler", "org.springframework.jms.annotation.JmsListeners", "org.springframework.amqp.rabbit.annotation.RabbitListeners", "org.springframework.kafka.annotation.KafkaListeners");

    SpringMessagingImplicitUsageProvider() {
    }

    public boolean isImplicitUsage(@NotNull PsiElement element) {
        if (element == null) {
            SpringMessagingImplicitUsageProvider.$$$reportNull$$$0(0);
        }
        return SpringMessagingImplicitUsageProvider.hasWriteAnnotations(element) || SpringMessagingImplicitUsageProvider.isComponentWithListener(element);
    }

    public boolean isImplicitRead(@NotNull PsiElement element) {
        if (element == null) {
            SpringMessagingImplicitUsageProvider.$$$reportNull$$$0(1);
        }
        return SpringMessagingImplicitUsageProvider.hasReadAnnotations(element);
    }

    private static boolean hasReadAnnotations(PsiElement element) {
        return element instanceof PsiMethod && SpringMessagingImplicitUsageProvider.isMessageMethod((PsiMethod)element);
    }

    public boolean isImplicitWrite(@NotNull PsiElement element) {
        if (element == null) {
            SpringMessagingImplicitUsageProvider.$$$reportNull$$$0(2);
        }
        return SpringMessagingImplicitUsageProvider.hasWriteAnnotations(element);
    }

    private static boolean hasWriteAnnotations(PsiElement element) {
        return element instanceof PsiMethod && SpringMessagingImplicitUsageProvider.isMessageMethod((PsiMethod)element);
    }

    private static boolean isComponentWithListener(PsiElement element) {
        if (!(element instanceof PsiClass)) {
            return false;
        }
        PsiClass psiClass = (PsiClass)element;
        return AnnotationUtil.isAnnotated((PsiModifierListOwner)psiClass, REGULAR_COMPONENT_ANNOTATIONS, (int)0) && SpringCommonUtils.isSpringBeanCandidateClassInSpringProject((PsiClass)psiClass) && ContainerUtil.exists((Object[])psiClass.getMethods(), SpringMessagingImplicitUsageProvider::isMessageMethod);
    }

    private static boolean isMessageMethod(@NotNull PsiMethod element) {
        if (element == null) {
            SpringMessagingImplicitUsageProvider.$$$reportNull$$$0(3);
        }
        if (AnnotationUtil.isAnnotated((PsiModifierListOwner)element, ANNOTATIONS, (int)0)) {
            return true;
        }
        PsiClass psiClass = element.getContainingClass();
        if (!SpringCommonUtils.isSpringBeanCandidateClassInSpringProject((PsiClass)psiClass)) {
            return false;
        }
        return SpringMessagingImplicitUsageProvider.isMessageMappingAnnotated((PsiModifierListOwner)element);
    }

    private static boolean isMessageMappingAnnotated(@NotNull PsiModifierListOwner element) {
        if (element == null) {
            SpringMessagingImplicitUsageProvider.$$$reportNull$$$0(4);
        }
        if (element instanceof PsiClass) {
            return false;
        }
        return MetaAnnotationUtil.isMetaAnnotated((PsiModifierListOwner)element, Collections.singletonList("org.springframework.messaging.handler.annotation.MessageMapping"));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "element";
        objectArray2[1] = "com/intellij/spring/messaging/providers/SpringMessagingImplicitUsageProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isImplicitUsage";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isImplicitRead";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isImplicitWrite";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isMessageMethod";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isMessageMappingAnnotated";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

