/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.lineProfiler.ui;

import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.profiler.api.AllocationSizeMetric;
import com.intellij.profiler.lineProfiler.LineProfilerBundle;
import com.intellij.profiler.lineProfiler.ProfilerLineProfilerIcons;
import com.intellij.profiler.lineProfiler.data.ClassAndMethodWithHits;
import com.intellij.profiler.lineProfiler.data.LineInfo;
import com.intellij.profiler.lineProfiler.data.LinesGroup;
import com.intellij.profiler.lineProfiler.data.SingleLineGroup;
import com.intellij.profiler.lineProfiler.ui.LineTooltipKt;
import com.intellij.profiler.lineProfiler.ui.UtilsKt;
import com.intellij.ui.JBColor;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.ui.components.panels.VerticalLayout;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u0006\u0010\u0012\u001a\u00020\u000fJ\u0014\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00150\u0014H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/profiler/lineProfiler/ui/LineTooltip;", "", "line", "", "linesGroup", "Lcom/intellij/profiler/lineProfiler/data/LinesGroup;", "<init>", "(ILcom/intellij/profiler/lineProfiler/data/LinesGroup;)V", "getLine", "()I", "tooltipComponent", "Lcom/intellij/ui/components/panels/NonOpaquePanel;", "popup", "Lcom/intellij/openapi/ui/popup/JBPopup;", "show", "", "e", "Ljava/awt/event/MouseEvent;", "hide", "getText", "Lkotlin/Pair;", "", "intellij.profiler.lineProfiler"})
@SourceDebugExtension(value={"SMAP\nLineTooltip.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LineTooltip.kt\ncom/intellij/profiler/lineProfiler/ui/LineTooltip\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,119:1\n1#2:120\n*E\n"})
public final class LineTooltip {
    private final int line;
    @NotNull
    private final LinesGroup linesGroup;
    @NotNull
    private final NonOpaquePanel tooltipComponent;
    @Nullable
    private JBPopup popup;

    /*
     * WARNING - void declaration
     */
    public LineTooltip(int line, @NotNull LinesGroup linesGroup) {
        List<ClassAndMethodWithHits> childrenCalls;
        Collection collection;
        Pair<String, String> pair;
        void $this$tooltipComponent_u24lambda_u242;
        NonOpaquePanel nonOpaquePanel;
        Intrinsics.checkNotNullParameter((Object)linesGroup, (String)"linesGroup");
        this.line = line;
        this.linesGroup = linesGroup;
        NonOpaquePanel nonOpaquePanel2 = nonOpaquePanel = new NonOpaquePanel((LayoutManager)new VerticalLayout(JBUI.scale((int)6)));
        LineTooltip lineTooltip = this;
        boolean bl = false;
        $this$tooltipComponent_u24lambda_u242.setBorder((Border)JBUI.Borders.empty((int)JBUI.scale((int)8), (int)JBUI.scale((int)12)));
        String comment = Intrinsics.areEqual((Object)this.linesGroup.getMetric(), (Object)AllocationSizeMetric.INSTANCE) ? "line.tooltip.hint.memory" : "line.tooltip.hint.time";
        $this$tooltipComponent_u24lambda_u242.add((Component)new JBLabel(LineProfilerBundle.message(comment, new Object[0])));
        Pair<String, String> it = pair = ProfilerLineProfilerIcons.Flame;
        boolean bl2 = false;
        Pair<String, String> icon = this.linesGroup.isFireLine(this.line) ? pair : null;
        pair = this.getText();
        String first = (String)pair.component1();
        String other = (String)pair.component2();
        $this$tooltipComponent_u24lambda_u242.add((Component)new JBLabel(first, icon, 2));
        if (((CharSequence)other).length() > 0) {
            $this$tooltipComponent_u24lambda_u242.add((Component)new JBLabel(other));
        }
        if (!((collection = (Collection)(childrenCalls = this.linesGroup.getChildrenCalls(this.line))) == null || collection.isEmpty())) {
            void $this$tooltipComponent_u24lambda_u242_u24lambda_u241;
            String string;
            JBLabel jBLabel;
            if (childrenCalls.size() == 1) {
                jBLabel = new JBLabel[]{((ClassAndMethodWithHits)CollectionsKt.single(childrenCalls)).fullName()};
                string = LineProfilerBundle.message("click.to.navigate.to", (Object[])jBLabel);
            } else {
                string = LineProfilerBundle.message("click.to.navigate", new Object[0]);
            }
            String message = string;
            JBLabel jBLabel2 = jBLabel = new JBLabel(message);
            void var15_17 = $this$tooltipComponent_u24lambda_u242;
            boolean bl3 = false;
            $this$tooltipComponent_u24lambda_u242_u24lambda_u241.setFont($this$tooltipComponent_u24lambda_u242_u24lambda_u241.getFont().deriveFont(JBUIScale.scale((float)12.0f)));
            $this$tooltipComponent_u24lambda_u242_u24lambda_u241.setForeground((Color)JBColor.GRAY);
            var15_17.add((Component)jBLabel);
        }
        lineTooltip.tooltipComponent = nonOpaquePanel;
    }

    public final int getLine() {
        return this.line;
    }

    public final void show(@NotNull MouseEvent e) {
        Object object;
        block8: {
            JBPopup it;
            JBPopup jBPopup;
            block7: {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                object = this.popup;
                if (object == null) break block7;
                it = jBPopup = object;
                boolean bl = false;
                object = !it.isDisposed() ? jBPopup : null;
                if (object != null) break block8;
            }
            it = jBPopup = LineTooltipKt.access$createPopup((JComponent)this.tooltipComponent);
            boolean bl = false;
            this.popup = it;
            object = jBPopup;
        }
        JBPopup popup = object;
        Point point = e.getLocationOnScreen();
        Point newPoint = new Point(point.x + JBUI.scale((int)10), point.y + JBUI.scale((int)16));
        if (popup.isVisible()) {
            Point point2 = popup.getLocationOnScreen();
            Intrinsics.checkNotNullExpressionValue((Object)point2, (String)"getLocationOnScreen(...)");
            if (LineTooltipKt.access$squareDistance(point2, newPoint) > 1) {
                popup.setLocation(newPoint);
            }
        } else {
            popup.show(RelativePoint.fromScreen((Point)newPoint));
        }
    }

    public final void hide() {
        JBPopup currentPopup = this.popup;
        if (currentPopup != null) {
            ActionsKt.invokeLater$default(null, () -> LineTooltip.hide$lambda$5(currentPopup), (int)1, null);
        }
        this.popup = null;
    }

    private final Pair<String, String> getText() {
        Pair pair;
        SingleLineGroup singleLineGroup = this.linesGroup.getLines().get(this.line);
        if (singleLineGroup == null) {
            return TuplesKt.to((Object)"", (Object)"");
        }
        SingleLineGroup lines = singleLineGroup;
        float totalPercent = (float)lines.getTotalHits() / (float)this.linesGroup.getTotalHits();
        if (lines.getLines().size() == 1) {
            HtmlBuilder htmlBuilder = new HtmlBuilder();
            HtmlChunk.Element element = HtmlChunk.div();
            Intrinsics.checkNotNullExpressionValue((Object)element, (String)"div(...)");
            HtmlChunk.Element element2 = LineTooltip.getText$addTotalPercent(element, totalPercent).child(HtmlChunk.nbsp((int)4));
            Intrinsics.checkNotNullExpressionValue((Object)element2, (String)"child(...)");
            String string = htmlBuilder.append((HtmlChunk)LineTooltip.getText$addParentPercent(element2, (LineInfo)CollectionsKt.single(lines.getLines()))).wrapWithHtmlBody().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            pair = TuplesKt.to((Object)string, (Object)"");
        } else {
            HtmlBuilder htmlBuilder = new HtmlBuilder();
            HtmlChunk.Element element = HtmlChunk.div();
            Intrinsics.checkNotNullExpressionValue((Object)element, (String)"div(...)");
            String string = htmlBuilder.append((HtmlChunk)LineTooltip.getText$addTotalPercent(element, totalPercent)).wrapWithHtmlBody().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            String first = string;
            HtmlBuilder builder = new HtmlBuilder();
            for (LineInfo line : lines.getLines()) {
                HtmlChunk.Element element3 = HtmlChunk.div();
                Intrinsics.checkNotNullExpressionValue((Object)element3, (String)"div(...)");
                builder.append((HtmlChunk)LineTooltip.getText$addParentPercent(element3, line));
            }
            pair = TuplesKt.to((Object)first, (Object)builder.wrapWithHtmlBody().toString());
        }
        return pair;
    }

    private static final Unit hide$lambda$5(JBPopup $currentPopup) {
        $currentPopup.cancel();
        return Unit.INSTANCE;
    }

    private static final HtmlChunk.Element getText$addTotalPercent(HtmlChunk.Element $this$getText_u24addTotalPercent, float totalPercent) {
        HtmlChunk.Element element = $this$getText_u24addTotalPercent.child((HtmlChunk)HtmlChunk.text((String)UtilsKt.formatPercent(totalPercent)).bold()).child(HtmlChunk.text((String)LineProfilerBundle.message("percent.of.all", new Object[0])));
        Intrinsics.checkNotNullExpressionValue((Object)element, (String)"child(...)");
        return element;
    }

    private static final HtmlChunk.Element getText$addParentPercent(HtmlChunk.Element $this$getText_u24addParentPercent, LineInfo line) {
        Object[] objectArray = new Object[]{line.getParentMethod()};
        HtmlChunk.Element element = $this$getText_u24addParentPercent.child((HtmlChunk)HtmlChunk.text((String)UtilsKt.formatPercent(line.getParentPercent())).bold()).child(HtmlChunk.text((String)LineProfilerBundle.message("percent.of.parent", objectArray)));
        Intrinsics.checkNotNullExpressionValue((Object)element, (String)"child(...)");
        return element;
    }
}

