/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cdi.beans;

import com.intellij.cdi.beans.AbstractCdiBeanDescriptor;
import com.intellij.cdi.beans.CdiBeanDescriptor;
import com.intellij.cdi.beans.CdiCustomizationManager;
import com.intellij.cdi.constants.CdiAnnoConstants;
import com.intellij.cdi.manager.CdiManager;
import com.intellij.openapi.module.Module;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiModifierListOwner;
import java.util.Objects;
import java.util.Set;

public abstract class ProducerBeanDescriptor<T extends PsiMember>
extends AbstractCdiBeanDescriptor<T> {
    private final PsiMember myMember;

    protected ProducerBeanDescriptor(PsiMember member) {
        this.myMember = member;
    }

    @Override
    public PsiClass getDefaultDeploymentType() {
        Set<CdiBeanDescriptor<?>> cdiBeanDescriptors;
        Module module;
        PsiClass psiClass = this.getAnnotatedItem().getContainingClass();
        if (psiClass != null && (module = this.getModule()) != null && (cdiBeanDescriptors = CdiManager.resolveBeanByClass(module, psiClass, new PsiAnnotation[0])).size() == 1) {
            return cdiBeanDescriptors.iterator().next().getDeploymentType();
        }
        return this.getAnnotationClass(CdiAnnoConstants.PRODUCTION_ANNOTATION.fqn((PsiElement)this.myMember));
    }

    @Override
    public boolean isDefault() {
        return CdiCustomizationManager.hasDefaultBeanAnnotation((PsiModifierListOwner)this.myMember);
    }

    @Override
    public boolean isMock() {
        return CdiCustomizationManager.hasMockAnnotation((PsiModifierListOwner)this.myMember);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ProducerBeanDescriptor)) {
            return false;
        }
        ProducerBeanDescriptor that = (ProducerBeanDescriptor)o;
        return Objects.equals(this.myMember, that.myMember);
    }

    public int hashCode() {
        return this.myMember != null ? this.myMember.hashCode() : 0;
    }
}

