/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cdi.highlighting;

import com.intellij.cdi.beans.CdiBeanDescriptor;
import com.intellij.cdi.beans.CdiCustomizationManager;
import com.intellij.cdi.beans.CdiCustomizationProvider;
import com.intellij.cdi.beans.InjectionPointDescriptor;
import com.intellij.cdi.constants.CdiAnnoConstants;
import com.intellij.cdi.highlighting.CdiBaseInspection;
import com.intellij.cdi.resources.CdiInspectionBundle;
import com.intellij.cdi.utils.CdiCommonUtils;
import com.intellij.cdi.utils.CdiInjectionUtils;
import com.intellij.cdi.utils.CdiManagedBeanValidationUtils;
import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.module.Module;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CdiUnproxyableBeanTypesInspection
extends CdiBaseInspection {
    @Override
    protected void checkClass(@NotNull PsiClass aClass, @NotNull ProblemsHolder holder, @NotNull Module module) {
        boolean isPassivatingScopedClass;
        if (aClass == null) {
            CdiUnproxyableBeanTypesInspection.$$$reportNull$$$0(0);
        }
        if (holder == null) {
            CdiUnproxyableBeanTypesInspection.$$$reportNull$$$0(1);
        }
        if (module == null) {
            CdiUnproxyableBeanTypesInspection.$$$reportNull$$$0(2);
        }
        if (isPassivatingScopedClass = CdiManagedBeanValidationUtils.isPassivisingScopeDeclared((PsiModifierListOwner)aClass)) {
            CdiUnproxyableBeanTypesInspection.checkPassivatingScopedBeanIsSerializable((PsiModifierListOwner)aClass, aClass, holder);
        }
        Set<InjectionPointDescriptor> injectionPoints = CdiInjectionUtils.getInjectionPoints(aClass);
        for (InjectionPointDescriptor injectionPoint : injectionPoints) {
            PsiFile ipContainingFile = injectionPoint.getOwner().getContainingFile();
            if (ipContainingFile == null || !ipContainingFile.equals(aClass.getContainingFile())) continue;
            CdiUnproxyableBeanTypesInspection.checkInjectionPoint(injectionPoint, holder, module, isPassivatingScopedClass);
        }
        CdiUnproxyableBeanTypesInspection.checkPassivatingScopeProducers(aClass, holder);
    }

    private static void checkPassivatingScopeProducers(@NotNull PsiClass aClass, @NotNull ProblemsHolder holder) {
        if (aClass == null) {
            CdiUnproxyableBeanTypesInspection.$$$reportNull$$$0(3);
        }
        if (holder == null) {
            CdiUnproxyableBeanTypesInspection.$$$reportNull$$$0(4);
        }
        for (PsiMethod psiMethod : CdiCommonUtils.getProducerMethods(aClass)) {
            PsiType returnType;
            if (!aClass.equals(psiMethod.getContainingClass()) || !CdiManagedBeanValidationUtils.isPassivisingScopeDeclared((PsiModifierListOwner)psiMethod) || !((returnType = psiMethod.getReturnType()) instanceof PsiClassType)) continue;
            CdiUnproxyableBeanTypesInspection.checkPassivatingScopedBeanIsSerializable((PsiModifierListOwner)psiMethod, ((PsiClassType)returnType).resolve(), holder);
        }
        for (PsiField psiField : CdiCommonUtils.getProducerFields(aClass)) {
            PsiType type;
            if (!aClass.equals(psiField.getContainingClass()) || !CdiManagedBeanValidationUtils.isPassivisingScopeDeclared((PsiModifierListOwner)psiField) || !((type = psiField.getType()) instanceof PsiClassType)) continue;
            CdiUnproxyableBeanTypesInspection.checkPassivatingScopedBeanIsSerializable((PsiModifierListOwner)psiField, ((PsiClassType)type).resolve(), holder);
        }
    }

    private static void checkPassivatingScopedBeanIsSerializable(@Nullable PsiModifierListOwner psiElement, @Nullable PsiClass aClass, ProblemsHolder holder) {
        if (psiElement == null || aClass == null) {
            return;
        }
        if (!InheritanceUtil.isInheritor((PsiClass)aClass, (String)"java.io.Serializable")) {
            CdiUnproxyableBeanTypesInspection.registerProblem(holder, CdiUnproxyableBeanTypesInspection.getIdentifyingElement(psiElement), CdiInspectionBundle.message("CdiUnproxyableBeanTypesInspection.passivating.scoped.bean.must.be.serializable", new Object[0]));
        }
    }

    private static void checkInjectionPoint(@NotNull InjectionPointDescriptor injectionPoint, ProblemsHolder holder, Module module, boolean isPassivatingScopedClass) {
        Collection<CdiBeanDescriptor<?>> injectedBeans;
        if (injectionPoint == null) {
            CdiUnproxyableBeanTypesInspection.$$$reportNull$$$0(5);
        }
        if ((injectedBeans = CdiInjectionUtils.getInjectedBeans(injectionPoint)).size() == 1) {
            PsiClass injectedClass;
            CdiBeanDescriptor<?> descriptor = injectedBeans.iterator().next();
            PsiType type = descriptor.getType();
            if (type == null) {
                return;
            }
            CdiUnproxyableBeanTypesInspection.checkProxyable(injectionPoint, holder, module, descriptor);
            if (isPassivatingScopedClass && type instanceof PsiClassType && (injectedClass = ((PsiClassType)type).resolve()) != null && !CdiUnproxyableBeanTypesInspection.isApplicationScoped(injectedClass) && !CdiUnproxyableBeanTypesInspection.isRequestScoped(injectedClass) && !InheritanceUtil.isInheritor((PsiClass)injectedClass, (String)"java.io.Serializable") && !CdiManagedBeanValidationUtils.isEjbBean(injectedClass)) {
                CdiUnproxyableBeanTypesInspection.registerProblem(holder, CdiUnproxyableBeanTypesInspection.getIdentifyingElement(injectionPoint.getOwner()), CdiInspectionBundle.message("CdiUnproxyableBeanTypesInspection.injected.in.passivating.scoped.bean.must.be.serializable", new Object[0]));
            }
        }
    }

    private static boolean isRequestScoped(PsiClass injectedClass) {
        return AnnotationUtil.isAnnotated((PsiModifierListOwner)injectedClass, (String)CdiAnnoConstants.REQUEST_SCOPED_ANNOTATION.fqn((PsiElement)injectedClass), (int)1);
    }

    private static boolean isApplicationScoped(PsiClass injectedClass) {
        return AnnotationUtil.isAnnotated((PsiModifierListOwner)injectedClass, (String)CdiAnnoConstants.APPLICATION_SCOPED_ANNOTATION.fqn((PsiElement)injectedClass), (int)1);
    }

    private static void checkProxyable(InjectionPointDescriptor injectionPoint, ProblemsHolder holder, Module module, CdiBeanDescriptor<?> descriptor) {
        PsiType ipType = injectionPoint.getType();
        if (ipType == null) {
            return;
        }
        PsiClass scopeType = descriptor.getScopeType();
        if (scopeType == null) {
            return;
        }
        CdiCustomizationProvider cdiCustomization = CdiCustomizationManager.getCustomization(module);
        if (cdiCustomization != null && cdiCustomization.isUnproxyableBeanInjectionSupported()) {
            return;
        }
        Collection<PsiClass> normalScopeAnnotations = CdiCommonUtils.getNormalScopeTypesClasses(module);
        if (normalScopeAnnotations.contains(scopeType) && !CdiCommonUtils.canBeProxied(ipType)) {
            CdiUnproxyableBeanTypesInspection.registerProblem(holder, CdiUnproxyableBeanTypesInspection.getIdentifyingElement(injectionPoint.getOwner()), CdiInspectionBundle.message("CdiUnproxyableBeanTypesInspection.unproxyable.type.detected", new Object[0]));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "injectionPoint";
                break;
            }
        }
        objectArray2[1] = "com/intellij/cdi/highlighting/CdiUnproxyableBeanTypesInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "checkClass";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "checkPassivatingScopeProducers";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "checkInjectionPoint";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

