/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cdi.jam;

import com.intellij.cdi.constants.CdiAnnoConstants;
import com.intellij.cdi.utils.CdiCommonUtils;
import com.intellij.jam.JamBaseElement;
import com.intellij.jam.JamElement;
import com.intellij.jam.JamPomTarget;
import com.intellij.jam.JamStringAttributeElement;
import com.intellij.jam.reflect.JamAnnotationMeta;
import com.intellij.jam.reflect.JamAttributeMeta;
import com.intellij.jam.reflect.JamStringAttributeMeta;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.PomTarget;
import com.intellij.pom.references.PomService;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementRef;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiTarget;
import com.intellij.psi.PsiType;
import com.intellij.psi.targets.AliasingPsiTarget;
import com.intellij.psi.targets.DecapitalizedAliasingPsiTarget;
import com.intellij.psi.util.PropertyUtilBase;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CdiNamedBean<T extends PsiMember & PsiNamedElement>
extends JamBaseElement<T> {
    private static final JamStringAttributeMeta.Single<String> NAME_VALUE_META = JamAttributeMeta.singleString((String)"value");
    private final JamAnnotationMeta myMeta;
    private final boolean isStereotype;

    public CdiNamedBean(T psiMember, String annoName) {
        super(PsiElementRef.real(psiMember));
        this.myMeta = new JamAnnotationMeta(annoName);
        this.isStereotype = !CdiAnnoConstants.NAMED_ANNOTATION.javax().equals(annoName) && !CdiAnnoConstants.NAMED_ANNOTATION.jakarta().equals(annoName);
    }

    public boolean isStereotypeAnnotated() {
        return this.isStereotype;
    }

    @NotNull
    public String getName() {
        if (this.isStereotypeAnnotated()) {
            String string = this.getDefaultName();
            if (string == null) {
                CdiNamedBean.$$$reportNull$$$0(0);
            }
            return string;
        }
        String nameValue = this.getNamedStringAttributeElement().getStringValue();
        String string = StringUtil.isEmptyOrSpaces((String)nameValue) ? this.getDefaultName() : nameValue;
        if (string == null) {
            CdiNamedBean.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    private JamStringAttributeElement<String> getNamedStringAttributeElement() {
        JamStringAttributeElement jamStringAttributeElement = (JamStringAttributeElement)this.myMeta.getAttribute((PsiModifierListOwner)this.getPsiElement(), NAME_VALUE_META);
        if (jamStringAttributeElement == null) {
            CdiNamedBean.$$$reportNull$$$0(2);
        }
        return jamStringAttributeElement;
    }

    public abstract String getDefaultName();

    @Nullable
    public abstract PsiType getType();

    public PsiNamedElement getIdentifyingPsiElement() {
        PsiElement element = this.getPsiElement();
        return (PsiNamedElement)PomService.convertToPsi((Project)element.getProject(), (PomTarget)this.getPsiTarget());
    }

    public PsiTarget getPsiTarget() {
        JamStringAttributeElement<String> namedAttributeValue = this.getNamedStringAttributeElement();
        if (StringUtil.isEmptyOrSpaces((String)namedAttributeValue.getStringValue())) {
            return this.getAliasingPsiTarget();
        }
        return new JamPomTarget((JamElement)this, namedAttributeValue);
    }

    protected abstract PsiTarget getAliasingPsiTarget();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/cdi/jam/CdiNamedBean";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getNamedStringAttributeElement";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    public static class FieldMapping
    extends CdiNamedBean<PsiField> {
        public FieldMapping(PsiField psiField, String annoName) {
            super(psiField, annoName);
        }

        @Override
        public String getDefaultName() {
            return ((PsiField)this.getPsiElement()).getName();
        }

        @Override
        @Nullable
        public PsiType getType() {
            return ((PsiField)this.getPsiElement()).getType();
        }

        @Override
        protected PsiTarget getAliasingPsiTarget() {
            return new AliasingPsiTarget((PsiNamedElement)this.getPsiElement()){

                @NotNull
                public String getNameAlias(@NotNull String delegatePsiTargetName) {
                    if (delegatePsiTargetName == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    String string = StringUtil.decapitalize((String)delegatePsiTargetName);
                    if (string == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return string;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[switch (n) {
                        default -> 3;
                        case 1 -> 2;
                    }];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "delegatePsiTargetName";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/intellij/cdi/jam/CdiNamedBean$FieldMapping$1";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/intellij/cdi/jam/CdiNamedBean$FieldMapping$1";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getNameAlias";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray;
                            objectArray[2] = "getNameAlias";
                            break;
                        }
                        case 1: {
                            break;
                        }
                    }
                    String string = String.format(v0, objectArray);
                    throw switch (n) {
                        default -> new IllegalArgumentException(string);
                        case 1 -> new IllegalStateException(string);
                    };
                }
            };
        }
    }

    public static class MethodMapping
    extends CdiNamedBean<PsiMethod> {
        public MethodMapping(PsiMethod method, String annoName) {
            super(method, annoName);
        }

        @Override
        public String getDefaultName() {
            String propertyName = PropertyUtilBase.getPropertyName((PsiMethod)((PsiMethod)this.getPsiElement()));
            return propertyName == null ? ((PsiMethod)this.getPsiElement()).getName() : propertyName;
        }

        @Override
        @Nullable
        public PsiType getType() {
            return ((PsiMethod)this.getPsiElement()).getReturnType();
        }

        @Override
        protected PsiTarget getAliasingPsiTarget() {
            return new AliasingPsiTarget((PsiNamedElement)this.getPsiElement()){

                public String getNameAlias(@NotNull String delegatePsiTargetName) {
                    String propertyName;
                    if (delegatePsiTargetName == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return StringUtil.isEmptyOrSpaces((String)(propertyName = PropertyUtilBase.getPropertyName((String)delegatePsiTargetName))) ? super.getNameAlias(delegatePsiTargetName) : propertyName;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegatePsiTargetName", "com/intellij/cdi/jam/CdiNamedBean$MethodMapping$1", "getNameAlias"));
                }
            };
        }
    }

    public static class ClassMapping
    extends CdiNamedBean<PsiClass> {
        public ClassMapping(PsiClass psiClass, String annoName) {
            super(psiClass, annoName);
        }

        @Override
        public String getDefaultName() {
            return CdiCommonUtils.decapitalizeBeanName(StringUtil.notNullize((String)((PsiClass)this.getPsiElement()).getName()));
        }

        @Override
        @NotNull
        public PsiType getType() {
            PsiClass psiClass = (PsiClass)this.getPsiElement();
            PsiClassType psiClassType = JavaPsiFacade.getElementFactory((Project)psiClass.getProject()).createType(psiClass);
            if (psiClassType == null) {
                ClassMapping.$$$reportNull$$$0(0);
            }
            return psiClassType;
        }

        @Override
        protected PsiTarget getAliasingPsiTarget() {
            return new DecapitalizedAliasingPsiTarget((PsiNamedElement)this.getPsiElement());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/cdi/jam/CdiNamedBean$ClassMapping", "getType"));
        }
    }
}

