/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cdi.jam;

import com.intellij.cdi.beans.CdiCustomizationManager;
import com.intellij.cdi.beans.CdiCustomizationProvider;
import com.intellij.cdi.constants.CdiAnnoConstants;
import com.intellij.cdi.jam.CdiNamedBean;
import com.intellij.cdi.jam.decorators.CdiDecorator;
import com.intellij.cdi.jam.events.CdiEventObserves;
import com.intellij.cdi.jam.events.CdiEventObservesAsync;
import com.intellij.cdi.jam.inject.CdiInject;
import com.intellij.cdi.jam.interceptor.CdiInterceptor;
import com.intellij.cdi.jam.lifecycle.CdiDispose;
import com.intellij.cdi.jam.priority.CdiPriority;
import com.intellij.cdi.jam.producers.CdiProduces;
import com.intellij.cdi.jam.specialization.CdiSpecializes;
import com.intellij.cdi.utils.CdiCommonUtils;
import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.jam.JamService;
import com.intellij.jam.reflect.JamMemberMeta;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.patterns.PsiMemberPattern;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementRef;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.semantic.SemContributor;
import com.intellij.semantic.SemKey;
import com.intellij.semantic.SemRegistrar;
import com.intellij.semantic.SemService;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CdiSemContributor
extends SemContributor {
    private static final SemKey<JamMemberMeta<PsiMember, CdiNamedBean<?>>> NAMED_META_KEY = JamService.ALIASING_MEMBER_META_KEY.subKey("CdiNamedBeanMeta", new SemKey[0]);
    public static final SemKey<CdiNamedBean<?>> NAMED_JAM_KEY = JamService.JAM_ALIASING_ELEMENT_KEY.subKey("CdiNamedBean", new SemKey[0]);

    protected boolean isAvailable(@NotNull Project project) {
        if (project == null) {
            CdiSemContributor.$$$reportNull$$$0(0);
        }
        return CdiCommonUtils.isCdiAvailable(project);
    }

    public void registerSemProviders(@NotNull SemRegistrar registrar, @NotNull Project project) {
        if (registrar == null) {
            CdiSemContributor.$$$reportNull$$$0(1);
        }
        if (project == null) {
            CdiSemContributor.$$$reportNull$$$0(2);
        }
        PsiMemberPattern.Capture psiMemberPlace = PsiJavaPatterns.psiMember();
        registrar.registerSemElementProvider(NAMED_META_KEY, (ElementPattern)psiMemberPlace, CdiSemContributor::calcNamedBeanMeta);
        registrar.registerSemElementProvider(NAMED_JAM_KEY, (ElementPattern)psiMemberPlace, member -> {
            JamMemberMeta memberMeta = (JamMemberMeta)SemService.getSemService((Project)project).getSemElement(NAMED_META_KEY, (PsiElement)member);
            return memberMeta != null ? (CdiNamedBean)memberMeta.createJamElement(PsiElementRef.real((PsiElement)member)) : null;
        });
        registrar.registerSemElementProvider(CdiInject.INJECT_META_KEY, (ElementPattern)psiMemberPlace, CdiSemContributor::calcInjectPlaceMeta);
        registrar.registerSemElementProvider(CdiInject.INJECT_JAM_KEY, (ElementPattern)psiMemberPlace, member -> {
            JamMemberMeta memberMeta = (JamMemberMeta)SemService.getSemService((Project)project).getSemElement(CdiInject.INJECT_META_KEY, (PsiElement)member);
            return memberMeta != null ? (CdiInject)memberMeta.createJamElement(PsiElementRef.real((PsiElement)member)) : null;
        });
        CdiEventObserves.META.register(registrar, (ElementPattern)PsiJavaPatterns.psiParameter().withAnnotations(CdiAnnoConstants.OBSERVES_ANNOTATION.all()));
        CdiEventObservesAsync.META.register(registrar, (ElementPattern)PsiJavaPatterns.psiParameter().withAnnotations(CdiAnnoConstants.OBSERVES_ASYNC_ANNOTATION.all()));
        CdiDispose.META.register(registrar, (ElementPattern)PsiJavaPatterns.psiParameter().withAnnotations(CdiAnnoConstants.DISPOSES_ANNOTATION.all()));
        CdiProduces.METHOD_META.register(registrar, (ElementPattern)PsiJavaPatterns.psiMethod().withAnnotations(CdiAnnoConstants.PRODUCES_ANNOTATION.all()));
        CdiProduces.FIELD_META.register(registrar, (ElementPattern)PsiJavaPatterns.psiField().withAnnotations(CdiAnnoConstants.PRODUCES_ANNOTATION.all()));
        CdiInterceptor.META.register(registrar, (ElementPattern)PsiJavaPatterns.psiClass().withAnnotations(CdiAnnoConstants.INTERCEPTOR_BINDING_ANNOTATION.all()));
        CdiDecorator.META.register(registrar, (ElementPattern)PsiJavaPatterns.psiClass().withAnnotations(CdiAnnoConstants.DECORATOR_ANNOTATION.all()));
        CdiSpecializes.CLASS_META.register(registrar, (ElementPattern)PsiJavaPatterns.psiClass().withAnnotations(CdiAnnoConstants.SPECIALIZES_ANNOTATION.all()));
        CdiSpecializes.METHOD_META.register(registrar, (ElementPattern)PsiJavaPatterns.psiMethod().withAnnotations(CdiAnnoConstants.SPECIALIZES_ANNOTATION.all()));
        CdiPriority.CLASS_META.register(registrar, (ElementPattern)PsiJavaPatterns.psiClass().withAnnotations(CdiAnnoConstants.PRIORITY_ANNOTATION.all()));
        CdiPriority.METHOD_META.register(registrar, (ElementPattern)PsiJavaPatterns.psiMethod().withAnnotations(CdiAnnoConstants.PRIORITY_ANNOTATION.all()));
    }

    private static JamMemberMeta<PsiMember, CdiNamedBean<?>> calcNamedBeanMeta(PsiMember member) {
        String namedAnno = CdiAnnoConstants.NAMED_ANNOTATION.fqnFromAnnotated((PsiModifierListOwner)member);
        if (AnnotationUtil.isAnnotated((PsiModifierListOwner)member, (String)namedAnno, (int)1)) {
            return CdiSemContributor.createNamedBeanMeta(namedAnno).addPomTargetProducer((cdiNamedBean, consumer) -> consumer.consume((Object)cdiNamedBean.getPsiTarget()));
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)member);
        if (module == null) {
            return null;
        }
        Collection<PsiClass> stereotypeAnnotationClasses = CdiCommonUtils.getStereotypeAnnotationClasses(module, namedAnno);
        for (PsiClass stereotypeAnnotation : stereotypeAnnotationClasses) {
            String annotationFQN = stereotypeAnnotation.getQualifiedName();
            if (annotationFQN == null || !AnnotationUtil.isAnnotated((PsiModifierListOwner)member, (String)annotationFQN, (int)1)) continue;
            return CdiSemContributor.createNamedBeanMeta(annotationFQN);
        }
        return null;
    }

    private static JamMemberMeta<PsiMember, CdiNamedBean<?>> createNamedBeanMeta(String annotationFQN) {
        return new JamMemberMeta(null, NAMED_JAM_KEY, ref -> CdiSemContributor.createNamedBean((PsiMember)ref.getPsiElement(), annotationFQN));
    }

    @Nullable
    private static CdiNamedBean<?> createNamedBean(PsiMember member, String annoName) {
        if (member instanceof PsiClass && !((PsiClass)member).isAnnotationType()) {
            return new CdiNamedBean.ClassMapping((PsiClass)member, annoName);
        }
        if (member instanceof PsiMethod) {
            return new CdiNamedBean.MethodMapping((PsiMethod)member, annoName);
        }
        if (member instanceof PsiField) {
            return new CdiNamedBean.FieldMapping((PsiField)member, annoName);
        }
        return null;
    }

    private static JamMemberMeta<PsiMember, CdiInject<?>> calcInjectPlaceMeta(PsiMember member) {
        if (CdiAnnoConstants.INJECT_ANNOTATION.isAnnotated((PsiModifierListOwner)member, 1)) {
            return CdiSemContributor.createInjectPlaceMeta();
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)member);
        if (module == null) {
            return null;
        }
        CdiCustomizationProvider customization = CdiCustomizationManager.getCustomization(module);
        if (customization == null || !customization.isInjectByQualifierEnabled()) {
            return null;
        }
        PsiAnnotation[] annotations = CdiCommonUtils.getQualifierAnnotations((PsiModifierListOwner)member);
        if (annotations.length == 0) {
            return null;
        }
        return CdiSemContributor.createInjectPlaceMeta();
    }

    private static JamMemberMeta<PsiMember, CdiInject<?>> createInjectPlaceMeta() {
        return new JamMemberMeta(null, CdiInject.INJECT_JAM_KEY, ref -> CdiSemContributor.createInjectPlace((PsiMember)ref.getPsiElement()));
    }

    @Nullable
    private static CdiInject<?> createInjectPlace(PsiMember member) {
        if (member instanceof PsiMethod) {
            return new CdiInject.Method((PsiMethod)member);
        }
        if (member instanceof PsiField) {
            return new CdiInject.Field((PsiField)member);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "registrar";
                break;
            }
        }
        objectArray2[1] = "com/intellij/cdi/jam/CdiSemContributor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isAvailable";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "registerSemProviders";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

