/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cdi.logical.providers;

import com.intellij.cdi.beans.CdiBeanPsiClassDescriptor;
import com.intellij.cdi.constants.CdiAnnoConstants;
import com.intellij.cdi.jam.inject.CdiInject;
import com.intellij.cdi.jam.producers.CdiProduces;
import com.intellij.cdi.logical.CdiBeanLogicalModel;
import com.intellij.cdi.manager.CdiDescriptorsFactory;
import com.intellij.cdi.manager.CdiManager;
import com.intellij.cdi.utils.CdiCommonUtils;
import com.intellij.cdi.utils.CdiInjectionUtils;
import com.intellij.cdi.utils.CdiManagedBeanValidationUtils;
import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.javaee.utils.JavaeeClass;
import com.intellij.lang.java.logical.PsiClassLogicalElementProvider;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0007J\u0010\u0010\u000b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\r\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\u000e"}, d2={"Lcom/intellij/cdi/logical/providers/CdiBeanLogicalStructureProvider;", "Lcom/intellij/lang/java/logical/PsiClassLogicalElementProvider;", "Lcom/intellij/cdi/logical/CdiBeanLogicalModel;", "<init>", "()V", "convert", "p", "Lcom/intellij/psi/PsiClass;", "hasInjectionPoints", "", "psiClass", "isNamedClass", "hasNormaScopeAnnotation", "hasImplicitProducesAnnotation", "intellij.javaee.cdi"})
@SourceDebugExtension(value={"SMAP\nCdiBeanLogicalStructureProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CdiBeanLogicalStructureProvider.kt\ncom/intellij/cdi/logical/providers/CdiBeanLogicalStructureProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,40:1\n1374#2:41\n1460#2,5:42\n*S KotlinDebug\n*F\n+ 1 CdiBeanLogicalStructureProvider.kt\ncom/intellij/cdi/logical/providers/CdiBeanLogicalStructureProvider\n*L\n38#1:41\n38#1:42,5\n*E\n"})
public final class CdiBeanLogicalStructureProvider
extends PsiClassLogicalElementProvider<CdiBeanLogicalModel> {
    @Nullable
    public CdiBeanLogicalModel convert(@NotNull PsiClass p) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        Project project = p.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        if (DumbService.Companion.isDumb(project)) {
            return null;
        }
        if (CdiCommonUtils.isManagedBean(p) && (this.isNamedClass(p) || this.hasNormaScopeAnnotation(p) || this.hasImplicitProducesAnnotation(p) || this.hasInjectionPoints(p))) {
            PsiElement psiElement = (PsiElement)p;
            CdiBeanPsiClassDescriptor cdiBeanPsiClassDescriptor = CdiDescriptorsFactory.createCdiBeanDescriptor(p);
            Intrinsics.checkNotNullExpressionValue((Object)cdiBeanPsiClassDescriptor, (String)"createCdiBeanDescriptor(...)");
            return new CdiBeanLogicalModel(psiElement, cdiBeanPsiClassDescriptor, true);
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean hasInjectionPoints(@NotNull PsiClass psiClass) {
        Intrinsics.checkNotNullParameter((Object)psiClass, (String)"psiClass");
        List<CdiInject<?>> list = CdiInjectionUtils.geInjectMembers(psiClass);
        Intrinsics.checkNotNullExpressionValue(list, (String)"geInjectMembers(...)");
        if (!((Collection)list).isEmpty()) {
            return true;
        }
        boolean bl = false;
        if (bl) return true;
        List<CdiProduces<?>> list2 = CdiInjectionUtils.getProduces(psiClass);
        Intrinsics.checkNotNullExpressionValue(list2, (String)"getProduces(...)");
        if (!((Collection)list2).isEmpty()) {
            return true;
        }
        boolean bl2 = false;
        if (bl2) return true;
        List<PsiMethod> list3 = CdiCommonUtils.getObservesMethods(psiClass);
        Intrinsics.checkNotNullExpressionValue(list3, (String)"getObservesMethods(...)");
        if (!((Collection)list3).isEmpty()) {
            return true;
        }
        boolean bl3 = false;
        if (bl3) return true;
        Set<PsiMethod> set = CdiCommonUtils.getDisposerMethods(psiClass);
        Intrinsics.checkNotNullExpressionValue(set, (String)"getDisposerMethods(...)");
        if (!((Collection)set).isEmpty()) {
            return true;
        }
        boolean bl4 = false;
        if (bl4) return true;
        if (!CdiManagedBeanValidationUtils.isAnnotatedAsCustomBean(psiClass)) return false;
        return true;
    }

    private final boolean isNamedClass(PsiClass p) {
        PsiModifierListOwner psiModifierListOwner = (PsiModifierListOwner)p;
        String[] stringArray = CdiAnnoConstants.NAMED_ANNOTATION.all();
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"all(...)");
        return AnnotationUtil.isAnnotated((PsiModifierListOwner)psiModifierListOwner, (Collection)ArraysKt.asList((Object[])stringArray), (int)0);
    }

    private final boolean hasNormaScopeAnnotation(PsiClass p) {
        return AnnotationUtil.isAnnotated((PsiModifierListOwner)((PsiModifierListOwner)p), (Collection)CdiCommonUtils.NORMAL_SCOPE_ANNOTATIONS, (int)0);
    }

    /*
     * WARNING - void declaration
     */
    private final boolean hasImplicitProducesAnnotation(PsiClass p) {
        void $this$flatMapTo$iv$iv;
        void $this$flatMap$iv;
        PsiModifierListOwner psiModifierListOwner = (PsiModifierListOwner)p;
        List<JavaeeClass> list = CdiManager.IMPLICIT_PRODUCES_ANNOTATIONS;
        Intrinsics.checkNotNullExpressionValue(list, (String)"IMPLICIT_PRODUCES_ANNOTATIONS");
        Iterable iterable = list;
        PsiModifierListOwner psiModifierListOwner2 = psiModifierListOwner;
        boolean $i$f$flatMap = false;
        void var4_5 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            JavaeeClass it = (JavaeeClass)element$iv$iv;
            boolean bl = false;
            Object[] objectArray = new String[]{it.javax(), it.jakarta()};
            Iterable list$iv$iv = CollectionsKt.listOf((Object[])objectArray);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return AnnotationUtil.isAnnotated((PsiModifierListOwner)psiModifierListOwner2, (Collection)((List)destination$iv$iv), (int)0);
    }
}

