/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.cli;

import com.intellij.docker.DockerCloudConfiguration;
import com.intellij.docker.DockerCloudConfigurationKt;
import com.intellij.docker.agent.DockerCliConnectionHint;
import com.intellij.docker.agent.DockerCliConnectionHintKt;
import com.intellij.docker.agent.cli.DockerCli;
import com.intellij.docker.cli.CliExecutor;
import com.intellij.docker.cli.DockerComposeCli;
import com.intellij.docker.compose.cli.DockerComposeCliUtil;
import com.intellij.docker.i18n.DockerBundle;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.CapturingProcessHandler;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\u0018\u0000 \u00042\u00020\u0001:\u0001\u0004B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0005"}, d2={"Lcom/intellij/docker/cli/DockerComposeCli;", "", "<init>", "()V", "Companion", "intellij.clouds.docker"})
@SourceDebugExtension(value={"SMAP\nDockerCliExecutor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DockerCliExecutor.kt\ncom/intellij/docker/cli/DockerComposeCli\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,173:1\n14#2:174\n*S KotlinDebug\n*F\n+ 1 DockerCliExecutor.kt\ncom/intellij/docker/cli/DockerComposeCli\n*L\n26#1:174\n*E\n"})
public final class DockerComposeCli {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String VERSION_COMMAND = "version";
    @NotNull
    private static final String SHORT_FLAG = "--short";
    @NotNull
    private static final Logger logger;

    private DockerComposeCli() {
    }

    @JvmStatic
    @NotNull
    public static final String getVersion(@NotNull DockerCloudConfiguration config2, @Nullable ProgressIndicator indicator) throws ExecutionException {
        return Companion.getVersion(config2, indicator);
    }

    @JvmStatic
    private static final ProcessOutput runCommand(ProgressIndicator indicator, GeneralCommandLine cmd) throws ExecutionException {
        return DockerComposeCli.Companion.runCommand(indicator, cmd);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(DockerComposeCli.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        DockerComposeCli.logger = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J8\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0014\b\u0002\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u000e2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u0005H\u0086@\u00a2\u0006\u0002\u0010\u0010J\u0016\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\nH\u0086@\u00a2\u0006\u0002\u0010\u0013J\u001c\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f2\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0007J\u001a\u0010\u0016\u001a\u00020\u00172\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0018\u001a\u00020\u0019H\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/intellij/docker/cli/DockerComposeCli$Companion;", "", "<init>", "()V", "VERSION_COMMAND", "", "SHORT_FLAG", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "createExecutor", "Lcom/intellij/docker/cli/CliExecutor;", "config", "Lcom/intellij/docker/DockerCloudConfiguration;", "additionalEnvs", "", "overrideComposeExePath", "(Lcom/intellij/docker/DockerCloudConfiguration;Ljava/util/Map;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getVersion", "cliExecutor", "(Lcom/intellij/docker/cli/CliExecutor;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "runCommand", "Lcom/intellij/execution/process/ProcessOutput;", "cmd", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "intellij.clouds.docker"})
    @SourceDebugExtension(value={"SMAP\nDockerCliExecutor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DockerCliExecutor.kt\ncom/intellij/docker/cli/DockerComposeCli$Companion\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,173:1\n37#2:174\n36#2,3:175\n543#3,6:178\n*S KotlinDebug\n*F\n+ 1 DockerCliExecutor.kt\ncom/intellij/docker/cli/DockerComposeCli$Companion\n*L\n60#1:174\n60#1:175,3\n61#1:178,6\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * Unable to fully structure code
         */
        @Nullable
        public final Object createExecutor(@NotNull DockerCloudConfiguration config, @NotNull Map<String, String> additionalEnvs, @Nullable String overrideComposeExePath, @NotNull Continuation<? super CliExecutor> $completion) {
            if (!($completion instanceof createExecutor.1)) ** GOTO lbl-1000
            var10_5 = $completion;
            if ((var10_5.label & -2147483648) != 0) {
                var10_5.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, $completion){
                    Object L$0;
                    Object L$1;
                    Object L$2;
                    /* synthetic */ Object result;
                    final /* synthetic */ Companion this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return this.this$0.createExecutor(null, null, null, (Continuation<? super CliExecutor>)((Continuation)this));
                    }
                };
            }
            $result = $continuation.result;
            var11_7 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    $continuation.L$0 = config;
                    $continuation.L$1 = additionalEnvs;
                    $continuation.L$2 = overrideComposeExePath;
                    $continuation.label = 1;
                    v0 = DockerCloudConfigurationKt.updateBinaryPaths(config, (Continuation<? super Unit>)$continuation);
                    if (v0 == var11_7) {
                        return var11_7;
                    }
                    ** GOTO lbl26
                }
                case 1: {
                    overrideComposeExePath = (String)$continuation.L$2;
                    additionalEnvs = (Map)$continuation.L$1;
                    config = (DockerCloudConfiguration)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl26:
                    // 2 sources

                    envVars = MapsKt.plus((Map)DockerCliConnectionHintKt.createEnvVars((DockerCliConnectionHint)config.getCliConnectionHint()), (Map)additionalEnvs);
                    if (DockerComposeCliUtil.isUseComposeV2(config)) {
                        v1 = overrideComposeExePath;
                        if (v1 == null && (v1 = config.getDockerComposeExePath()) == null) {
                            throw new IllegalStateException("Docker compose exe path should be specified".toString());
                        }
                        var6_9 = v1;
                        var7_10 = config.getCliProcessCreator$intellij_clouds_docker();
                        var8_11 = config.getEelApiProvider$intellij_clouds_docker();
                        v2 = (CliExecutor)new DockerCli(envVars, var6_9, var7_10, var8_11){};
                    } else {
                        v3 = overrideComposeExePath;
                        if (v3 == null && (v3 = config.getDockerComposeExePath()) == null) {
                            throw new IllegalStateException("Docker compose exe path should be specified".toString());
                        }
                        v2 = new CliExecutor(v3, envVars, config.getCliProcessCreator$intellij_clouds_docker(), config.getEelApiProvider$intellij_clouds_docker());
                    }
                    return v2;
                }
            }
            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
        }

        public static /* synthetic */ Object createExecutor$default(Companion companion, DockerCloudConfiguration dockerCloudConfiguration, Map map, String string, Continuation continuation, int n, Object object) {
            if ((n & 2) != 0) {
                map = MapsKt.emptyMap();
            }
            if ((n & 4) != 0) {
                string = null;
            }
            return companion.createExecutor(dockerCloudConfiguration, map, string, (Continuation<? super CliExecutor>)continuation);
        }

        @Nullable
        public final Object getVersion(@NotNull CliExecutor cliExecutor, @NotNull Continuation<? super String> $completion) {
            String[] stringArray;
            String[] $this$getVersion_u24lambda_u240 = stringArray = CollectionsKt.createListBuilder();
            boolean bl = false;
            if (cliExecutor instanceof DockerCli) {
                $this$getVersion_u24lambda_u240.add("compose");
            }
            $this$getVersion_u24lambda_u240.add(DockerComposeCli.VERSION_COMMAND);
            $this$getVersion_u24lambda_u240.add(DockerComposeCli.SHORT_FLAG);
            List args = CollectionsKt.build((List)stringArray);
            Collection $this$toTypedArray$iv = args;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            stringArray = thisCollection$iv.toArray(new String[0]);
            return cliExecutor.run(Arrays.copyOf(stringArray, stringArray.length), Companion::getVersion$lambda$2, $completion);
        }

        @JvmStatic
        @NotNull
        public final String getVersion(@NotNull DockerCloudConfiguration config2, @Nullable ProgressIndicator indicator) throws ExecutionException {
            Intrinsics.checkNotNullParameter((Object)((Object)config2), (String)"config");
            Object[] objectArray = new String[]{DockerComposeCli.VERSION_COMMAND, DockerComposeCli.SHORT_FLAG};
            GeneralCommandLine generalCommandLine = DockerComposeCliUtil.createDockerComposeCommandlineBlocking$default(config2, null, false, 6, null).withParameters((String[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)generalCommandLine, (String)"withParameters(...)");
            GeneralCommandLine cmd = generalCommandLine;
            ProcessOutput processOutput = this.runCommand(indicator, cmd);
            if (processOutput.getExitCode() != 0 || processOutput.isTimeout()) {
                if (processOutput.isTimeout()) {
                    logger.debug(processOutput.getStderr() + "\nTimed out");
                    throw new ExecutionException(DockerBundle.message((String)"DockerComposeCli.error.version.command.time.out", (Object[])new Object[0]));
                }
                logger.debug(processOutput.getStderr() + "\nExit code " + processOutput.getExitCode());
                objectArray = new Object[]{processOutput.getExitCode()};
                throw new ExecutionException(DockerBundle.message((String)"DockerComposeCli.error.version.command.nonzero.exit.code", (Object[])objectArray));
            }
            String string = processOutput.getStdout();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getStdout(...)");
            String stdout = string;
            if (StringsKt.isBlank((CharSequence)stdout)) {
                Object[] objectArray2 = new Object[]{stdout};
                throw new ExecutionException(DockerBundle.message((String)"DockerComposeCli.error.cant.find.version.in.output", (Object[])objectArray2));
            }
            return ((Object)StringsKt.trim((CharSequence)stdout)).toString();
        }

        public static /* synthetic */ String getVersion$default(Companion companion, DockerCloudConfiguration dockerCloudConfiguration, ProgressIndicator progressIndicator, int n, Object object) throws ExecutionException {
            if ((n & 2) != 0) {
                progressIndicator = null;
            }
            return companion.getVersion(dockerCloudConfiguration, progressIndicator);
        }

        @JvmStatic
        private final ProcessOutput runCommand(ProgressIndicator indicator, GeneralCommandLine cmd) throws ExecutionException {
            ProcessBuilder processBuilder = new ProcessBuilder(new String[0]).command(cmd.getCommandLineList(null));
            Process process = null;
            try {
                Process process2 = processBuilder.start();
                Intrinsics.checkNotNullExpressionValue((Object)process2, (String)"start(...)");
                process = process2;
            }
            catch (IOException e) {
                throw new ExecutionException((Throwable)e);
            }
            CapturingProcessHandler processHandler = new CapturingProcessHandler(process, cmd.getCharset(), cmd.getCommandLineString());
            if (indicator != null) {
                ProcessOutput processOutput = processHandler.runProcessWithProgressIndicator(indicator);
                Intrinsics.checkNotNullExpressionValue((Object)processOutput, (String)"runProcessWithProgressIndicator(...)");
                return processOutput;
            }
            ProcessOutput processOutput = processHandler.runProcess();
            Intrinsics.checkNotNullExpressionValue((Object)processOutput, (String)"runProcess(...)");
            return processOutput;
        }

        private static final String getVersion$lambda$2(List stdoutLines) {
            Object v1;
            block2: {
                Intrinsics.checkNotNullParameter((Object)stdoutLines, (String)"stdoutLines");
                List $this$lastOrNull$iv = stdoutLines;
                boolean $i$f$lastOrNull = false;
                ListIterator iterator$iv = $this$lastOrNull$iv.listIterator($this$lastOrNull$iv.size());
                while (iterator$iv.hasPrevious()) {
                    Object element$iv = iterator$iv.previous();
                    String it = (String)element$iv;
                    boolean bl = false;
                    boolean bl2 = !StringsKt.isBlank((CharSequence)it);
                    if (!bl2) continue;
                    v1 = element$iv;
                    break block2;
                }
                v1 = null;
            }
            String string = v1;
            if (string == null) {
                Object[] objectArray = new Object[]{CollectionsKt.joinToString$default((Iterable)stdoutLines, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null)};
                throw new ExecutionException(DockerBundle.message((String)"DockerComposeCli.error.cant.find.version.in.output", (Object[])objectArray));
            }
            return string;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

