/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.utils;

import com.intellij.docker.DockerCloudConfiguration;
import java.net.URI;
import java.net.URISyntaxException;
import org.jetbrains.annotations.NotNull;

public final class DockerEngineUtil {
    private static final String UNIX_URL_SCHEME = "unix";
    private static final String WINDOWS_NPIPE_SCHEME = "npipe";

    private DockerEngineUtil() {
    }

    public static boolean isUnixSocket(@NotNull DockerCloudConfiguration account) {
        if (account == null) {
            DockerEngineUtil.$$$reportNull$$$0(0);
        }
        return DockerEngineUtil.isUnixSocket(DockerEngineUtil.getDockerApiUri(account));
    }

    public static boolean isUnixSocket(@NotNull URI dockerApiUri) {
        if (dockerApiUri == null) {
            DockerEngineUtil.$$$reportNull$$$0(1);
        }
        return UNIX_URL_SCHEME.equals(dockerApiUri.getScheme());
    }

    public static boolean isWindowsPipe(@NotNull URI dockerApiUri) {
        if (dockerApiUri == null) {
            DockerEngineUtil.$$$reportNull$$$0(2);
        }
        return WINDOWS_NPIPE_SCHEME.equals(dockerApiUri.getScheme());
    }

    @NotNull
    public static URI getDockerApiUri(@NotNull DockerCloudConfiguration account) {
        if (account == null) {
            DockerEngineUtil.$$$reportNull$$$0(3);
        }
        try {
            return new URI(account.getApiUrl());
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException(e);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "account";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dockerApiUri";
                break;
            }
        }
        objectArray2[1] = "com/intellij/docker/utils/DockerEngineUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isUnixSocket";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isWindowsPipe";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getDockerApiUri";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

