/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.sshAgentProxy;

import com.intellij.community.wintools.ErrorToolsKt;
import com.intellij.openapi.diagnostic.Logger;
import com.jetbrains.codeWithMe.model.SshRequesterProcessInfo;
import com.jetbrains.rdserver.actions.ActionTimestamp;
import com.jetbrains.rdserver.portForwarding.utils.ProcessInfoUtil;
import com.jetbrains.rdserver.sshAgentProxy.SshAgentIpc;
import com.jetbrains.rdserver.sshAgentProxy.SshAgentIpcService;
import com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.win32.W32APIOptions;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u0000 '2\u00020\u0001:\u0005&'()*B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010\u0013\u001a\u00020\u0012H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u0006\u0010\u0019\u001a\u00020\u001aJ\u0010\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u001dH\u0014J\b\u0010#\u001a\u00020\u0012H\u0002J\b\u0010$\u001a\u00020\u0012H\u0016J\b\u0010%\u001a\u00020\u0012H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0016R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010 \u001a\u00020\u001f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"\u00a8\u0006+"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "Lcom/jetbrains/rdserver/sshAgentProxy/SshAgentIpc;", "pipePath", "", "WindowsNamedPipeAgentIpc", "(Ljava/lang/String;)V", "key", "getKey", "()Ljava/lang/String;", "hPipe", "Lcom/sun/jna/platform/win32/WinNT$HANDLE;", "lock", "", "connectionThread", "Ljava/lang/Thread;", "state", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$NamedPipeState;", "assertConnectionThread", "", "open", "isOpen", "", "()Z", "accept", "Lcom/jetbrains/rdserver/sshAgentProxy/SshAgentIpc$Streams;", "getRequesterPid", "", "isSshProcess", "process", "Lcom/jetbrains/rdserver/portForwarding/utils/ProcessInfoUtil$ProcessInfo;", "requestorProcessValue", "Lcom/jetbrains/codeWithMe/model/SshRequesterProcessInfo;", "requesterProcessInfo", "getRequesterProcessInfo", "()Lcom/jetbrains/codeWithMe/model/SshRequesterProcessInfo;", "disconnect", "close", "cleanup", "NamedPipeState", "Companion", "Kernel32Ex", "PipeReadableByteChannel", "PipeWritableByteChannel", "intellij.platform.backend.split"})
@SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n1#2:392\n24#3:393\n24#3:394\n24#3:395\n24#3:396\n24#3:397\n24#3:398\n24#3:399\n24#3:400\n24#3:401\n24#3:402\n24#3:403\n24#3:404\n24#3:405\n24#3:406\n24#3:407\n24#3:408\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc\n*L\n131#1:393\n142#1:394\n151#1:395\n161#1:396\n179#1:397\n203#1:398\n208#1:399\n228#1:400\n236#1:401\n238#1:402\n249#1:403\n264#1:404\n274#1:405\n284#1:406\n288#1:407\n290#1:408\n*E\n"})
public final class WindowsNamedPipeAgentIpc
extends SshAgentIpc {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final String pipePath;
    @NotNull
    private final String key;
    @NotNull
    private WinNT.HANDLE hPipe;
    @NotNull
    private final Object lock;
    @Nullable
    private Thread connectionThread;
    @NotNull
    private NamedPipeState state;
    @NotNull
    private SshRequesterProcessInfo requestorProcessValue;
    private static final String[] c;
    private static final String[] d;

    public WindowsNamedPipeAgentIpc(@NotNull String pipePath) {
        long l2 = 91598402559582L;
        Intrinsics.checkNotNullParameter((Object)pipePath, (String)WindowsNamedPipeAgentIpc.b(-365029950 - -((char)-1191), -364898880 + -((char)-20687), (int)l2));
        this.key = this.pipePath = pipePath;
        WinNT.HANDLE hANDLE = WinNT.INVALID_HANDLE_VALUE;
        Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(-365029950 - -((char)-1192), -364898880 + -((char)-24477), (int)l2));
        this.hPipe = hANDLE;
        this.lock = new Object();
        this.state = NamedPipeState.Initial;
        this.requestorProcessValue = SshAgentIpc.Companion.getMissingProcessInfo();
    }

    @Override
    @NotNull
    public String getKey() {
        return this.key;
    }

    private final void assertConnectionThread() {
        block3: {
            boolean bl;
            Thread thread;
            long l2;
            block2: {
                l2 = 11377078115712L;
                thread = Thread.currentThread();
                String[] stringArray = SshAgentIpcService.K();
                try {
                    bl = Intrinsics.areEqual((Object)thread, (Object)this.connectionThread);
                    if (stringArray == null) break block2;
                    if (bl) break block3;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                bl = false;
            }
            boolean bl2 = bl;
            Thread thread2 = thread;
            Thread thread3 = this.connectionThread;
            String string = this.pipePath;
            String string2 = WindowsNamedPipeAgentIpc.b(-290188980 + -((char)-379), -290188980 + -((char)-22616), (int)l2) + string + WindowsNamedPipeAgentIpc.b(-290188980 + -((char)-378), -290188980 + -((char)-26332), (int)l2) + thread3 + WindowsNamedPipeAgentIpc.b(-290188980 + -((char)-373), 290188980 + (char)-24114, (int)l2) + thread2;
            throw new IllegalArgumentException(string2.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open() {
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
        long l2;
        block14: {
            block15: {
                l2 = 40641080042736L;
                Object object = this.lock;
                String[] stringArray = SshAgentIpcService.K();
                synchronized (object) {
                    boolean bl;
                    boolean bl2 = false;
                    try {
                        bl = this.connectionThread == null;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl) {
                        boolean bl3 = false;
                        String string = WindowsNamedPipeAgentIpc.b(2099479260 + 10452, 2099479260 + 15824, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(2099479260 + 10455, 2099479260 + 22239, (int)l2) + this.state;
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.connectionThread = Thread.currentThread();
                    Unit unit = Unit.INSTANCE;
                }
                try {
                    try {
                        WinNT.HANDLE hANDLE = Kernel32.INSTANCE.CreateNamedPipe(this.pipePath, 3, 0, 1, 16384, 16384, 0, null);
                        Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(2099479260 + 10454, -2099479260 + -12905, (int)l2));
                        this.hPipe = hANDLE;
                        windowsNamedPipeAgentIpc = this;
                        if (stringArray == null) break block14;
                        if (Intrinsics.areEqual((Object)windowsNamedPipeAgentIpc.hPipe, (Object)WinNT.INVALID_HANDLE_VALUE)) {
                        }
                        break block15;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    throw new RuntimeException(WindowsNamedPipeAgentIpc.b(2099479260 + 10465, 2099479260 + 23809, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(2099479260 + 10464, 2099479260 + 23775, (int)l2) + ErrorToolsKt.kernel32LastError());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
            }
            this.state = NamedPipeState.Open;
            windowsNamedPipeAgentIpc = this;
        }
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = windowsNamedPipeAgentIpc;
        boolean bl = false;
        try {
            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(2099479260 + 10467, 2099479260 + 11544, (int)l2));
            logger.info(WindowsNamedPipeAgentIpc.b(2099479260 + 10465, 2099479260 + 23809, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(2099479260 + 10466, -2099479260 + -8610, (int)l2));
            if (ActionTimestamp.K() != null) {
                SshAgentIpcService.K(new String[4]);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
        }
    }

    @Override
    public boolean isOpen() {
        int n2;
        block8: {
            block7: {
                String[] stringArray;
                block6: {
                    long l2 = 90954270158469L;
                    stringArray = SshAgentIpcService.K();
                    try {
                        try {
                            n2 = this.state.compareTo((Enum)NamedPipeState.Open);
                            if (stringArray == null) break block6;
                            if (n2 < 0) break block7;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        n2 = this.state.compareTo((Enum)NamedPipeState.Disconnecting);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                try {
                    if (stringArray == null) break block8;
                    if (n2 > 0) break block7;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                n2 = 1;
                break block8;
            }
            n2 = 0;
        }
        return n2 != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    @NotNull
    public SshAgentIpc.Streams accept() {
        SshAgentIpc.Streams streams;
        Object object;
        Object object2;
        String[] stringArray;
        long l2;
        block27: {
            block28: {
                l2 = 60582901043099L;
                this.assertConnectionThread();
                Object object3 = this.lock;
                synchronized (object3) {
                    boolean bl;
                    NamedPipeState namedPipeState;
                    NamedPipeState namedPipeState2;
                    block25: {
                        block26: {
                            stringArray = SshAgentIpcService.K();
                            boolean bl2 = false;
                            try {
                                namedPipeState2 = this.state;
                                namedPipeState = NamedPipeState.Closing;
                                if (stringArray == null) break block25;
                                if (namedPipeState2.compareTo((Enum)namedPipeState) < 0) break block26;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
                            boolean bl3 = false;
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1907592780 + -((char)-20254), 1907592780 + (char)-31617, (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(-1907592780 + -((char)-20258), -1907592780 + -((char)-17154), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1907592780 + -((char)-20255), 1907592780 + (char)-17762, (int)l2) + this.state);
                            throw new ClosedChannelException();
                        }
                        namedPipeState2 = this.state;
                        namedPipeState = NamedPipeState.Open;
                    }
                    try {
                        bl = namedPipeState2 == namedPipeState;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl) {
                        boolean bl4 = false;
                        String string = WindowsNamedPipeAgentIpc.b(-1907592780 + -((char)-20258), -1907592780 + -((char)-17154), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1907592780 + -((char)-20252), -1907592780 + -32145, (int)l2) + this.state;
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.state = NamedPipeState.Connecting;
                    Unit unit = Unit.INSTANCE;
                }
                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
                boolean bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1907592780 + -((char)-20254), 1907592780 + (char)-31617, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(-1907592780 + -((char)-20258), -1907592780 + -((char)-17154), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1907592780 + -((char)-20253), 1907592780 + (char)-11573, (int)l2));
                    object2 = Kernel32.INSTANCE;
                    if (stringArray == null) break block27;
                    if (object2.ConnectNamedPipe(this.hPipe, null)) break block28;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                int n2 = Kernel32.INSTANCE.GetLastError();
                if (n2 == 535) {
                    WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = this;
                    boolean bl5 = false;
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1907592780 + -((char)-20254), 1907592780 + (char)-31617, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(-1907592780 + -((char)-20258), -1907592780 + -((char)-17154), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1907592780 + -((char)-20250), 1907592780 + (char)-24033, (int)l2));
                } else {
                    throw new IllegalStateException((WindowsNamedPipeAgentIpc.b(-1907592780 + -((char)-20258), -1907592780 + -((char)-17154), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1907592780 + -((char)-20251), 1907592780 + (char)-23700, (int)l2) + ErrorToolsKt.prettyHRESULT(n2)).toString());
                }
            }
            object2 = this.lock;
        }
        Kernel32 kernel32 = object2;
        synchronized (kernel32) {
            boolean bl;
            NamedPipeState namedPipeState;
            NamedPipeState namedPipeState3;
            block29: {
                block30: {
                    boolean bl6 = false;
                    namedPipeState3 = this.state;
                    namedPipeState = NamedPipeState.Closing;
                    if (stringArray == null) break block29;
                    try {
                        block31: {
                            if (namedPipeState3.compareTo((Enum)namedPipeState) < 0) break block30;
                            break block31;
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                        }
                        throw new ClosedChannelException();
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                namedPipeState3 = this.state;
                namedPipeState = NamedPipeState.Connecting;
            }
            try {
                bl = namedPipeState3 == namedPipeState;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
            }
            if (!bl) {
                boolean bl7 = false;
                String string = WindowsNamedPipeAgentIpc.b(-1907592780 + -((char)-20258), -1907592780 + -((char)-17154), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1907592780 + -((char)-20252), -1907592780 + -32145, (int)l2) + this.state;
                throw new IllegalArgumentException(string.toString());
            }
            this.state = NamedPipeState.Connected;
            object = Unit.INSTANCE;
        }
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
        boolean bl = false;
        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1907592780 + -((char)-20254), 1907592780 + (char)-31617, (int)l2));
        logger.info(WindowsNamedPipeAgentIpc.b(-1907592780 + -((char)-20258), -1907592780 + -((char)-17154), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1907592780 + -((char)-20248), 1907592780 + (char)-27743, (int)l2));
        long l3 = this.getRequesterPid();
        this.requestorProcessValue = this.calcRequesterProcessInfo(l3);
        object = new PipeReadableByteChannel(this);
        PipeWritableByteChannel pipeWritableByteChannel = new PipeWritableByteChannel(this);
        try {
            streams = new SshAgentIpc.Streams((PipeReadableByteChannel)object, pipeWritableByteChannel, this){
                final /* synthetic */ PipeReadableByteChannel $read;
                final /* synthetic */ PipeWritableByteChannel $write;
                final /* synthetic */ WindowsNamedPipeAgentIpc this$0;
                private static final String[] a;
                private static final String[] b;
                {
                    this.$read = $read;
                    this.$write = $write;
                    this.this$0 = $receiver;
                }

                public InputStream getInputStream() {
                    long l2 = 138121400833216L;
                    InputStream inputStream = Channels.newInputStream(this.$read);
                    Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)accept.3.a(452453640 - 20107, 452453640 - 22071, (int)l2));
                    return inputStream;
                }

                public OutputStream getOutputStream() {
                    long l2 = 90625214167742L;
                    OutputStream outputStream = Channels.newOutputStream(this.$write);
                    Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)accept.3.a(-1404152910 + -((char)-9296), -1404283980 - -((char)-9683), (int)l2));
                    return outputStream;
                }

                public void close() {
                    WindowsNamedPipeAgentIpc.access$disconnect(this.this$0);
                }

                /*
                 * Unable to fully structure code
                 */
                static {
                    block13: {
                        var5 = new String[2];
                        var3_1 = 0;
                        var2_2 = "M\u00984\u00b5\u0002*\u00ec\u00ce\"\u001e)/\u00f4;z\u00be\u00054\u0011\u0014\u00fb\u00b9\u00e2\u0097\u00c3\u00ac\u00a9\u009b\b\u00b2\u00a9n&\u00ea\u00e1\u000f\u009b\u00c4\u00c5\u00d6";
                        var4_3 = "M\u00984\u00b5\u0002*\u00ec\u00ce\"\u001e)/\u00f4;z\u00be\u00054\u0011\u0014\u00fb\u00b9\u00e2\u0097\u00c3\u00ac\u00a9\u009b\b\u00b2\u00a9n&\u00ea\u00e1\u000f\u009b\u00c4\u00c5\u00d6".length();
                        var1_4 = 19;
                        var0_5 = -1;
lbl7:
                        // 2 sources

                        while (true) {
                            continue;
                            break;
                        }
lbl9:
                        // 1 sources

                        while (true) {
                            var5[var3_1++] = new String(v0).intern();
                            if ((var0_5 += var1_4) < var4_3) {
                                var1_4 = var2_2.charAt(var0_5);
                                ** continue;
                            }
                            break block13;
                            break;
                        }
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4).toCharArray();
                        v3 = v2.length;
                        var6_6 = 0;
                        v4 = 19;
                        v5 = v2;
                        v6 = v3;
                        if (v3 > 1) ** GOTO lbl67
                        do {
                            v7 = v4;
                            v5 = v5;
                            v8 = v5;
                            v9 = v4;
                            v10 = var6_6;
                            while (true) {
                                switch (var6_6 % 7) {
                                    case 0: {
                                        v11 = 19;
                                        break;
                                    }
                                    case 1: {
                                        v11 = 2;
                                        break;
                                    }
                                    case 2: {
                                        v11 = 90;
                                        break;
                                    }
                                    case 3: {
                                        v11 = 23;
                                        break;
                                    }
                                    case 4: {
                                        v11 = 73;
                                        break;
                                    }
                                    case 5: {
                                        v11 = 31;
                                        break;
                                    }
                                    default: {
                                        v11 = 34;
                                    }
                                }
                                v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                                ++var6_6;
                                v4 = v7;
                                if (v7 != 0) break;
                                v7 = v4;
                                v5 = v5;
                                v10 = v4;
                                v8 = v5;
                                v9 = v4;
                            }
lbl67:
                            // 2 sources

                            v0 = v5;
                            v6 = v6;
                        } while (v6 > var6_6);
                        ** while (true)
                    }
                    accept.3.a = var5;
                    accept.3.b = new String[2];
                }

                private static String a(int n2, int n3, int n4) {
                    int n5 = (n2 ^ n4 ^ 0xFFFFC2BD) & 0xFFFF;
                    if (b[n5] == null) {
                        int n6;
                        char[] cArray = a[n5].toCharArray();
                        int n7 = switch (cArray[0] & 0xFF) {
                            case 0 -> 3;
                            case 1 -> 85;
                            case 2 -> 116;
                            case 3 -> 115;
                            case 4 -> 22;
                            case 5 -> 192;
                            case 6 -> 144;
                            case 7 -> 98;
                            case 8 -> 215;
                            case 9 -> 131;
                            case 10 -> 25;
                            case 11 -> 83;
                            case 12 -> 254;
                            case 13 -> 153;
                            case 14 -> 187;
                            case 15 -> 19;
                            case 16 -> 168;
                            case 17 -> 89;
                            case 18 -> 240;
                            case 19 -> 23;
                            case 20 -> 2;
                            case 21 -> 235;
                            case 22 -> 68;
                            case 23 -> 114;
                            case 24 -> 243;
                            case 25 -> 196;
                            case 26 -> 133;
                            case 27 -> 247;
                            case 28 -> 75;
                            case 29 -> 170;
                            case 30 -> 90;
                            case 31 -> 142;
                            case 32 -> 148;
                            case 33 -> 195;
                            case 34 -> 69;
                            case 35 -> 210;
                            case 36 -> 252;
                            case 37 -> 204;
                            case 38 -> 10;
                            case 39 -> 217;
                            case 40 -> 46;
                            case 41 -> 126;
                            case 42 -> 207;
                            case 43 -> 229;
                            case 44 -> 50;
                            case 45 -> 181;
                            case 46 -> 160;
                            case 47 -> 14;
                            case 48 -> 40;
                            case 49 -> 145;
                            case 50 -> 0;
                            case 51 -> 249;
                            case 52 -> 60;
                            case 53 -> 101;
                            case 54 -> 122;
                            case 55 -> 61;
                            case 56 -> 59;
                            case 57 -> 88;
                            case 58 -> 17;
                            case 59 -> 178;
                            case 60 -> 246;
                            case 61 -> 250;
                            case 62 -> 55;
                            case 63 -> 5;
                            case 64 -> 147;
                            case 65 -> 222;
                            case 66 -> 6;
                            case 67 -> 185;
                            case 68 -> 26;
                            case 69 -> 141;
                            case 70 -> 251;
                            case 71 -> 39;
                            case 72 -> 97;
                            case 73 -> 182;
                            case 74 -> 106;
                            case 75 -> 161;
                            case 76 -> 117;
                            case 77 -> 238;
                            case 78 -> 158;
                            case 79 -> 186;
                            case 80 -> 166;
                            case 81 -> 35;
                            case 82 -> 232;
                            case 83 -> 193;
                            case 84 -> 129;
                            case 85 -> 82;
                            case 86 -> 208;
                            case 87 -> 44;
                            case 88 -> 199;
                            case 89 -> 225;
                            case 90 -> 191;
                            case 91 -> 228;
                            case 92 -> 169;
                            case 93 -> 81;
                            case 94 -> 53;
                            case 95 -> 95;
                            case 96 -> 120;
                            case 97 -> 184;
                            case 98 -> 103;
                            case 99 -> 123;
                            case 100 -> 21;
                            case 101 -> 183;
                            case 102 -> 174;
                            case 103 -> 136;
                            case 104 -> 156;
                            case 105 -> 102;
                            case 106 -> 151;
                            case 107 -> 29;
                            case 108 -> 212;
                            case 109 -> 253;
                            case 110 -> 226;
                            case 111 -> 200;
                            case 112 -> 173;
                            case 113 -> 54;
                            case 114 -> 66;
                            case 115 -> 70;
                            case 116 -> 48;
                            case 117 -> 111;
                            case 118 -> 149;
                            case 119 -> 177;
                            case 120 -> 11;
                            case 121 -> 86;
                            case 122 -> 73;
                            case 123 -> 130;
                            case 124 -> 108;
                            case 125 -> 80;
                            case 126 -> 63;
                            case 127 -> 56;
                            case 128 -> 175;
                            case 129 -> 234;
                            case 130 -> 107;
                            case 131 -> 37;
                            case 132 -> 87;
                            case 133 -> 1;
                            case 134 -> 209;
                            case 135 -> 18;
                            case 136 -> 94;
                            case 137 -> 79;
                            case 138 -> 64;
                            case 139 -> 47;
                            case 140 -> 134;
                            case 141 -> 194;
                            case 142 -> 150;
                            case 143 -> 113;
                            case 144 -> 244;
                            case 145 -> 221;
                            case 146 -> 7;
                            case 147 -> 4;
                            case 148 -> 77;
                            case 149 -> 99;
                            case 150 -> 72;
                            case 151 -> 233;
                            case 152 -> 255;
                            case 153 -> 162;
                            case 154 -> 163;
                            case 155 -> 179;
                            case 156 -> 100;
                            case 157 -> 216;
                            case 158 -> 197;
                            case 159 -> 164;
                            case 160 -> 211;
                            case 161 -> 78;
                            case 162 -> 140;
                            case 163 -> 41;
                            case 164 -> 96;
                            case 165 -> 157;
                            case 166 -> 219;
                            case 167 -> 138;
                            case 168 -> 132;
                            case 169 -> 57;
                            case 170 -> 227;
                            case 171 -> 119;
                            case 172 -> 91;
                            case 173 -> 74;
                            case 174 -> 213;
                            case 175 -> 143;
                            case 176 -> 8;
                            case 177 -> 237;
                            case 178 -> 24;
                            case 179 -> 43;
                            case 180 -> 180;
                            case 181 -> 239;
                            case 182 -> 248;
                            case 183 -> 205;
                            case 184 -> 104;
                            case 185 -> 84;
                            case 186 -> 110;
                            case 187 -> 223;
                            case 188 -> 33;
                            case 189 -> 201;
                            case 190 -> 188;
                            case 191 -> 34;
                            case 192 -> 13;
                            case 193 -> 93;
                            case 194 -> 42;
                            case 195 -> 220;
                            case 196 -> 118;
                            case 197 -> 32;
                            case 198 -> 198;
                            case 199 -> 206;
                            case 200 -> 20;
                            case 201 -> 9;
                            case 202 -> 58;
                            case 203 -> 49;
                            case 204 -> 16;
                            case 205 -> 214;
                            case 206 -> 128;
                            case 207 -> 203;
                            case 208 -> 51;
                            case 209 -> 137;
                            case 210 -> 155;
                            case 211 -> 135;
                            case 212 -> 109;
                            case 213 -> 105;
                            case 214 -> 172;
                            case 215 -> 231;
                            case 216 -> 167;
                            case 217 -> 159;
                            case 218 -> 190;
                            case 219 -> 30;
                            case 220 -> 67;
                            case 221 -> 146;
                            case 222 -> 125;
                            case 223 -> 31;
                            case 224 -> 224;
                            case 225 -> 15;
                            case 226 -> 28;
                            case 227 -> 52;
                            case 228 -> 12;
                            case 229 -> 38;
                            case 230 -> 65;
                            case 231 -> 152;
                            case 232 -> 127;
                            case 233 -> 45;
                            case 234 -> 165;
                            case 235 -> 154;
                            case 236 -> 92;
                            case 237 -> 62;
                            case 238 -> 139;
                            case 239 -> 176;
                            case 240 -> 121;
                            case 241 -> 71;
                            case 242 -> 27;
                            case 243 -> 245;
                            case 244 -> 218;
                            case 245 -> 36;
                            case 246 -> 241;
                            case 247 -> 76;
                            case 248 -> 171;
                            case 249 -> 189;
                            case 250 -> 242;
                            case 251 -> 202;
                            case 252 -> 112;
                            case 253 -> 230;
                            case 254 -> 124;
                            default -> 236;
                        };
                        int n8 = ((n3 ^= n4) & 0xFF) - n7;
                        if (n8 < 0) {
                            n8 += 256;
                        }
                        if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                            n6 += 256;
                        }
                        int n9 = 0;
                        while (n9 < cArray.length) {
                            int n10 = n9 % 2;
                            int n11 = n9;
                            char[] cArray2 = cArray;
                            char c2 = cArray[n11];
                            if (n10 == 0) {
                                cArray2[n11] = (char)(c2 ^ n8);
                                n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                            } else {
                                cArray2[n11] = (char)(c2 ^ n6);
                                n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                            }
                            ++n9;
                        }
                        accept.3.b[n5] = new String(cArray).intern();
                    }
                    return b[n5];
                }
            };
            if (stringArray == null) {
                ActionTimestamp.K(new ActionTimestamp[5]);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
        }
        return streams;
    }

    public final long getRequesterPid() {
        long l2;
        block4: {
            boolean bl;
            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
            int n2;
            long l3;
            block2: {
                block3: {
                    l3 = 71697289441772L;
                    WinDef.ULONGByReference uLONGByReference = new WinDef.ULONGByReference();
                    String[] stringArray = SshAgentIpcService.K();
                    try {
                        n2 = Kernel32.INSTANCE.GetNamedPipeClientProcessId(this.hPipe, uLONGByReference);
                        if (stringArray == null) break block2;
                        if (n2 == 0) break block3;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    WinDef.ULONG uLONG = uLONGByReference.getValue();
                    windowsNamedPipeAgentIpc = this;
                    bl = false;
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1400351880 + 21021, -1400351880 + -9916, (int)l3));
                    logger.info(WindowsNamedPipeAgentIpc.b(1400351880 + 21017, 1400351880 - 8647, (int)l3) + this.pipePath + WindowsNamedPipeAgentIpc.b(1400351880 + 21042, -1400351880 + -8963, (int)l3) + uLONG);
                    l2 = uLONGByReference.getValue().longValue();
                    break block4;
                }
                n2 = Kernel32.INSTANCE.GetLastError();
            }
            int n3 = n2;
            windowsNamedPipeAgentIpc = this;
            bl = false;
            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1400351880 + 21021, -1400351880 + -9916, (int)l3));
            logger.warn(WindowsNamedPipeAgentIpc.b(1400351880 + 21017, 1400351880 - 8647, (int)l3) + this.pipePath + WindowsNamedPipeAgentIpc.b(1400351880 + 21045, 1400351880 + 18493, (int)l3) + ErrorToolsKt.prettyHRESULT(n3));
            l2 = -1L;
        }
        long l4 = l2;
        return l4;
    }

    @Override
    protected boolean isSshProcess(@NotNull ProcessInfoUtil.ProcessInfo process2) {
        boolean bl;
        block14: {
            block12: {
                block15: {
                    String string;
                    Object object;
                    String[] stringArray;
                    block13: {
                        long l2 = 136394559577146L;
                        String[] stringArray2 = SshAgentIpcService.K();
                        Intrinsics.checkNotNullParameter((Object)process2, (String)WindowsNamedPipeAgentIpc.b(-716821830 + -22352, 716821830 + 27948, (int)l2));
                        stringArray = stringArray2;
                        try {
                            try {
                                try {
                                    try {
                                        if (stringArray == null || (object = process2.getExecutable()) == null) break block12;
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                    }
                                    if ((object = object.getFileName()) == null) break block12;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                String string2 = object.toString();
                                string = string2;
                                object = string2;
                                if (stringArray == null) break block13;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            if (string == null) break block12;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        string = WindowsNamedPipeAgentIpc.b(-716821830 + -22353, -716821830 + -17152, (int)l2);
                    }
                    try {
                        try {
                            bl = StringsKt.equals((String)object, (String)string, (boolean)true);
                            if (stringArray == null) break block14;
                            if (!bl) break block15;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        bl = true;
                        break block14;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                bl = false;
                break block14;
            }
            bl = false;
        }
        return bl;
    }

    @Override
    @NotNull
    public SshRequesterProcessInfo getRequesterProcessInfo() {
        return this.requestorProcessValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private final void disconnect() {
        Object object;
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
        String[] stringArray;
        long l2;
        block25: {
            block26: {
                l2 = 37264558463119L;
                String[] stringArray2 = SshAgentIpcService.K();
                this.assertConnectionThread();
                Object object2 = this.lock;
                stringArray = stringArray2;
                synchronized (object2) {
                    boolean bl;
                    NamedPipeState namedPipeState;
                    NamedPipeState namedPipeState2;
                    block23: {
                        block24: {
                            block21: {
                                block22: {
                                    boolean bl2 = false;
                                    namedPipeState2 = this.state;
                                    namedPipeState = NamedPipeState.Closing;
                                    if (stringArray == null) break block21;
                                    try {
                                        block29: {
                                            if (namedPipeState2.compareTo((Enum)namedPipeState) < 0) break block22;
                                            break block29;
                                            catch (IllegalArgumentException illegalArgumentException) {
                                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                            }
                                        }
                                        throw new ClosedChannelException();
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                    }
                                }
                                namedPipeState2 = this.state;
                                namedPipeState = NamedPipeState.Open;
                            }
                            try {
                                if (stringArray == null) break block23;
                                if (namedPipeState2 != namedPipeState) break block24;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = this;
                            boolean bl3 = false;
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1422240570 - (char)-27788, -1422240570 - -28953, (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(1422240570 - (char)-27784, 1422240570 - 18328, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1422240570 - (char)-27811, 1422240570 - 22523, (int)l2));
                            return;
                        }
                        namedPipeState2 = this.state;
                        namedPipeState = NamedPipeState.Connected;
                    }
                    try {
                        bl = namedPipeState2 == namedPipeState;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl) {
                        boolean bl4 = false;
                        String string = WindowsNamedPipeAgentIpc.b(1422240570 - (char)-27784, 1422240570 - 18328, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1422240570 - (char)-27786, 1422240570 - (char)-30717, (int)l2) + this.state;
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.state = NamedPipeState.Disconnecting;
                    Unit unit = Unit.INSTANCE;
                }
                windowsNamedPipeAgentIpc = this;
                boolean bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1422240570 - (char)-27788, -1422240570 - -28953, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(1422240570 - (char)-27784, 1422240570 - 18328, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1422240570 - (char)-27800, -1422240570 - -((char)-26922), (int)l2));
                    object = Kernel32.INSTANCE;
                    if (stringArray == null) break block25;
                    if (object.DisconnectNamedPipe(this.hPipe)) break block26;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                windowsNamedPipeAgentIpc = this;
                bl = false;
                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1422240570 - (char)-27788, -1422240570 - -28953, (int)l2));
                logger.warn(WindowsNamedPipeAgentIpc.b(1422240570 - (char)-27784, 1422240570 - 18328, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1422240570 - (char)-27801, -1422240570 - -((char)-31769), (int)l2) + ErrorToolsKt.kernel32LastError());
                return;
            }
            object = this.lock;
        }
        Kernel32 kernel32 = object;
        synchronized (kernel32) {
            block27: {
                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc3;
                block28: {
                    boolean bl = false;
                    windowsNamedPipeAgentIpc3 = this;
                    if (stringArray == null) break block27;
                    try {
                        block30: {
                            if (windowsNamedPipeAgentIpc3.state.compareTo((Enum)NamedPipeState.Closing) < 0) break block28;
                            break block30;
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                        }
                        throw new ClosedChannelException();
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                windowsNamedPipeAgentIpc3 = this;
            }
            windowsNamedPipeAgentIpc3.state = NamedPipeState.Open;
            Unit unit = Unit.INSTANCE;
        }
        windowsNamedPipeAgentIpc = this;
        boolean bl = false;
        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1422240570 - (char)-27788, -1422240570 - -28953, (int)l2));
        logger.info(WindowsNamedPipeAgentIpc.b(1422240570 - (char)-27784, 1422240570 - 18328, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1422240570 - (char)-27798, -1422240570 - -((char)-22258), (int)l2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        block17: {
            int n2;
            boolean bl;
            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
            long l2;
            block15: {
                String[] stringArray;
                block16: {
                    l2 = 123195796317716L;
                    Object object = this.lock;
                    synchronized (object) {
                        block13: {
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2;
                            block14: {
                                stringArray = SshAgentIpcService.K();
                                boolean bl2 = false;
                                try {
                                    windowsNamedPipeAgentIpc2 = this;
                                    if (stringArray == null) break block13;
                                    if (windowsNamedPipeAgentIpc2.state.compareTo((Enum)NamedPipeState.Closing) < 0) break block14;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc3 = this;
                                boolean bl3 = false;
                                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1045545390 + -((char)-11019), 1045545390 + (char)-1642, (int)l2));
                                logger.info(WindowsNamedPipeAgentIpc.b(-1045545390 + -((char)-11015), -1045676460 - -((char)-8475), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1045545390 + -((char)-11000), 1045545390 + (char)-11140, (int)l2) + this.state + WindowsNamedPipeAgentIpc.b(-1045545390 + -((char)-11003), -1045676460 - -((char)-287), (int)l2));
                                return;
                            }
                            windowsNamedPipeAgentIpc2 = this;
                        }
                        windowsNamedPipeAgentIpc2.state = NamedPipeState.Closing;
                        Unit unit = Unit.INSTANCE;
                    }
                    WindowsNamedPipeAgentIpc.Companion.connectToPipe(this.pipePath);
                    windowsNamedPipeAgentIpc = this;
                    bl = false;
                    try {
                        try {
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1045545390 + -((char)-11019), 1045545390 + (char)-1642, (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(-1045545390 + -((char)-11015), -1045676460 - -((char)-8475), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1045545390 + -((char)-11002), 1045676460 - (char)-12595, (int)l2));
                            n2 = Kernel32Ex.Companion.getINSTANCE().CancelIoEx(this.hPipe, null);
                            if (stringArray == null) break block15;
                            if (n2 != 0) break block16;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        n2 = Kernel32.INSTANCE.GetLastError();
                        if (stringArray == null) break block15;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    int n3 = n2;
                    if (n3 != 1168) {
                        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc4 = this;
                        boolean bl4 = false;
                        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1045545390 + -((char)-11019), 1045545390 + (char)-1642, (int)l2));
                        logger.info(WindowsNamedPipeAgentIpc.b(-1045545390 + -((char)-11015), -1045676460 - -((char)-8475), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1045545390 + -((char)-11005), -1045676460 - -((char)-14773), (int)l2) + ErrorToolsKt.prettyHRESULT(n3));
                    }
                }
                windowsNamedPipeAgentIpc = this;
                bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1045545390 + -((char)-11019), 1045545390 + (char)-1642, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(-1045545390 + -((char)-11015), -1045676460 - -((char)-8475), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1045545390 + -((char)-11004), 1045545390 + (char)-497, (int)l2));
                    if (stringArray == null) break block17;
                    n2 = Kernel32.INSTANCE.CloseHandle(this.hPipe) ? 1 : 0;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
            }
            if (n2 == 0) {
                windowsNamedPipeAgentIpc = this;
                bl = false;
                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1045545390 + -((char)-11019), 1045545390 + (char)-1642, (int)l2));
                logger.warn(WindowsNamedPipeAgentIpc.b(-1045545390 + -((char)-11015), -1045676460 - -((char)-8475), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1045545390 + -((char)-11039), 1045545390 + (char)-3234, (int)l2) + ErrorToolsKt.kernel32LastError());
            }
            WinNT.HANDLE hANDLE = WinNT.INVALID_HANDLE_VALUE;
            Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(-1045545390 + -((char)-11038), -1045676460 - -((char)-2943), (int)l2));
            this.hPipe = hANDLE;
            this.state = NamedPipeState.Closed;
        }
    }

    @Override
    public void cleanup() {
    }

    public static final /* synthetic */ String access$getPipePath$p(WindowsNamedPipeAgentIpc $this) {
        return $this.pipePath;
    }

    /*
     * Unable to fully structure code
     */
    static {
        block20: {
            block19: {
                var5 = new String[34];
                var3_1 = 0;
                var2_2 = "\u00f1\u00f3\u00f5\u009b\u00d8w\u00bf\u00a1\u0014p\u009f\u00fd\u00f1'\u00b2\u00ef\u0003\u008aP\u009ao4\u00eev\u0095\u00fe\u00a6\u00ab\u00f8\u00065\fmd\u00a1\u00c9\u0018\u00bf\u00d5d\u0088\u0096X\u00db\u009e\u00c4\u009e\\\u00c6\u008a$\u00f3N\u00e7\u00b4\u00a6'\u00e3\u00e4\u0011\u00ad\tL\u00a5\u00847\u00e10-\u00db&\u0005a\u0000\u00e7\u00e5\u00ea\b\u00d9\u0081\u00f0\u00a4*\u00b6\u00e7{\u0014\u0019\u0085\u00a8)\u00e0\u00a1\"\u00f6]3\u00cb\u00b7TV\u00c1o\u001a*\u00ce+\u0005\u00b3\u008c\u00bdt\u00a1\u001e\u0091\u00cb\u00ec\u00f8\u0016\u0092i\u00bd7\u00eeiO`5\f\b\u00f9\u00ed\u00b7\u00f8m0\u00cc\u00fa\u0005\u009f\u0093*V\t\u0010\u00fcq\u00a5jh\u00f2PHm\u00e2\u00af3\u00be\u00efx\u00cc\t\u0002\u00db\u009b\u00e9Q\u00cc\u001d\u00db\u00ce\u0010}x\u0095Kn\u00d6\u0090\u00ccur\u00ac!\u00de\u00adt\u0084?\u00b4\u00c8@\u0098\u008e\u0097\u00ffq\u0094\u00a6X\u00bd\u00f9\u009d\u0002$\u00fd\rJ!\\Y\u0091\u00b1\u00be\u001e\u00e9\u00ae.\u00cf\u0087k\u001a\u009e\u0081\u00d9Q\u0015\u009d\u00c9\u0090\u0018\u00b2\u00b5\u00f2Q\u00daQs\u00db\u00da\u0090\u00f5%\u00af~E\u00a4=,a\u0001a\b\u00a9@\u00fe\u009c\u00eb\u00b1\u00df\u009b\f\u00e9\u00e1\u00e6\u00b3\u00f56\u00f2l\u0010.R\u00aeF4O]f\u0082\u008c\u001c;\u00cd\u00c8\u00e3\u00b6\u0018\u00f4!/e\u000bYN,\u00e6\u009ct)\u008d\u00e8\u00d7\u00b1\u00c9N\u0097\u001f\u00b7\u00e3\u00dd\u00c7\u00d8\u00e4\u00b4,\u00a2\u00ae\u0019\u00afA%.k\u00cc\u00bf\u00d8\u00b6\u00ba\u00d1\u0096\u0015\u00cd\u00a1\u00bd\u00c1Z)\u00cb\u00fe\u0018\u0082\u00ca\u00d6\u00f2\u001f\u00ba\u00f5\u0089?\u00baj\u00fc\u00a2\u0085\r?3\u00aa\u00a7^\u00eb\u00c8y\u00ec\u00a0\u00cd\u00bb\u000f \u001c\u0014\u00a7\u0097\u00cdO\u00c3\u000b\u000e\u00fc\u001a\u0010jB\u0001\u00e2n\u00f3\u0097\u0015\u008b\u00c9\u00aa\u00b5{\u009e\u00cf\u0004\u0089\u00cf\u00a3\u00a0\u0087y\u00e6f$\\\u00ac}\u00f3)\u00ddke\u00ec'\u0010O\u00ed\u00f3\u00e4\u00f1\u000ew\n{[3\u00e7H\u00d4\u00a9ME\u00e6:\u0085\u00b4\u00dd\u0080\u00f2\u00e8\u00ce59\u00c0\u0081\u00bdN \u00cf\u0017\u0007\u0081\u0089\u00e4\u00aa3\u0085V\u0007oR]\u00bd\u00e3\u0088Z(\u0094\u0010\u0000\u00a2;\u00b3:\u00be-Y\u0000\u008fj\u00bb\u009a\u00ee\b\u00fc\u0081\u00f4\u00f1w!j&\u00a8\u0081\u0003\u0011I\u0001\u00a0\u00f3\u009f\u0086\u00f8\u00cf\u001c\u00fdv\u000f\u00ceD\u0005\u0001s\u00ab\u0096~\u00cd\u00cc\u00bdl}\u0093\u00e6\"a\u00ed\u00f2<\u00d5\n\u0011\u00ae8\u008c\u0088\u0003[\u00a7\u009a \u00e4\u00a18^M\u001cy\u009c.\u009e\u00fb`Mw\u00f3yx<\u000eM\u00adu<}\fW\u008a\u00f5R\u00ba\u00bf\u0091\u00e3\u001b\u00f8`\u00c4\u0080\u00b0.{\u0092'\u00d6m.;\u00e7\u00b0>\t\u00c88\u00efv\u001emz\u00e7/\u0097\n-\u0097\u00bayk\u00f5\u00d3\u00c3\u0099\u009e\u0018't?\u000f\u00cec\u0095e\u00e4\u00e1\u00d7W\u00d5\u009b\u0091\u0090Z\u001c\u0085\f\u00b9)\u00cf\u00cf)=\u0000y\u0081\u00a4\u00bd?X\u00fdR0\u00d8K\u00d9cZN\u00b28\u00bb\u009d\u00b0\u008aU\u00b6a\u00b8\u00adR\u00a0\t\u0015,\u009c6\u00a1\u00bdn \u00cb\u0017\t\u00fc\u00e6DP\u00a04u\u009f~";
                var4_3 = "\u00f1\u00f3\u00f5\u009b\u00d8w\u00bf\u00a1\u0014p\u009f\u00fd\u00f1'\u00b2\u00ef\u0003\u008aP\u009ao4\u00eev\u0095\u00fe\u00a6\u00ab\u00f8\u00065\fmd\u00a1\u00c9\u0018\u00bf\u00d5d\u0088\u0096X\u00db\u009e\u00c4\u009e\\\u00c6\u008a$\u00f3N\u00e7\u00b4\u00a6'\u00e3\u00e4\u0011\u00ad\tL\u00a5\u00847\u00e10-\u00db&\u0005a\u0000\u00e7\u00e5\u00ea\b\u00d9\u0081\u00f0\u00a4*\u00b6\u00e7{\u0014\u0019\u0085\u00a8)\u00e0\u00a1\"\u00f6]3\u00cb\u00b7TV\u00c1o\u001a*\u00ce+\u0005\u00b3\u008c\u00bdt\u00a1\u001e\u0091\u00cb\u00ec\u00f8\u0016\u0092i\u00bd7\u00eeiO`5\f\b\u00f9\u00ed\u00b7\u00f8m0\u00cc\u00fa\u0005\u009f\u0093*V\t\u0010\u00fcq\u00a5jh\u00f2PHm\u00e2\u00af3\u00be\u00efx\u00cc\t\u0002\u00db\u009b\u00e9Q\u00cc\u001d\u00db\u00ce\u0010}x\u0095Kn\u00d6\u0090\u00ccur\u00ac!\u00de\u00adt\u0084?\u00b4\u00c8@\u0098\u008e\u0097\u00ffq\u0094\u00a6X\u00bd\u00f9\u009d\u0002$\u00fd\rJ!\\Y\u0091\u00b1\u00be\u001e\u00e9\u00ae.\u00cf\u0087k\u001a\u009e\u0081\u00d9Q\u0015\u009d\u00c9\u0090\u0018\u00b2\u00b5\u00f2Q\u00daQs\u00db\u00da\u0090\u00f5%\u00af~E\u00a4=,a\u0001a\b\u00a9@\u00fe\u009c\u00eb\u00b1\u00df\u009b\f\u00e9\u00e1\u00e6\u00b3\u00f56\u00f2l\u0010.R\u00aeF4O]f\u0082\u008c\u001c;\u00cd\u00c8\u00e3\u00b6\u0018\u00f4!/e\u000bYN,\u00e6\u009ct)\u008d\u00e8\u00d7\u00b1\u00c9N\u0097\u001f\u00b7\u00e3\u00dd\u00c7\u00d8\u00e4\u00b4,\u00a2\u00ae\u0019\u00afA%.k\u00cc\u00bf\u00d8\u00b6\u00ba\u00d1\u0096\u0015\u00cd\u00a1\u00bd\u00c1Z)\u00cb\u00fe\u0018\u0082\u00ca\u00d6\u00f2\u001f\u00ba\u00f5\u0089?\u00baj\u00fc\u00a2\u0085\r?3\u00aa\u00a7^\u00eb\u00c8y\u00ec\u00a0\u00cd\u00bb\u000f \u001c\u0014\u00a7\u0097\u00cdO\u00c3\u000b\u000e\u00fc\u001a\u0010jB\u0001\u00e2n\u00f3\u0097\u0015\u008b\u00c9\u00aa\u00b5{\u009e\u00cf\u0004\u0089\u00cf\u00a3\u00a0\u0087y\u00e6f$\\\u00ac}\u00f3)\u00ddke\u00ec'\u0010O\u00ed\u00f3\u00e4\u00f1\u000ew\n{[3\u00e7H\u00d4\u00a9ME\u00e6:\u0085\u00b4\u00dd\u0080\u00f2\u00e8\u00ce59\u00c0\u0081\u00bdN \u00cf\u0017\u0007\u0081\u0089\u00e4\u00aa3\u0085V\u0007oR]\u00bd\u00e3\u0088Z(\u0094\u0010\u0000\u00a2;\u00b3:\u00be-Y\u0000\u008fj\u00bb\u009a\u00ee\b\u00fc\u0081\u00f4\u00f1w!j&\u00a8\u0081\u0003\u0011I\u0001\u00a0\u00f3\u009f\u0086\u00f8\u00cf\u001c\u00fdv\u000f\u00ceD\u0005\u0001s\u00ab\u0096~\u00cd\u00cc\u00bdl}\u0093\u00e6\"a\u00ed\u00f2<\u00d5\n\u0011\u00ae8\u008c\u0088\u0003[\u00a7\u009a \u00e4\u00a18^M\u001cy\u009c.\u009e\u00fb`Mw\u00f3yx<\u000eM\u00adu<}\fW\u008a\u00f5R\u00ba\u00bf\u0091\u00e3\u001b\u00f8`\u00c4\u0080\u00b0.{\u0092'\u00d6m.;\u00e7\u00b0>\t\u00c88\u00efv\u001emz\u00e7/\u0097\n-\u0097\u00bayk\u00f5\u00d3\u00c3\u0099\u009e\u0018't?\u000f\u00cec\u0095e\u00e4\u00e1\u00d7W\u00d5\u009b\u0091\u0090Z\u001c\u0085\f\u00b9)\u00cf\u00cf)=\u0000y\u0081\u00a4\u00bd?X\u00fdR0\u00d8K\u00d9cZN\u00b28\u00bb\u009d\u00b0\u008aU\u00b6a\u00b8\u00adR\u00a0\t\u0015,\u009c6\u00a1\u00bdn \u00cb\u0017\t\u00fc\u00e6DP\u00a04u\u009f~".length();
                var1_4 = 8;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    v0 = 83;
                    v1 = ++var0_5;
                    v2 = var2_2.substring(v1, v1 + var1_4);
                    v3 = -1;
                    break block19;
                    break;
                }
lbl13:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v4.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    var2_2 = "\u00bc\u0019k\u0080\u00c4\u00bf\u0011:\u001a<\u00ee7\u00b2\u0006~\u0083\u00cf\u00a7z\u00bf\u00a2-\u00bc\u001a\u00f9\u00b6\u00e20\u00ab\u0014\u00b1u\u00e7\u008eF\u007f\u00e1\u0098i\u0001\u00c4g\u00dd\u00cdi\u00d3?L\u00b1\u0087";
                    var4_3 = "\u00bc\u0019k\u0080\u00c4\u00bf\u0011:\u001a<\u00ee7\u00b2\u0006~\u0083\u00cf\u00a7z\u00bf\u00a2-\u00bc\u001a\u00f9\u00b6\u00e20\u00ab\u0014\u00b1u\u00e7\u008eF\u007f\u00e1\u0098i\u0001\u00c4g\u00dd\u00cdi\u00d3?L\u00b1\u0087".length();
                    var1_4 = 29;
                    var0_5 = -1;
lbl22:
                    // 2 sources

                    while (true) {
                        v0 = 24;
                        v5 = ++var0_5;
                        v2 = var2_2.substring(v5, v5 + var1_4);
                        v3 = 0;
                        break block19;
                        break;
                    }
                    break;
                }
lbl28:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v4.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block20;
                    break;
                }
            }
            v6 = v2.toCharArray();
            v7 = v6.length;
            var6_6 = 0;
            v8 = v0;
            v9 = v6;
            v10 = v7;
            if (v7 > 1) ** GOTO lbl85
            do {
                v11 = v8;
                v9 = v9;
                v12 = v9;
                v13 = v8;
                v14 = var6_6;
                while (true) {
                    switch (var6_6 % 7) {
                        case 0: {
                            v15 = 52;
                            break;
                        }
                        case 1: {
                            v15 = 68;
                            break;
                        }
                        case 2: {
                            v15 = 122;
                            break;
                        }
                        case 3: {
                            v15 = 117;
                            break;
                        }
                        case 4: {
                            v15 = 62;
                            break;
                        }
                        case 5: {
                            v15 = 59;
                            break;
                        }
                        default: {
                            v15 = 116;
                        }
                    }
                    v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                    ++var6_6;
                    v8 = v11;
                    if (v11 != 0) break;
                    v11 = v8;
                    v9 = v9;
                    v14 = v8;
                    v12 = v9;
                    v13 = v8;
                }
lbl85:
                // 2 sources

                v16 = v9;
                v10 = v10;
            } while (v10 > var6_6);
            v4 = new String(v16);
            switch (v3) {
                default: {
                    ** continue;
                }
                ** case 0:
lbl95:
                // 1 sources

                ** continue;
            }
        }
        WindowsNamedPipeAgentIpc.c = var5;
        WindowsNamedPipeAgentIpc.d = new String[34];
        WindowsNamedPipeAgentIpc.Companion = new Companion(null);
    }

    private static IllegalArgumentException a(IllegalArgumentException illegalArgumentException) {
        return illegalArgumentException;
    }

    private static String b(int n2, int n3, int n4) {
        int n5 = (n2 ^ n4 ^ 0xF45) & 0xFFFF;
        if (d[n5] == null) {
            int n6;
            char[] cArray = c[n5].toCharArray();
            int n7 = switch (cArray[0] & 0xFF) {
                case 0 -> 226;
                case 1 -> 111;
                case 2 -> 244;
                case 3 -> 145;
                case 4 -> 156;
                case 5 -> 73;
                case 6 -> 230;
                case 7 -> 132;
                case 8 -> 5;
                case 9 -> 37;
                case 10 -> 117;
                case 11 -> 55;
                case 12 -> 17;
                case 13 -> 184;
                case 14 -> 200;
                case 15 -> 71;
                case 16 -> 141;
                case 17 -> 123;
                case 18 -> 100;
                case 19 -> 115;
                case 20 -> 124;
                case 21 -> 69;
                case 22 -> 13;
                case 23 -> 165;
                case 24 -> 119;
                case 25 -> 151;
                case 26 -> 211;
                case 27 -> 190;
                case 28 -> 207;
                case 29 -> 108;
                case 30 -> 131;
                case 31 -> 161;
                case 32 -> 182;
                case 33 -> 52;
                case 34 -> 149;
                case 35 -> 177;
                case 36 -> 36;
                case 37 -> 252;
                case 38 -> 245;
                case 39 -> 249;
                case 40 -> 47;
                case 41 -> 57;
                case 42 -> 75;
                case 43 -> 251;
                case 44 -> 121;
                case 45 -> 148;
                case 46 -> 201;
                case 47 -> 241;
                case 48 -> 213;
                case 49 -> 34;
                case 50 -> 246;
                case 51 -> 172;
                case 52 -> 33;
                case 53 -> 112;
                case 54 -> 218;
                case 55 -> 225;
                case 56 -> 205;
                case 57 -> 96;
                case 58 -> 202;
                case 59 -> 126;
                case 60 -> 70;
                case 61 -> 154;
                case 62 -> 39;
                case 63 -> 147;
                case 64 -> 81;
                case 65 -> 74;
                case 66 -> 50;
                case 67 -> 122;
                case 68 -> 30;
                case 69 -> 3;
                case 70 -> 118;
                case 71 -> 20;
                case 72 -> 18;
                case 73 -> 103;
                case 74 -> 187;
                case 75 -> 109;
                case 76 -> 72;
                case 77 -> 45;
                case 78 -> 12;
                case 79 -> 53;
                case 80 -> 86;
                case 81 -> 150;
                case 82 -> 2;
                case 83 -> 135;
                case 84 -> 85;
                case 85 -> 208;
                case 86 -> 198;
                case 87 -> 194;
                case 88 -> 239;
                case 89 -> 171;
                case 90 -> 43;
                case 91 -> 48;
                case 92 -> 143;
                case 93 -> 58;
                case 94 -> 181;
                case 95 -> 28;
                case 96 -> 197;
                case 97 -> 170;
                case 98 -> 247;
                case 99 -> 61;
                case 100 -> 233;
                case 101 -> 19;
                case 102 -> 63;
                case 103 -> 192;
                case 104 -> 27;
                case 105 -> 35;
                case 106 -> 1;
                case 107 -> 87;
                case 108 -> 68;
                case 109 -> 155;
                case 110 -> 188;
                case 111 -> 51;
                case 112 -> 140;
                case 113 -> 113;
                case 114 -> 209;
                case 115 -> 10;
                case 116 -> 220;
                case 117 -> 134;
                case 118 -> 236;
                case 119 -> 146;
                case 120 -> 243;
                case 121 -> 89;
                case 122 -> 231;
                case 123 -> 229;
                case 124 -> 41;
                case 125 -> 179;
                case 126 -> 14;
                case 127 -> 31;
                case 128 -> 212;
                case 129 -> 114;
                case 130 -> 84;
                case 131 -> 159;
                case 132 -> 219;
                case 133 -> 223;
                case 134 -> 78;
                case 135 -> 56;
                case 136 -> 227;
                case 137 -> 180;
                case 138 -> 59;
                case 139 -> 0;
                case 140 -> 144;
                case 141 -> 116;
                case 142 -> 216;
                case 143 -> 152;
                case 144 -> 110;
                case 145 -> 158;
                case 146 -> 164;
                case 147 -> 93;
                case 148 -> 25;
                case 149 -> 168;
                case 150 -> 235;
                case 151 -> 49;
                case 152 -> 183;
                case 153 -> 139;
                case 154 -> 255;
                case 155 -> 8;
                case 156 -> 26;
                case 157 -> 237;
                case 158 -> 186;
                case 159 -> 153;
                case 160 -> 120;
                case 161 -> 24;
                case 162 -> 125;
                case 163 -> 6;
                case 164 -> 98;
                case 165 -> 166;
                case 166 -> 242;
                case 167 -> 40;
                case 168 -> 95;
                case 169 -> 128;
                case 170 -> 67;
                case 171 -> 46;
                case 172 -> 76;
                case 173 -> 250;
                case 174 -> 185;
                case 175 -> 16;
                case 176 -> 66;
                case 177 -> 92;
                case 178 -> 228;
                case 179 -> 4;
                case 180 -> 204;
                case 181 -> 79;
                case 182 -> 191;
                case 183 -> 189;
                case 184 -> 21;
                case 185 -> 157;
                case 186 -> 169;
                case 187 -> 130;
                case 188 -> 94;
                case 189 -> 174;
                case 190 -> 199;
                case 191 -> 7;
                case 192 -> 88;
                case 193 -> 105;
                case 194 -> 22;
                case 195 -> 54;
                case 196 -> 97;
                case 197 -> 142;
                case 198 -> 80;
                case 199 -> 232;
                case 200 -> 203;
                case 201 -> 64;
                case 202 -> 91;
                case 203 -> 29;
                case 204 -> 253;
                case 205 -> 106;
                case 206 -> 196;
                case 207 -> 224;
                case 208 -> 206;
                case 209 -> 175;
                case 210 -> 102;
                case 211 -> 136;
                case 212 -> 137;
                case 213 -> 15;
                case 214 -> 62;
                case 215 -> 133;
                case 216 -> 176;
                case 217 -> 99;
                case 218 -> 104;
                case 219 -> 163;
                case 220 -> 162;
                case 221 -> 60;
                case 222 -> 160;
                case 223 -> 90;
                case 224 -> 167;
                case 225 -> 214;
                case 226 -> 38;
                case 227 -> 9;
                case 228 -> 77;
                case 229 -> 42;
                case 230 -> 178;
                case 231 -> 65;
                case 232 -> 44;
                case 233 -> 217;
                case 234 -> 32;
                case 235 -> 215;
                case 236 -> 195;
                case 237 -> 222;
                case 238 -> 240;
                case 239 -> 234;
                case 240 -> 129;
                case 241 -> 173;
                case 242 -> 193;
                case 243 -> 221;
                case 244 -> 107;
                case 245 -> 23;
                case 246 -> 127;
                case 247 -> 138;
                case 248 -> 248;
                case 249 -> 238;
                case 250 -> 82;
                case 251 -> 11;
                case 252 -> 101;
                case 253 -> 254;
                case 254 -> 83;
                default -> 210;
            };
            int n8 = ((n3 ^= n4) & 0xFF) - n7;
            if (n8 < 0) {
                n8 += 256;
            }
            if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                n6 += 256;
            }
            int n9 = 0;
            while (n9 < cArray.length) {
                int n10 = n9 % 2;
                int n11 = n9;
                char[] cArray2 = cArray;
                char c2 = cArray[n11];
                if (n10 == 0) {
                    cArray2[n11] = (char)(c2 ^ n8);
                    n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                } else {
                    cArray2[n11] = (char)(c2 ^ n6);
                    n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                }
                ++n9;
            }
            WindowsNamedPipeAgentIpc.d[n5] = new String(cArray).intern();
        }
        return d[n5];
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\t"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion;", "", "WindowsNamedPipeAgentIpc$Companion", "()V", "connectToPipeTest", "", "pipePath", "", "connectToPipe", "intellij.platform.backend.split"})
    @SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n24#2:392\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion\n*L\n84#1:392\n*E\n"})
    public static final class Companion {
        private static final String[] a;
        private static final String[] b;

        private Companion() {
        }

        @TestOnly
        public final void connectToPipeTest(@NotNull String pipePath) {
            long l2 = 137341120992867L;
            Intrinsics.checkNotNullParameter((Object)pipePath, (String)com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(951830340 - (char)-2282, 951699270 + (char)-16579, (int)l2));
            this.connectToPipe(pipePath);
        }

        private final void connectToPipe(String pipePath) {
            block6: {
                boolean bl;
                WinNT.HANDLE hANDLE;
                block7: {
                    long l2;
                    block5: {
                        WinNT.HANDLE hANDLE2;
                        String[] stringArray;
                        block4: {
                            l2 = 71446839867747L;
                            hANDLE = Kernel32.INSTANCE.CreateFile(pipePath, -1073741824, 0, null, 3, 0, null);
                            stringArray = SshAgentIpcService.K();
                            try {
                                hANDLE2 = hANDLE;
                                if (stringArray == null) break block4;
                                if (hANDLE2 == null) break block5;
                            }
                            catch (RuntimeException runtimeException) {
                                throw com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(runtimeException);
                            }
                            hANDLE2 = WinNT.INVALID_HANDLE_VALUE;
                        }
                        try {
                            bl = Intrinsics.areEqual((Object)hANDLE2, (Object)hANDLE);
                            if (stringArray == null) break block6;
                            if (!bl) break block7;
                        }
                        catch (RuntimeException runtimeException) {
                            throw com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(runtimeException);
                        }
                    }
                    Companion companion = this;
                    boolean bl2 = false;
                    Logger logger = Logger.getInstance(Companion.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(58850430 + (char)-15695, 58850430 + (char)-8737, (int)l2));
                    logger.info(com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(58850430 + (char)-15698, 58850430 + (char)-5026, (int)l2) + pipePath + com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(58850430 + (char)-15697, -58850430 + -((char)-14260), (int)l2));
                }
                bl = Kernel32.INSTANCE.CloseHandle(hANDLE);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var5 = new String[4];
                    var3_1 = 0;
                    var2_2 = "a\u00a1\u0016Dk9\u00edM\u0010\u00806\u00db\u0017h\u00e8t.\u001b\u00df\u00f4[`\u00c6\u0086\u001b";
                    var4_3 = "a\u00a1\u0016Dk9\u00edM\u0010\u00806\u00db\u0017h\u00e8t.\u001b\u00df\u00f4[`\u00c6\u0086\u001b".length();
                    var1_4 = 8;
                    var0_5 = -1;
lbl7:
                    // 2 sources

                    while (true) {
                        v0 = 114;
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl13:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        var2_2 = "u\u00d3E\u00db\u00a05\u008f\u00ef\r0{\u00e4\u00df\u00d5\u00c8\u00ca\u00cd\u00e8a\u008br\u00e9\u00cd9\u00c5RDF\u001d&\n]\u0004\u0019\u00f7*M\u00d4\u00a1\u00b1\u0007\u0089g\u0015[\u00bc\u009clP\u00f0\u00dbV\u0013G\u000b\u001b\u00e5\u008d\u0013";
                        var4_3 = "u\u00d3E\u00db\u00a05\u008f\u00ef\r0{\u00e4\u00df\u00d5\u00c8\u00ca\u00cd\u00e8a\u008br\u00e9\u00cd9\u00c5RDF\u001d&\n]\u0004\u0019\u00f7*M\u00d4\u00a1\u00b1\u0007\u0089g\u0015[\u00bc\u009clP\u00f0\u00dbV\u0013G\u000b\u001b\u00e5\u008d\u0013".length();
                        var1_4 = 5;
                        var0_5 = -1;
lbl22:
                        // 2 sources

                        while (true) {
                            v0 = 69;
                            v5 = ++var0_5;
                            v2 = var2_2.substring(v5, v5 + var1_4);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl28:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_6 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl85
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v15 = 123;
                                break;
                            }
                            case 1: {
                                v15 = 50;
                                break;
                            }
                            case 2: {
                                v15 = 103;
                                break;
                            }
                            case 3: {
                                v15 = 43;
                                break;
                            }
                            case 4: {
                                v15 = 87;
                                break;
                            }
                            case 5: {
                                v15 = 64;
                                break;
                            }
                            default: {
                                v15 = 120;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_6;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl85:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_6);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl95:
                    // 1 sources

                    ** continue;
                }
            }
            com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a = var5;
            com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.b = new String[4];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0x64D) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 35;
                    case 1 -> 97;
                    case 2 -> 60;
                    case 3 -> 176;
                    case 4 -> 119;
                    case 5 -> 21;
                    case 6 -> 191;
                    case 7 -> 51;
                    case 8 -> 17;
                    case 9 -> 221;
                    case 10 -> 27;
                    case 11 -> 156;
                    case 12 -> 155;
                    case 13 -> 165;
                    case 14 -> 182;
                    case 15 -> 187;
                    case 16 -> 207;
                    case 17 -> 55;
                    case 18 -> 211;
                    case 19 -> 153;
                    case 20 -> 239;
                    case 21 -> 252;
                    case 22 -> 12;
                    case 23 -> 29;
                    case 24 -> 150;
                    case 25 -> 92;
                    case 26 -> 28;
                    case 27 -> 218;
                    case 28 -> 228;
                    case 29 -> 138;
                    case 30 -> 246;
                    case 31 -> 22;
                    case 32 -> 59;
                    case 33 -> 91;
                    case 34 -> 173;
                    case 35 -> 78;
                    case 36 -> 0;
                    case 37 -> 240;
                    case 38 -> 50;
                    case 39 -> 90;
                    case 40 -> 137;
                    case 41 -> 108;
                    case 42 -> 229;
                    case 43 -> 83;
                    case 44 -> 201;
                    case 45 -> 159;
                    case 46 -> 100;
                    case 47 -> 129;
                    case 48 -> 82;
                    case 49 -> 37;
                    case 50 -> 31;
                    case 51 -> 144;
                    case 52 -> 170;
                    case 53 -> 161;
                    case 54 -> 39;
                    case 55 -> 216;
                    case 56 -> 104;
                    case 57 -> 135;
                    case 58 -> 197;
                    case 59 -> 163;
                    case 60 -> 124;
                    case 61 -> 217;
                    case 62 -> 230;
                    case 63 -> 114;
                    case 64 -> 123;
                    case 65 -> 120;
                    case 66 -> 86;
                    case 67 -> 25;
                    case 68 -> 18;
                    case 69 -> 199;
                    case 70 -> 67;
                    case 71 -> 9;
                    case 72 -> 75;
                    case 73 -> 79;
                    case 74 -> 19;
                    case 75 -> 132;
                    case 76 -> 143;
                    case 77 -> 102;
                    case 78 -> 188;
                    case 79 -> 116;
                    case 80 -> 196;
                    case 81 -> 117;
                    case 82 -> 10;
                    case 83 -> 89;
                    case 84 -> 112;
                    case 85 -> 38;
                    case 86 -> 237;
                    case 87 -> 68;
                    case 88 -> 42;
                    case 89 -> 248;
                    case 90 -> 149;
                    case 91 -> 190;
                    case 92 -> 11;
                    case 93 -> 63;
                    case 94 -> 56;
                    case 95 -> 224;
                    case 96 -> 181;
                    case 97 -> 96;
                    case 98 -> 118;
                    case 99 -> 81;
                    case 100 -> 193;
                    case 101 -> 243;
                    case 102 -> 66;
                    case 103 -> 32;
                    case 104 -> 200;
                    case 105 -> 58;
                    case 106 -> 235;
                    case 107 -> 203;
                    case 108 -> 185;
                    case 109 -> 157;
                    case 110 -> 212;
                    case 111 -> 215;
                    case 112 -> 1;
                    case 113 -> 172;
                    case 114 -> 142;
                    case 115 -> 245;
                    case 116 -> 192;
                    case 117 -> 174;
                    case 118 -> 184;
                    case 119 -> 139;
                    case 120 -> 6;
                    case 121 -> 244;
                    case 122 -> 152;
                    case 123 -> 54;
                    case 124 -> 98;
                    case 125 -> 175;
                    case 126 -> 227;
                    case 127 -> 186;
                    case 128 -> 247;
                    case 129 -> 33;
                    case 130 -> 2;
                    case 131 -> 133;
                    case 132 -> 110;
                    case 133 -> 44;
                    case 134 -> 222;
                    case 135 -> 254;
                    case 136 -> 154;
                    case 137 -> 80;
                    case 138 -> 45;
                    case 139 -> 214;
                    case 140 -> 85;
                    case 141 -> 23;
                    case 142 -> 69;
                    case 143 -> 179;
                    case 144 -> 105;
                    case 145 -> 168;
                    case 146 -> 107;
                    case 147 -> 208;
                    case 148 -> 205;
                    case 149 -> 46;
                    case 150 -> 213;
                    case 151 -> 65;
                    case 152 -> 30;
                    case 153 -> 41;
                    case 154 -> 16;
                    case 155 -> 147;
                    case 156 -> 250;
                    case 157 -> 210;
                    case 158 -> 148;
                    case 159 -> 140;
                    case 160 -> 103;
                    case 161 -> 189;
                    case 162 -> 162;
                    case 163 -> 171;
                    case 164 -> 113;
                    case 165 -> 88;
                    case 166 -> 241;
                    case 167 -> 169;
                    case 168 -> 84;
                    case 169 -> 178;
                    case 170 -> 122;
                    case 171 -> 48;
                    case 172 -> 234;
                    case 173 -> 3;
                    case 174 -> 7;
                    case 175 -> 87;
                    case 176 -> 125;
                    case 177 -> 202;
                    case 178 -> 204;
                    case 179 -> 61;
                    case 180 -> 72;
                    case 181 -> 20;
                    case 182 -> 109;
                    case 183 -> 194;
                    case 184 -> 95;
                    case 185 -> 130;
                    case 186 -> 4;
                    case 187 -> 128;
                    case 188 -> 101;
                    case 189 -> 236;
                    case 190 -> 47;
                    case 191 -> 71;
                    case 192 -> 126;
                    case 193 -> 131;
                    case 194 -> 34;
                    case 195 -> 99;
                    case 196 -> 223;
                    case 197 -> 40;
                    case 198 -> 14;
                    case 199 -> 151;
                    case 200 -> 52;
                    case 201 -> 255;
                    case 202 -> 180;
                    case 203 -> 24;
                    case 204 -> 167;
                    case 205 -> 76;
                    case 206 -> 121;
                    case 207 -> 94;
                    case 208 -> 249;
                    case 209 -> 115;
                    case 210 -> 232;
                    case 211 -> 233;
                    case 212 -> 145;
                    case 213 -> 198;
                    case 214 -> 225;
                    case 215 -> 195;
                    case 216 -> 177;
                    case 217 -> 15;
                    case 218 -> 183;
                    case 219 -> 106;
                    case 220 -> 141;
                    case 221 -> 74;
                    case 222 -> 136;
                    case 223 -> 231;
                    case 224 -> 77;
                    case 225 -> 43;
                    case 226 -> 127;
                    case 227 -> 238;
                    case 228 -> 53;
                    case 229 -> 8;
                    case 230 -> 209;
                    case 231 -> 242;
                    case 232 -> 134;
                    case 233 -> 160;
                    case 234 -> 49;
                    case 235 -> 219;
                    case 236 -> 146;
                    case 237 -> 5;
                    case 238 -> 62;
                    case 239 -> 251;
                    case 240 -> 206;
                    case 241 -> 220;
                    case 242 -> 253;
                    case 243 -> 70;
                    case 244 -> 26;
                    case 245 -> 166;
                    case 246 -> 158;
                    case 247 -> 111;
                    case 248 -> 36;
                    case 249 -> 226;
                    case 250 -> 93;
                    case 251 -> 13;
                    case 252 -> 57;
                    case 253 -> 164;
                    case 254 -> 73;
                    default -> 64;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u0000 \b2\u00020\u0001:\u0001\bJ\u001c\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\t\u00c0\u0006\u0001"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "Lcom/sun/jna/platform/win32/Kernel32;", "CancelIoEx", "", "hFile", "Lcom/sun/jna/platform/win32/WinNT$HANDLE;", "lpOverlapped", "Lcom/sun/jna/Pointer;", "Companion", "intellij.platform.backend.split"})
    public static interface Kernel32Ex
    extends Kernel32 {
        @NotNull
        public static final Companion Companion = Companion.$$INSTANCE;

        public boolean CancelIoEx(@Nullable WinNT.HANDLE var1, @Nullable Pointer var2);

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex$Companion;", "", "WindowsNamedPipeAgentIpc$Kernel32Ex$Companion", "()V", "INSTANCE", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "getINSTANCE", "()Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "intellij.platform.backend.split"})
        public static final class Companion {
            static final /* synthetic */ Companion $$INSTANCE;
            @NotNull
            private static final Kernel32Ex INSTANCE;

            private Companion() {
            }

            @NotNull
            public final Kernel32Ex getINSTANCE() {
                return INSTANCE;
            }

            /*
             * Unable to fully structure code
             */
            static {
                block13: {
                    var7 = 39566523443912L;
                    var0_1 = new String[2];
                    var4_2 = 0;
                    var3_3 = "h\u001dD{%\u0006e1\to\u0017WqhDx-Q";
                    var5_4 = "h\u001dD{%\u0006e1\to\u0017WqhDx-Q".length();
                    var2_5 = 8;
                    var1_6 = -1;
lbl8:
                    // 2 sources

                    while (true) {
                        continue;
                        break;
                    }
lbl10:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = new String(v0).intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        break block13;
                        break;
                    }
                    v1 = ++var1_6;
                    v2 = var3_3.substring(v1, v1 + var2_5).toCharArray();
                    v3 = v2.length;
                    var6_7 = 0;
                    v4 = 78;
                    v5 = v2;
                    v6 = v3;
                    if (v3 > 1) ** GOTO lbl68
                    do {
                        v7 = v4;
                        v5 = v5;
                        v8 = v5;
                        v9 = v4;
                        v10 = var6_7;
                        while (true) {
                            switch (var6_7 % 7) {
                                case 0: {
                                    v11 = 77;
                                    break;
                                }
                                case 1: {
                                    v11 = 54;
                                    break;
                                }
                                case 2: {
                                    v11 = 120;
                                    break;
                                }
                                case 3: {
                                    v11 = 91;
                                    break;
                                }
                                case 4: {
                                    v11 = 14;
                                    break;
                                }
                                case 5: {
                                    v11 = 36;
                                    break;
                                }
                                default: {
                                    v11 = 24;
                                }
                            }
                            v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                            ++var6_7;
                            v4 = v7;
                            if (v7 != 0) break;
                            v7 = v4;
                            v5 = v5;
                            v10 = v4;
                            v8 = v5;
                            v9 = v4;
                        }
lbl68:
                        // 2 sources

                        v0 = v5;
                        v6 = v6;
                    } while (v6 > var6_7);
                    ** while (true)
                }
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Kernel32Ex$Companion.$$INSTANCE = new Companion();
                v12 = Native.load((String)var0_1[0], Kernel32Ex.class, (Map)W32APIOptions.DEFAULT_OPTIONS);
                Intrinsics.checkNotNullExpressionValue((Object)v12, (String)var0_1[1]);
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Kernel32Ex$Companion.INSTANCE = (Kernel32Ex)v12;
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\n\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\n\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$NamedPipeState;", "", "WindowsNamedPipeAgentIpc$NamedPipeState", "(Ljava/lang/String;I)V", "Initial", "Open", "Connecting", "Connected", "Disconnecting", "Closing", "Closed", "intellij.platform.backend.split"})
    public static final class NamedPipeState
    extends Enum<NamedPipeState> {
        public static final /* enum */ NamedPipeState Initial;
        public static final /* enum */ NamedPipeState Open;
        public static final /* enum */ NamedPipeState Connecting;
        public static final /* enum */ NamedPipeState Connected;
        public static final /* enum */ NamedPipeState Disconnecting;
        public static final /* enum */ NamedPipeState Closing;
        public static final /* enum */ NamedPipeState Closed;
        private static final /* synthetic */ NamedPipeState[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static NamedPipeState[] values() {
            return (NamedPipeState[])$VALUES.clone();
        }

        public static NamedPipeState valueOf(String value) {
            return Enum.valueOf(NamedPipeState.class, value);
        }

        @NotNull
        public static EnumEntries<NamedPipeState> getEntries() {
            return $ENTRIES;
        }

        private static final /* synthetic */ NamedPipeState[] $values() {
            NamedPipeState[] namedPipeStateArray = new NamedPipeState[]{Initial, Open, Connecting, Connected, Disconnecting, Closing, Closed};
            return namedPipeStateArray;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var7 = 116194803210011L;
                    var0_1 = new String[7];
                    var4_2 = 0;
                    var3_3 = "W\u000br\u0002IL\u001c\u0004Q\u0015~\u0018\n]\nu\u0018EN\u0004w\u000b|\t]\nu\u0018EN\u0004{\u0001\rZ\fh\u0015OC\u001e{\u0006o\u001fNJ";
                    var5_4 = "W\u000br\u0002IL\u001c\u0004Q\u0015~\u0018\n]\nu\u0018EN\u0004w\u000b|\t]\nu\u0018EN\u0004{\u0001\rZ\fh\u0015OC\u001e{\u0006o\u001fNJ".length();
                    var2_5 = 7;
                    var1_6 = -1;
lbl8:
                    // 2 sources

                    while (true) {
                        v0 = 72;
                        v1 = ++var1_6;
                        v2 = var3_3.substring(v1, v1 + var2_5);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl14:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = v4.intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        var3_3 = "W\u0003~\u000fCI\u001d\u0006W\u0003~\u000fOC";
                        var5_4 = "W\u0003~\u000fCI\u001d\u0006W\u0003~\u000fOC".length();
                        var2_5 = 7;
                        var1_6 = -1;
lbl23:
                        // 2 sources

                        while (true) {
                            v0 = 66;
                            v5 = ++var1_6;
                            v2 = var3_3.substring(v5, v5 + var2_5);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl29:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = v4.intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_7 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl86
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_7;
                    while (true) {
                        switch (var6_7 % 7) {
                            case 0: {
                                v15 = 86;
                                break;
                            }
                            case 1: {
                                v15 = 45;
                                break;
                            }
                            case 2: {
                                v15 = 83;
                                break;
                            }
                            case 3: {
                                v15 = 62;
                                break;
                            }
                            case 4: {
                                v15 = 104;
                                break;
                            }
                            case 5: {
                                v15 = 101;
                                break;
                            }
                            default: {
                                v15 = 56;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_7;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl86:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_7);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl96:
                    // 1 sources

                    ** continue;
                }
            }
            NamedPipeState.Initial = new NamedPipeState();
            NamedPipeState.Open = new NamedPipeState();
            NamedPipeState.Connecting = new NamedPipeState();
            NamedPipeState.Connected = new NamedPipeState();
            NamedPipeState.Disconnecting = new NamedPipeState();
            NamedPipeState.Closing = new NamedPipeState();
            NamedPipeState.Closed = new NamedPipeState();
            NamedPipeState.$VALUES = NamedPipeState.$values();
            NamedPipeState.$ENTRIES = EnumEntriesKt.enumEntries((Enum[])NamedPipeState.$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel;", "Ljava/nio/channels/ReadableByteChannel;", "agent", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "WindowsNamedPipeAgentIpc$PipeReadableByteChannel", "(Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;)V", "read", "", "dst", "Ljava/nio/ByteBuffer;", "isOpen", "", "close", "", "intellij.platform.backend.split"})
    @SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n24#2:392\n24#2:393\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel\n*L\n315#1:392\n320#1:393\n*E\n"})
    private static final class PipeReadableByteChannel
    implements ReadableByteChannel {
        @NotNull
        private final WindowsNamedPipeAgentIpc agent;
        private static final String[] a;
        private static final String[] b;

        public PipeReadableByteChannel(@NotNull WindowsNamedPipeAgentIpc agent) {
            long l2 = 23028705235674L;
            Intrinsics.checkNotNullParameter((Object)agent, (String)PipeReadableByteChannel.a(909363660 + (char)-31009, -909363660 + -((char)-22356), (int)l2));
            this.agent = agent;
        }

        /*
         * Exception decompiling
         */
        @Override
        public int read(@NotNull ByteBuffer dst) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 5[SWITCH]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        @Override
        public boolean isOpen() {
            boolean bl;
            long l2 = 18238228927047L;
            try {
                bl = this.agent.state == NamedPipeState.Connected;
            }
            catch (RuntimeException runtimeException) {
                throw PipeReadableByteChannel.a(runtimeException);
            }
            return bl;
        }

        @Override
        public void close() {
            this.agent.disconnect();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var5 = new String[9];
                    var3_1 = 0;
                    var2_2 = "<Y\u00d3KZ\u0003\u00fb\u00d6\u009f\u0005\u0080$b \u008f\rFL\u008cg\u00a7\u0080\u0097\u009c\u009bE\u00d3_\u0091\u0010\u00f1\u0000\u00bd\u0005\u00beY\u009f\u009aS\u0001)\u009a(\u00cf\r\u000f\u0005\u009ep\u00a1\u00aa\u00f73\u00dbs\u0018\u00bd\u00df\n\u0083\u00e4\u00ad3}\u00f5ds\u00a8\u0087?\u00ea'\n_\u0018\u00fc\u00fc\u00f8R\u0091N\u00a8\u0090\u0000\u00db\u0002\u00d4s\u001d\u00f7\\\u00fcT\u00d7\u00cb{\u00d2Ve\u0007)\u00e0\u00b5\u008c";
                    var4_3 = "<Y\u00d3KZ\u0003\u00fb\u00d6\u009f\u0005\u0080$b \u008f\rFL\u008cg\u00a7\u0080\u0097\u009c\u009bE\u00d3_\u0091\u0010\u00f1\u0000\u00bd\u0005\u00beY\u009f\u009aS\u0001)\u009a(\u00cf\r\u000f\u0005\u009ep\u00a1\u00aa\u00f73\u00dbs\u0018\u00bd\u00df\n\u0083\u00e4\u00ad3}\u00f5ds\u00a8\u0087?\u00ea'\n_\u0018\u00fc\u00fc\u00f8R\u0091N\u00a8\u0090\u0000\u00db\u0002\u00d4s\u001d\u00f7\\\u00fcT\u00d7\u00cb{\u00d2Ve\u0007)\u00e0\u00b5\u008c".length();
                    var1_4 = 5;
                    var0_5 = -1;
lbl7:
                    // 2 sources

                    while (true) {
                        v0 = 116;
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl13:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        var2_2 = "\u00e0\u00eb\u00fc\u001b\u00f5\u00f9\u0095\u00edq\u008c\u000eH\u00af\u00f6\u009eKL\\\u0091\u009c\u009e\u00d3\u0081?\u008c\u00ad39\u0006G\u00b1\u0010\u00daN\u00f3\u0095\u00bc\u0002\u00c9\u001e\u0007\u00e4\u00a5T\u0015\u0089\u00d1\u00a8\u00ffd\u00dd\u00adC}*\u00f4\u009f\u0083,]0\u00e4\u0084\u00f9N\u00ae\u000e\u00ceAzp\u0084P\u00e0\u0011\u009c\u0081\u00d7\u00e9i\f':aY&\u00a1j\b\u00ee\u0096\u008c\u0087";
                        var4_3 = "\u00e0\u00eb\u00fc\u001b\u00f5\u00f9\u0095\u00edq\u008c\u000eH\u00af\u00f6\u009eKL\\\u0091\u009c\u009e\u00d3\u0081?\u008c\u00ad39\u0006G\u00b1\u0010\u00daN\u00f3\u0095\u00bc\u0002\u00c9\u001e\u0007\u00e4\u00a5T\u0015\u0089\u00d1\u00a8\u00ffd\u00dd\u00adC}*\u00f4\u009f\u0083,]0\u00e4\u0084\u00f9N\u00ae\u000e\u00ceAzp\u0084P\u00e0\u0011\u009c\u0081\u00d7\u00e9i\f':aY&\u00a1j\b\u00ee\u0096\u008c\u0087".length();
                        var1_4 = 16;
                        var0_5 = -1;
lbl22:
                        // 2 sources

                        while (true) {
                            v0 = 119;
                            v5 = ++var0_5;
                            v2 = var2_2.substring(v5, v5 + var1_4);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl28:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_6 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl85
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v15 = 125;
                                break;
                            }
                            case 1: {
                                v15 = 107;
                                break;
                            }
                            case 2: {
                                v15 = 41;
                                break;
                            }
                            case 3: {
                                v15 = 18;
                                break;
                            }
                            case 4: {
                                v15 = 66;
                                break;
                            }
                            case 5: {
                                v15 = 82;
                                break;
                            }
                            default: {
                                v15 = 45;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_6;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl85:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_6);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl95:
                    // 1 sources

                    ** continue;
                }
            }
            PipeReadableByteChannel.a = var5;
            PipeReadableByteChannel.b = new String[9];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0xFFFFC271) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 228;
                    case 1 -> 68;
                    case 2 -> 210;
                    case 3 -> 139;
                    case 4 -> 189;
                    case 5 -> 148;
                    case 6 -> 166;
                    case 7 -> 173;
                    case 8 -> 244;
                    case 9 -> 21;
                    case 10 -> 51;
                    case 11 -> 225;
                    case 12 -> 208;
                    case 13 -> 57;
                    case 14 -> 125;
                    case 15 -> 249;
                    case 16 -> 209;
                    case 17 -> 20;
                    case 18 -> 122;
                    case 19 -> 4;
                    case 20 -> 179;
                    case 21 -> 160;
                    case 22 -> 66;
                    case 23 -> 157;
                    case 24 -> 237;
                    case 25 -> 195;
                    case 26 -> 158;
                    case 27 -> 93;
                    case 28 -> 108;
                    case 29 -> 143;
                    case 30 -> 0;
                    case 31 -> 212;
                    case 32 -> 10;
                    case 33 -> 130;
                    case 34 -> 82;
                    case 35 -> 159;
                    case 36 -> 46;
                    case 37 -> 200;
                    case 38 -> 152;
                    case 39 -> 185;
                    case 40 -> 178;
                    case 41 -> 190;
                    case 42 -> 151;
                    case 43 -> 13;
                    case 44 -> 172;
                    case 45 -> 38;
                    case 46 -> 196;
                    case 47 -> 113;
                    case 48 -> 102;
                    case 49 -> 174;
                    case 50 -> 197;
                    case 51 -> 37;
                    case 52 -> 106;
                    case 53 -> 254;
                    case 54 -> 245;
                    case 55 -> 88;
                    case 56 -> 28;
                    case 57 -> 156;
                    case 58 -> 59;
                    case 59 -> 147;
                    case 60 -> 142;
                    case 61 -> 36;
                    case 62 -> 241;
                    case 63 -> 219;
                    case 64 -> 41;
                    case 65 -> 167;
                    case 66 -> 191;
                    case 67 -> 114;
                    case 68 -> 129;
                    case 69 -> 56;
                    case 70 -> 98;
                    case 71 -> 12;
                    case 72 -> 8;
                    case 73 -> 251;
                    case 74 -> 74;
                    case 75 -> 107;
                    case 76 -> 230;
                    case 77 -> 135;
                    case 78 -> 207;
                    case 79 -> 78;
                    case 80 -> 43;
                    case 81 -> 62;
                    case 82 -> 214;
                    case 83 -> 155;
                    case 84 -> 187;
                    case 85 -> 170;
                    case 86 -> 77;
                    case 87 -> 86;
                    case 88 -> 87;
                    case 89 -> 120;
                    case 90 -> 96;
                    case 91 -> 52;
                    case 92 -> 89;
                    case 93 -> 60;
                    case 94 -> 75;
                    case 95 -> 14;
                    case 96 -> 123;
                    case 97 -> 109;
                    case 98 -> 164;
                    case 99 -> 53;
                    case 100 -> 150;
                    case 101 -> 132;
                    case 102 -> 19;
                    case 103 -> 48;
                    case 104 -> 140;
                    case 105 -> 131;
                    case 106 -> 81;
                    case 107 -> 136;
                    case 108 -> 73;
                    case 109 -> 44;
                    case 110 -> 3;
                    case 111 -> 149;
                    case 112 -> 232;
                    case 113 -> 103;
                    case 114 -> 247;
                    case 115 -> 54;
                    case 116 -> 6;
                    case 117 -> 18;
                    case 118 -> 67;
                    case 119 -> 35;
                    case 120 -> 128;
                    case 121 -> 50;
                    case 122 -> 226;
                    case 123 -> 111;
                    case 124 -> 176;
                    case 125 -> 202;
                    case 126 -> 71;
                    case 127 -> 235;
                    case 128 -> 145;
                    case 129 -> 40;
                    case 130 -> 134;
                    case 131 -> 85;
                    case 132 -> 238;
                    case 133 -> 213;
                    case 134 -> 169;
                    case 135 -> 211;
                    case 136 -> 58;
                    case 137 -> 9;
                    case 138 -> 221;
                    case 139 -> 181;
                    case 140 -> 188;
                    case 141 -> 115;
                    case 142 -> 231;
                    case 143 -> 92;
                    case 144 -> 184;
                    case 145 -> 11;
                    case 146 -> 227;
                    case 147 -> 121;
                    case 148 -> 91;
                    case 149 -> 138;
                    case 150 -> 177;
                    case 151 -> 217;
                    case 152 -> 234;
                    case 153 -> 216;
                    case 154 -> 99;
                    case 155 -> 141;
                    case 156 -> 165;
                    case 157 -> 162;
                    case 158 -> 15;
                    case 159 -> 5;
                    case 160 -> 229;
                    case 161 -> 17;
                    case 162 -> 253;
                    case 163 -> 42;
                    case 164 -> 55;
                    case 165 -> 220;
                    case 166 -> 223;
                    case 167 -> 243;
                    case 168 -> 250;
                    case 169 -> 69;
                    case 170 -> 117;
                    case 171 -> 33;
                    case 172 -> 34;
                    case 173 -> 154;
                    case 174 -> 144;
                    case 175 -> 168;
                    case 176 -> 203;
                    case 177 -> 23;
                    case 178 -> 240;
                    case 179 -> 194;
                    case 180 -> 39;
                    case 181 -> 248;
                    case 182 -> 27;
                    case 183 -> 222;
                    case 184 -> 64;
                    case 185 -> 199;
                    case 186 -> 95;
                    case 187 -> 25;
                    case 188 -> 61;
                    case 189 -> 83;
                    case 190 -> 119;
                    case 191 -> 118;
                    case 192 -> 70;
                    case 193 -> 32;
                    case 194 -> 163;
                    case 195 -> 205;
                    case 196 -> 72;
                    case 197 -> 47;
                    case 198 -> 24;
                    case 199 -> 30;
                    case 200 -> 63;
                    case 201 -> 126;
                    case 202 -> 246;
                    case 203 -> 182;
                    case 204 -> 153;
                    case 205 -> 80;
                    case 206 -> 124;
                    case 207 -> 49;
                    case 208 -> 94;
                    case 209 -> 161;
                    case 210 -> 45;
                    case 211 -> 112;
                    case 212 -> 22;
                    case 213 -> 79;
                    case 214 -> 65;
                    case 215 -> 84;
                    case 216 -> 255;
                    case 217 -> 16;
                    case 218 -> 137;
                    case 219 -> 218;
                    case 220 -> 242;
                    case 221 -> 183;
                    case 222 -> 2;
                    case 223 -> 233;
                    case 224 -> 236;
                    case 225 -> 180;
                    case 226 -> 215;
                    case 227 -> 239;
                    case 228 -> 104;
                    case 229 -> 90;
                    case 230 -> 224;
                    case 231 -> 206;
                    case 232 -> 146;
                    case 233 -> 26;
                    case 234 -> 171;
                    case 235 -> 127;
                    case 236 -> 201;
                    case 237 -> 29;
                    case 238 -> 204;
                    case 239 -> 100;
                    case 240 -> 110;
                    case 241 -> 175;
                    case 242 -> 252;
                    case 243 -> 192;
                    case 244 -> 133;
                    case 245 -> 186;
                    case 246 -> 105;
                    case 247 -> 116;
                    case 248 -> 31;
                    case 249 -> 198;
                    case 250 -> 193;
                    case 251 -> 7;
                    case 252 -> 101;
                    case 253 -> 97;
                    case 254 -> 76;
                    default -> 1;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                PipeReadableByteChannel.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeWritableByteChannel;", "Ljava/nio/channels/WritableByteChannel;", "agent", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "WindowsNamedPipeAgentIpc$PipeWritableByteChannel", "(Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;)V", "write", "", "src", "Ljava/nio/ByteBuffer;", "isOpen", "", "close", "", "intellij.platform.backend.split"})
    private static final class PipeWritableByteChannel
    implements WritableByteChannel {
        @NotNull
        private final WindowsNamedPipeAgentIpc agent;
        private static final String[] a;
        private static final String[] b;

        public PipeWritableByteChannel(@NotNull WindowsNamedPipeAgentIpc agent) {
            long l2 = 130613105181346L;
            Intrinsics.checkNotNullParameter((Object)agent, (String)PipeWritableByteChannel.a(1145289660 - 30964, -1145289660 - -25390, (int)l2));
            this.agent = agent;
        }

        @Override
        public int write(@NotNull ByteBuffer src) {
            int n2;
            block7: {
                IntByReference intByReference;
                block8: {
                    long l2 = 131214067298392L;
                    String[] stringArray = SshAgentIpcService.K();
                    Intrinsics.checkNotNullParameter((Object)src, (String)PipeWritableByteChannel.a(1478600670 - 14251, 1478600670 - (char)-23028, (int)l2));
                    String[] stringArray2 = stringArray;
                    try {
                        if (!this.agent.isOpen()) {
                            throw new ClosedChannelException();
                        }
                    }
                    catch (RuntimeException runtimeException) {
                        throw PipeWritableByteChannel.a(runtimeException);
                    }
                    intByReference = new IntByReference();
                    byte[] byArray = new byte[src.remaining()];
                    try {
                        try {
                            src.get(byArray);
                            n2 = Kernel32.INSTANCE.WriteFile(this.agent.hPipe, byArray, byArray.length, intByReference, null);
                            if (stringArray2 == null) break block7;
                            if (n2 != 0) break block8;
                        }
                        catch (RuntimeException runtimeException) {
                            throw PipeWritableByteChannel.a(runtimeException);
                        }
                        return -1;
                    }
                    catch (RuntimeException runtimeException) {
                        throw PipeWritableByteChannel.a(runtimeException);
                    }
                }
                n2 = intByReference.getValue();
            }
            return n2;
        }

        @Override
        public boolean isOpen() {
            boolean bl;
            long l2 = 52802506883159L;
            try {
                bl = this.agent.state == NamedPipeState.Connected;
            }
            catch (RuntimeException runtimeException) {
                throw PipeWritableByteChannel.a(runtimeException);
            }
            return bl;
        }

        @Override
        public void close() {
            this.agent.disconnect();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block13: {
                var5 = new String[2];
                var3_1 = 0;
                var2_2 = "?\u00bf<\u00e5\u001d\u0003Q\u00dc\u00a7";
                var4_3 = "?\u00bf<\u00e5\u001d\u0003Q\u00dc\u00a7".length();
                var1_4 = 5;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    continue;
                    break;
                }
lbl9:
                // 1 sources

                while (true) {
                    var5[var3_1++] = new String(v0).intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block13;
                    break;
                }
                v1 = ++var0_5;
                v2 = var2_2.substring(v1, v1 + var1_4).toCharArray();
                v3 = v2.length;
                var6_6 = 0;
                v4 = 122;
                v5 = v2;
                v6 = v3;
                if (v3 > 1) ** GOTO lbl67
                do {
                    v7 = v4;
                    v5 = v5;
                    v8 = v5;
                    v9 = v4;
                    v10 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v11 = 100;
                                break;
                            }
                            case 1: {
                                v11 = 119;
                                break;
                            }
                            case 2: {
                                v11 = 74;
                                break;
                            }
                            case 3: {
                                v11 = 44;
                                break;
                            }
                            case 4: {
                                v11 = 91;
                                break;
                            }
                            case 5: {
                                v11 = 81;
                                break;
                            }
                            default: {
                                v11 = 95;
                            }
                        }
                        v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                        ++var6_6;
                        v4 = v7;
                        if (v7 != 0) break;
                        v7 = v4;
                        v5 = v5;
                        v10 = v4;
                        v8 = v5;
                        v9 = v4;
                    }
lbl67:
                    // 2 sources

                    v0 = v5;
                    v6 = v6;
                } while (v6 > var6_6);
                ** while (true)
            }
            PipeWritableByteChannel.a = var5;
            PipeWritableByteChannel.b = new String[2];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0xFFFF806A) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 196;
                    case 1 -> 186;
                    case 2 -> 177;
                    case 3 -> 236;
                    case 4 -> 246;
                    case 5 -> 39;
                    case 6 -> 162;
                    case 7 -> 113;
                    case 8 -> 94;
                    case 9 -> 96;
                    case 10 -> 233;
                    case 11 -> 104;
                    case 12 -> 86;
                    case 13 -> 74;
                    case 14 -> 11;
                    case 15 -> 112;
                    case 16 -> 140;
                    case 17 -> 60;
                    case 18 -> 164;
                    case 19 -> 97;
                    case 20 -> 234;
                    case 21 -> 181;
                    case 22 -> 146;
                    case 23 -> 20;
                    case 24 -> 218;
                    case 25 -> 213;
                    case 26 -> 245;
                    case 27 -> 241;
                    case 28 -> 38;
                    case 29 -> 231;
                    case 30 -> 211;
                    case 31 -> 133;
                    case 32 -> 207;
                    case 33 -> 144;
                    case 34 -> 223;
                    case 35 -> 135;
                    case 36 -> 226;
                    case 37 -> 208;
                    case 38 -> 214;
                    case 39 -> 178;
                    case 40 -> 106;
                    case 41 -> 189;
                    case 42 -> 71;
                    case 43 -> 56;
                    case 44 -> 77;
                    case 45 -> 160;
                    case 46 -> 165;
                    case 47 -> 155;
                    case 48 -> 129;
                    case 49 -> 194;
                    case 50 -> 171;
                    case 51 -> 131;
                    case 52 -> 227;
                    case 53 -> 199;
                    case 54 -> 27;
                    case 55 -> 32;
                    case 56 -> 35;
                    case 57 -> 122;
                    case 58 -> 42;
                    case 59 -> 173;
                    case 60 -> 54;
                    case 61 -> 23;
                    case 62 -> 87;
                    case 63 -> 201;
                    case 64 -> 44;
                    case 65 -> 30;
                    case 66 -> 50;
                    case 67 -> 57;
                    case 68 -> 198;
                    case 69 -> 126;
                    case 70 -> 187;
                    case 71 -> 13;
                    case 72 -> 7;
                    case 73 -> 58;
                    case 74 -> 158;
                    case 75 -> 252;
                    case 76 -> 217;
                    case 77 -> 33;
                    case 78 -> 15;
                    case 79 -> 78;
                    case 80 -> 185;
                    case 81 -> 47;
                    case 82 -> 45;
                    case 83 -> 108;
                    case 84 -> 10;
                    case 85 -> 1;
                    case 86 -> 80;
                    case 87 -> 176;
                    case 88 -> 156;
                    case 89 -> 64;
                    case 90 -> 6;
                    case 91 -> 180;
                    case 92 -> 8;
                    case 93 -> 101;
                    case 94 -> 48;
                    case 95 -> 175;
                    case 96 -> 221;
                    case 97 -> 243;
                    case 98 -> 73;
                    case 99 -> 235;
                    case 100 -> 90;
                    case 101 -> 203;
                    case 102 -> 170;
                    case 103 -> 4;
                    case 104 -> 28;
                    case 105 -> 154;
                    case 106 -> 184;
                    case 107 -> 253;
                    case 108 -> 55;
                    case 109 -> 202;
                    case 110 -> 69;
                    case 111 -> 37;
                    case 112 -> 70;
                    case 113 -> 153;
                    case 114 -> 145;
                    case 115 -> 62;
                    case 116 -> 114;
                    case 117 -> 166;
                    case 118 -> 121;
                    case 119 -> 159;
                    case 120 -> 72;
                    case 121 -> 81;
                    case 122 -> 130;
                    case 123 -> 151;
                    case 124 -> 117;
                    case 125 -> 191;
                    case 126 -> 152;
                    case 127 -> 21;
                    case 128 -> 169;
                    case 129 -> 124;
                    case 130 -> 149;
                    case 131 -> 49;
                    case 132 -> 148;
                    case 133 -> 83;
                    case 134 -> 161;
                    case 135 -> 88;
                    case 136 -> 242;
                    case 137 -> 237;
                    case 138 -> 105;
                    case 139 -> 188;
                    case 140 -> 209;
                    case 141 -> 36;
                    case 142 -> 195;
                    case 143 -> 12;
                    case 144 -> 102;
                    case 145 -> 118;
                    case 146 -> 247;
                    case 147 -> 89;
                    case 148 -> 220;
                    case 149 -> 43;
                    case 150 -> 34;
                    case 151 -> 174;
                    case 152 -> 134;
                    case 153 -> 172;
                    case 154 -> 46;
                    case 155 -> 190;
                    case 156 -> 31;
                    case 157 -> 238;
                    case 158 -> 24;
                    case 159 -> 239;
                    case 160 -> 157;
                    case 161 -> 244;
                    case 162 -> 67;
                    case 163 -> 59;
                    case 164 -> 84;
                    case 165 -> 40;
                    case 166 -> 137;
                    case 167 -> 100;
                    case 168 -> 63;
                    case 169 -> 216;
                    case 170 -> 115;
                    case 171 -> 147;
                    case 172 -> 143;
                    case 173 -> 92;
                    case 174 -> 128;
                    case 175 -> 109;
                    case 176 -> 206;
                    case 177 -> 224;
                    case 178 -> 29;
                    case 179 -> 232;
                    case 180 -> 254;
                    case 181 -> 123;
                    case 182 -> 19;
                    case 183 -> 193;
                    case 184 -> 250;
                    case 185 -> 255;
                    case 186 -> 111;
                    case 187 -> 138;
                    case 188 -> 163;
                    case 189 -> 75;
                    case 190 -> 26;
                    case 191 -> 192;
                    case 192 -> 22;
                    case 193 -> 76;
                    case 194 -> 61;
                    case 195 -> 52;
                    case 196 -> 68;
                    case 197 -> 240;
                    case 198 -> 3;
                    case 199 -> 229;
                    case 200 -> 200;
                    case 201 -> 197;
                    case 202 -> 119;
                    case 203 -> 110;
                    case 204 -> 41;
                    case 205 -> 251;
                    case 206 -> 14;
                    case 207 -> 182;
                    case 208 -> 98;
                    case 209 -> 5;
                    case 210 -> 219;
                    case 211 -> 82;
                    case 212 -> 248;
                    case 213 -> 9;
                    case 214 -> 222;
                    case 215 -> 91;
                    case 216 -> 204;
                    case 217 -> 17;
                    case 218 -> 141;
                    case 219 -> 125;
                    case 220 -> 127;
                    case 221 -> 183;
                    case 222 -> 205;
                    case 223 -> 103;
                    case 224 -> 228;
                    case 225 -> 230;
                    case 226 -> 25;
                    case 227 -> 95;
                    case 228 -> 79;
                    case 229 -> 107;
                    case 230 -> 139;
                    case 231 -> 212;
                    case 232 -> 65;
                    case 233 -> 120;
                    case 234 -> 0;
                    case 235 -> 2;
                    case 236 -> 150;
                    case 237 -> 136;
                    case 238 -> 249;
                    case 239 -> 66;
                    case 240 -> 168;
                    case 241 -> 210;
                    case 242 -> 18;
                    case 243 -> 215;
                    case 244 -> 225;
                    case 245 -> 179;
                    case 246 -> 93;
                    case 247 -> 167;
                    case 248 -> 85;
                    case 249 -> 51;
                    case 250 -> 53;
                    case 251 -> 16;
                    case 252 -> 99;
                    case 253 -> 142;
                    case 254 -> 116;
                    default -> 132;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                PipeWritableByteChannel.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }
}

