/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.stylelint;

import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.lang.javascript.linter.JSLinterError;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.webcore.util.JsonUtil;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class StylelintResultParser {
    private static final Logger LOG = Logger.getInstance(StylelintResultParser.class);
    private static final String LINE = "line";
    private static final String LINE_END = "endLine";
    private static final String COLUMN = "column";
    private static final String COLUMN_END = "endColumn";
    private static final String TEXT = "text";
    private static final String SEVERITY = "severity";
    private static final String WARNING = "warning";
    private static final String WARNINGS = "warnings";
    private static final String ERROR_MESSAGE = "Stylelint result parsing error";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public List<JSLinterError> parse(String stdout) throws Exception {
        if (StringUtil.isEmptyOrSpaces((String)stdout)) {
            return null;
        }
        ArrayList<JSLinterError> errorList = new ArrayList<JSLinterError>();
        try (JsonReader reader = new JsonReader((Reader)new StringReader(stdout));){
            reader.beginArray();
            if (reader.peek() == JsonToken.END_ARRAY) {
                reader.endArray();
                ArrayList<JSLinterError> arrayList = errorList;
                return arrayList;
            }
            reader.beginObject();
            while (reader.hasNext()) {
                String name = reader.nextName();
                if (WARNINGS.equals(name)) {
                    reader.beginArray();
                    while (reader.hasNext()) {
                        errorList.add(StylelintResultParser.parseItem(JsonUtil.nextMap((JsonReader)reader)));
                    }
                    reader.endArray();
                    continue;
                }
                reader.skipValue();
            }
            reader.endObject();
            reader.endArray();
            ArrayList<JSLinterError> arrayList = errorList;
            return arrayList;
        }
        catch (IOException e) {
            return null;
        }
        catch (Exception e) {
            LOG.warn(ERROR_MESSAGE);
            throw new Exception(ERROR_MESSAGE, e);
        }
    }

    private static JSLinterError parseItem(Map<String, Object> map) {
        int line = ((Double)map.get(LINE)).intValue();
        int column = ((Double)map.get(COLUMN)).intValue();
        int lineEnd = map.get(LINE_END) != null ? ((Double)map.get(LINE_END)).intValue() : -1;
        int columnEnd = map.get(COLUMN_END) != null ? ((Double)map.get(COLUMN_END)).intValue() : -1;
        String text = (String)map.get(TEXT);
        String severity = (String)map.get(SEVERITY);
        HighlightSeverity highlightSeverity = WARNING.equals(severity) ? HighlightSeverity.WARNING : null;
        return new JSLinterError(line, column, lineEnd, columnEnd, text, null, highlightSeverity);
    }
}

