/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring;

import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.contexts.model.CacheableCommonSpringModel;
import com.intellij.spring.contexts.model.LocalModel;
import com.intellij.spring.contexts.model.LocalXmlModel;
import com.intellij.spring.contexts.model.visitors.CommonSpringModelVisitorContext;
import com.intellij.spring.contexts.model.visitors.SpringModelVisitors;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.SpringQualifier;
import com.intellij.spring.model.xml.context.SpringBeansPackagesScan;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.Processors;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public final class SpringModelVisitorUtils {
    private static final CommonSpringModelVisitorContext.Exec<SpringBeanPointer<?>> DOM_BEANS = (m, p) -> {
        if (m instanceof LocalXmlModel) {
            for (SpringBeanPointer<?> pointer : ((LocalXmlModel)m).getLocalBeans()) {
                if (p.process(pointer)) continue;
                return false;
            }
        }
        return true;
    };
    private static final CommonSpringModelVisitorContext.Exec<SpringBeanPointer<?>> PLACEHOLDERS = (m, p) -> {
        if (m instanceof LocalXmlModel) {
            for (SpringBeanPointer<?> pointer : ((LocalXmlModel)m).getPlaceholderConfigurerBeans()) {
                if (p.process(pointer)) continue;
                return false;
            }
        }
        return true;
    };
    private static final CommonSpringModelVisitorContext.Exec<SpringBeansPackagesScan> SCANS = (m, p) -> {
        if (m instanceof LocalModel) {
            for (SpringBeansPackagesScan scan : ((LocalModel)m).getPackagesScans()) {
                if (p.process((Object)scan)) continue;
                return false;
            }
        }
        return true;
    };
    private static final CommonSpringModelVisitorContext.Exec<SpringBeanPointer<?>> ANNO_CONFIGS = (m, p) -> {
        if (m instanceof LocalXmlModel) {
            for (SpringBeanPointer<?> pointer : ((LocalXmlModel)m).getAnnotationConfigAppContexts()) {
                if (p.process(pointer)) continue;
                return false;
            }
        }
        return true;
    };
    private static final CommonSpringModelVisitorContext.Exec<String> PROFILES = (m, p) -> {
        if (m instanceof CacheableCommonSpringModel) {
            for (String s : ((CacheableCommonSpringModel)m).getProfiles()) {
                if (p.process((Object)s)) continue;
                return false;
            }
        }
        return true;
    };
    private static final CommonSpringModelVisitorContext.Exec<LocalXmlModel> LOCAL_XML_MODELS = (m, p) -> !(m instanceof LocalXmlModel) || p.process((Object)((LocalXmlModel)m));

    @NotNull
    public static Set<String> getProfiles(@NotNull CommonSpringModel model) {
        if (model == null) {
            SpringModelVisitorUtils.$$$reportNull$$$0(0);
        }
        CommonProcessors.CollectProcessor processor2 = new CommonProcessors.CollectProcessor();
        SpringModelVisitors.visitRelatedModels(model, CommonSpringModelVisitorContext.context(processor2, PROFILES));
        return new HashSet<String>(processor2.getResults());
    }

    @NotNull
    public static Collection<SpringBeanPointer<?>> getAllDomBeans(@NotNull CommonSpringModel model) {
        if (model == null) {
            SpringModelVisitorUtils.$$$reportNull$$$0(1);
        }
        CommonProcessors.CollectProcessor processor2 = new CommonProcessors.CollectProcessor();
        SpringModelVisitors.visitRelatedModels(model, CommonSpringModelVisitorContext.context(processor2, DOM_BEANS));
        Collection collection = processor2.getResults();
        if (collection == null) {
            SpringModelVisitorUtils.$$$reportNull$$$0(2);
        }
        return collection;
    }

    @NotNull
    public static Set<LocalXmlModel> getLocalXmlModels(@NotNull CommonSpringModel model) {
        if (model == null) {
            SpringModelVisitorUtils.$$$reportNull$$$0(3);
        }
        CommonProcessors.CollectProcessor processor2 = new CommonProcessors.CollectProcessor();
        SpringModelVisitors.visitRelatedModels(model, CommonSpringModelVisitorContext.context(processor2, LOCAL_XML_MODELS));
        return new HashSet<LocalXmlModel>(processor2.getResults());
    }

    @NotNull
    public static Set<SpringBeanPointer<?>> getPlaceholderConfigurers(@NotNull CommonSpringModel model) {
        if (model == null) {
            SpringModelVisitorUtils.$$$reportNull$$$0(4);
        }
        HashSet placeholders = new HashSet();
        SpringModelVisitors.visitRelatedModels(model, CommonSpringModelVisitorContext.context(Processors.cancelableCollectProcessor(placeholders), PLACEHOLDERS));
        Set<SpringBeanPointer<?>> set = Set.copyOf(placeholders);
        if (set == null) {
            SpringModelVisitorUtils.$$$reportNull$$$0(5);
        }
        return set;
    }

    @NotNull
    public static List<SpringBeansPackagesScan> getComponentScans(@NotNull CommonSpringModel model) {
        if (model == null) {
            SpringModelVisitorUtils.$$$reportNull$$$0(6);
        }
        ArrayList<SpringBeansPackagesScan> scans = new ArrayList<SpringBeansPackagesScan>();
        SpringModelVisitors.visitRecursionAwareRelatedModels(model, CommonSpringModelVisitorContext.context(Processors.cancelableCollectProcessor(scans), SCANS));
        ArrayList<SpringBeansPackagesScan> arrayList = scans;
        if (arrayList == null) {
            SpringModelVisitorUtils.$$$reportNull$$$0(7);
        }
        return arrayList;
    }

    public static boolean hasComponentScans(@NotNull CommonSpringModel model) {
        if (model == null) {
            SpringModelVisitorUtils.$$$reportNull$$$0(8);
        }
        CommonProcessors.FindFirstProcessor processor2 = new CommonProcessors.FindFirstProcessor();
        SpringModelVisitors.visitRecursionAwareRelatedModels(model, CommonSpringModelVisitorContext.context(processor2, SCANS));
        return processor2.isFound();
    }

    @NotNull
    public static List<SpringBeanPointer<?>> getAnnotationConfigApplicationContexts(@NotNull CommonSpringModel model) {
        if (model == null) {
            SpringModelVisitorUtils.$$$reportNull$$$0(9);
        }
        LinkedList pointers = new LinkedList();
        SpringModelVisitors.visitRecursionAwareRelatedModels(model, CommonSpringModelVisitorContext.context(Processors.cancelableCollectProcessor(pointers), ANNO_CONFIGS));
        LinkedList linkedList = pointers;
        if (linkedList == null) {
            SpringModelVisitorUtils.$$$reportNull$$$0(10);
        }
        return linkedList;
    }

    public static Collection<XmlTag> getCustomBeanCandidates(@NotNull CommonSpringModel model, String id) {
        if (model == null) {
            SpringModelVisitorUtils.$$$reportNull$$$0(11);
        }
        HashSet<XmlTag> tags = new HashSet<XmlTag>();
        SpringModelVisitors.visitRecursionAwareRelatedModels(model, CommonSpringModelVisitorContext.context(Processors.cancelableCollectProcessor(tags), (m, p) -> {
            if (m instanceof LocalXmlModel) {
                for (XmlTag xmlTag : ((LocalXmlModel)m).getCustomBeans(id)) {
                    if (p.process((Object)xmlTag)) continue;
                    return false;
                }
            }
            return true;
        }));
        return tags;
    }

    @NotNull
    public static List<SpringBeanPointer<?>> getDescendants(@NotNull CommonSpringModel model, @NotNull SpringBeanPointer<?> context) {
        if (model == null) {
            SpringModelVisitorUtils.$$$reportNull$$$0(12);
        }
        if (context == null) {
            SpringModelVisitorUtils.$$$reportNull$$$0(13);
        }
        LinkedList pointers = new LinkedList();
        SpringModelVisitors.visitRecursionAwareRelatedModels(model, CommonSpringModelVisitorContext.context(Processors.cancelableCollectProcessor(pointers), (m, p) -> {
            if (m instanceof LocalXmlModel) {
                for (SpringBeanPointer<?> pointer : ((LocalXmlModel)m).getDescendantBeans(context)) {
                    if (p.process(pointer)) continue;
                    return false;
                }
            }
            return true;
        }));
        LinkedList linkedList = pointers;
        if (linkedList == null) {
            SpringModelVisitorUtils.$$$reportNull$$$0(14);
        }
        return linkedList;
    }

    @NotNull
    public static Set<String> getAllBeanNames(@NotNull CommonSpringModel model, @NotNull SpringBeanPointer<?> pointer) {
        String name;
        if (model == null) {
            SpringModelVisitorUtils.$$$reportNull$$$0(15);
        }
        if (pointer == null) {
            SpringModelVisitorUtils.$$$reportNull$$$0(16);
        }
        if (StringUtil.isEmptyOrSpaces((String)(name = pointer.getName()))) {
            Set<String> set = Collections.emptySet();
            if (set == null) {
                SpringModelVisitorUtils.$$$reportNull$$$0(17);
            }
            return set;
        }
        HashSet results = new HashSet();
        SpringModelVisitors.visitRelatedModels(model, CommonSpringModelVisitorContext.context(Processors.cancelableCollectProcessor(results), (m, p) -> {
            if (m instanceof CacheableCommonSpringModel) {
                for (String s : ((CacheableCommonSpringModel)m).getAllBeanNames(pointer)) {
                    if (p.process((Object)s)) continue;
                    return false;
                }
            }
            return true;
        }));
        Set<Object> set = !results.isEmpty() ? new HashSet(results) : Collections.singleton(name);
        if (set == null) {
            SpringModelVisitorUtils.$$$reportNull$$$0(18);
        }
        return set;
    }

    @NotNull
    public static Set<SpringBeanPointer<?>> findQualifiedBeans(@NotNull CommonSpringModel model, @NotNull SpringQualifier qualifier) {
        if (model == null) {
            SpringModelVisitorUtils.$$$reportNull$$$0(19);
        }
        if (qualifier == null) {
            SpringModelVisitorUtils.$$$reportNull$$$0(20);
        }
        LinkedHashSet pointers = new LinkedHashSet();
        SpringModelVisitors.visitRecursionAwareRelatedModels(model, CommonSpringModelVisitorContext.context(Processors.cancelableCollectProcessor(pointers), (m, p) -> {
            if (m instanceof CacheableCommonSpringModel) {
                for (SpringBeanPointer<?> pointer : ((CacheableCommonSpringModel)m).findQualified(qualifier)) {
                    if (p.process(pointer)) continue;
                    return false;
                }
            }
            return true;
        }));
        LinkedHashSet linkedHashSet = pointers;
        if (linkedHashSet == null) {
            SpringModelVisitorUtils.$$$reportNull$$$0(21);
        }
        return linkedHashSet;
    }

    @NotNull
    public static Set<PsiFile> getConfigFiles(@NotNull CommonSpringModel model) {
        if (model == null) {
            SpringModelVisitorUtils.$$$reportNull$$$0(22);
        }
        CommonProcessors.CollectProcessor processor2 = new CommonProcessors.CollectProcessor(new HashSet());
        SpringModelVisitorUtils.processConfigFiles(model, (Processor<? super PsiFile>)processor2);
        Set<PsiFile> set = Set.copyOf(processor2.getResults());
        if (set == null) {
            SpringModelVisitorUtils.$$$reportNull$$$0(23);
        }
        return set;
    }

    public static boolean hasConfigFile(@NotNull CommonSpringModel model, final @NotNull PsiFile configFile) {
        if (model == null) {
            SpringModelVisitorUtils.$$$reportNull$$$0(24);
        }
        if (configFile == null) {
            SpringModelVisitorUtils.$$$reportNull$$$0(25);
        }
        final VirtualFile virtualFile = configFile.getVirtualFile();
        CommonProcessors.FindFirstProcessor<PsiFile> findProcessor2 = new CommonProcessors.FindFirstProcessor<PsiFile>(){

            protected boolean accept(PsiFile file) {
                return Comparing.equal((Object)virtualFile, (Object)file.getVirtualFile()) || configFile.getManager().areElementsEquivalent((PsiElement)configFile, (PsiElement)file);
            }
        };
        SpringModelVisitorUtils.processConfigFiles(model, (Processor<? super PsiFile>)findProcessor2);
        return findProcessor2.isFound();
    }

    public static void processConfigFiles(@NotNull CommonSpringModel model, @NotNull Processor<? super PsiFile> processor2) {
        if (model == null) {
            SpringModelVisitorUtils.$$$reportNull$$$0(26);
        }
        if (processor2 == null) {
            SpringModelVisitorUtils.$$$reportNull$$$0(27);
        }
        SpringModelVisitors.visitRecursionAwareRelatedModels(model, CommonSpringModelVisitorContext.context(processor2, (m, p) -> {
            PsiFile file;
            return !(m instanceof LocalModel) || (file = ((LocalModel)m).getConfig().getContainingFile()) == null || p.process((Object)file);
        }), false);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 5, 7, 10, 14, 17, 18, 21, 23 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 10: 
            case 14: 
            case 17: 
            case 18: 
            case 21: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/SpringModelVisitorUtils";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pointer";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifier";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configFile";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/SpringModelVisitorUtils";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllDomBeans";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getPlaceholderConfigurers";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponentScans";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getAnnotationConfigApplicationContexts";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescendants";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllBeanNames";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "findQualifiedBeans";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getProfiles";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getAllDomBeans";
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 10: 
            case 14: 
            case 17: 
            case 18: 
            case 21: 
            case 23: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getLocalXmlModels";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getPlaceholderConfigurers";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getComponentScans";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "hasComponentScans";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getAnnotationConfigApplicationContexts";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getCustomBeanCandidates";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getDescendants";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getAllBeanNames";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "findQualifiedBeans";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getConfigFiles";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "hasConfigFile";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "processConfigFiles";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 5, 7, 10, 14, 17, 18, 21, 23 -> new IllegalStateException(string);
        };
    }
}

