/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.contexts.model;

import com.intellij.jam.JamService;
import com.intellij.jam.reflect.JamMemberMeta;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.SpringLocalModelFactory;
import com.intellij.spring.contexts.model.AnnotationSpringModel;
import com.intellij.spring.contexts.model.BeansSpringModel;
import com.intellij.spring.contexts.model.ComponentScanPackagesModel;
import com.intellij.spring.contexts.model.ComponentScannedApplicationContext;
import com.intellij.spring.contexts.model.LocalAnnotationModel;
import com.intellij.spring.facet.SpringFileSet;
import com.intellij.spring.model.jam.JamPsiClassSpringBean;
import com.intellij.spring.model.jam.stereotype.SpringComponent;
import com.intellij.spring.model.jam.stereotype.SpringConfiguration;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.model.utils.SpringProfileUtils;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AnnotationSpringModelImpl
extends AnnotationSpringModel {
    private final Set<SmartPsiElementPointer<? extends PsiClass>> myConfigClasses;

    public AnnotationSpringModelImpl(@NotNull Set<? extends PsiClass> classes, @NotNull Module module, @Nullable SpringFileSet fileSet) {
        if (classes == null) {
            AnnotationSpringModelImpl.$$$reportNull$$$0(0);
        }
        if (module == null) {
            AnnotationSpringModelImpl.$$$reportNull$$$0(1);
        }
        super(module, fileSet);
        this.myConfigClasses = classes.stream().filter(o -> o != null && o.isValid()).map(cl -> SmartPointerManager.getInstance((Project)module.getProject()).createSmartPsiElementPointer((PsiElement)cl)).collect(Collectors.toSet());
    }

    @Override
    @NotNull
    public Module getModule() {
        Module module = super.getModule();
        if (module == null) {
            AnnotationSpringModelImpl.$$$reportNull$$$0(2);
        }
        return module;
    }

    @Override
    @NotNull
    public Set<CommonSpringModel> getRelatedModels(boolean checkActiveProfiles) {
        Set<PsiPackage> packages;
        Set<LocalAnnotationModel> localAnnotationModels = this.getLocalAnnotationSpringModels(checkActiveProfiles);
        LinkedHashSet<CommonSpringModel> models = new LinkedHashSet<CommonSpringModel>(localAnnotationModels);
        LinkedHashSet<PsiClass> simpleBeans = new LinkedHashSet<PsiClass>();
        for (SmartPsiElementPointer<? extends PsiClass> psiElementPointer : this.myConfigClasses) {
            PsiClass configClass = (PsiClass)psiElementPointer.getElement();
            if (configClass == null || !configClass.isValid() || AnnotationSpringModelImpl.isConfiguration(configClass)) continue;
            simpleBeans.add(configClass);
        }
        if (!simpleBeans.isEmpty()) {
            models.add((LocalAnnotationModel)((Object)new BeansSpringModel(this.getModule(), simpleBeans)));
        }
        if (!(packages = this.getComponentScanPackages()).isEmpty()) {
            models.add(new ComponentScanPackagesModel((NotNullLazyValue<? extends Set<PsiPackage>>)NotNullLazyValue.lazy(() -> packages), this.getModule(), false));
        }
        models.addAll(this.getDependencies());
        LinkedHashSet<CommonSpringModel> linkedHashSet = models;
        if (linkedHashSet == null) {
            AnnotationSpringModelImpl.$$$reportNull$$$0(3);
        }
        return linkedHashSet;
    }

    @NotNull
    private Set<PsiPackage> getComponentScanPackages() {
        SpringFileSet set = this.getFileSet();
        if (!(set instanceof ComponentScannedApplicationContext)) {
            Set<PsiPackage> set2 = Collections.emptySet();
            if (set2 == null) {
                AnnotationSpringModelImpl.$$$reportNull$$$0(4);
            }
            return set2;
        }
        LinkedHashSet<PsiPackage> packages = new LinkedHashSet<PsiPackage>();
        for (String pkg : ((ComponentScannedApplicationContext)((Object)set)).getComponentScanPackages()) {
            PsiPackage psiPackage = JavaPsiFacade.getInstance((Project)this.getModule().getProject()).findPackage(pkg);
            ContainerUtil.addIfNotNull(packages, (Object)psiPackage);
        }
        LinkedHashSet<PsiPackage> linkedHashSet = packages;
        if (linkedHashSet == null) {
            AnnotationSpringModelImpl.$$$reportNull$$$0(5);
        }
        return linkedHashSet;
    }

    private Set<LocalAnnotationModel> getLocalAnnotationSpringModels(boolean checkActiveProfiles) {
        Set<String> activeProfiles = this.getActiveProfiles();
        LinkedHashSet<LocalAnnotationModel> models = new LinkedHashSet<LocalAnnotationModel>();
        for (SmartPsiElementPointer<? extends PsiClass> psiElementPointer : this.myConfigClasses) {
            Set<String> profiles;
            JamPsiClassSpringBean springConfiguration;
            PsiClass configClass = (PsiClass)psiElementPointer.getElement();
            if (configClass == null || !configClass.isValid() || (springConfiguration = (JamPsiClassSpringBean)ObjectUtils.chooseNotNull((Object)AnnotationSpringModelImpl.getConfiguration(configClass), (Object)AnnotationSpringModelImpl.getComponent(configClass))) != null && checkActiveProfiles && !SpringProfileUtils.isInActiveProfiles(springConfiguration, activeProfiles)) continue;
            Set<Object> set = profiles = activeProfiles == null || !checkActiveProfiles ? Collections.emptySet() : activeProfiles;
            LocalAnnotationModel model = SpringLocalModelFactory.getInstance().getOrCreateLocalAnnotationModel(configClass, this.getModule(), profiles);
            if (model == null) continue;
            models.add(model);
        }
        return models;
    }

    private static boolean isConfiguration(@NotNull PsiClass configClass) {
        if (configClass == null) {
            AnnotationSpringModelImpl.$$$reportNull$$$0(6);
        }
        return configClass.isValid() && SpringCommonUtils.isConfigurationOrMeta(configClass);
    }

    @Nullable
    private static SpringConfiguration getConfiguration(@NotNull PsiClass configClass) {
        if (configClass == null) {
            AnnotationSpringModelImpl.$$$reportNull$$$0(7);
        }
        return configClass.isValid() ? (SpringConfiguration)JamService.getJamService((Project)configClass.getProject()).getJamElement(SpringConfiguration.JAM_KEY, (PsiElement)configClass) : null;
    }

    @Nullable
    private static SpringComponent getComponent(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            AnnotationSpringModelImpl.$$$reportNull$$$0(8);
        }
        return (SpringComponent)JamService.getJamService((Project)psiClass.getProject()).getJamElement((PsiElement)psiClass, new JamMemberMeta[]{SpringComponent.META});
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classes";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/contexts/model/AnnotationSpringModelImpl";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configClass";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/contexts/model/AnnotationSpringModelImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getModule";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getRelatedModels";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponentScanPackages";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isConfiguration";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getConfiguration";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getComponent";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 5 -> new IllegalStateException(string);
        };
    }
}

