/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.diagrams.beans;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.diagram.DiagramDataModel;
import com.intellij.diagram.DiagramEdge;
import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.DiagramProvider;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.SuggestedNameInfo;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.xml.XmlFile;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.contexts.model.LocalXmlModel;
import com.intellij.spring.diagrams.beans.SpringDiagramEdgeCreationUtil;
import com.intellij.spring.diagrams.perspectives.SpringDiagramNode;
import com.intellij.spring.diagrams.perspectives.beans.SpringBeanPointerWrapper;
import com.intellij.spring.diagrams.perspectives.beans.SpringElementWrapper;
import com.intellij.spring.diagrams.perspectives.beans.UserDefinedClassWrapper;
import com.intellij.spring.model.BeanService;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.utils.SpringModelSearchers;
import com.intellij.spring.model.xml.beans.Beans;
import com.intellij.spring.model.xml.beans.SpringBean;
import com.intellij.util.xml.DomFileElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SpringDiagramBeansProcessingModel
extends DiagramDataModel<SpringElementWrapper<?>> {
    private final Collection<DiagramNode<SpringElementWrapper<?>>> myNodes = new LinkedHashSet();
    private final Collection<DiagramEdge<SpringElementWrapper<?>>> myEdges = new LinkedHashSet();
    private Collection<DiagramNode<SpringElementWrapper<?>>> myNodesToRebuild;

    public SpringDiagramBeansProcessingModel(Project project, DiagramProvider<SpringElementWrapper<?>> springBaseBeanPointerDiagramProvider) {
        super(project, springBaseBeanPointerDiagramProvider);
    }

    @NotNull
    public Collection<DiagramNode<SpringElementWrapper<?>>> getNodes() {
        Collection<DiagramNode<SpringElementWrapper<?>>> collection = this.myNodes;
        if (collection == null) {
            SpringDiagramBeansProcessingModel.$$$reportNull$$$0(0);
        }
        return collection;
    }

    @NotNull
    public Collection<DiagramEdge<SpringElementWrapper<?>>> getEdges() {
        Collection<DiagramEdge<SpringElementWrapper<?>>> collection = this.myEdges;
        if (collection == null) {
            SpringDiagramBeansProcessingModel.$$$reportNull$$$0(1);
        }
        return collection;
    }

    public long getModificationCount() {
        return super.getModificationCount() + PsiManager.getInstance((Project)this.getProject()).getModificationTracker().getModificationCount();
    }

    public DiagramEdge<SpringElementWrapper<?>> createEdge(@NotNull DiagramNode<SpringElementWrapper<?>> from, @NotNull DiagramNode<SpringElementWrapper<?>> to) {
        DiagramEdge<SpringElementWrapper<?>> edge;
        if (from == null) {
            SpringDiagramBeansProcessingModel.$$$reportNull$$$0(2);
        }
        if (to == null) {
            SpringDiagramBeansProcessingModel.$$$reportNull$$$0(3);
        }
        if ((edge = SpringDiagramEdgeCreationUtil.createEdge(from, to, this.myEdges, this.getBuilder(), this.getActualModel())) != null) {
            this.myEdges.add(edge);
        }
        return edge;
    }

    public void removeNode(@NotNull DiagramNode<SpringElementWrapper<?>> node) {
        if (node == null) {
            SpringDiagramBeansProcessingModel.$$$reportNull$$$0(4);
        }
        ArrayList edges = new ArrayList();
        for (DiagramEdge<SpringElementWrapper<?>> edge : this.myEdges) {
            if (!edge.getTarget().equals(node) && !edge.getSource().equals(node)) continue;
            edges.add(edge);
        }
        this.myEdges.removeAll(edges);
        this.myNodes.remove(node);
    }

    protected abstract CommonSpringModel getActualModel();

    protected void clearAll() {
        this.myEdges.clear();
        this.myNodes.clear();
    }

    public void rebuild(SpringElementWrapper<?> element) {
        this.myNodesToRebuild = new HashSet();
    }

    public void refreshDataModel() {
        if (this.myNodesToRebuild != null) {
            this.myNodes.retainAll(this.myNodesToRebuild);
            this.myNodesToRebuild = null;
        }
    }

    @Nullable
    public DiagramNode<SpringElementWrapper<?>> addElement(@Nullable SpringElementWrapper element) {
        if (element instanceof UserDefinedClassWrapper) {
            LocalXmlModel localXmlModel;
            DomFileElement<Beans> root;
            PsiClass wrapped = (PsiClass)((UserDefinedClassWrapper)element).getWrapped();
            CommonSpringModel model = this.getActualModel();
            if (model instanceof LocalXmlModel && (root = (localXmlModel = (LocalXmlModel)model).getRoot()) != null) {
                if (!FileModificationService.getInstance().preparePsiElementsForWrite(new PsiElement[]{localXmlModel.getConfig()})) {
                    return null;
                }
                Beans beans = (Beans)root.getRootElement();
                SpringBean springBean = beans.addBean();
                springBean.getClazz().setStringValue(wrapped.getQualifiedName());
                Project project = wrapped.getProject();
                JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)project);
                SuggestedNameInfo info = codeStyleManager.suggestVariableName(VariableKind.FIELD, null, null, (PsiType)PsiTypesUtil.getClassType((PsiClass)wrapped));
                for (String beanName : info.names) {
                    if (SpringModelSearchers.findBean(model, beanName) != null) continue;
                    springBean.getId().setStringValue(beanName);
                }
                SpringBean stableCopy = (SpringBean)springBean.createStableCopy();
                PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)this.getProject());
                Document document = psiDocumentManager.getDocument(((XmlFile)localXmlModel.getConfig()).getContainingFile());
                if (document != null) {
                    psiDocumentManager.doPostponedOperationsAndUnblockDocument(document);
                }
                SpringBeanPointer<?> pointer = BeanService.getInstance().createSpringBeanPointer(stableCopy);
                return this.addNode(SpringBeanPointerWrapper.create(pointer, model));
            }
        }
        return element != null ? this.addNode(element) : null;
    }

    private DiagramNode<SpringElementWrapper<?>> addNode(@NotNull SpringElementWrapper<?> beanPointerWrapper) {
        SpringDiagramNode node;
        if (beanPointerWrapper == null) {
            SpringDiagramBeansProcessingModel.$$$reportNull$$$0(5);
        }
        if (!this.myNodes.contains((Object)(node = new SpringDiagramNode(beanPointerWrapper, this.getProvider())))) {
            this.myNodes.add((DiagramNode<SpringElementWrapper<?>>)node);
        }
        if (this.myNodesToRebuild != null) {
            this.myNodesToRebuild.add((DiagramNode<SpringElementWrapper<?>>)node);
        }
        return node;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 4, 5 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/diagrams/beans/SpringDiagramBeansProcessingModel";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "beanPointerWrapper";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodes";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getEdges";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/diagrams/beans/SpringDiagramBeansProcessingModel";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createEdge";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "removeNode";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addNode";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 4, 5 -> new IllegalArgumentException(string);
        };
    }
}

