/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.diagrams.beans;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.diagram.DiagramEdge;
import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.DiagramProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.semantic.SemService;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.diagrams.beans.edges.ByConstructorAutowire;
import com.intellij.spring.diagrams.beans.edges.ByNameAutowire;
import com.intellij.spring.diagrams.beans.edges.ByTypeAutowire;
import com.intellij.spring.diagrams.beans.edges.DependsOnEdge;
import com.intellij.spring.diagrams.beans.edges.FactoryBeanEdge;
import com.intellij.spring.diagrams.beans.edges.ImportedBeanEdge;
import com.intellij.spring.diagrams.beans.edges.InjectionEdge;
import com.intellij.spring.diagrams.beans.edges.JavaBeanEdge;
import com.intellij.spring.diagrams.beans.edges.LookupMethodEdge;
import com.intellij.spring.diagrams.beans.edges.ParentBeanEdge;
import com.intellij.spring.diagrams.beans.edges.ScannedBeanEdge;
import com.intellij.spring.diagrams.perspectives.SpringDependencyType;
import com.intellij.spring.diagrams.perspectives.SpringDiagramEdge;
import com.intellij.spring.diagrams.perspectives.SpringDiagramNode;
import com.intellij.spring.diagrams.perspectives.beans.SpringBeanPointerWrapper;
import com.intellij.spring.diagrams.perspectives.beans.SpringElementWrapper;
import com.intellij.spring.model.BeanService;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.DelegateConditionalSpringBeanPointer;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.SpringModelSearchParameters;
import com.intellij.spring.model.jam.JamSpringBeanPointer;
import com.intellij.spring.model.jam.javaConfig.SpringJavaBean;
import com.intellij.spring.model.jam.stereotype.SpringImport;
import com.intellij.spring.model.jam.stereotype.SpringStereotypeElement;
import com.intellij.spring.model.jam.utils.SpringJamUtils;
import com.intellij.spring.model.utils.SpringAutowireUtil;
import com.intellij.spring.model.utils.SpringAutowireUtils;
import com.intellij.spring.model.utils.SpringModelSearchers;
import com.intellij.spring.model.utils.SpringPropertyUtils;
import com.intellij.spring.model.xml.DomSpringBean;
import com.intellij.spring.model.xml.beans.CollectionElements;
import com.intellij.spring.model.xml.beans.LookupMethod;
import com.intellij.spring.model.xml.beans.SpringBean;
import com.intellij.spring.model.xml.beans.SpringValueHolderDefinition;
import com.intellij.spring.model.xml.context.SpringBeansPackagesScan;
import com.intellij.spring.model.xml.context.SpringBeansPackagesScanBean;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomElementVisitor;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.util.xml.GenericDomValue;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringDiagramDataModelUpdater {
    private static final Key<Boolean> PROCESSED_KEY = Key.create((String)"PROCESSED_KEY");
    private final CommonSpringModel myModel;
    private final DiagramProvider<SpringElementWrapper<?>> myProvider;
    private final boolean myIncludeLibraries;
    private final Collection<DiagramNode<SpringElementWrapper<?>>> myNodes;
    private final Collection<DiagramEdge<SpringElementWrapper<?>>> myEdges;
    private final Set<SpringBeanPointer<?>> myPointers;

    public SpringDiagramDataModelUpdater(@NotNull CommonSpringModel model, @NotNull DiagramProvider<SpringElementWrapper<?>> provider, boolean includeLibraries) {
        if (model == null) {
            SpringDiagramDataModelUpdater.$$$reportNull$$$0(0);
        }
        if (provider == null) {
            SpringDiagramDataModelUpdater.$$$reportNull$$$0(1);
        }
        this.myNodes = new LinkedHashSet();
        this.myEdges = new LinkedHashSet();
        this.myPointers = new LinkedHashSet();
        this.myModel = model;
        this.myProvider = provider;
        this.myIncludeLibraries = includeLibraries;
    }

    public CommonSpringModel getModel() {
        return this.myModel;
    }

    @NotNull
    public Collection<DiagramNode<SpringElementWrapper<?>>> getNodes() {
        Collection<DiagramNode<SpringElementWrapper<?>>> collection = this.myNodes;
        if (collection == null) {
            SpringDiagramDataModelUpdater.$$$reportNull$$$0(2);
        }
        return collection;
    }

    @NotNull
    public Collection<DiagramEdge<SpringElementWrapper<?>>> getEdges() {
        Collection<DiagramEdge<SpringElementWrapper<?>>> collection = this.myEdges;
        if (collection == null) {
            SpringDiagramDataModelUpdater.$$$reportNull$$$0(3);
        }
        return collection;
    }

    public void performUpdate() {
        Collection<SpringBeanPointer<?>> pointers = this.myModel.getAllCommonBeans(this.myIncludeLibraries);
        for (JamSpringBeanPointer jamSpringBeanPointer : pointers) {
            JamSpringBeanPointer jamSpringBeanPointer2;
            if (jamSpringBeanPointer instanceof DelegateConditionalSpringBeanPointer) {
                DelegateConditionalSpringBeanPointer conditionalPointer = (DelegateConditionalSpringBeanPointer)jamSpringBeanPointer;
                jamSpringBeanPointer2 = conditionalPointer.getDelegate();
            } else {
                jamSpringBeanPointer2 = jamSpringBeanPointer;
            }
            this.myPointers.add(jamSpringBeanPointer2);
        }
        for (SpringBeanPointer<?> springBeanPointer : this.myPointers) {
            DiagramNode<SpringElementWrapper<?>> sourceNode = this.getOrCreateElement(springBeanPointer);
            this.processDependencies(springBeanPointer, sourceNode);
        }
    }

    private void processDependencies(@NotNull SpringBeanPointer<?> pointer, @NotNull DiagramNode<SpringElementWrapper<?>> node) {
        if (pointer == null) {
            SpringDiagramDataModelUpdater.$$$reportNull$$$0(4);
        }
        if (node == null) {
            SpringDiagramDataModelUpdater.$$$reportNull$$$0(5);
        }
        if (SpringDiagramDataModelUpdater.isProcessed(node)) {
            return;
        }
        SpringDiagramDataModelUpdater.setProcessed(node);
        Object springBean = pointer.getSpringBean();
        if (!springBean.isValid()) {
            return;
        }
        this.processXmlBeanDependencies(pointer, node, (CommonSpringBean)springBean);
        this.processStereotypeElementDependencies(node, (CommonSpringBean)springBean);
        this.addAutowiredDependencies(node, (CommonSpringBean)springBean);
    }

    @NotNull
    private DiagramNode<SpringElementWrapper<?>> getOrCreateElement(@NotNull SpringBeanPointer<?> beanPointer) {
        DiagramNode<SpringElementWrapper<?>> target;
        if (beanPointer == null) {
            SpringDiagramDataModelUpdater.$$$reportNull$$$0(6);
        }
        if ((target = this.getNode(beanPointer)) == null) {
            target = this.addNode(beanPointer);
        }
        DiagramNode<SpringElementWrapper<?>> diagramNode = target;
        if (diagramNode == null) {
            SpringDiagramDataModelUpdater.$$$reportNull$$$0(7);
        }
        return diagramNode;
    }

    private void processStereotypeElementDependencies(@NotNull DiagramNode<SpringElementWrapper<?>> node, @NotNull CommonSpringBean springBean) {
        if (node == null) {
            SpringDiagramDataModelUpdater.$$$reportNull$$$0(8);
        }
        if (springBean == null) {
            SpringDiagramDataModelUpdater.$$$reportNull$$$0(9);
        }
        if (springBean instanceof SpringStereotypeElement) {
            SpringStereotypeElement stereotypeElement = (SpringStereotypeElement)springBean;
            this.addJavaImportedDependencies(node, stereotypeElement);
            this.addJavaComponentScans(node, stereotypeElement);
            this.addJavaBeans(node, stereotypeElement);
        }
    }

    private void processXmlBeanDependencies(@NotNull SpringBeanPointer<?> pointer, @NotNull DiagramNode<SpringElementWrapper<?>> node, @NotNull CommonSpringBean springBean) {
        if (pointer == null) {
            SpringDiagramDataModelUpdater.$$$reportNull$$$0(10);
        }
        if (node == null) {
            SpringDiagramDataModelUpdater.$$$reportNull$$$0(11);
        }
        if (springBean == null) {
            SpringDiagramDataModelUpdater.$$$reportNull$$$0(12);
        }
        if (springBean instanceof SpringBean) {
            this.addSpringBeanDependencies(node, (SpringBean)springBean);
        } else if (springBean instanceof CollectionElements) {
            this.addCollectionElements(node, pointer);
        } else if (springBean instanceof SpringBeansPackagesScanBean) {
            Module module = this.myModel.getModule();
            if (module != null) {
                for (CommonSpringBean bean : ((SpringBeansPackagesScanBean)springBean).getScannedElements(module)) {
                    this.addScannedBeanNode(node, bean);
                }
            }
        } else if (springBean instanceof DomSpringBean) {
            this.addPointedDependencies(node, pointer);
        }
    }

    @Nullable
    private DiagramNode<SpringElementWrapper<?>> getNode(@NotNull SpringBeanPointer<?> beanPointer) {
        if (beanPointer == null) {
            SpringDiagramDataModelUpdater.$$$reportNull$$$0(13);
        }
        for (DiagramNode<SpringElementWrapper<?>> node : this.myNodes) {
            if (!beanPointer.equals(((SpringElementWrapper)node.getIdentifyingElement()).getWrapped())) continue;
            return node;
        }
        return null;
    }

    @NotNull
    private DiagramNode<SpringElementWrapper<?>> addNode(@NotNull SpringBeanPointer<?> beanPointer) {
        SpringBeanPointerWrapper wrapper;
        SpringDiagramNode node;
        if (beanPointer == null) {
            SpringDiagramDataModelUpdater.$$$reportNull$$$0(14);
        }
        if (!this.myNodes.contains((Object)(node = new SpringDiagramNode(wrapper = SpringBeanPointerWrapper.create(beanPointer, this.myModel), this.myProvider)))) {
            this.myNodes.add((DiagramNode<SpringElementWrapper<?>>)node);
        }
        SpringDiagramNode springDiagramNode = node;
        if (springDiagramNode == null) {
            SpringDiagramDataModelUpdater.$$$reportNull$$$0(15);
        }
        return springDiagramNode;
    }

    private void addCollectionElements(DiagramNode<SpringElementWrapper<?>> sourceNode, SpringBeanPointer<?> pointer) {
        Object springBean = pointer.getSpringBean();
        if (springBean instanceof CollectionElements) {
            LinkedHashMap beans = new LinkedHashMap();
            SpringPropertyUtils.addCollectionReferences((CollectionElements)springBean, beans);
            this.handleBeanMap(sourceNode, beans);
        }
    }

    private void addSpringBeanDependencies(@NotNull DiagramNode<SpringElementWrapper<?>> sourceNode, @NotNull SpringBean bean) {
        if (sourceNode == null) {
            SpringDiagramDataModelUpdater.$$$reportNull$$$0(16);
        }
        if (bean == null) {
            SpringDiagramDataModelUpdater.$$$reportNull$$$0(17);
        }
        this.addXmlBeanInjectedDependencies(sourceNode, bean);
        this.addXmlBeanLookupMethodInjectedDependencies(sourceNode, bean);
        this.addXmlBeanFactoryBeanDependencies(sourceNode, bean);
        this.addXmlBeanParentBeanDependencies(sourceNode, bean);
        this.addXmlBeanDependsOnDependencies(sourceNode, bean);
        this.addXmlBeanAutowiredDependencies(sourceNode, bean);
    }

    private void addJavaImportedDependencies(@NotNull DiagramNode<SpringElementWrapper<?>> node, @NotNull SpringStereotypeElement commonSpringBean) {
        if (node == null) {
            SpringDiagramDataModelUpdater.$$$reportNull$$$0(18);
        }
        if (commonSpringBean == null) {
            SpringDiagramDataModelUpdater.$$$reportNull$$$0(19);
        }
        PsiClass psiClass = commonSpringBean.getPsiElement();
        List springImports = SemService.getSemService((Project)psiClass.getProject()).getSemElements(SpringImport.IMPORT_JAM_KEY, (PsiElement)psiClass);
        for (SpringImport springImport : springImports) {
            for (PsiClass aClass : springImport.getImportedClasses()) {
                List<SpringBeanPointer<?>> importedBeans = SpringModelSearchers.findBeans(this.myModel, SpringModelSearchParameters.byClass(aClass));
                if (importedBeans.size() != 1) continue;
                SpringBeanPointer<?> targetPointer = importedBeans.get(0);
                DiagramNode<SpringElementWrapper<?>> targetNode = this.getNode(targetPointer);
                if (targetNode == null) {
                    targetNode = this.addNode(targetPointer);
                }
                this.processDependencies(targetPointer, targetNode);
                this.addEdge(new ImportedBeanEdge(node, targetNode, SpringDiagramDataModelUpdater.getShortAnnotationName(springImport.getAnnotation())));
            }
        }
    }

    @Nullable
    private static String getShortAnnotationName(@Nullable PsiAnnotation annotation) {
        if (annotation != null) {
            String qualifiedName = annotation.getQualifiedName();
            return qualifiedName == null ? null : "@" + StringUtil.getShortName((String)qualifiedName);
        }
        return null;
    }

    private void addJavaComponentScans(@NotNull DiagramNode<SpringElementWrapper<?>> node, @NotNull SpringStereotypeElement commonSpringBean) {
        Module module;
        if (node == null) {
            SpringDiagramDataModelUpdater.$$$reportNull$$$0(20);
        }
        if (commonSpringBean == null) {
            SpringDiagramDataModelUpdater.$$$reportNull$$$0(21);
        }
        if ((module = this.myModel.getModule()) == null) {
            return;
        }
        PsiClass psiClass = commonSpringBean.getPsiElement();
        List<? extends SpringBeansPackagesScan> scans = SpringJamUtils.getInstance().getBeansPackagesScan(psiClass);
        for (SpringBeansPackagesScan springBeansPackagesScan : scans) {
            Set<CommonSpringBean> scannedElements = springBeansPackagesScan.getScannedElements(module);
            for (CommonSpringBean springBean : scannedElements) {
                this.addScannedBeanNode(node, springBean);
            }
        }
    }

    private void addJavaBeans(@NotNull DiagramNode<SpringElementWrapper<?>> node, @NotNull SpringStereotypeElement stereotypeElement) {
        if (node == null) {
            SpringDiagramDataModelUpdater.$$$reportNull$$$0(22);
        }
        if (stereotypeElement == null) {
            SpringDiagramDataModelUpdater.$$$reportNull$$$0(23);
        }
        for (SpringJavaBean springJavaBean : stereotypeElement.getBeans()) {
            SpringBeanPointer<?> targetPointer = BeanService.getInstance().createSpringBeanPointer(springJavaBean);
            DiagramNode<SpringElementWrapper<?>> targetNode = this.getNode(targetPointer);
            if (targetNode == null) {
                targetNode = this.addNode(targetPointer);
            }
            this.addEdge(new JavaBeanEdge(node, targetNode));
        }
    }

    private void addScannedBeanNode(DiagramNode<SpringElementWrapper<?>> node, CommonSpringBean bean) {
        SpringBeanPointer<?> targetPointer = BeanService.getInstance().createSpringBeanPointer(bean);
        DiagramNode<SpringElementWrapper<?>> targetNode = this.getNode(targetPointer);
        if (targetNode == null) {
            targetNode = this.addNode(targetPointer);
        }
        this.processDependencies(targetPointer, targetNode);
        this.addEdge(new ScannedBeanEdge(node, targetNode));
    }

    private void addPointedDependencies(final DiagramNode<SpringElementWrapper<?>> sourceNode, SpringBeanPointer<?> springBeanPointer) {
        Object springBean = springBeanPointer.getSpringBean();
        if (SpringDiagramDataModelUpdater.isCustomSchemaBean(springBean)) {
            ((DomSpringBean)springBean).acceptChildren(new DomElementVisitor(){

                public void visitDomElement(DomElement element) {
                    if (element instanceof SpringBean && DomUtil.hasXml((DomElement)element)) {
                        SpringBeanPointer<?> pointer = BeanService.getInstance().createSpringBeanPointer((SpringBean)element);
                        DiagramNode<SpringElementWrapper<?>> targetNode = SpringDiagramDataModelUpdater.this.getNode(pointer);
                        if (targetNode == null) {
                            targetNode = SpringDiagramDataModelUpdater.this.addNode(pointer);
                        }
                        SpringDiagramDataModelUpdater.this.processDependencies(pointer, targetNode);
                        SpringDiagramDataModelUpdater.this.addEdge(new InjectionEdge(sourceNode, targetNode, element));
                    } else if (element instanceof GenericAttributeValue && DomUtil.hasXml((DomElement)element)) {
                        Object pointer = ((GenericDomValue)element).getValue();
                        if (pointer instanceof SpringBeanPointer) {
                            SpringBeanPointer beanPointer = (SpringBeanPointer)pointer;
                            DiagramNode<SpringElementWrapper<?>> target = SpringDiagramDataModelUpdater.this.getOrCreateElement(beanPointer);
                            XmlAttribute xmlAttribute = ((GenericAttributeValue)element).getXmlAttribute();
                            String attrName = xmlAttribute != null ? xmlAttribute.getLocalName() : null;
                            SpringDiagramDataModelUpdater.this.addEdge(new InjectionEdge(sourceNode, target, element, attrName));
                        }
                    } else if (element instanceof SpringValueHolderDefinition) {
                        SpringDiagramDataModelUpdater.this.addSpringValueHolderDependencies(sourceNode, (SpringValueHolderDefinition)element);
                    } else {
                        List children = DomUtil.getDefinedChildren((DomElement)element, (boolean)true, (boolean)true);
                        for (DomElement child : children) {
                            child.accept((DomElementVisitor)this);
                        }
                    }
                }
            });
        }
    }

    private void addEdge(@Nullable DiagramNode<SpringElementWrapper<?>> source, @Nullable DiagramNode<SpringElementWrapper<?>> target, @NotNull SpringDependencyType info) {
        if (info == null) {
            SpringDiagramDataModelUpdater.$$$reportNull$$$0(24);
        }
        if (source != null && target != null) {
            this.addEdge(new SpringDiagramEdge(source, target, info, null));
        }
    }

    private void addEdge(SpringDiagramEdge edge) {
        if (!this.myEdges.contains((Object)edge)) {
            this.myEdges.add((DiagramEdge<SpringElementWrapper<?>>)edge);
        }
    }

    private static boolean isCustomSchemaBean(CommonSpringBean springBean) {
        return springBean instanceof DomSpringBean && !(springBean instanceof SpringBean);
    }

    private void addXmlBeanAutowiredDependencies(@NotNull DiagramNode<SpringElementWrapper<?>> sourceNode, SpringBean springBean) {
        if (sourceNode == null) {
            SpringDiagramDataModelUpdater.$$$reportNull$$$0(25);
        }
        if (SpringAutowireUtil.isByTypeAutowired(springBean)) {
            this.addXmlByTypeAutowireDependencies(sourceNode, springBean);
        } else if (SpringAutowireUtil.isByNameAutowired(springBean)) {
            this.addXmlByNameAutowireDependencies(sourceNode, springBean);
        } else if (SpringAutowireUtil.isConstructorAutowire(springBean)) {
            this.addXmlConstructorAutowireDependencies(sourceNode, springBean);
        }
    }

    private void addAutowiredDependencies(@NotNull DiagramNode<SpringElementWrapper<?>> sourceNode, CommonSpringBean commonSpringBean) {
        PsiMethod[] constructors;
        if (sourceNode == null) {
            SpringDiagramDataModelUpdater.$$$reportNull$$$0(26);
        }
        Map<PsiMember, Set<SpringBeanPointer<?>>> map = SpringAutowireUtils.getInstance().getAutowireAnnotationProperties(commonSpringBean, this.myModel);
        HashSet<PsiMember> annotated = new HashSet<PsiMember>();
        for (Map.Entry<PsiMember, Set<SpringBeanPointer<?>>> entry : map.entrySet()) {
            PsiMember member = entry.getKey();
            annotated.add(member);
            Set<SpringBeanPointer<?>> springBeans = entry.getValue();
            for (SpringBeanPointer<?> bean : springBeans) {
                DiagramNode<SpringElementWrapper<?>> targetNode = this.getOrCreateElement(bean);
                this.addEdge(sourceNode, targetNode, SpringDiagramDataModelUpdater.getAnnotatedAutowireType(member));
            }
        }
        if (commonSpringBean instanceof SpringBean) {
            return;
        }
        PsiClass beanClass = PsiTypesUtil.getPsiClass((PsiType)commonSpringBean.getBeanType());
        if (beanClass == null) {
            return;
        }
        for (PsiMethod constructor : constructors = beanClass.getConstructors()) {
            if (annotated.remove(constructor)) continue;
            for (PsiParameter parameter : constructor.getParameterList().getParameters()) {
                Set<SpringBeanPointer<?>> pointers = SpringAutowireUtil.getAutowiredBeansFor((PsiModifierListOwner)parameter, SpringAutowireUtil.getAutowiredType(parameter.getType()), this.getModel());
                for (SpringBeanPointer<?> pointer : pointers) {
                    this.addEdge(sourceNode, this.getOrCreateElement(pointer), SpringDependencyType.CONSTRUCTOR_INJECTION);
                }
            }
        }
    }

    private static SpringDependencyType getAnnotatedAutowireType(PsiMember member) {
        if (AnnotationUtil.isAnnotated((PsiModifierListOwner)member, Arrays.asList("javax.annotation.Resource", "jakarta.annotation.Resource"), (int)0)) {
            return SpringDependencyType.ANNO_RESOURCE_AUTOWIRED;
        }
        if (AnnotationUtil.isAnnotated((PsiModifierListOwner)member, Arrays.asList("javax.inject.Inject", "jakarta.inject.Inject"), (int)0)) {
            return SpringDependencyType.ANNO_INJECT_AUTOWIRED;
        }
        return SpringDependencyType.ANNO_AUTOWIRED;
    }

    private void addXmlConstructorAutowireDependencies(DiagramNode<SpringElementWrapper<?>> sourceNode, @NotNull SpringBean springBean) {
        if (springBean == null) {
            SpringDiagramDataModelUpdater.$$$reportNull$$$0(27);
        }
        Map<PsiType, Collection<SpringBeanPointer<?>>> autowiredProperties = SpringAutowireUtil.getConstructorAutowiredProperties(springBean, this.myModel);
        for (Collection<SpringBeanPointer<?>> springBeans : autowiredProperties.values()) {
            for (SpringBeanPointer<?> bean : springBeans) {
                DiagramNode<SpringElementWrapper<?>> targetNode = this.getOrCreateElement(bean);
                this.addEdge(new ByConstructorAutowire(sourceNode, targetNode));
            }
        }
    }

    private void addXmlByNameAutowireDependencies(@NotNull DiagramNode<SpringElementWrapper<?>> sourceNode, SpringBean springBean) {
        if (sourceNode == null) {
            SpringDiagramDataModelUpdater.$$$reportNull$$$0(28);
        }
        Map<PsiMethod, SpringBeanPointer<?>> autowiredProperties = SpringAutowireUtil.getByNameAutowiredProperties(springBean);
        for (SpringBeanPointer<?> bean : autowiredProperties.values()) {
            if (bean == null) continue;
            DiagramNode<SpringElementWrapper<?>> targetNode = this.getOrCreateElement(bean);
            this.addEdge(new ByNameAutowire(sourceNode, targetNode));
        }
    }

    private void addXmlByTypeAutowireDependencies(@NotNull DiagramNode<SpringElementWrapper<?>> sourceNode, SpringBean springBean) {
        if (sourceNode == null) {
            SpringDiagramDataModelUpdater.$$$reportNull$$$0(29);
        }
        Map<PsiMethod, Collection<SpringBeanPointer<?>>> autowiredProperties = SpringAutowireUtil.getByTypeAutowiredProperties(springBean, this.myModel);
        for (Collection<SpringBeanPointer<?>> springBeans : autowiredProperties.values()) {
            for (SpringBeanPointer<?> bean : springBeans) {
                DiagramNode<SpringElementWrapper<?>> targetNode = this.getOrCreateElement(bean);
                this.addEdge(new ByTypeAutowire(sourceNode, targetNode));
            }
        }
    }

    private void addXmlBeanParentBeanDependencies(@NotNull DiagramNode<SpringElementWrapper<?>> sourceNode, @NotNull SpringBean springBean) {
        GenericAttributeValue<SpringBeanPointer<?>> parentBean;
        SpringBeanPointer parentBeanValue;
        if (sourceNode == null) {
            SpringDiagramDataModelUpdater.$$$reportNull$$$0(30);
        }
        if (springBean == null) {
            SpringDiagramDataModelUpdater.$$$reportNull$$$0(31);
        }
        if ((parentBeanValue = (SpringBeanPointer)(parentBean = springBean.getParentBean()).getValue()) == null) {
            return;
        }
        SpringBeanPointer<?> parentBeanPointer = parentBeanValue.getBasePointer();
        if (this.myPointers.contains(parentBeanPointer)) {
            DiagramNode<SpringElementWrapper<?>> targetNode = this.getOrCreateElement(parentBeanPointer);
            this.addEdge(new ParentBeanEdge(sourceNode, targetNode, (DomElement)parentBean));
        }
    }

    private void addXmlBeanDependsOnDependencies(@NotNull DiagramNode<SpringElementWrapper<?>> sourceNode, SpringBean bean) {
        GenericAttributeValue<List<SpringBeanPointer<?>>> dependsOn;
        List dependsOnBeanPointer;
        if (sourceNode == null) {
            SpringDiagramDataModelUpdater.$$$reportNull$$$0(32);
        }
        if ((dependsOnBeanPointer = (List)(dependsOn = bean.getDependsOn()).getValue()) != null) {
            for (SpringBeanPointer dependsOnBean : dependsOnBeanPointer) {
                if (dependsOnBean == null) continue;
                SpringBeanPointer<?> pointer = dependsOnBean.getBasePointer();
                DiagramNode<SpringElementWrapper<?>> targetNode = this.getOrCreateElement(pointer);
                this.addEdge(new DependsOnEdge(sourceNode, targetNode, (DomElement)dependsOn));
            }
        }
    }

    private void addXmlBeanFactoryBeanDependencies(@NotNull DiagramNode<SpringElementWrapper<?>> node, SpringBean springBean) {
        GenericAttributeValue<SpringBeanPointer<?>> factoryBean;
        SpringBeanPointer factoryBeanValue;
        if (node == null) {
            SpringDiagramDataModelUpdater.$$$reportNull$$$0(33);
        }
        if ((factoryBeanValue = (SpringBeanPointer)(factoryBean = springBean.getFactoryBean()).getValue()) == null) {
            return;
        }
        SpringBeanPointer<?> factoryBeanPointer = factoryBeanValue.getBasePointer();
        if (this.myPointers.contains(factoryBeanPointer)) {
            DiagramNode<SpringElementWrapper<?>> source = this.getOrCreateElement(factoryBeanPointer);
            this.addEdge(new FactoryBeanEdge(source, node, (DomElement)factoryBean));
        }
    }

    private void addXmlBeanInjectedDependencies(@NotNull DiagramNode<SpringElementWrapper<?>> sourceNode, SpringBean springBean) {
        if (sourceNode == null) {
            SpringDiagramDataModelUpdater.$$$reportNull$$$0(34);
        }
        for (SpringValueHolderDefinition valueHolderDefinition : SpringPropertyUtils.getValueHolders(springBean)) {
            this.addSpringValueHolderDependencies(sourceNode, valueHolderDefinition);
        }
    }

    private void addSpringValueHolderDependencies(DiagramNode<SpringElementWrapper<?>> sourceNode, SpringValueHolderDefinition valueHolderDefinition) {
        this.handleBeanMap(sourceNode, SpringPropertyUtils.getValueHolderDependencies(valueHolderDefinition));
    }

    private void handleBeanMap(DiagramNode<SpringElementWrapper<?>> sourceNode, Map<SpringBeanPointer<?>, DomElement> beanMap) {
        for (Map.Entry<SpringBeanPointer<?>, DomElement> entry : beanMap.entrySet()) {
            SpringBeanPointer<?> bean = entry.getKey();
            DomElement identifyingElement = entry.getValue();
            if (!SpringDiagramDataModelUpdater.modelBeansContain(this.myPointers, bean)) continue;
            DiagramNode<SpringElementWrapper<?>> targetNode = this.getNode(bean);
            if (targetNode == null) {
                targetNode = this.addNode(bean);
            }
            this.processDependencies(bean, targetNode);
            this.addEdge(new InjectionEdge(sourceNode, targetNode, identifyingElement));
        }
    }

    private void addXmlBeanLookupMethodInjectedDependencies(@NotNull DiagramNode<SpringElementWrapper<?>> sourceNode, @NotNull SpringBean springBean) {
        if (sourceNode == null) {
            SpringDiagramDataModelUpdater.$$$reportNull$$$0(35);
        }
        if (springBean == null) {
            SpringDiagramDataModelUpdater.$$$reportNull$$$0(36);
        }
        for (LookupMethod method : springBean.getLookupMethods()) {
            SpringBeanPointer<?> pointer;
            GenericAttributeValue<SpringBeanPointer<?>> bean = method.getBean();
            SpringBeanPointer beanValue = (SpringBeanPointer)bean.getValue();
            if (beanValue == null || !this.myPointers.contains(pointer = beanValue.getBasePointer())) continue;
            DiagramNode<SpringElementWrapper<?>> targetNode = this.getOrCreateElement(pointer);
            this.addEdge(new LookupMethodEdge(sourceNode, targetNode, (DomElement)bean));
        }
    }

    private static void setProcessed(@NotNull DiagramNode<SpringElementWrapper<?>> targetNode) {
        if (targetNode == null) {
            SpringDiagramDataModelUpdater.$$$reportNull$$$0(37);
        }
        targetNode.putUserData(PROCESSED_KEY, (Object)true);
    }

    private static boolean isProcessed(@NotNull DiagramNode<SpringElementWrapper<?>> targetNode) {
        Boolean isProcessed;
        if (targetNode == null) {
            SpringDiagramDataModelUpdater.$$$reportNull$$$0(38);
        }
        return (isProcessed = (Boolean)targetNode.getUserData(PROCESSED_KEY)) != null && isProcessed != false;
    }

    private static boolean modelBeansContain(Collection<SpringBeanPointer<?>> modelBeans, SpringBeanPointer<?> bean) {
        if (modelBeans.contains(bean)) {
            return true;
        }
        Object commonSpringBean = bean.getSpringBean();
        if (commonSpringBean instanceof DomSpringBean) {
            for (DomSpringBean parent = (DomSpringBean)((DomSpringBean)commonSpringBean).getParentOfType(DomSpringBean.class, true); parent != null; parent = (DomSpringBean)parent.getParentOfType(DomSpringBean.class, true)) {
                SpringBeanPointer<?> beanPointer = BeanService.getInstance().createSpringBeanPointer(parent);
                if (!modelBeans.contains(beanPointer)) continue;
                return true;
            }
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 7, 15 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/diagrams/beans/SpringDiagramDataModelUpdater";
                break;
            }
            case 4: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pointer";
                break;
            }
            case 5: 
            case 8: 
            case 11: 
            case 18: 
            case 20: 
            case 22: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 6: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "beanPointer";
                break;
            }
            case 9: 
            case 12: 
            case 27: 
            case 31: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "springBean";
                break;
            }
            case 16: 
            case 25: 
            case 26: 
            case 28: 
            case 29: 
            case 30: 
            case 32: 
            case 34: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceNode";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bean";
                break;
            }
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commonSpringBean";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stereotypeElement";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 37: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetNode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/diagrams/beans/SpringDiagramDataModelUpdater";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodes";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getEdges";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateElement";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "addNode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 15: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "processDependencies";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateElement";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "processStereotypeElementDependencies";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "processXmlBeanDependencies";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getNode";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "addNode";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "addSpringBeanDependencies";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "addJavaImportedDependencies";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "addJavaComponentScans";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "addJavaBeans";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "addEdge";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "addXmlBeanAutowiredDependencies";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "addAutowiredDependencies";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "addXmlConstructorAutowireDependencies";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "addXmlByNameAutowireDependencies";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "addXmlByTypeAutowireDependencies";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "addXmlBeanParentBeanDependencies";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "addXmlBeanDependsOnDependencies";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "addXmlBeanFactoryBeanDependencies";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "addXmlBeanInjectedDependencies";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "addXmlBeanLookupMethodInjectedDependencies";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "setProcessed";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "isProcessed";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 7, 15 -> new IllegalStateException(string);
        };
    }
}

