/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.diagrams.contexts;

import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.DiagramProvider;
import com.intellij.jam.model.util.JamCommonUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.xml.XmlFile;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.SpringLocalModelFactory;
import com.intellij.spring.contexts.model.LocalAnnotationModel;
import com.intellij.spring.contexts.model.LocalModel;
import com.intellij.spring.contexts.model.LocalXmlModel;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.contexts.model.graph.LazyModelDependenciesGraph;
import com.intellij.spring.contexts.model.graph.LocalModelDependency;
import com.intellij.spring.diagrams.contexts.beans.FilesetLocalModelWrapper;
import com.intellij.spring.diagrams.contexts.beans.LocalModelGraphElementWrapper;
import com.intellij.spring.diagrams.contexts.beans.LocalModelWrapper;
import com.intellij.spring.diagrams.contexts.beans.ModuleLocalModelWrapper;
import com.intellij.spring.diagrams.contexts.beans.SpringLocalModelDependencyEdge;
import com.intellij.spring.diagrams.contexts.beans.SpringLocalModelDiagramNode;
import com.intellij.spring.dom.SpringDomUtils;
import com.intellij.spring.facet.SpringFacet;
import com.intellij.spring.facet.SpringFileSet;
import com.intellij.spring.facet.SpringFileSetService;
import com.intellij.spring.impl.SpringAutoConfiguredModels;
import com.intellij.spring.model.SpringProfile;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringLocalModelsRelatedVisitor {
    private final Project myProject;
    private final SpringLocalModelDiagramNode myRootNode;
    private final DiagramProvider<LocalModelGraphElementWrapper<?>> myProvider;
    private final boolean myShowLibraryConfigs;
    private final boolean myShowModuleFilesetNodes;
    private final Collection<SpringLocalModelDiagramNode> myNodes;
    private final Collection<SpringLocalModelDependencyEdge> myEdges;
    private final Collection<SpringLocalModelDiagramNode> myFilteredNodes;

    SpringLocalModelsRelatedVisitor(@NotNull Project project, @NotNull SpringLocalModelDiagramNode rootNode, @NotNull DiagramProvider<LocalModelGraphElementWrapper<?>> provider, boolean showLibraryConfigs, boolean showModuleFilesetNodes) {
        if (project == null) {
            SpringLocalModelsRelatedVisitor.$$$reportNull$$$0(0);
        }
        if (rootNode == null) {
            SpringLocalModelsRelatedVisitor.$$$reportNull$$$0(1);
        }
        if (provider == null) {
            SpringLocalModelsRelatedVisitor.$$$reportNull$$$0(2);
        }
        this.myNodes = new LinkedHashSet<SpringLocalModelDiagramNode>();
        this.myEdges = new LinkedHashSet<SpringLocalModelDependencyEdge>();
        this.myFilteredNodes = new LinkedHashSet<SpringLocalModelDiagramNode>();
        this.myProject = project;
        this.myRootNode = rootNode;
        this.myProvider = provider;
        this.myShowLibraryConfigs = showLibraryConfigs;
        this.myShowModuleFilesetNodes = showModuleFilesetNodes;
    }

    @NotNull
    public Collection<SpringLocalModelDiagramNode> getNodes() {
        Collection<SpringLocalModelDiagramNode> collection = this.myNodes;
        if (collection == null) {
            SpringLocalModelsRelatedVisitor.$$$reportNull$$$0(3);
        }
        return collection;
    }

    @NotNull
    public Collection<SpringLocalModelDependencyEdge> getEdges() {
        Collection<SpringLocalModelDependencyEdge> collection = this.myEdges;
        if (collection == null) {
            SpringLocalModelsRelatedVisitor.$$$reportNull$$$0(4);
        }
        return collection;
    }

    public void visitLocalModel(@NotNull LocalModel<?> model) {
        Module module;
        if (model == null) {
            SpringLocalModelsRelatedVisitor.$$$reportNull$$$0(5);
        }
        if ((module = model.getModule()) == null || module.isDisposed()) {
            return;
        }
        Set<String> profiles = model.getActiveProfiles();
        LazyModelDependenciesGraph graph = LazyModelDependenciesGraph.getOrCreateLocalModelDependenciesGraph(module, profiles == null ? SpringProfile.DEFAULT.getNames() : profiles);
        SpringLocalModelDiagramNode node = this.getDiagramNode(LocalModelWrapper.create(model));
        node.getTooltip();
        this.myNodes.add(node);
        this.visitRelated(node, graph);
    }

    public void visitModule(@NotNull Module module) {
        if (module == null) {
            SpringLocalModelsRelatedVisitor.$$$reportNull$$$0(6);
        }
        if (module.isDisposed()) {
            return;
        }
        SpringFacet springFacet = SpringFacet.getInstance(module);
        if (springFacet == null) {
            LazyModelDependenciesGraph graph = LazyModelDependenciesGraph.getOrCreateLocalModelDependenciesGraph(module, Collections.emptySet());
            for (SpringModel model : SpringAutoConfiguredModels.discoverAutoConfiguredModels(module)) {
                for (CommonSpringModel relatedModel : model.getRelatedModels()) {
                    if (!(relatedModel instanceof LocalModel)) continue;
                    this.createEdgeToLocalModelAndVisitIt(null, graph, LocalModelWrapper.create((LocalModel)relatedModel), LocalModelDependency.create());
                }
            }
        } else {
            SpringLocalModelDiagramNode moduleNode = null;
            if (this.myShowModuleFilesetNodes) {
                moduleNode = this.getDiagramNode(ModuleLocalModelWrapper.create(module));
                this.myNodes.add(moduleNode);
            }
            for (SpringFileSet fileSet : SpringFileSetService.getInstance().getAllSets(springFacet)) {
                SpringLocalModelDiagramNode toNode = null;
                if (this.myShowModuleFilesetNodes) {
                    toNode = this.getDiagramNode(FilesetLocalModelWrapper.create(fileSet));
                    this.myNodes.add(toNode);
                    moduleNode.addChild(toNode);
                    SpringLocalModelDependencyEdge edge = new SpringLocalModelDependencyEdge((DiagramNode<LocalModelGraphElementWrapper<?>>)moduleNode, (DiagramNode<LocalModelGraphElementWrapper<?>>)toNode, LocalModelDependency.create());
                    this.myEdges.add(edge);
                }
                this.visitFileSet(toNode, fileSet);
            }
        }
    }

    public void visitFileSet(@NotNull SpringFileSet fileSet) {
        if (fileSet == null) {
            SpringLocalModelsRelatedVisitor.$$$reportNull$$$0(7);
        }
        SpringLocalModelDiagramNode node = null;
        if (this.myShowModuleFilesetNodes) {
            node = this.getDiagramNode(FilesetLocalModelWrapper.create(fileSet));
            this.myNodes.add(node);
        }
        this.visitFileSet(node, fileSet);
    }

    private void visitFileSet(@Nullable SpringLocalModelDiagramNode node, @NotNull SpringFileSet fileSet) {
        if (fileSet == null) {
            SpringLocalModelsRelatedVisitor.$$$reportNull$$$0(8);
        }
        Module module = fileSet.getFacet().getModule();
        Set<String> profiles = fileSet.getActiveProfiles();
        LazyModelDependenciesGraph graph = LazyModelDependenciesGraph.getOrCreateLocalModelDependenciesGraph(module, profiles);
        List<VirtualFilePointer> files = fileSet.getFiles();
        SpringLocalModelFactory localModelFactory = SpringLocalModelFactory.getInstance();
        for (VirtualFilePointer file : files) {
            PsiClass[] psiClasses;
            VirtualFile virtualFile = file.getFile();
            if (virtualFile == null || !this.myShowLibraryConfigs && ProjectRootManager.getInstance((Project)this.myProject).getFileIndex().isInLibraryClasses(virtualFile)) continue;
            PsiFile psiFile = PsiManager.getInstance((Project)this.myProject).findFile(virtualFile);
            if (JamCommonUtil.isPlainXmlFile((PsiElement)psiFile) && SpringDomUtils.isSpringXml((XmlFile)psiFile)) {
                LocalXmlModel model = localModelFactory.getOrCreateLocalXmlModel((XmlFile)psiFile, module, Collections.emptySet());
                if (model == null) continue;
                this.createEdgeToLocalModelAndVisitIt(node, graph, LocalModelWrapper.create(model), LocalModelDependency.create());
                continue;
            }
            if (!(psiFile instanceof PsiClassOwner)) continue;
            PsiClassOwner classOwner = (PsiClassOwner)psiFile;
            for (PsiClass psiClass : psiClasses = classOwner.getClasses()) {
                LocalAnnotationModel model = localModelFactory.getOrCreateLocalAnnotationModel(psiClass, module, Collections.emptySet());
                if (model == null) continue;
                this.createEdgeToLocalModelAndVisitIt(node, graph, LocalModelWrapper.create(model), LocalModelDependency.create());
            }
        }
    }

    private void visitRelated(@NotNull SpringLocalModelDiagramNode fromNode, @NotNull LazyModelDependenciesGraph graph) {
        if (fromNode == null) {
            SpringLocalModelsRelatedVisitor.$$$reportNull$$$0(9);
        }
        if (graph == null) {
            SpringLocalModelsRelatedVisitor.$$$reportNull$$$0(10);
        }
        for (Pair to : graph.getOrCreateOutDependencies(((LocalModelWrapper)fromNode.getIdentifyingElement()).getElement())) {
            this.createEdgeToLocalModelAndVisitIt(fromNode, graph, LocalModelWrapper.create((LocalModel)to.first), (LocalModelDependency)to.second);
        }
    }

    private void createEdgeToLocalModelAndVisitIt(@Nullable SpringLocalModelDiagramNode fromNode, @NotNull LazyModelDependenciesGraph graph, LocalModelWrapper<?> toNodeLocalModelWrapper, LocalModelDependency dependency) {
        SpringLocalModelDiagramNode toNode;
        if (graph == null) {
            SpringLocalModelsRelatedVisitor.$$$reportNull$$$0(11);
        }
        if ((toNode = this.getDiagramNode(toNodeLocalModelWrapper)) == fromNode || this.myFilteredNodes.contains((Object)toNode)) {
            return;
        }
        boolean error = false;
        if (!this.myNodes.contains((Object)toNode)) {
            if (!this.myShowLibraryConfigs && SpringLocalModelsRelatedVisitor.isLibraryConfig(toNode.getIdentifyingElement())) {
                this.myFilteredNodes.add(toNode);
                return;
            }
            toNode.getTooltip();
            this.myNodes.add(toNode);
            this.visitRelated(toNode, graph);
        } else {
            error = true;
        }
        if (fromNode != null) {
            SpringLocalModelDependencyEdge edge = new SpringLocalModelDependencyEdge((DiagramNode<LocalModelGraphElementWrapper<?>>)fromNode, (DiagramNode<LocalModelGraphElementWrapper<?>>)toNode, dependency);
            if (error) {
                edge.setError(true);
            } else {
                fromNode.addChild(toNode);
            }
            this.myEdges.add(edge);
        }
    }

    private static boolean isLibraryConfig(LocalModelGraphElementWrapper<?> element) {
        if (element instanceof LocalModelWrapper) {
            LocalModel localModel = (LocalModel)element.getElement();
            Project project = localModel.getConfig().getProject();
            return ProjectRootManager.getInstance((Project)project).getFileIndex().isInLibraryClasses(localModel.getConfig().getContainingFile().getVirtualFile());
        }
        return false;
    }

    @NotNull
    private SpringLocalModelDiagramNode getDiagramNode(@NotNull LocalModelGraphElementWrapper<?> model) {
        if (model == null) {
            SpringLocalModelsRelatedVisitor.$$$reportNull$$$0(12);
        }
        if (model.equals(this.myRootNode.getIdentifyingElement())) {
            SpringLocalModelDiagramNode springLocalModelDiagramNode = this.myRootNode;
            if (springLocalModelDiagramNode == null) {
                SpringLocalModelsRelatedVisitor.$$$reportNull$$$0(13);
            }
            return springLocalModelDiagramNode;
        }
        for (SpringLocalModelDiagramNode node : this.myNodes) {
            if (!model.equals(node.getIdentifyingElement())) continue;
            SpringLocalModelDiagramNode springLocalModelDiagramNode = node;
            if (springLocalModelDiagramNode == null) {
                SpringLocalModelsRelatedVisitor.$$$reportNull$$$0(14);
            }
            return springLocalModelDiagramNode;
        }
        return new SpringLocalModelDiagramNode(model, this.myProvider);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 13, 14 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootNode";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 3: 
            case 4: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/diagrams/contexts/SpringLocalModelsRelatedVisitor";
                break;
            }
            case 5: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileSet";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fromNode";
                break;
            }
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "graph";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/diagrams/contexts/SpringLocalModelsRelatedVisitor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodes";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getEdges";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getDiagramNode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 13: 
            case 14: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "visitLocalModel";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "visitModule";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "visitFileSet";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "visitRelated";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createEdgeToLocalModelAndVisitIt";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getDiagramNode";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 13, 14 -> new IllegalStateException(string);
        };
    }
}

