/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.facet;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.spring.facet.SpringFileSetData;
import com.intellij.util.SmartList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

final class SpringFileSetDataImpl
implements SpringFileSetData {
    private final String myId;
    private String myName;
    private final List<String> myFiles;
    private final Set<String> myDependencies;
    private Set<String> myActiveProfiles;
    private boolean myRemoved;

    SpringFileSetDataImpl(@NonNls @NotNull String id, @NotNull String name) {
        if (id == null) {
            SpringFileSetDataImpl.$$$reportNull$$$0(0);
        }
        if (name == null) {
            SpringFileSetDataImpl.$$$reportNull$$$0(1);
        }
        this.myFiles = new SmartList();
        this.myDependencies = new LinkedHashSet<String>();
        this.myActiveProfiles = new LinkedHashSet<String>();
        this.myId = id;
        this.myName = name;
    }

    @Override
    public boolean isRemoved() {
        return this.myRemoved;
    }

    @Override
    @NotNull
    public String getId() {
        String string = this.myId;
        if (string == null) {
            SpringFileSetDataImpl.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    public String getName() {
        return this.myName;
    }

    @Override
    public void setName(@NotNull String name) {
        if (name == null) {
            SpringFileSetDataImpl.$$$reportNull$$$0(3);
        }
        this.myName = name;
    }

    @Override
    @NotNull
    public List<String> getFiles() {
        List<String> list = this.myFiles;
        if (list == null) {
            SpringFileSetDataImpl.$$$reportNull$$$0(4);
        }
        return list;
    }

    @Override
    public void setActiveProfiles(@NotNull Set<String> activeProfiles) {
        if (activeProfiles == null) {
            SpringFileSetDataImpl.$$$reportNull$$$0(5);
        }
        this.myActiveProfiles = activeProfiles;
    }

    @Override
    @NotNull
    public Set<String> getActiveProfiles() {
        Set<String> set = this.myActiveProfiles;
        if (set == null) {
            SpringFileSetDataImpl.$$$reportNull$$$0(6);
        }
        return set;
    }

    @Override
    public Set<String> getDependencies() {
        return this.myDependencies;
    }

    @Override
    public void addDependency(String dep) {
        this.myDependencies.add(dep);
    }

    @Override
    public void addFile(@NonNls String url) {
        if (!StringUtil.isEmptyOrSpaces((String)url)) {
            this.myFiles.add(url);
        }
    }

    @Override
    public void removeFile(@NonNls String url) {
        this.myFiles.remove(url);
    }

    @Override
    public void setRemoved(boolean removed) {
        this.myRemoved = removed;
    }

    static SpringFileSetDataImpl copy(SpringFileSetData origin) {
        SpringFileSetDataImpl springFileSetData = new SpringFileSetDataImpl(origin.getId(), origin.getName());
        springFileSetData.setRemoved(origin.isRemoved());
        springFileSetData.getDependencies().addAll(origin.getDependencies());
        springFileSetData.getFiles().addAll(origin.getFiles());
        springFileSetData.getActiveProfiles().addAll(origin.getActiveProfiles());
        return springFileSetData;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SpringFileSetData data = (SpringFileSetData)o;
        if (!this.myId.equals(data.getId())) {
            return false;
        }
        return Objects.equals(this.myName, data.getName());
    }

    public int hashCode() {
        int result2 = this.myId.hashCode();
        result2 = 31 * result2 + (this.myName != null ? this.myName.hashCode() : 0);
        return result2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 4, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/facet/SpringFileSetDataImpl";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "activeProfiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/facet/SpringFileSetDataImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFiles";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getActiveProfiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setActiveProfiles";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 4, 6 -> new IllegalStateException(string);
        };
    }
}

