/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.facet;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.spring.SpringAutodetectedFilesetsSearcher;
import com.intellij.spring.SpringManager;
import com.intellij.spring.SpringModelVisitorUtils;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.facet.SpringAutodetectedFileSet;
import com.intellij.spring.facet.SpringFacet;
import com.intellij.spring.facet.SpringFileSet;
import com.intellij.spring.facet.SpringFileSetService;
import com.intellij.util.Function;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.UniqueNameGenerator;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringFileSetServiceImpl
extends SpringFileSetService {
    public static final ExtensionPointName<SpringAutodetectedFilesetsSearcher> SPRING_AUTODETECTED_FILESETS_EP_NAME = new ExtensionPointName("com.intellij.spring.autodetected.filesets");
    @NonNls
    private static final String ID_PREFIX = "fileset";
    @NonNls
    private static final String DEPENDENCY_DELIMITER = "==";
    private static final Function<SpringFileSet, String> FILESET_ID = SpringFileSet::getId;

    public SpringFileSetServiceImpl() {
        SPRING_AUTODETECTED_FILESETS_EP_NAME.addChangeListener(SpringAutodetectedFileSet::refreshAutodetectedFileSets, null);
    }

    @Override
    public String getUniqueId(Collection<SpringFileSet> existing) {
        return UniqueNameGenerator.generateUniqueName((String)ID_PREFIX, (Collection)ContainerUtil.map(existing, FILESET_ID));
    }

    @Override
    public String getUniqueName(String prefix, Collection<SpringFileSet> existing) {
        UniqueNameGenerator generator2 = new UniqueNameGenerator(existing, SpringFileSet::getName);
        return generator2.generateUniqueName(prefix, "", "", " (", ")");
    }

    @Override
    @NotNull
    public Set<SpringFileSet> getAllSets(@NotNull SpringFacet facet) {
        if (facet == null) {
            SpringFileSetServiceImpl.$$$reportNull$$$0(0);
        }
        Set<SpringFileSet> fileSets = SpringFileSetServiceImpl.getFileSets(facet);
        Set existing = ContainerUtil.map2Set(fileSets, FILESET_ID);
        for (SpringFileSet provided : this.getModelProviderSets(facet)) {
            if (existing.contains(provided.getId())) continue;
            fileSets.add(provided);
        }
        Set<SpringFileSet> set = fileSets;
        if (set == null) {
            SpringFileSetServiceImpl.$$$reportNull$$$0(1);
        }
        return set;
    }

    @Override
    @NotNull
    public List<SpringFileSet> getModelProviderSets(@NotNull SpringFacet facet) {
        if (facet == null) {
            SpringFileSetServiceImpl.$$$reportNull$$$0(2);
        }
        if (facet.getModule().isDisposed() || DumbService.isDumb((Project)facet.getModule().getProject())) {
            List<SpringFileSet> list = Collections.emptyList();
            if (list == null) {
                SpringFileSetServiceImpl.$$$reportNull$$$0(3);
            }
            return list;
        }
        SmartList result2 = new SmartList();
        for (SpringAutodetectedFilesetsSearcher modelProvider : SPRING_AUTODETECTED_FILESETS_EP_NAME.getExtensionList()) {
            List<? extends SpringAutodetectedFileSet> modelProviderFilesets = modelProvider.getFilesets(facet);
            result2.addAll(modelProviderFilesets);
        }
        SmartList smartList = result2;
        if (smartList == null) {
            SpringFileSetServiceImpl.$$$reportNull$$$0(4);
        }
        return smartList;
    }

    @Override
    @Nullable
    public SpringFileSet findFileSet(Module module, PsiFile psiFile) {
        SpringFacet springFacet = SpringFacet.getInstance(module);
        if (springFacet == null) {
            return null;
        }
        VirtualFile virtualFile = psiFile.getVirtualFile();
        for (SpringFileSet fileSet : this.getAllSets(springFacet)) {
            if (!fileSet.hasFile(virtualFile)) continue;
            return fileSet;
        }
        for (SpringModel model : SpringManager.getInstance(module.getProject()).getAllModels(module)) {
            if (model.getFileSet() == null) {
                return null;
            }
            if (!SpringModelVisitorUtils.hasConfigFile(model, psiFile)) continue;
            return model.getFileSet();
        }
        return null;
    }

    @Override
    public String getQualifiedName(@NotNull SpringFileSet fileset) {
        if (fileset == null) {
            SpringFileSetServiceImpl.$$$reportNull$$$0(5);
        }
        return fileset.getId() + DEPENDENCY_DELIMITER + fileset.getFacet().getModule().getName();
    }

    @Override
    public String getDependencyIdFor(SpringFileSet current, SpringFileSet otherFileSet) {
        boolean isCurrentModule = current.getFacet().getModule().equals(otherFileSet.getFacet().getModule());
        if (isCurrentModule) {
            return otherFileSet.getId();
        }
        return this.getQualifiedName(otherFileSet);
    }

    @Override
    @Nullable
    public SpringFileSet findDependencyFileSet(SpringFileSet current, @NotNull String dependencyId) {
        SpringFacet facetToSearch;
        if (dependencyId == null) {
            SpringFileSetServiceImpl.$$$reportNull$$$0(6);
        }
        if ((facetToSearch = SpringFileSetServiceImpl.getSpringFacetFor(current, dependencyId)) == null) {
            return null;
        }
        Condition fileSetCondition = springFileSet -> this.getDependencyIdFor(current, (SpringFileSet)springFileSet).equals(dependencyId);
        SpringFileSet fileSet = (SpringFileSet)ContainerUtil.find(SpringFileSetServiceImpl.getFileSets(facetToSearch), (Condition)fileSetCondition);
        if (fileSet != null) {
            return fileSet;
        }
        return (SpringFileSet)ContainerUtil.find(this.getModelProviderSets(facetToSearch), (Condition)fileSetCondition);
    }

    private static Set<SpringFileSet> getFileSets(SpringFacet facet) {
        return new LinkedHashSet<SpringFileSet>(facet.getFileSets());
    }

    @Nullable
    private static SpringFacet getSpringFacetFor(SpringFileSet current, @NotNull String dependencyId) {
        if (dependencyId == null) {
            SpringFileSetServiceImpl.$$$reportNull$$$0(7);
        }
        if (!dependencyId.contains(DEPENDENCY_DELIMITER)) {
            return current.getFacet();
        }
        String moduleName = StringUtil.substringAfter((String)dependencyId, (String)DEPENDENCY_DELIMITER);
        assert (moduleName != null) : dependencyId;
        Module moduleByName = ModuleManager.getInstance((Project)current.getFacet().getModule().getProject()).findModuleByName(moduleName);
        return moduleByName == null ? null : SpringFacet.getInstance(moduleByName);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/facet/SpringFileSetServiceImpl";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = ID_PREFIX;
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependencyId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/facet/SpringFileSetServiceImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllSets";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getModelProviderSets";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getAllSets";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getModelProviderSets";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getQualifiedName";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findDependencyFileSet";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getSpringFacetFor";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 3, 4 -> new IllegalStateException(string);
        };
    }
}

