/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.gutter;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.daemon.GutterIconNavigationHandler;
import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.codeInsight.daemon.MergeableLineMarkerInfo;
import com.intellij.codeInsight.daemon.RelatedItemLineMarkerInfo;
import com.intellij.ide.SelectInContext;
import com.intellij.ide.SelectInManager;
import com.intellij.ide.SmartSelectInContext;
import com.intellij.jam.model.common.CommonModelElement;
import com.intellij.microservices.jvm.gutter.DumbAwareLineMarkerUtilsKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbModeBlockedFunctionality;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.Pair;
import com.intellij.pom.PomTarget;
import com.intellij.pom.PomTargetPsiElement;
import com.intellij.psi.DelegatePsiTarget;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.semantic.SemService;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.SpringApiIcons;
import com.intellij.spring.SpringBundle;
import com.intellij.spring.contexts.model.LocalAnnotationModel;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.contexts.model.visitors.CommonSpringModelVisitorContext;
import com.intellij.spring.contexts.model.visitors.SpringModelVisitors;
import com.intellij.spring.gutter.BeanClassLineMarker;
import com.intellij.spring.gutter.NavigationGutterIconBuilderUtil;
import com.intellij.spring.gutter.SpringAnnotatorBase;
import com.intellij.spring.gutter.SpringAutowiredAnnotator;
import com.intellij.spring.gutter.SpringBeansPsiElementCellRenderer;
import com.intellij.spring.gutter.SpringDumbModeLineMarkers;
import com.intellij.spring.gutter.groups.SpringGroupLineMarker;
import com.intellij.spring.gutter.groups.SpringGutterIconBuilder;
import com.intellij.spring.impl.SpringAutoConfiguredModels;
import com.intellij.spring.java.SpringJavaClassInfo;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.SpringBeanPsiTarget;
import com.intellij.spring.model.jam.JamPsiMemberSpringBean;
import com.intellij.spring.model.jam.JamSpringBeanPointer;
import com.intellij.spring.model.jam.javaConfig.SpringJavaBean;
import com.intellij.spring.model.jam.javaConfig.SpringOldJavaConfigurationUtil;
import com.intellij.spring.model.jam.stereotype.SpringImport;
import com.intellij.spring.model.jam.stereotype.SpringStereotypeElement;
import com.intellij.spring.model.jam.utils.SpringJamUtils;
import com.intellij.spring.model.utils.SpringAutowireUtil;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.model.utils.SpringModelUtils;
import com.intellij.spring.toolWindow.SpringBeansViewSelectInTarget;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UAnnotated;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UIdentifier;
import org.jetbrains.uast.UMethod;

public final class SpringBeanAnnotator
extends SpringAnnotatorBase
implements DumbAware {
    public String getId() {
        return "SpringBeanAnnotator";
    }

    public String getName() {
        return SpringBundle.message("spring.core.bean.annotator.name", new Object[0]);
    }

    @NotNull
    public Icon getIcon() {
        Icon icon = SpringApiIcons.SpringBean;
        if (icon == null) {
            SpringBeanAnnotator.$$$reportNull$$$0(0);
        }
        return icon;
    }

    @Override
    protected void annotateClass(@NotNull Collection<? super RelatedItemLineMarkerInfo<?>> result2, @NotNull UClass uClass, @NotNull PsiElement identifier) {
        PsiClass psiClass;
        if (result2 == null) {
            SpringBeanAnnotator.$$$reportNull$$$0(1);
        }
        if (uClass == null) {
            SpringBeanAnnotator.$$$reportNull$$$0(2);
        }
        if (identifier == null) {
            SpringBeanAnnotator.$$$reportNull$$$0(3);
        }
        if (!SpringCommonUtils.isSpringBeanCandidateClass(psiClass = uClass.getJavaPsi())) {
            return;
        }
        if (SpringBeanAnnotator.looksLikeStereotypeBean(psiClass)) {
            if (AnnotationUtil.isAnnotated((PsiModifierListOwner)psiClass, SpringAutoConfiguredModels.bootAnnotations, (int)8)) {
                return;
            }
            NotNullLazyValue targets = NotNullLazyValue.lazy(() -> {
                SmartList result2 = new SmartList();
                List<JamSpringBeanPointer> mappedBeans = SpringJavaClassInfo.getSpringJavaClassInfo(psiClass).resolve().getStereotypeMappedBeans();
                for (JamSpringBeanPointer mappedBean : mappedBeans) {
                    JamPsiMemberSpringBean bean = (JamPsiMemberSpringBean)mappedBean.getSpringBean();
                    if (!(bean instanceof SpringJavaBean) && (!(bean instanceof SpringStereotypeElement) || psiClass.isEquivalentTo(bean.getPsiElement()))) continue;
                    result2.add(bean);
                }
                CommonSpringModel model = SpringModelUtils.getInstance().getPsiClassSpringModel(psiClass);
                Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiClass);
                if (module != null) {
                    Collection<Module> searchScopeModules = SpringAutowireUtil.getSpringSearchScopeModule(module);
                    if (searchScopeModules.isEmpty()) {
                        searchScopeModules.add(module);
                    }
                    for (Module searchScopeModule : searchScopeModules) {
                        ContainerUtil.addAllNotNull((Collection)result2, SpringJamUtils.getInstance().findStereotypeConfigurationBeans(model, mappedBeans, searchScopeModule));
                    }
                    ContainerUtil.addAllNotNull((Collection)result2, SpringBeanAnnotator.getImportConfigurations(model, psiClass));
                }
                return result2;
            });
            if (!SpringCommonUtils.isConfigurationOrMeta(psiClass)) {
                PsiClassType classType = JavaPsiFacade.getInstance((Project)psiClass.getProject()).getElementFactory().createType(psiClass);
                result2.add(SpringAutowiredAnnotator.getNavigateToAutowiredCandidatesBuilder((PsiMember)psiClass, (PsiType)classType).createSpringGroupLineMarkerInfo(identifier));
            }
            SpringBeanAnnotator.addSpringJavaBeanGutterIcon(result2, identifier, (NotNullLazyValue<Collection<? extends CommonModelElement>>)targets, SpringApiIcons.Gutter.SpringBean);
            if (ModuleUtilCore.findModuleForPsiElement((PsiElement)identifier) != null) {
                SpringBeanAnnotator.addShowInSpringViewGutterIcon(result2, identifier, NotNullLazyValue.lazy(() -> {
                    ArrayList mappedBeans = new ArrayList(SpringJavaClassInfo.getSpringJavaClassInfo(psiClass).resolve().getBeans());
                    mappedBeans.sort(SpringBeanPointer.DISPLAY_COMPARATOR);
                    return mappedBeans;
                }));
            }
        } else if (SpringBeanAnnotator.isXmlMappedBean(psiClass)) {
            NotNullLazyValue targets = NotNullLazyValue.lazy(() -> ContainerUtil.sorted(SpringJavaClassInfo.getSpringJavaClassInfo(psiClass).resolve().getMappedDomBeans(), SpringBeanPointer.DISPLAY_COMPARATOR));
            SpringBeanAnnotator.addSpringBeanGutterIcon(result2, identifier, targets);
            if (ModuleUtilCore.findModuleForPsiElement((PsiElement)identifier) != null) {
                SpringBeanAnnotator.addShowInSpringViewGutterIcon(result2, identifier, targets);
            }
        }
    }

    public void collectSlowLineMarkers(@NotNull List<? extends PsiElement> elements, @NotNull Collection<? super LineMarkerInfo<?>> result2) {
        PsiElement first;
        if (elements == null) {
            SpringBeanAnnotator.$$$reportNull$$$0(4);
        }
        if (result2 == null) {
            SpringBeanAnnotator.$$$reportNull$$$0(5);
        }
        if ((first = (PsiElement)ContainerUtil.getFirstItem(elements)) == null || !SpringCommonUtils.isSpringConfigured(first.getProject())) {
            return;
        }
        boolean isDumb = DumbService.isDumb((Project)first.getProject());
        Module module = DumbAwareLineMarkerUtilsKt.findModuleForElement((PsiElement)first, (boolean)isDumb);
        int size = elements.size();
        for (int i = 0; i < size; ++i) {
            PsiElement element = elements.get(i);
            UElement uElement = DumbAwareLineMarkerUtilsKt.getUParentForIdentifierDumbAware((PsiElement)element, (boolean)isDumb);
            if (uElement == null) continue;
            if (isDumb) {
                SpringBeanAnnotator.annotateInDumbMode(module, uElement, element, result2);
                continue;
            }
            this.annotateInSmartMode(module, uElement, element, result2);
        }
    }

    private void annotateInSmartMode(@Nullable Module module, @NotNull UElement uElement, @NotNull PsiElement element, @NotNull Collection<? super LineMarkerInfo<?>> result2) {
        if (uElement == null) {
            SpringBeanAnnotator.$$$reportNull$$$0(6);
        }
        if (element == null) {
            SpringBeanAnnotator.$$$reportNull$$$0(7);
        }
        if (result2 == null) {
            SpringBeanAnnotator.$$$reportNull$$$0(8);
        }
        if (module != null && !SpringCommonUtils.isSpringConfigured(module)) {
            return;
        }
        if (uElement instanceof UMethod) {
            this.annotateMethod((UMethod)uElement, result2);
        } else if (uElement instanceof UClass) {
            UClass uClass = (UClass)uElement;
            UElement anchor = uClass.getUastAnchor();
            if (anchor == null || anchor.getSourcePsi() != element) {
                return;
            }
            ArrayList classMarkers = new ArrayList();
            this.annotateClass(classMarkers, uClass);
            SpringBeanAnnotator.annotateExtensions(classMarkers, uClass, element);
            if (!classMarkers.isEmpty()) {
                MultiMap groups = MultiMap.createLinked();
                for (LineMarkerInfo marker : classMarkers) {
                    if (!(marker instanceof MergeableLineMarkerInfo)) {
                        Logger.getInstance(((Object)((Object)this)).getClass()).error("All SpringBeanAnnotator line markers must implement MergeableLineMarkerInfo");
                        continue;
                    }
                    PsiElement markerElement = marker.getElement();
                    if (markerElement == null) continue;
                    groups.putValue((Object)markerElement, (Object)((MergeableLineMarkerInfo)marker));
                }
                for (Map.Entry entry : groups.entrySet()) {
                    if (((Collection)entry.getValue()).size() == 1) {
                        result2.addAll((Collection)entry.getValue());
                        continue;
                    }
                    ArrayList merging = new ArrayList((Collection)entry.getValue());
                    List merged = MergeableLineMarkerInfo.merge(merging, (int)11);
                    result2.addAll(merged);
                }
            }
        }
    }

    private static void annotateInDumbMode(@Nullable Module module, @NotNull UElement uElement, @NotNull PsiElement psiIdentifier, @NotNull Collection<? super LineMarkerInfo<?>> result2) {
        block10: {
            block11: {
                if (uElement == null) {
                    SpringBeanAnnotator.$$$reportNull$$$0(9);
                }
                if (psiIdentifier == null) {
                    SpringBeanAnnotator.$$$reportNull$$$0(10);
                }
                if (result2 == null) {
                    SpringBeanAnnotator.$$$reportNull$$$0(11);
                }
                if (module == null || !SpringCommonUtils.isSpringConfigured(module)) {
                    return;
                }
                if (!(uElement instanceof UClass)) break block11;
                for (UAnnotation annotation : SpringBeanAnnotator.getAnnotationsInDumbMode((UAnnotated)((UClass)uElement))) {
                    PsiElement idSourcePsi;
                    UIdentifier id;
                    try {
                        id = annotation.getUastAnchor();
                    }
                    catch (IndexNotReadyException e) {
                        continue;
                    }
                    if (id == null || (idSourcePsi = id.getSourcePsi()) == null || !SpringDumbModeLineMarkers.COMPONENT_ANNOTATION_SHORTNAMES.contains(id.getName())) continue;
                    PsiElement target = SpringDumbModeLineMarkers.ANNOTATION_TARGET_SHORTNAMES.contains(id.getName()) ? idSourcePsi : psiIdentifier;
                    result2.add(new LineMarkerInfo(target, target.getTextRange(), SpringGroupLineMarker.SPRING_MERGED_LINE_MARKER_ICON, element -> SpringBundle.message("gutter.navigate.to.autowired.candidates.title", new Object[0]), SpringDumbModeLineMarkers.getDumbNavigationHandler(DumbModeBlockedFunctionality.GotoInjectionPoints), SpringGutterIconBuilder.DEFAULT_GUTTER_ICON_ALIGNMENT, SpringBundle.messagePointer("gutter.navigate.to.autowired.candidates.title", new Object[0])));
                    break block10;
                }
                break block10;
            }
            if (!(uElement instanceof UMethod)) break block10;
            List<UAnnotation> annotations = SpringBeanAnnotator.getAnnotationsInDumbMode((UAnnotated)((UMethod)uElement));
            for (UAnnotation annotation : annotations) {
                try {
                    String name;
                    PsiElement idSourcePsi;
                    UIdentifier id = annotation.getUastAnchor();
                    if (id == null || (idSourcePsi = id.getSourcePsi()) == null || !SpringDumbModeLineMarkers.BEAN_ANNOTATION_SHORTNAME.equals(name = id.getName())) continue;
                    result2.add(new LineMarkerInfo(idSourcePsi, idSourcePsi.getTextRange(), SpringApiIcons.Gutter.ShowAutowiredCandidates, element -> SpringBundle.message("gutter.navigate.to.autowired.candidates.title", new Object[0]), SpringDumbModeLineMarkers.getDumbNavigationHandler(DumbModeBlockedFunctionality.GotoBeanDeclarations), SpringGutterIconBuilder.DEFAULT_GUTTER_ICON_ALIGNMENT, SpringBundle.messagePointer("gutter.navigate.to.autowired.candidates.title", new Object[0])));
                }
                catch (IndexNotReadyException indexNotReadyException) {}
            }
        }
    }

    @NotNull
    private static List<UAnnotation> getAnnotationsInDumbMode(@NotNull UAnnotated uElement) {
        List list;
        if (uElement == null) {
            SpringBeanAnnotator.$$$reportNull$$$0(12);
        }
        try {
            list = uElement.getUAnnotations();
        }
        catch (IndexNotReadyException e) {
            List<UAnnotation> list2 = Collections.emptyList();
            if (list2 == null) {
                SpringBeanAnnotator.$$$reportNull$$$0(14);
            }
            return list2;
        }
        if (list == null) {
            SpringBeanAnnotator.$$$reportNull$$$0(13);
        }
        return list;
    }

    private static void annotateExtensions(@NotNull Collection<? super LineMarkerInfo<?>> result2, UClass uClass, PsiElement element) {
        PsiClass psiClass;
        if (result2 == null) {
            SpringBeanAnnotator.$$$reportNull$$$0(15);
        }
        if (!SpringCommonUtils.isSpringBeanCandidateClass(psiClass = uClass.getJavaPsi())) {
            return;
        }
        if (SpringBeanAnnotator.looksLikeStereotypeBean(psiClass) || SpringBeanAnnotator.isXmlMappedBean(psiClass)) {
            BeanClassLineMarker.EP_NAME.forEachExtensionSafe(extension -> extension.annotate(psiClass, element, result2));
        }
    }

    public static boolean looksLikeStereotypeBean(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            SpringBeanAnnotator.$$$reportNull$$$0(16);
        }
        if (SpringCommonUtils.isStereotypeComponentOrMeta(psiClass)) {
            return true;
        }
        SpringJavaClassInfo.MappedBeanInfo mappedBeanInfo = SpringJavaClassInfo.getSpringJavaClassInfo(psiClass).resolve();
        return mappedBeanInfo.isStereotypeJavaBean();
    }

    public static boolean isXmlMappedBean(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            SpringBeanAnnotator.$$$reportNull$$$0(17);
        }
        if (!SpringCommonUtils.hasSpringXmlInResolveScope(psiClass)) {
            return false;
        }
        SpringJavaClassInfo.MappedBeanInfo mappedBeanInfo = SpringJavaClassInfo.getSpringJavaClassInfo(psiClass).resolve();
        return mappedBeanInfo.isMappedDomBean();
    }

    private static void addShowInSpringViewGutterIcon(Collection<? super RelatedItemLineMarkerInfo<?>> result2, PsiElement psiIdentifier, NotNullLazyValue<Collection<? extends SpringBeanPointer<?>>> targets) {
        SpringGutterIconBuilder<SpringBeanPointer<?>> builder = SpringGutterIconBuilder.createBuilder(SpringApiIcons.Gutter.Spring, NavigationGutterIconBuilderUtil.BEAN_POINTER_CONVERTOR, null);
        builder.setTargets(targets).setEmptyPopupText(SpringBundle.message("gutter.navigate.no.matching.beans", new Object[0])).setPopupTitle(SpringBundle.message("spring.bean.class.navigate.choose.class.title", new Object[0])).setTargetRenderer(SpringBeansPsiElementCellRenderer::new).setTooltipText(SpringBundle.message("spring.bean.class.tooltip.show.in.description", new Object[0]));
        result2.add(builder.createSpringGroupLineMarkerInfo(psiIdentifier, (GutterIconNavigationHandler<PsiElement>)((GutterIconNavigationHandler)(e, elt) -> {
            if (elt == null) {
                return;
            }
            PsiFile file = elt.getContainingFile();
            if (file == null) {
                return;
            }
            SmartSelectInContext context = new SmartSelectInContext(file, SpringBeanAnnotator.getElementToShowIn(elt));
            List selectInTargets = SelectInManager.getInstance((Project)context.getProject()).getTargetList();
            SpringBeansViewSelectInTarget selectInTarget = (SpringBeansViewSelectInTarget)ContainerUtil.findInstance((Iterable)selectInTargets, SpringBeansViewSelectInTarget.class);
            if (selectInTarget != null) {
                selectInTarget.selectIn((SelectInContext)context, true);
            }
        })));
    }

    private static PsiElement getElementToShowIn(PsiElement element) {
        if (element instanceof PomTargetPsiElement) {
            PomTarget target = ((PomTargetPsiElement)element).getTarget();
            if (target instanceof SpringBeanPsiTarget) {
                return ((SpringBeanPsiTarget)target).getNavigationElement();
            }
            if (target instanceof DelegatePsiTarget) {
                return ((DelegatePsiTarget)target).getNavigationElement();
            }
        }
        return element;
    }

    @Override
    protected void annotateMethod(@NotNull UMethod uMethod, PsiElement identifier, Collection<? super RelatedItemLineMarkerInfo<?>> result2) {
        PsiMethod method;
        PsiClass psiClass;
        if (uMethod == null) {
            SpringBeanAnnotator.$$$reportNull$$$0(18);
        }
        if ((psiClass = (method = uMethod.getJavaPsi()).getContainingClass()) == null) {
            return;
        }
        if (SpringCommonUtils.isSpringBeanCandidateClassInSpringProject(psiClass)) {
            SpringJavaClassInfo.MappedBeanInfo info;
            Collection<Pair<PsiElement, SpringJavaClassInfo.SpringMethodType>> methodTypes;
            List<SpringBeanPointer<?>> externalBeans = SpringOldJavaConfigurationUtil.findExternalBeans(method);
            if (!externalBeans.isEmpty()) {
                SpringBeanAnnotator.addSpringBeanGutterIcon(result2, identifier, NotNullLazyValue.lazy(() -> {
                    List<SpringBeanPointer<?>> externalBeans2 = SpringOldJavaConfigurationUtil.findExternalBeans(method);
                    externalBeans2.sort(SpringBeanPointer.DISPLAY_COMPARATOR);
                    return externalBeans2;
                }));
            }
            if (!SpringCommonUtils.isStereotypeComponentOrMeta(psiClass) && !(methodTypes = (info = SpringJavaClassInfo.getSpringJavaClassInfo(psiClass).resolve()).getMethodTypes(method)).isEmpty()) {
                SpringBeanAnnotator.addMethodTypesGutterIcon(result2, method, methodTypes);
            }
        }
    }

    private static void addMethodTypesGutterIcon(Collection<? super RelatedItemLineMarkerInfo<?>> result2, PsiMethod psiMethod, Collection<? extends Pair<PsiElement, SpringJavaClassInfo.SpringMethodType>> targets) {
        String tooltipText = SpringBundle.message("spring.bean.methods.tooltip.navigate.declaration", new Object[0]);
        Icon icon = SpringApiIcons.Gutter.SpringBeanMethod;
        if (targets.size() == 1) {
            SpringJavaClassInfo.SpringMethodType methodType = (SpringJavaClassInfo.SpringMethodType)((Object)targets.iterator().next().second);
            tooltipText = SpringBundle.message("spring.bean.method.tooltip.navigate.declaration", methodType.getName());
            if (methodType == SpringJavaClassInfo.SpringMethodType.FACTORY) {
                icon = SpringApiIcons.Gutter.FactoryMethodBean;
            }
        }
        SpringGutterIconBuilder<PsiElement> builder = SpringGutterIconBuilder.createBuilder(icon);
        builder.setTargets(ContainerUtil.mapNotNull(targets, pair -> (PsiElement)pair.getFirst())).setTargetRenderer(SpringBeansPsiElementCellRenderer::new).setPopupTitle(SpringBundle.message("spring.bean.class.navigate.choose.class.title", new Object[0])).setTooltipText(tooltipText);
        PsiIdentifier identifier = psiMethod.getNameIdentifier();
        if (identifier != null) {
            result2.add(builder.createLineMarkerInfo((PsiElement)identifier));
        }
    }

    private static void addSpringBeanGutterIcon(Collection<? super RelatedItemLineMarkerInfo<?>> result2, PsiElement psiIdentifier, NotNullLazyValue<Collection<? extends SpringBeanPointer<?>>> targets) {
        SpringGutterIconBuilder<SpringBeanPointer<?>> builder = SpringGutterIconBuilder.createBuilder(SpringApiIcons.Gutter.SpringBean, NavigationGutterIconBuilderUtil.BEAN_POINTER_CONVERTOR, NavigationGutterIconBuilderUtil.AUTOWIRED_BEAN_POINTER_GOTO_PROVIDER);
        builder.setTargets(targets).setEmptyPopupText(SpringBundle.message("gutter.navigate.no.matching.beans", new Object[0])).setPopupTitle(SpringBundle.message("spring.bean.class.navigate.choose.class.title", new Object[0])).setTargetRenderer(SpringBeansPsiElementCellRenderer::new).setTooltipText(SpringBundle.message("spring.bean.class.tooltip.navigate.declaration", new Object[0]));
        result2.add(builder.createSpringGroupLineMarkerInfo(psiIdentifier));
    }

    private static List<CommonModelElement> getImportConfigurations(@NotNull CommonSpringModel model, @NotNull PsiClass psiClass) {
        Module module;
        if (model == null) {
            SpringBeanAnnotator.$$$reportNull$$$0(19);
        }
        if (psiClass == null) {
            SpringBeanAnnotator.$$$reportNull$$$0(20);
        }
        if ((module = model.getModule()) == null) {
            return Collections.emptyList();
        }
        SmartList result2 = new SmartList();
        if (model instanceof SpringModel) {
            SpringModelVisitors.visitRecursionAwareRelatedModels(model, CommonSpringModelVisitorContext.context(p -> true, (arg_0, arg_1) -> SpringBeanAnnotator.lambda$getImportConfigurations$10((List)result2, psiClass, arg_0, arg_1)));
        }
        return result2;
    }

    private static CommonModelElement getImportConfiguration(PsiClass candidate, PsiClass importedPsiClass) {
        SpringImport springImport = (SpringImport)SemService.getSemService((Project)candidate.getProject()).getSemElement(SpringImport.IMPORT_JAM_KEY, (PsiElement)candidate);
        if (springImport != null && springImport.getImportedClasses().contains(importedPsiClass)) {
            return springImport;
        }
        return null;
    }

    private static /* synthetic */ boolean lambda$getImportConfigurations$10(List result2, PsiClass psiClass, CommonSpringModel m, Processor p) {
        if (m instanceof LocalAnnotationModel) {
            PsiClass configClass = ((LocalAnnotationModel)m).getConfig();
            ContainerUtil.addIfNotNull((Collection)result2, (Object)SpringBeanAnnotator.getImportConfiguration(configClass, psiClass));
            for (PsiClass superClass : InheritanceUtil.getSuperClasses((PsiClass)configClass)) {
                if ("java.lang.Object".equals(superClass.getQualifiedName())) continue;
                ContainerUtil.addIfNotNull((Collection)result2, (Object)SpringBeanAnnotator.getImportConfiguration(superClass, psiClass));
            }
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 15, 16, 17, 18, 19, 20 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/gutter/SpringBeanAnnotator";
                break;
            }
            case 1: 
            case 5: 
            case 8: 
            case 11: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uClass";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identifier";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 6: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uElement";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiIdentifier";
                break;
            }
            case 16: 
            case 17: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uMethod";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/gutter/SpringBeanAnnotator";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getAnnotationsInDumbMode";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "annotateClass";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "collectSlowLineMarkers";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "annotateInSmartMode";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "annotateInDumbMode";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getAnnotationsInDumbMode";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "annotateExtensions";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "looksLikeStereotypeBean";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isXmlMappedBean";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "annotateMethod";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getImportConfigurations";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 15, 16, 17, 18, 19, 20 -> new IllegalArgumentException(string);
        };
    }
}

