/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.gutter;

import com.intellij.codeInsight.daemon.RelatedItemLineMarkerInfo;
import com.intellij.codeInsight.navigation.DomNavigationUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PropertyUtilBase;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.spring.SpringApiIcons;
import com.intellij.spring.SpringBundle;
import com.intellij.spring.SpringModelVisitorUtils;
import com.intellij.spring.gutter.SpringAnnotatorBase;
import com.intellij.spring.gutter.SpringBeansPsiElementCellRenderer;
import com.intellij.spring.gutter.groups.SpringGutterIconBuilder;
import com.intellij.spring.java.SpringJavaClassInfo;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.model.utils.SpringModelUtils;
import com.intellij.spring.model.xml.beans.SpringBean;
import com.intellij.spring.model.xml.beans.SpringProperty;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericAttributeValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UElementKt;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UastUtils;

public final class SpringPropertiesAnnotator
extends SpringAnnotatorBase {
    public String getId() {
        return "SpringPropertiesAnnotator";
    }

    public String getName() {
        return SpringBundle.message("spring.core.properties.annotator.name", new Object[0]);
    }

    @NotNull
    public Icon getIcon() {
        Icon icon = SpringApiIcons.Gutter.SpringProperty;
        if (icon == null) {
            SpringPropertiesAnnotator.$$$reportNull$$$0(0);
        }
        return icon;
    }

    @Override
    protected void collectNavigationMarkers(@NotNull PsiElement psiElement, @NotNull Collection<? super RelatedItemLineMarkerInfo<?>> result2) {
        UElement element;
        if (psiElement == null) {
            SpringPropertiesAnnotator.$$$reportNull$$$0(1);
        }
        if (result2 == null) {
            SpringPropertiesAnnotator.$$$reportNull$$$0(2);
        }
        if ((element = UastUtils.getUParentForIdentifier((PsiElement)psiElement)) instanceof UClass) {
            UClass uClass = (UClass)element;
            PsiClass psiClass = (PsiClass)UElementKt.getAsJavaPsiElement((UElement)uClass, PsiClass.class);
            if (psiClass == null || !SpringCommonUtils.isSpringBeanCandidateClass(psiClass)) {
                return;
            }
            this.annotateClass(result2, uClass);
            for (UMethod method : uClass.getMethods()) {
                this.annotateMethod(method, result2);
            }
        }
    }

    private static void addPropertiesGutterIcon(Collection<? super RelatedItemLineMarkerInfo<?>> result2, PsiElement psiIdentifier, NotNullLazyValue<Collection<? extends DomElement>> targets) {
        SpringGutterIconBuilder builder = SpringGutterIconBuilder.createBuilder(SpringApiIcons.Gutter.SpringProperty, DomNavigationUtil.DEFAULT_DOM_CONVERTOR, DomNavigationUtil.DOM_GOTO_RELATED_ITEM_PROVIDER);
        builder.setTargets(targets).setTargetRenderer(SpringBeansPsiElementCellRenderer::new).setPopupTitle(SpringBundle.message("spring.bean.property.navigate.choose.class.title", new Object[0])).setTooltipText(SpringBundle.message("spring.bean.property.tooltip.navigate.declaration", new Object[0]));
        result2.add(builder.createSpringRelatedMergeableLineMarkerInfo(psiIdentifier));
    }

    @Override
    protected void annotateClass(Collection<? super RelatedItemLineMarkerInfo<?>> result2, @NotNull UClass uClass, PsiElement identifier) {
        Module module;
        PsiClass psiClass;
        if (uClass == null) {
            SpringPropertiesAnnotator.$$$reportNull$$$0(3);
        }
        if ((psiClass = (PsiClass)UElementKt.getAsJavaPsiElement((UElement)uClass, PsiClass.class)) == null) {
            return;
        }
        if (!SpringCommonUtils.isStereotypeComponentOrMeta(psiClass) && SpringCommonUtils.isSpringConfigured(module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiClass)) && SpringCommonUtils.hasSpringXmlInResolveScope(psiClass)) {
            SpringJavaClassInfo.MappedBeanInfo info = SpringJavaClassInfo.getSpringJavaClassInfo(psiClass).resolve();
            if (info.isMappedDomBean() || info.isStereotypeJavaBean()) {
                return;
            }
            SpringPropertiesAnnotator.annotatePsiClassSpringPropertyValues(result2, psiClass, identifier, SpringModelVisitorUtils.getConfigFiles(SpringModelUtils.getInstance().getSpringModel((PsiElement)psiClass)));
        }
    }

    @Override
    protected void annotateMethod(@NotNull UMethod umethod, PsiElement identifier, @NotNull Collection<? super RelatedItemLineMarkerInfo<?>> result2) {
        PsiMethod method;
        if (umethod == null) {
            SpringPropertiesAnnotator.$$$reportNull$$$0(4);
        }
        if (result2 == null) {
            SpringPropertiesAnnotator.$$$reportNull$$$0(5);
        }
        if ((method = (PsiMethod)UElementKt.getAsJavaPsiElement((UElement)umethod, PsiMethod.class)) == null) {
            return;
        }
        PsiClass psiClass = method.getContainingClass();
        if (psiClass == null) {
            return;
        }
        if (!SpringCommonUtils.hasSpringXmlInResolveScope(psiClass)) {
            return;
        }
        SpringJavaClassInfo info = SpringJavaClassInfo.getSpringJavaClassInfo(psiClass);
        if (PropertyUtilBase.isSimplePropertySetter((PsiMethod)method) && info.resolve().isMappedProperty(method)) {
            SpringPropertiesAnnotator.addPropertiesGutterIcon(result2, identifier, (NotNullLazyValue<Collection<? extends DomElement>>)NotNullLazyValue.lazy(() -> {
                String propertyName = PropertyUtilBase.getPropertyNameBySetter((PsiMethod)method);
                return SpringJavaClassInfo.getSpringJavaClassInfo(psiClass).resolve().getMappedProperties(propertyName);
            }));
        }
    }

    private static void annotatePsiClassSpringPropertyValues(@NotNull Collection<? super RelatedItemLineMarkerInfo<?>> result2, @NotNull PsiClass psiClass, @NotNull PsiElement identifier, @NotNull Set<? extends PsiFile> xmlConfigFiles) {
        if (result2 == null) {
            SpringPropertiesAnnotator.$$$reportNull$$$0(6);
        }
        if (psiClass == null) {
            SpringPropertiesAnnotator.$$$reportNull$$$0(7);
        }
        if (identifier == null) {
            SpringPropertiesAnnotator.$$$reportNull$$$0(8);
        }
        if (xmlConfigFiles == null) {
            SpringPropertiesAnnotator.$$$reportNull$$$0(9);
        }
        if (DumbService.isDumb((Project)psiClass.getProject())) {
            return;
        }
        if (xmlConfigFiles.isEmpty()) {
            return;
        }
        List values = Collections.synchronizedList(new ArrayList());
        List springFiles = ContainerUtil.mapNotNull(xmlConfigFiles, psiFile -> psiFile instanceof XmlFile ? psiFile.getVirtualFile() : null);
        ReferencesSearch.search((PsiElement)psiClass, (SearchScope)GlobalSearchScope.filesScope((Project)psiClass.getProject(), (Collection)springFiles)).forEach(psiReference -> {
            SpringProperty value;
            DomElement domElement;
            PsiElement element = psiReference.getElement();
            if (element instanceof XmlElement && (domElement = DomUtil.getDomElement((PsiElement)element)) != null && !SpringPropertiesAnnotator.isAnonymousBeanClass(domElement) && (value = (SpringProperty)domElement.getParentOfType(SpringProperty.class, false)) != null) {
                values.add(value);
            }
            return true;
        });
        if (!values.isEmpty()) {
            SpringPropertiesAnnotator.addPropertiesGutterIcon(result2, identifier, (NotNullLazyValue<Collection<? extends DomElement>>)NotNullLazyValue.lazy(() -> values));
        }
    }

    private static boolean isAnonymousBeanClass(DomElement domElement) {
        GenericAttributeValue genericAttributeValue = (GenericAttributeValue)domElement.getParentOfType(GenericAttributeValue.class, false);
        if (genericAttributeValue != null && "class".equals(genericAttributeValue.getXmlElementName())) {
            return genericAttributeValue.getParent() instanceof SpringBean;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6, 7, 8, 9 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/gutter/SpringPropertiesAnnotator";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 2: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uClass";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "umethod";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identifier";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "xmlConfigFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/gutter/SpringPropertiesAnnotator";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "collectNavigationMarkers";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "annotateClass";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "annotateMethod";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "annotatePsiClassSpringPropertyValues";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 6, 7, 8, 9 -> new IllegalArgumentException(string);
        };
    }
}

