/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.xml.XmlFile;
import com.intellij.spring.SpringLocalModelFactory;
import com.intellij.spring.SpringLocalModelProducer;
import com.intellij.spring.SpringModificationTrackersManager;
import com.intellij.spring.contexts.model.LocalAnnotationModel;
import com.intellij.spring.contexts.model.LocalAnnotationModelImpl;
import com.intellij.spring.contexts.model.LocalXmlModel;
import com.intellij.spring.contexts.model.LocalXmlModelImpl;
import com.intellij.spring.dom.SpringDomUtils;
import com.intellij.spring.model.utils.SpringProfileUtils;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SpringLocalModelFactoryImpl
extends SpringLocalModelFactory {
    private static final Logger LOG = Logger.getInstance(SpringLocalModelFactoryImpl.class);
    private static final Key<CachedValue<Map<Pair<Module, String>, LocalXmlModel>>> LOCAL_XML_MODEL_KEY = Key.create((String)"LOCAL_XML_MODEL_KEY");
    private static final Key<CachedValue<Map<Pair<Module, String>, LocalAnnotationModel>>> LOCAL_ANNO_MODEL_KEY = Key.create((String)"LOCAL_ANN_MODEL_KEY");
    private static final Key<CachedValue<Map<Pair<Module, String>, LocalAnnotationModel>>> LOCAL_ANNO_TEST_MODEL_KEY = Key.create((String)"LOCAL_ANNO_TEST_MODEL_KEY");

    @Override
    @Nullable
    public LocalXmlModel getOrCreateLocalXmlModel(@NotNull XmlFile configFile, @NotNull Module module, @Nullable Set<String> activeProfiles) {
        if (configFile == null) {
            SpringLocalModelFactoryImpl.$$$reportNull$$$0(0);
        }
        if (module == null) {
            SpringLocalModelFactoryImpl.$$$reportNull$$$0(1);
        }
        if (module.isDisposed()) {
            return null;
        }
        if (!SpringDomUtils.isSpringXml(configFile)) {
            return null;
        }
        Map localXmlModelsMap = (Map)CachedValuesManager.getManager((Project)module.getProject()).getCachedValue((UserDataHolder)configFile, LOCAL_XML_MODEL_KEY, () -> {
            ConcurrentMap result2 = ConcurrentFactoryMap.createMap(cacheKey -> {
                Set<String> profiles = SpringLocalModelFactoryImpl.getProfilesFromString((String)cacheKey.second);
                return new LocalXmlModelImpl(configFile, (Module)cacheKey.first, profiles);
            });
            return CachedValueProvider.Result.create((Object)result2, (Object[])SpringLocalModelFactoryImpl.getLocalXmlModelDependencies(configFile));
        }, false);
        Pair key = Pair.create((Object)module, (Object)SpringProfileUtils.profilesAsString(activeProfiles));
        return (LocalXmlModel)localXmlModelsMap.get(key);
    }

    @Override
    @Nullable
    public LocalAnnotationModel getOrCreateLocalAnnotationModel(@NotNull PsiClass psiClass, @NotNull Module module, @NotNull Set<String> activeProfiles, boolean testContext) {
        if (psiClass == null) {
            SpringLocalModelFactoryImpl.$$$reportNull$$$0(2);
        }
        if (module == null) {
            SpringLocalModelFactoryImpl.$$$reportNull$$$0(3);
        }
        if (activeProfiles == null) {
            SpringLocalModelFactoryImpl.$$$reportNull$$$0(4);
        }
        if (module.isDisposed() || !psiClass.isValid()) {
            return null;
        }
        Map<Pair<Module, String>, LocalAnnotationModel> cachedMap = testContext ? SpringLocalModelFactoryImpl.getTestContextLocalModelsCachedMap(psiClass, module) : SpringLocalModelFactoryImpl.getLocalModesCachedMap(psiClass, module);
        Pair key = Pair.create((Object)module, (Object)SpringProfileUtils.profilesAsString(activeProfiles));
        return cachedMap.get(key);
    }

    private static Map<Pair<Module, String>, LocalAnnotationModel> getLocalModesCachedMap(@NotNull PsiClass psiClass, @NotNull Module module) {
        if (psiClass == null) {
            SpringLocalModelFactoryImpl.$$$reportNull$$$0(5);
        }
        if (module == null) {
            SpringLocalModelFactoryImpl.$$$reportNull$$$0(6);
        }
        return (Map)CachedValuesManager.getManager((Project)module.getProject()).getCachedValue((UserDataHolder)psiClass, LOCAL_ANNO_MODEL_KEY, () -> CachedValueProvider.Result.create(SpringLocalModelFactoryImpl.createLocalModelsMap(psiClass, false), (Object[])SpringLocalModelFactoryImpl.getLocalAnnotationModelDependencies(psiClass)), false);
    }

    private static Map<Pair<Module, String>, LocalAnnotationModel> getTestContextLocalModelsCachedMap(@NotNull PsiClass psiClass, @NotNull Module module) {
        if (psiClass == null) {
            SpringLocalModelFactoryImpl.$$$reportNull$$$0(7);
        }
        if (module == null) {
            SpringLocalModelFactoryImpl.$$$reportNull$$$0(8);
        }
        return (Map)CachedValuesManager.getManager((Project)module.getProject()).getCachedValue((UserDataHolder)psiClass, LOCAL_ANNO_TEST_MODEL_KEY, () -> CachedValueProvider.Result.create(SpringLocalModelFactoryImpl.createLocalModelsMap(psiClass, true), (Object[])SpringLocalModelFactoryImpl.getLocalAnnotationModelDependencies(psiClass)), false);
    }

    @NotNull
    private static Map<Pair<Module, String>, LocalAnnotationModel> createLocalModelsMap(@NotNull PsiClass psiClass, boolean testContext) {
        if (psiClass == null) {
            SpringLocalModelFactoryImpl.$$$reportNull$$$0(9);
        }
        ConcurrentMap concurrentMap = ConcurrentFactoryMap.createMap(cacheKey -> {
            SpringLocalModelFactoryImpl.checkValidConfigClass(psiClass);
            Set<String> profiles = Collections.unmodifiableSet(SpringLocalModelFactoryImpl.getProfilesFromString((String)cacheKey.second));
            for (SpringLocalModelProducer localModelProducer : SpringLocalModelProducer.EP_NAME.getExtensionList()) {
                LocalAnnotationModel customLocalModel = localModelProducer.create(psiClass, (Module)cacheKey.first, profiles, testContext);
                if (customLocalModel == null) continue;
                return customLocalModel;
            }
            return new LocalAnnotationModelImpl(psiClass, (Module)cacheKey.first, profiles, testContext);
        });
        if (concurrentMap == null) {
            SpringLocalModelFactoryImpl.$$$reportNull$$$0(10);
        }
        return concurrentMap;
    }

    private static void checkValidConfigClass(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            SpringLocalModelFactoryImpl.$$$reportNull$$$0(11);
        }
        if (psiClass instanceof PsiTypeParameter || psiClass.getQualifiedName() == null || PsiUtil.isLocalOrAnonymousClass((PsiClass)psiClass)) {
            LOG.error("invalid config class: " + String.valueOf(psiClass) + " in " + psiClass.getContainingFile().getVirtualFile().getPath());
        }
    }

    @NotNull
    public static Set<String> getProfilesFromString(String key) {
        if (key.isEmpty()) {
            Set<String> set = Collections.emptySet();
            if (set == null) {
                SpringLocalModelFactoryImpl.$$$reportNull$$$0(12);
            }
            return set;
        }
        Set set = ContainerUtil.map2Set((Collection)StringUtil.split((String)key, (String)","), StringUtil::trim);
        if (set == null) {
            SpringLocalModelFactoryImpl.$$$reportNull$$$0(13);
        }
        return set;
    }

    public static Object @NotNull [] getLocalXmlModelDependencies(@NotNull XmlFile psiFile) {
        if (psiFile == null) {
            SpringLocalModelFactoryImpl.$$$reportNull$$$0(14);
        }
        Project project = psiFile.getProject();
        SpringModificationTrackersManager springModificationTrackersManager = SpringModificationTrackersManager.getInstance(project);
        Object[] dependencies = springModificationTrackersManager.getOuterModelsDependencies();
        dependencies = ArrayUtil.append((Object[])dependencies, (Object)psiFile);
        if ((dependencies = ArrayUtil.append((Object[])dependencies, (Object)springModificationTrackersManager.getCustomBeanParserModificationTracker())) == null) {
            SpringLocalModelFactoryImpl.$$$reportNull$$$0(15);
        }
        return dependencies;
    }

    private static Object @NotNull [] getLocalAnnotationModelDependencies(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            SpringLocalModelFactoryImpl.$$$reportNull$$$0(16);
        }
        Object[] objectArray = ArrayUtil.prepend((Object)psiClass, (Object[])SpringModificationTrackersManager.getInstance(psiClass.getProject()).getOuterModelsDependencies());
        if (objectArray == null) {
            SpringLocalModelFactoryImpl.$$$reportNull$$$0(17);
        }
        return objectArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 10, 12, 13, 15, 17 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configFile";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "activeProfiles";
                break;
            }
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/impl/SpringLocalModelFactoryImpl";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/impl/SpringLocalModelFactoryImpl";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createLocalModelsMap";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getProfilesFromString";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocalXmlModelDependencies";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocalAnnotationModelDependencies";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateLocalXmlModel";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateLocalAnnotationModel";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getLocalModesCachedMap";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getTestContextLocalModelsCachedMap";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createLocalModelsMap";
                break;
            }
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 17: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "checkValidConfigClass";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getLocalXmlModelDependencies";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getLocalAnnotationModelDependencies";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 10, 12, 13, 15, 17 -> new IllegalStateException(string);
        };
    }
}

