/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.actions;

import com.intellij.codeInsight.CodeInsightActionHandler;
import com.intellij.codeInsight.generation.actions.BaseGenerateAction;
import com.intellij.jam.model.util.JamCommonUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.xml.XmlFile;
import com.intellij.spring.SpringApiIcons;
import com.intellij.spring.dom.SpringDomUtils;
import com.intellij.spring.facet.SpringFacet;
import com.intellij.spring.facet.SpringFileSet;
import com.intellij.spring.facet.SpringFileSetService;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UastUtils;

public abstract class GenerateSpringBeanDependencyAction
extends BaseGenerateAction {
    public GenerateSpringBeanDependencyAction(CodeInsightActionHandler handler, @NotNull Supplier<String> text) {
        if (text == null) {
            GenerateSpringBeanDependencyAction.$$$reportNull$$$0(0);
        }
        super(handler);
        this.getTemplatePresentation().setText(text);
        this.getTemplatePresentation().setIcon(SpringApiIcons.Spring);
    }

    protected boolean isValidForFile(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile psiFile) {
        if (project == null) {
            GenerateSpringBeanDependencyAction.$$$reportNull$$$0(1);
        }
        if (editor == null) {
            GenerateSpringBeanDependencyAction.$$$reportNull$$$0(2);
        }
        if (psiFile == null) {
            GenerateSpringBeanDependencyAction.$$$reportNull$$$0(3);
        }
        if (psiFile instanceof PsiCompiledElement) {
            return false;
        }
        PsiClass psiClass = this.getTargetClass(editor, psiFile);
        if (psiClass == null || psiClass.isInterface() || psiClass.isEnum() || psiClass.getQualifiedName() == null) {
            return false;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiClass);
        return module != null && this.checkContext(module) && this.acceptPsiClass(psiClass);
    }

    @Nullable
    protected PsiClass getTargetClass(Editor editor, PsiFile file) {
        int offset = editor.getCaretModel().getOffset();
        PsiElement element = file.findElementAt(offset);
        UClass uClass = (UClass)UastUtils.findContaining((PsiElement)element, UClass.class);
        return uClass != null ? uClass.getJavaPsi() : null;
    }

    protected boolean checkContext(@NotNull Module module) {
        if (module == null) {
            GenerateSpringBeanDependencyAction.$$$reportNull$$$0(4);
        }
        if (this.isXmlBasedAction()) {
            SpringFacet facet = SpringFacet.getInstance(module);
            if (facet != null) {
                for (SpringFileSet set : SpringFileSetService.getInstance().getAllSets(facet)) {
                    for (VirtualFilePointer pointer : set.getFiles()) {
                        PsiFile psiFile;
                        VirtualFile virtualFile = pointer.getFile();
                        if (virtualFile == null || ProjectRootManager.getInstance((Project)module.getProject()).getFileIndex().isInLibraryClasses(virtualFile) || !JamCommonUtil.isPlainXmlFile((PsiElement)(psiFile = PsiManager.getInstance((Project)module.getProject()).findFile(virtualFile))) || !SpringDomUtils.isSpringXml((XmlFile)psiFile)) continue;
                        return true;
                    }
                }
            }
            return false;
        }
        return true;
    }

    protected boolean isXmlBasedAction() {
        return true;
    }

    protected boolean acceptPsiClass(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            GenerateSpringBeanDependencyAction.$$$reportNull$$$0(5);
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
        }
        objectArray2[1] = "com/intellij/spring/model/actions/GenerateSpringBeanDependencyAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isValidForFile";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "checkContext";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "acceptPsiClass";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

