/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.cacheable.highlighting;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.jam.JamService;
import com.intellij.jam.reflect.JamMemberMeta;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.semantic.SemService;
import com.intellij.spring.SpringBundle;
import com.intellij.spring.model.cacheable.jam.SpringCachingGroupsForClass;
import com.intellij.spring.model.cacheable.jam.SpringCachingGroupsForMethod;
import com.intellij.spring.model.cacheable.jam.SpringJamBaseCacheableElement;
import com.intellij.spring.model.cacheable.jam.standard.SpringJamCachingGroup;
import com.intellij.spring.model.highlighting.jam.SpringBeanPointerResolveInspection;
import com.intellij.spring.model.highlighting.providers.SpringAspectJModeSeacherKt;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SpringCacheableComponentsInspection
extends SpringBeanPointerResolveInspection {
    public ProblemDescriptor @Nullable [] checkMethod(@NotNull PsiMethod method, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (method == null) {
            SpringCacheableComponentsInspection.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            SpringCacheableComponentsInspection.$$$reportNull$$$0(1);
        }
        if (SpringCacheableComponentsInspection.isPlainJavaFileInSpringModule((PsiElement)method)) {
            ProblemsHolder holder = new ProblemsHolder(manager, method.getContainingFile(), isOnTheFly);
            List elements = SemService.getSemService((Project)method.getProject()).getSemElements(SpringJamBaseCacheableElement.CACHEABLE_BASE_JAM_KEY, (PsiElement)method);
            for (SpringJamBaseCacheableElement cacheable : elements) {
                PsiAnnotation annotation;
                if (!method.getModifierList().hasModifierProperty("public") && (annotation = cacheable.getAnnotation()) != null && !SpringAspectJModeSeacherKt.hasAspectJCachingMode(ModuleUtilCore.findModuleForPsiElement((PsiElement)method))) {
                    holder.registerProblem((PsiElement)annotation, SpringBundle.message("cacheable.annotations.should.be.defined.on.public.methods", new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[0]);
                }
                SpringCacheableComponentsInspection.checkBeansResolve(cacheable, holder);
            }
            this.checkCachingGroups(holder, (SpringJamCachingGroup)JamService.getJamService((Project)method.getProject()).getJamElement((PsiElement)method, new JamMemberMeta[]{SpringCachingGroupsForMethod.META}));
            return holder.getResultsArray();
        }
        return null;
    }

    public ProblemDescriptor @Nullable [] checkClass(@NotNull PsiClass aClass, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (aClass == null) {
            SpringCacheableComponentsInspection.$$$reportNull$$$0(2);
        }
        if (manager == null) {
            SpringCacheableComponentsInspection.$$$reportNull$$$0(3);
        }
        if (SpringCacheableComponentsInspection.isPlainJavaFileInSpringModule((PsiElement)aClass)) {
            ProblemsHolder holder = new ProblemsHolder(manager, aClass.getContainingFile(), isOnTheFly);
            List elements = SemService.getSemService((Project)aClass.getProject()).getSemElements(SpringJamBaseCacheableElement.CACHEABLE_BASE_JAM_KEY, (PsiElement)aClass);
            for (SpringJamBaseCacheableElement cacheable : elements) {
                SpringCacheableComponentsInspection.checkBeansResolve(cacheable, holder);
            }
            this.checkCachingGroups(holder, (SpringJamCachingGroup)JamService.getJamService((Project)aClass.getProject()).getJamElement((PsiElement)aClass, new JamMemberMeta[]{SpringCachingGroupsForClass.META}));
            return holder.getResultsArray();
        }
        return null;
    }

    public void checkCachingGroups(@NotNull ProblemsHolder holder, @Nullable SpringJamCachingGroup<? extends PsiMember> cachingGroups) {
        if (holder == null) {
            SpringCacheableComponentsInspection.$$$reportNull$$$0(4);
        }
        if (cachingGroups != null) {
            for (SpringJamBaseCacheableElement springJamBaseCacheableElement : cachingGroups.getCacheables()) {
                SpringCacheableComponentsInspection.checkBeansResolve(springJamBaseCacheableElement, holder);
            }
            for (SpringJamBaseCacheableElement springJamBaseCacheableElement : cachingGroups.getCachePuts()) {
                SpringCacheableComponentsInspection.checkBeansResolve(springJamBaseCacheableElement, holder);
            }
            for (SpringJamBaseCacheableElement springJamBaseCacheableElement : cachingGroups.getCacheEvict()) {
                SpringCacheableComponentsInspection.checkBeansResolve(springJamBaseCacheableElement, holder);
            }
        }
    }

    private static void checkBeansResolve(@NotNull SpringJamBaseCacheableElement cacheable, @NotNull ProblemsHolder holder) {
        if (cacheable == null) {
            SpringCacheableComponentsInspection.$$$reportNull$$$0(5);
        }
        if (holder == null) {
            SpringCacheableComponentsInspection.$$$reportNull$$$0(6);
        }
        SpringCacheableComponentsInspection.checkBeanPointerResolve(holder, cacheable.getCacheManagerElement());
        SpringCacheableComponentsInspection.checkBeanPointerResolve(holder, cacheable.getCacheResolverElement());
        SpringCacheableComponentsInspection.checkBeanPointerResolve(holder, cacheable.getKeyGeneratorElement());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cacheable";
                break;
            }
        }
        objectArray2[1] = "com/intellij/spring/model/cacheable/highlighting/SpringCacheableComponentsInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "checkMethod";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "checkClass";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "checkCachingGroups";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "checkBeansResolve";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

