/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.cacheable.jam;

import com.intellij.jam.JamElement;
import com.intellij.jam.JamService;
import com.intellij.jam.reflect.JamAnnotationMeta;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementRef;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiNamedElement;
import com.intellij.semantic.SemKey;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SpringJamCacheableElement<T extends PsiMember & PsiNamedElement>
implements JamElement {
    public static final SemKey<SpringJamCacheableElement> CACHEABLE_ROOT_JAM_KEY = JamService.JAM_ELEMENT_KEY.subKey("SpringJamCacheableElement", new SemKey[0]);
    private final JamAnnotationMeta myMeta;
    private final PsiElementRef<PsiAnnotation> myPsiAnnotationRef;
    private static final Map<String, JamAnnotationMeta> annotationMetaMap = new HashMap<String, JamAnnotationMeta>();

    public SpringJamCacheableElement(@NotNull PsiElementRef<?> psiRef, @NotNull String annoName) {
        if (psiRef == null) {
            SpringJamCacheableElement.$$$reportNull$$$0(0);
        }
        if (annoName == null) {
            SpringJamCacheableElement.$$$reportNull$$$0(1);
        }
        this((PsiMember)Objects.requireNonNull(psiRef.getPsiElement()), annoName);
    }

    public SpringJamCacheableElement(@NotNull T psiMember, @NotNull String annoName) {
        if (psiMember == null) {
            SpringJamCacheableElement.$$$reportNull$$$0(2);
        }
        if (annoName == null) {
            SpringJamCacheableElement.$$$reportNull$$$0(3);
        }
        this.myMeta = SpringJamCacheableElement.getMeta(annoName);
        this.myPsiAnnotationRef = this.myMeta.getAnnotationRef(psiMember);
    }

    public SpringJamCacheableElement(@NotNull PsiAnnotation annotation) {
        if (annotation == null) {
            SpringJamCacheableElement.$$$reportNull$$$0(4);
        }
        String qualifiedName = annotation.getQualifiedName();
        assert (qualifiedName != null);
        this.myMeta = SpringJamCacheableElement.getMeta(qualifiedName);
        this.myPsiAnnotationRef = PsiElementRef.real((PsiElement)annotation);
    }

    @NotNull
    private static synchronized JamAnnotationMeta getMeta(@NotNull String anno) {
        JamAnnotationMeta meta;
        if (anno == null) {
            SpringJamCacheableElement.$$$reportNull$$$0(5);
        }
        if ((meta = annotationMetaMap.get(anno)) == null) {
            meta = new JamAnnotationMeta(anno);
            annotationMetaMap.put(anno, meta);
        }
        JamAnnotationMeta jamAnnotationMeta = meta;
        if (jamAnnotationMeta == null) {
            SpringJamCacheableElement.$$$reportNull$$$0(6);
        }
        return jamAnnotationMeta;
    }

    @NotNull
    public JamAnnotationMeta getAnnotationMeta() {
        JamAnnotationMeta jamAnnotationMeta = this.myMeta;
        if (jamAnnotationMeta == null) {
            SpringJamCacheableElement.$$$reportNull$$$0(7);
        }
        return jamAnnotationMeta;
    }

    @Nullable
    public final PsiAnnotation getAnnotation() {
        return (PsiAnnotation)this.getPsiAnnotationRef().getPsiElement();
    }

    protected PsiElementRef<PsiAnnotation> getPsiAnnotationRef() {
        return this.myPsiAnnotationRef;
    }

    @NotNull
    public abstract Set<String> getCacheNames();

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SpringJamCacheableElement element = (SpringJamCacheableElement)o;
        return Objects.equals(this.myMeta, element.myMeta) && Objects.equals(this.myPsiAnnotationRef, element.myPsiAnnotationRef);
    }

    public int hashCode() {
        return Objects.hash(this.myMeta, this.myPsiAnnotationRef);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiRef";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annoName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiMember";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotation";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anno";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/model/cacheable/jam/SpringJamCacheableElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/model/cacheable/jam/SpringJamCacheableElement";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getMeta";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getAnnotationMeta";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getMeta";
                break;
            }
            case 6: 
            case 7: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 7 -> new IllegalStateException(string);
        };
    }
}

