/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.highlighting.jam;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.ide.highlighter.XmlFileType;
import com.intellij.jam.model.util.JamCommonUtil;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PropertyUtilBase;
import com.intellij.spring.SpringBundle;
import com.intellij.spring.SpringLibraryUtil;
import com.intellij.spring.SpringManager;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.java.SpringJavaClassInfo;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.highlighting.jam.SpringJavaInspectionBase;
import com.intellij.spring.model.utils.SpringAutowireUtil;
import com.intellij.spring.model.utils.SpringBeanCoreUtils;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.model.xml.DomSpringBean;
import com.intellij.spring.model.xml.DomSpringBeanPointer;
import com.intellij.spring.model.xml.beans.SpringBean;
import com.intellij.spring.model.xml.beans.SpringProperty;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SpringRequiredAnnotationInspection
extends SpringJavaInspectionBase {
    public ProblemDescriptor[] checkMethod(@NotNull PsiMethod method, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (method == null) {
            SpringRequiredAnnotationInspection.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            SpringRequiredAnnotationInspection.$$$reportNull$$$0(1);
        }
        if (!SpringLibraryUtil.hasSpringLibrary(manager.getProject())) {
            return null;
        }
        if (!PropertyUtilBase.isSimplePropertySetter((PsiMethod)method)) {
            return null;
        }
        PsiClass psiClass = method.getContainingClass();
        if (psiClass == null) {
            return null;
        }
        if (!JamCommonUtil.isPlainJavaFile((PsiElement)method.getContainingFile())) {
            return null;
        }
        if (!AnnotationUtil.isAnnotated((PsiModifierListOwner)method, (String)"org.springframework.beans.factory.annotation.Required", (int)0)) {
            return null;
        }
        if (!SpringCommonUtils.isSpringBeanCandidateClass(psiClass)) {
            return null;
        }
        SpringJavaClassInfo.MappedBeanInfo info = SpringJavaClassInfo.getSpringJavaClassInfo(psiClass).resolve();
        if (!info.isMapped()) {
            return null;
        }
        final String propertyName = PropertyUtilBase.getPropertyNameBySetter((PsiMethod)method);
        final PsiType propertyType = PropertyUtilBase.getPropertyType((PsiMember)method);
        if (!info.getMappedProperties(propertyName).isEmpty() || info.isAutowired() || SpringRequiredAnnotationInspection.isAutowiredByDefault(method)) {
            return null;
        }
        List<DomSpringBeanPointer> list = info.getMappedDomBeans();
        final ArrayList<SpringBean> beans = new ArrayList<SpringBean>(list.size());
        for (DomSpringBeanPointer pointer : list) {
            DomSpringBean springBean = (DomSpringBean)pointer.getSpringBean();
            if (!(springBean instanceof SpringBean) || ((SpringBean)springBean).isAbstract()) continue;
            beans.add((SpringBean)springBean);
        }
        if (beans.isEmpty()) {
            return null;
        }
        LocalQuickFix fix2 = new LocalQuickFix(){

            @NotNull
            public String getName() {
                String string = SpringBundle.message("create.missing.mappings", propertyName);
                if (string == null) {
                    1.$$$reportNull$$$0(0);
                }
                return string;
            }

            @NotNull
            public String getFamilyName() {
                String string = SpringBundle.message("create.missing.mappings.family.name", new Object[0]);
                if (string == null) {
                    1.$$$reportNull$$$0(1);
                }
                return string;
            }

            public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
                if (project == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (descriptor == null) {
                    1.$$$reportNull$$$0(3);
                }
                HashSet<VirtualFile> files = new HashSet<VirtualFile>();
                for (SpringBean bean : beans) {
                    if (!bean.isValid()) continue;
                    files.add(bean.getContainingFile().getVirtualFile());
                }
                if (!ReadonlyStatusHandler.getInstance((Project)project).ensureFilesWritable(files).hasReadonlyFiles()) {
                    for (SpringBean bean : beans) {
                        if (!bean.isValid()) continue;
                        SpringProperty springProperty = bean.addProperty();
                        springProperty.getName().setStringValue(propertyName);
                        SpringRequiredAnnotationInspection.this.setPropertyValue(project, bean, springProperty, propertyType);
                    }
                }
            }

            @NotNull
            public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull ProblemDescriptor previewDescriptor) {
                if (project == null) {
                    1.$$$reportNull$$$0(4);
                }
                if (previewDescriptor == null) {
                    1.$$$reportNull$$$0(5);
                }
                StringBuilder sb = new StringBuilder();
                sb.append("<property name=\"");
                sb.append(propertyName);
                sb.append("\"");
                if (propertyType != null) {
                    sb.append(" ref=\"..\"");
                } else {
                    sb.append(" value=\"..\"");
                }
                sb.append(" />");
                return new IntentionPreviewInfo.CustomDiff((FileType)XmlFileType.INSTANCE, "", sb.toString());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 2;
                    case 2, 3, 4, 5 -> 3;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/spring/model/highlighting/jam/SpringRequiredAnnotationInspection$1";
                        break;
                    }
                    case 2: 
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "project";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "descriptor";
                        break;
                    }
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "previewDescriptor";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getName";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getFamilyName";
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/spring/model/highlighting/jam/SpringRequiredAnnotationInspection$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "applyFix";
                        break;
                    }
                    case 4: 
                    case 5: {
                        objectArray = objectArray;
                        objectArray[2] = "generatePreview";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalStateException(string);
                    case 2, 3, 4, 5 -> new IllegalArgumentException(string);
                };
            }
        };
        PsiIdentifier psiIdentifier = method.getNameIdentifier();
        assert (psiIdentifier != null);
        ProblemDescriptor descriptor = manager.createProblemDescriptor((PsiElement)psiIdentifier, SpringBundle.message("required.property.not.mapped", propertyName), fix2, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, isOnTheFly);
        return new ProblemDescriptor[]{descriptor};
    }

    public void setPropertyValue(@NotNull Project project, @NotNull SpringBean bean, @NotNull SpringProperty springProperty, @Nullable PsiType propertyType) {
        List<SpringBeanPointer<?>> beansByType;
        SpringModel modelByFile;
        if (project == null) {
            SpringRequiredAnnotationInspection.$$$reportNull$$$0(2);
        }
        if (bean == null) {
            SpringRequiredAnnotationInspection.$$$reportNull$$$0(3);
        }
        if (springProperty == null) {
            SpringRequiredAnnotationInspection.$$$reportNull$$$0(4);
        }
        if (propertyType != null && (modelByFile = SpringManager.getInstance(project).getSpringModelByFile(bean.getContainingFile())) != null && !(beansByType = SpringBeanCoreUtils.getBeansByType(propertyType, modelByFile)).isEmpty()) {
            springProperty.getRefAttr().setStringValue(beansByType.size() == 1 ? beansByType.get(0).getName() : "");
            return;
        }
        springProperty.getValueAttr().setStringValue("");
    }

    private static boolean isAutowiredByDefault(@NotNull PsiMethod method) {
        PsiType psiType;
        if (method == null) {
            SpringRequiredAnnotationInspection.$$$reportNull$$$0(5);
        }
        return (psiType = PropertyUtilBase.getPropertyType((PsiMember)method)) != null && SpringAutowireUtil.isAutowiredByDefault(psiType);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bean";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "springProperty";
                break;
            }
        }
        objectArray2[1] = "com/intellij/spring/model/highlighting/jam/SpringRequiredAnnotationInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "checkMethod";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "setPropertyValue";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "isAutowiredByDefault";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

