/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.highlighting.xml;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.spring.SpringBundle;
import com.intellij.spring.SpringManager;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.facet.SpringFileSet;
import com.intellij.spring.model.utils.SpringProfileUtils;
import com.intellij.spring.model.xml.beans.Beans;
import com.intellij.spring.profiles.SpringProfilesService;
import com.intellij.util.SmartList;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.highlighting.DomElementsInspection;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SpringInactiveProfileHighlightingInspection
extends DomElementsInspection<Beans> {
    public SpringInactiveProfileHighlightingInspection() {
        super(Beans.class, new Class[0]);
    }

    protected ProblemDescriptor @Nullable [] checkDomFile(@NotNull DomFileElement<Beans> domFileElement, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (domFileElement == null) {
            SpringInactiveProfileHighlightingInspection.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            SpringInactiveProfileHighlightingInspection.$$$reportNull$$$0(1);
        }
        SmartList descriptors = new SmartList();
        XmlFile xmlFile = domFileElement.getFile();
        Beans beans = (Beans)domFileElement.getRootElement();
        SpringModel springModel = SpringManager.getInstance(xmlFile.getProject()).getSpringModelByFile((PsiFile)xmlFile);
        if (springModel != null) {
            Set<String> activeProfiles = springModel.getActiveProfiles();
            if (SpringProfileUtils.isActiveProfile(beans, activeProfiles)) {
                for (Beans innerBeans : beans.getBeansProfiles()) {
                    if (SpringProfileUtils.isActiveProfile(innerBeans, activeProfiles)) continue;
                    descriptors.add(this.createProblem(manager, innerBeans, springModel));
                }
            } else {
                descriptors.add(this.createProblem(manager, beans, springModel));
            }
        }
        return descriptors.toArray(ProblemDescriptor.EMPTY_ARRAY);
    }

    @NotNull
    public ProblemDescriptor createProblem(@NotNull InspectionManager manager, @NotNull Beans beans, @NotNull SpringModel springModel) {
        if (manager == null) {
            SpringInactiveProfileHighlightingInspection.$$$reportNull$$$0(2);
        }
        if (beans == null) {
            SpringInactiveProfileHighlightingInspection.$$$reportNull$$$0(3);
        }
        if (springModel == null) {
            SpringInactiveProfileHighlightingInspection.$$$reportNull$$$0(4);
        }
        ProblemDescriptor problemDescriptor = manager.createProblemDescriptor((PsiElement)beans.getXmlTag(), SpringBundle.message("SpringInactiveProfilesHighlightingPass.inactive.profile", new Object[0]), true, SpringInactiveProfileHighlightingInspection.getFixes(beans.getProfile().getExpressions(), springModel), ProblemHighlightType.LIKE_UNUSED_SYMBOL);
        if (problemDescriptor == null) {
            SpringInactiveProfileHighlightingInspection.$$$reportNull$$$0(5);
        }
        return problemDescriptor;
    }

    private static LocalQuickFix[] getFixes(@NotNull Set<String> names2, @NotNull SpringModel springModel) {
        if (names2 == null) {
            SpringInactiveProfileHighlightingInspection.$$$reportNull$$$0(6);
        }
        if (springModel == null) {
            SpringInactiveProfileHighlightingInspection.$$$reportNull$$$0(7);
        }
        Module module = springModel.getModule();
        SpringFileSet fileSet = springModel.getFileSet();
        if (module == null && fileSet == null) {
            return LocalQuickFix.EMPTY_ARRAY;
        }
        ArrayList<ProfileQuickFix> fixes = new ArrayList<ProfileQuickFix>(names2.size());
        for (String name : names2) {
            if (name.startsWith("!")) {
                fixes.add(new DeactivateProfileQuickFix(name.substring(1), module, fileSet));
                continue;
            }
            fixes.add(new ActivateProfileQuickFix(name, module, fileSet));
        }
        return fixes.toArray(LocalQuickFix.EMPTY_ARRAY);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "domFileElement";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "beans";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "springModel";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/model/highlighting/xml/SpringInactiveProfileHighlightingInspection";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "names";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/model/highlighting/xml/SpringInactiveProfileHighlightingInspection";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createProblem";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "checkDomFile";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createProblem";
                break;
            }
            case 5: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getFixes";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5 -> new IllegalStateException(string);
        };
    }

    private static final class DeactivateProfileQuickFix
    extends ProfileQuickFix {
        DeactivateProfileQuickFix(String name, Module module, SpringFileSet set) {
            super(name, module, set);
        }

        @NotNull
        public String getName() {
            String string = SpringBundle.message("ActivateSpringProfileIntentionAction.deactivate.profile", this.myProfileName);
            if (string == null) {
                DeactivateProfileQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = SpringBundle.message("ActivateSpringProfileIntentionAction.deactivate.profile.family.name", new Object[0]);
            if (string == null) {
                DeactivateProfileQuickFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Override
        protected void changeActiveProfiles(Set<String> activeProfiles) {
            activeProfiles.remove(this.myProfileName);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/spring/model/highlighting/xml/SpringInactiveProfileHighlightingInspection$DeactivateProfileQuickFix";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    private static final class ActivateProfileQuickFix
    extends ProfileQuickFix {
        ActivateProfileQuickFix(String name, Module module, SpringFileSet set) {
            super(name, module, set);
        }

        @NotNull
        public String getName() {
            String string = SpringBundle.message("ActivateSpringProfileIntentionAction.activate.profile", this.myProfileName);
            if (string == null) {
                ActivateProfileQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = SpringBundle.message("ActivateSpringProfileIntentionAction.activate.profile.family.name", new Object[0]);
            if (string == null) {
                ActivateProfileQuickFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Override
        protected void changeActiveProfiles(Set<String> activeProfiles) {
            activeProfiles.add(this.myProfileName);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/spring/model/highlighting/xml/SpringInactiveProfileHighlightingInspection$ActivateProfileQuickFix";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    private static abstract class ProfileQuickFix
    implements LocalQuickFix {
        protected final String myProfileName;
        private final Module myModule;
        private final SpringFileSet myFileSet;

        protected ProfileQuickFix(String name, Module module, SpringFileSet set) {
            this.myProfileName = name;
            this.myModule = module;
            this.myFileSet = set;
        }

        protected abstract void changeActiveProfiles(Set<String> var1);

        public boolean startInWriteAction() {
            return false;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                ProfileQuickFix.$$$reportNull$$$0(0);
            }
            if (descriptor == null) {
                ProfileQuickFix.$$$reportNull$$$0(1);
            }
            HashSet<String> activeProfiles = new HashSet<String>(this.myFileSet == null ? SpringProfilesService.getInstance(this.myModule.getProject()).getActiveProfiles(this.myModule) : this.myFileSet.getActiveProfiles());
            this.changeActiveProfiles(activeProfiles);
            if (this.myFileSet == null) {
                SpringProfilesService.getInstance(this.myModule.getProject()).setActiveProfiles(this.myModule, activeProfiles);
            } else {
                this.myFileSet.setActiveProfiles(activeProfiles);
            }
            SpringProfileUtils.notifyProfilesChanged(project);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "descriptor";
                    break;
                }
            }
            objectArray[1] = "com/intellij/spring/model/highlighting/xml/SpringInactiveProfileHighlightingInspection$ProfileQuickFix";
            objectArray[2] = "applyFix";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

