/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.highlighting.xml;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.xml.XmlElement;
import com.intellij.spring.SpringBundle;
import com.intellij.spring.model.values.converters.resources.ResourceTypeCondition;
import com.intellij.spring.model.values.converters.resources.SpringResourceTypeProvider;
import com.intellij.spring.model.xml.beans.Beans;
import com.intellij.util.ProcessingContext;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.highlighting.BasicDomElementsInspection;
import com.intellij.util.xml.highlighting.DomElementAnnotationHolder;
import com.intellij.util.xml.highlighting.DomHighlightingHelper;
import com.intellij.util.xml.impl.GenericValueReferenceProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SpringIncorrectResourceTypeInspection
extends BasicDomElementsInspection<Beans> {
    private static final GenericValueReferenceProvider ourProvider = new GenericValueReferenceProvider();

    public SpringIncorrectResourceTypeInspection() {
        super(Beans.class, new Class[0]);
    }

    protected boolean shouldCheckResolveProblems(GenericDomValue value) {
        return false;
    }

    protected void checkDomElement(@NotNull DomElement element, @NotNull DomElementAnnotationHolder holder, @NotNull DomHighlightingHelper helper2) {
        if (element == null) {
            SpringIncorrectResourceTypeInspection.$$$reportNull$$$0(0);
        }
        if (holder == null) {
            SpringIncorrectResourceTypeInspection.$$$reportNull$$$0(1);
        }
        if (helper2 == null) {
            SpringIncorrectResourceTypeInspection.$$$reportNull$$$0(2);
        }
        if (element instanceof GenericDomValue) {
            PsiReference[] references;
            GenericDomValue value = (GenericDomValue)element;
            XmlElement valueElement = DomUtil.getValueElement((GenericDomValue)value);
            if (valueElement == null) {
                return;
            }
            Condition<PsiFileSystemItem> filter = SpringIncorrectResourceTypeInspection.findCondition(value);
            if (filter == null) {
                return;
            }
            for (PsiReference reference : references = ourProvider.getReferencesByElement((PsiElement)valueElement, new ProcessingContext())) {
                PsiFileSystemItem psiFileSystemItem;
                if (!(reference instanceof FileReference) || (psiFileSystemItem = ((FileReference)reference).resolve()) == null || psiFileSystemItem.isDirectory() || filter.value((Object)psiFileSystemItem)) continue;
                String expectedExtensions = null;
                if (filter instanceof ResourceTypeCondition) {
                    expectedExtensions = StringUtil.join((String[])((ResourceTypeCondition)filter).getExpectedExtensions(), (String)",");
                }
                holder.createProblem(element, expectedExtensions == null ? SpringBundle.message("SpringIncorrectResourceTypeInspection.incorrect.resource.type", new Object[0]) : SpringBundle.message("SpringIncorrectResourceTypeInspection.expected.resource.types", expectedExtensions), new LocalQuickFix[0]);
            }
        }
    }

    @Nullable
    private static Condition<PsiFileSystemItem> findCondition(GenericDomValue value) {
        for (SpringResourceTypeProvider provider : SpringResourceTypeProvider.EP_NAME.getExtensionList()) {
            Condition<PsiFileSystemItem> filter = provider.getResourceFilter(value);
            if (filter == null) continue;
            return filter;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "element";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "holder";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "helper";
                break;
            }
        }
        objectArray[1] = "com/intellij/spring/model/highlighting/xml/SpringIncorrectResourceTypeInspection";
        objectArray[2] = "checkDomElement";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

