/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.jam;

import com.intellij.jam.JamService;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.spring.SpringModificationTrackersManager;
import com.intellij.spring.model.custom.ComponentScanExtender;
import com.intellij.spring.model.jam.SpringJamModel;
import com.intellij.spring.model.jam.stereotype.CustomSpringComponent;
import com.intellij.spring.model.jam.stereotype.SpringComponent;
import com.intellij.spring.model.jam.stereotype.SpringConfiguration;
import com.intellij.spring.model.jam.stereotype.SpringController;
import com.intellij.spring.model.jam.stereotype.SpringRepository;
import com.intellij.spring.model.jam.stereotype.SpringService;
import com.intellij.spring.model.jam.stereotype.SpringStereotypeElement;
import com.intellij.spring.model.jam.stereotype.javaee.SpringCdiJakartaNamed;
import com.intellij.spring.model.jam.stereotype.javaee.SpringCdiJavaxNamed;
import com.intellij.spring.model.jam.stereotype.javaee.SpringJakartaManagedBean;
import com.intellij.spring.model.jam.stereotype.javaee.SpringJavaxManagedBean;
import com.intellij.spring.model.jam.utils.JamAnnotationTypeUtil;
import com.intellij.spring.search.SpringGlobalSearchScopes;
import com.intellij.util.SmartList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class SpringJamModelImpl
extends SpringJamModel {
    private final Module myModule;
    private final JamService myJamService;

    public SpringJamModelImpl(@NotNull Module module) {
        if (module == null) {
            SpringJamModelImpl.$$$reportNull$$$0(0);
        }
        this.myModule = module;
        this.myJamService = JamService.getJamService((Project)this.myModule.getProject());
    }

    @Override
    @NotNull
    public List<SpringStereotypeElement> getStereotypeComponents() {
        Project project = this.myModule.getProject();
        if (DumbService.isDumb((Project)project)) {
            List<SpringStereotypeElement> list = Collections.emptyList();
            if (list == null) {
                SpringJamModelImpl.$$$reportNull$$$0(1);
            }
            return list;
        }
        List list = (List)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)this.myModule, () -> {
            List<SpringStereotypeElement> components = this.getStereotypeComponents(SpringGlobalSearchScopes.runtime(this.myModule));
            return CachedValueProvider.Result.create(components, (Object[])SpringModificationTrackersManager.getInstance(project).getOuterModelsDependencies());
        });
        if (list == null) {
            SpringJamModelImpl.$$$reportNull$$$0(2);
        }
        return list;
    }

    @Override
    @NotNull
    public List<SpringStereotypeElement> getStereotypeComponents(@NotNull GlobalSearchScope scope) {
        if (scope == null) {
            SpringJamModelImpl.$$$reportNull$$$0(3);
        }
        ArrayList<SpringStereotypeElement> stereotypeElements = new ArrayList<SpringStereotypeElement>();
        stereotypeElements.addAll(this.getComponents(scope));
        stereotypeElements.addAll(this.getControllers(scope));
        stereotypeElements.addAll(this.getRepositories(scope));
        stereotypeElements.addAll(this.getServices(scope));
        stereotypeElements.addAll(this.getConfigurations(scope));
        stereotypeElements.addAll(this.getCdiJavaxNamed(scope));
        stereotypeElements.addAll(this.getCdiJakartaNamed(scope));
        stereotypeElements.addAll(this.getJavaxManagedBeans(scope));
        stereotypeElements.addAll(this.getJakartaManagedBeans(scope));
        stereotypeElements.addAll(this.getCustomStereotypeComponents(scope));
        stereotypeElements.addAll(this.getStereotypeComponentExtensions(scope));
        ArrayList<SpringStereotypeElement> arrayList = stereotypeElements;
        if (arrayList == null) {
            SpringJamModelImpl.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    private List<CustomSpringComponent> getCustomStereotypeComponents(@NotNull GlobalSearchScope scope) {
        if (scope == null) {
            SpringJamModelImpl.$$$reportNull$$$0(5);
        }
        SmartList customSpringComponents = new SmartList();
        for (String anno : JamAnnotationTypeUtil.getInstance(this.myModule).getUserDefinedCustomComponentAnnotations()) {
            customSpringComponents.addAll(this.myJamService.getJamClassElements(CustomSpringComponent.JAM_KEY, anno, scope));
        }
        return customSpringComponents;
    }

    private List<SpringStereotypeElement> getStereotypeComponentExtensions(@NotNull GlobalSearchScope scope) {
        if (scope == null) {
            SpringJamModelImpl.$$$reportNull$$$0(6);
        }
        SmartList stereotypeElements = new SmartList();
        for (ComponentScanExtender extender : ComponentScanExtender.EP_NAME.getExtensionList()) {
            stereotypeElements.addAll(extender.getComponents(scope, this.myModule));
        }
        return stereotypeElements;
    }

    @NotNull
    private List<SpringComponent> getComponents(@NotNull GlobalSearchScope scope) {
        if (scope == null) {
            SpringJamModelImpl.$$$reportNull$$$0(7);
        }
        List list = this.myJamService.getJamClassElements(SpringComponent.META, "org.springframework.stereotype.Component", scope);
        if (list == null) {
            SpringJamModelImpl.$$$reportNull$$$0(8);
        }
        return list;
    }

    @NotNull
    private List<SpringCdiJavaxNamed> getCdiJavaxNamed(@NotNull GlobalSearchScope scope) {
        if (scope == null) {
            SpringJamModelImpl.$$$reportNull$$$0(9);
        }
        List list = this.myJamService.getJamClassElements(SpringCdiJavaxNamed.META, "javax.inject.Named", scope);
        if (list == null) {
            SpringJamModelImpl.$$$reportNull$$$0(10);
        }
        return list;
    }

    @NotNull
    private List<SpringCdiJakartaNamed> getCdiJakartaNamed(@NotNull GlobalSearchScope scope) {
        if (scope == null) {
            SpringJamModelImpl.$$$reportNull$$$0(11);
        }
        List list = this.myJamService.getJamClassElements(SpringCdiJakartaNamed.META, "jakarta.inject.Named", scope);
        if (list == null) {
            SpringJamModelImpl.$$$reportNull$$$0(12);
        }
        return list;
    }

    @Override
    @NotNull
    public List<SpringController> getControllers(@NotNull GlobalSearchScope scope) {
        if (scope == null) {
            SpringJamModelImpl.$$$reportNull$$$0(13);
        }
        SmartList controllers = new SmartList();
        Collection<String> controllerAnnotations = SpringController.getControllerAnnotations().apply(this.myModule);
        for (String anno : controllerAnnotations) {
            controllers.addAll(this.myJamService.getJamClassElements(SpringController.META, anno, scope));
        }
        SmartList smartList = controllers;
        if (smartList == null) {
            SpringJamModelImpl.$$$reportNull$$$0(14);
        }
        return smartList;
    }

    private List<SpringRepository> getRepositories(@NotNull GlobalSearchScope scope) {
        if (scope == null) {
            SpringJamModelImpl.$$$reportNull$$$0(15);
        }
        SmartList repositories = new SmartList();
        Collection<String> repositoryAnnotations = SpringRepository.getRepositoryAnnotations().apply(this.myModule);
        for (String anno : repositoryAnnotations) {
            repositories.addAll(this.myJamService.getJamClassElements(SpringRepository.META, anno, scope));
        }
        return repositories;
    }

    @Override
    @NotNull
    public List<SpringService> getServices(@NotNull GlobalSearchScope scope) {
        if (scope == null) {
            SpringJamModelImpl.$$$reportNull$$$0(16);
        }
        SmartList services = new SmartList();
        Collection<String> serviceAnnotations = SpringService.getServiceAnnotations().apply(this.myModule);
        for (String anno : serviceAnnotations) {
            services.addAll(this.myJamService.getJamClassElements(SpringService.META, anno, scope));
        }
        SmartList smartList = services;
        if (smartList == null) {
            SpringJamModelImpl.$$$reportNull$$$0(17);
        }
        return smartList;
    }

    @NotNull
    private List<SpringJavaxManagedBean> getJavaxManagedBeans(@NotNull GlobalSearchScope scope) {
        if (scope == null) {
            SpringJamModelImpl.$$$reportNull$$$0(18);
        }
        List list = this.myJamService.getJamClassElements(SpringJavaxManagedBean.META, "javax.annotation.ManagedBean", scope);
        if (list == null) {
            SpringJamModelImpl.$$$reportNull$$$0(19);
        }
        return list;
    }

    @NotNull
    private List<SpringJakartaManagedBean> getJakartaManagedBeans(@NotNull GlobalSearchScope scope) {
        if (scope == null) {
            SpringJamModelImpl.$$$reportNull$$$0(20);
        }
        List list = this.myJamService.getJamClassElements(SpringJakartaManagedBean.META, "jakarta.annotation.ManagedBean", scope);
        if (list == null) {
            SpringJamModelImpl.$$$reportNull$$$0(21);
        }
        return list;
    }

    @Override
    @NotNull
    public List<SpringConfiguration> getConfigurations(@NotNull GlobalSearchScope scope) {
        if (scope == null) {
            SpringJamModelImpl.$$$reportNull$$$0(22);
        }
        if (DumbService.isDumb((Project)this.myModule.getProject())) {
            List<SpringConfiguration> list = Collections.emptyList();
            if (list == null) {
                SpringJamModelImpl.$$$reportNull$$$0(23);
            }
            return list;
        }
        SmartList configurations = new SmartList();
        Collection<String> configurationAnnotations = SpringConfiguration.getAnnotations().apply(this.myModule);
        for (String anno : configurationAnnotations) {
            configurations.addAll(this.myJamService.getJamClassElements(SpringConfiguration.META, anno, scope));
        }
        SmartList smartList = configurations;
        if (smartList == null) {
            SpringJamModelImpl.$$$reportNull$$$0(24);
        }
        return smartList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 4, 8, 10, 12, 14, 17, 19, 21, 23, 24 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 17: 
            case 19: 
            case 21: 
            case 23: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/model/jam/SpringJamModelImpl";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 15: 
            case 16: 
            case 18: 
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/model/jam/SpringJamModelImpl";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getStereotypeComponents";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponents";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getCdiJavaxNamed";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getCdiJakartaNamed";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getControllers";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getServices";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getJavaxManagedBeans";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getJakartaManagedBeans";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurations";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 17: 
            case 19: 
            case 21: 
            case 23: 
            case 24: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getStereotypeComponents";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getCustomStereotypeComponents";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getStereotypeComponentExtensions";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getComponents";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getCdiJavaxNamed";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getCdiJakartaNamed";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getControllers";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getRepositories";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getServices";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getJavaxManagedBeans";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getJakartaManagedBeans";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getConfigurations";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 4, 8, 10, 12, 14, 17, 19, 21, 23, 24 -> new IllegalStateException(string);
        };
    }
}

