/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.jam.converters;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.PackageReferenceSet;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.PsiPackageReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.CommonProcessors;
import com.intellij.util.PatternUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public class SpringAntPatternPackageReferenceSet
extends PackageReferenceSet {
    public SpringAntPatternPackageReferenceSet(@NotNull String packageName, @NotNull PsiElement element, int startInElement, @NotNull GlobalSearchScope scope) {
        if (packageName == null) {
            SpringAntPatternPackageReferenceSet.$$$reportNull$$$0(0);
        }
        if (element == null) {
            SpringAntPatternPackageReferenceSet.$$$reportNull$$$0(1);
        }
        if (scope == null) {
            SpringAntPatternPackageReferenceSet.$$$reportNull$$$0(2);
        }
        super(packageName, element, startInElement, scope);
    }

    @NotNull
    protected PsiPackageReference createReference(TextRange range, int index) {
        return new PsiPackageReference(this, range, index){

            protected ResolveResult @NotNull [] doMultiResolve() {
                LinkedHashSet<PsiPackage> packages = new LinkedHashSet<PsiPackage>();
                for (PsiPackage parentPackage : this.getContext()) {
                    packages.addAll(this.resolvePackages(parentPackage));
                }
                ResolveResult[] resolveResultArray = PsiElementResolveResult.createResults(packages);
                if (resolveResultArray == null) {
                    1.$$$reportNull$$$0(0);
                }
                return resolveResultArray;
            }

            private @Unmodifiable Collection<PsiPackage> resolvePackages(@Nullable PsiPackage context) {
                PsiPackageReference parentContextReference;
                if (context == null) {
                    return Collections.emptySet();
                }
                String packageName = this.getValue();
                CommonProcessors.CollectProcessor<PsiPackage> processor2 = 1.getProcessor(packageName);
                PsiPackageReference psiPackageReference = parentContextReference = this.myIndex > 0 ? (PsiPackageReference)this.getReferenceSet().getReference(this.myIndex - 1) : null;
                if (packageName.equals("*")) {
                    for (PsiPackage aPackage : context.getSubPackages(SpringAntPatternPackageReferenceSet.this.getResolveScope())) {
                        if (!processor2.process((Object)aPackage)) break;
                    }
                    return processor2.getResults();
                }
                if (parentContextReference != null && parentContextReference.getValue().equals("**")) {
                    return this.getSubPackages(context, processor2, true);
                }
                if (packageName.equals("**")) {
                    if (this.isLastReference()) {
                        return this.getSubPackages(context, processor2, false);
                    }
                    return Collections.singleton(context);
                }
                if (packageName.contains("*") || packageName.contains("?")) {
                    for (PsiPackage subPackage : context.getSubPackages(SpringAntPatternPackageReferenceSet.this.getResolveScope())) {
                        processor2.process((Object)subPackage);
                    }
                    return processor2.getResults();
                }
                return this.getReferenceSet().resolvePackageName(context, packageName);
            }

            private boolean isLastReference() {
                return ((Object)((Object)this)).equals(this.getReferenceSet().getLastReference());
            }

            @NotNull
            private static CommonProcessors.CollectProcessor<PsiPackage> getProcessor(@NotNull String packageName) {
                if (packageName == null) {
                    1.$$$reportNull$$$0(1);
                }
                final Pattern pattern = PatternUtil.fromMask((String)packageName);
                return new CommonProcessors.CollectProcessor<PsiPackage>(new LinkedHashSet()){

                    protected boolean accept(PsiPackage psiPackage) {
                        String name = psiPackage.getName();
                        return name != null && pattern.matcher(name).matches();
                    }
                };
            }

            @NotNull
            private Collection<PsiPackage> getSubPackages(@NotNull PsiPackage context, CommonProcessors.CollectProcessor<PsiPackage> processor2, boolean deep) {
                if (context == null) {
                    1.$$$reportNull$$$0(2);
                }
                this.processSubPackages(context, processor2, deep);
                Collection collection = processor2.getResults();
                if (collection == null) {
                    1.$$$reportNull$$$0(3);
                }
                return collection;
            }

            private void processSubPackages(PsiPackage psiPackage, CommonProcessors.CollectProcessor<PsiPackage> processor2, boolean deep) {
                for (PsiPackage subPackage : psiPackage.getSubPackages(SpringAntPatternPackageReferenceSet.this.getResolveScope())) {
                    processor2.process((Object)subPackage);
                    if (!deep) continue;
                    this.processSubPackages(subPackage, processor2, true);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 2;
                    case 1, 2 -> 3;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/spring/model/jam/converters/SpringAntPatternPackageReferenceSet$1";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "packageName";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "context";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "doMultiResolve";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/spring/model/jam/converters/SpringAntPatternPackageReferenceSet$1";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getSubPackages";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "getProcessor";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "getSubPackages";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalStateException(string);
                    case 1, 2 -> new IllegalArgumentException(string);
                };
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "packageName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "element";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "scope";
                break;
            }
        }
        objectArray[1] = "com/intellij/spring/model/jam/converters/SpringAntPatternPackageReferenceSet";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

