/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.jam.testContexts.override;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.MetaAnnotationUtil;
import com.intellij.codeInsight.daemon.ImplicitUsageProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.spring.model.utils.SpringCommonUtils;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class SpringTestingImplicitUsageProvider
implements ImplicitUsageProvider {
    public boolean isImplicitUsage(@NotNull PsiElement element) {
        if (element == null) {
            SpringTestingImplicitUsageProvider.$$$reportNull$$$0(0);
        }
        if (element instanceof PsiMethod) {
            return SpringTestingImplicitUsageProvider.isImplicitTestBeanFactoryMethod((PsiMethod)element);
        }
        if (!(element instanceof PsiField)) {
            return false;
        }
        PsiField modifierListOwner = (PsiField)element;
        PsiModifierList modifierList = modifierListOwner.getModifierList();
        if (modifierList == null || modifierList.getAnnotations().length == 0) {
            return false;
        }
        return SpringCommonUtils.isSpringConfigured(element.getProject()) && SpringTestingImplicitUsageProvider.isMetaAnnotated((PsiModifierListOwner)modifierListOwner, "org.springframework.test.context.bean.override.mockito.MockitoBean", "org.springframework.test.context.bean.override.mockito.MockitoSpyBean", "org.springframework.test.context.bean.override.convention.TestBean");
    }

    public boolean isImplicitRead(@NotNull PsiElement element) {
        if (element == null) {
            SpringTestingImplicitUsageProvider.$$$reportNull$$$0(1);
        }
        return this.isImplicitUsage(element);
    }

    public boolean isImplicitWrite(@NotNull PsiElement element) {
        if (element == null) {
            SpringTestingImplicitUsageProvider.$$$reportNull$$$0(2);
        }
        return this.isImplicitUsage(element);
    }

    private static boolean isImplicitTestBeanFactoryMethod(PsiMethod psiMethod) {
        if (psiMethod.getParameterList().getParametersCount() > 0) {
            return false;
        }
        if (!psiMethod.hasModifierProperty("static")) {
            return false;
        }
        PsiClass containingClass = psiMethod.getContainingClass();
        if (containingClass == null) {
            return false;
        }
        PsiField fieldByName = containingClass.findFieldByName(psiMethod.getName(), true);
        return fieldByName != null && AnnotationUtil.isAnnotated((PsiModifierListOwner)fieldByName, (String)"org.springframework.test.context.bean.override.convention.TestBean", (int)0);
    }

    @NotNull
    private static Set<String> getMetaAnnotations(@NotNull Module module, String ... annos) {
        if (module == null) {
            SpringTestingImplicitUsageProvider.$$$reportNull$$$0(3);
        }
        Set<String> set = Arrays.stream(annos).flatMap(anno -> SpringTestingImplicitUsageProvider.getMetaAnnotationsFor(module, anno).stream()).collect(Collectors.toSet());
        if (set == null) {
            SpringTestingImplicitUsageProvider.$$$reportNull$$$0(4);
        }
        return set;
    }

    @NotNull
    private static List<String> getMetaAnnotationsFor(@NotNull Module module, String annotation) {
        if (module == null) {
            SpringTestingImplicitUsageProvider.$$$reportNull$$$0(5);
        }
        List<String> list = MetaAnnotationUtil.getAnnotationTypesWithChildren((Module)module, (String)annotation, (boolean)true).stream().map(PsiClass::getQualifiedName).filter(Objects::nonNull).collect(Collectors.toList());
        if (list == null) {
            SpringTestingImplicitUsageProvider.$$$reportNull$$$0(6);
        }
        return list;
    }

    private static boolean isMetaAnnotated(@NotNull PsiModifierListOwner element, String ... annotations) {
        Module module;
        if (element == null) {
            SpringTestingImplicitUsageProvider.$$$reportNull$$$0(7);
        }
        return (module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element)) != null && AnnotationUtil.isAnnotated((PsiModifierListOwner)element, SpringTestingImplicitUsageProvider.getMetaAnnotations(module, annotations), (int)0);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/model/jam/testContexts/override/SpringTestingImplicitUsageProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/model/jam/testContexts/override/SpringTestingImplicitUsageProvider";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getMetaAnnotations";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getMetaAnnotationsFor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isImplicitUsage";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isImplicitRead";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isImplicitWrite";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getMetaAnnotations";
                break;
            }
            case 4: 
            case 6: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getMetaAnnotationsFor";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isMetaAnnotated";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 6 -> new IllegalStateException(string);
        };
    }
}

