/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.jam.testContexts.override.testBean.references;

import com.intellij.codeInspection.reference.PsiMemberReference;
import com.intellij.jam.JamSimpleReference;
import com.intellij.jam.JamSimpleReferenceConverter;
import com.intellij.jam.JamStringAttributeElement;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.JavaClassReferenceProvider;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.JavaClassReferenceSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FactoryMethodReferenceConverter
extends JamSimpleReferenceConverter<PsiMethod> {
    private static final JavaClassReferenceProvider PROVIDER = new JavaClassReferenceProvider();

    public PsiMethod fromString(@Nullable String s, JamStringAttributeElement<PsiMethod> context) {
        if (s == null) {
            return null;
        }
        PsiClass factoryClass = FactoryMethodReferenceConverter.findFactoryClass(s, context);
        return factoryClass == null ? null : (PsiMethod)ContainerUtil.find((Object[])factoryClass.getAllMethods(), method -> s.equals(method.getName()) && FactoryMethodReferenceConverter.isStaticMethodWithoutParameters(method));
    }

    @Nullable
    private static PsiClass findFactoryClass(@Nullable String expression, JamStringAttributeElement<PsiMethod> context) {
        PsiAnnotationMemberValue element = context.getPsiElement();
        if (element == null) {
            return null;
        }
        if (expression != null && expression.contains("#")) {
            String className = (String)FactoryMethodReferenceConverter.getClassAndMethod((String)expression, context).first;
            if (StringUtil.isEmptyOrSpaces((String)className)) {
                return null;
            }
            return JavaPsiFacade.getInstance((Project)element.getProject()).findClass(className, element.getResolveScope());
        }
        return (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)element, PsiClass.class);
    }

    @NotNull
    private static Pair<String, String> getClassAndMethod(@NotNull String expression, @NotNull JamStringAttributeElement<PsiMethod> context) {
        if (expression == null) {
            FactoryMethodReferenceConverter.$$$reportNull$$$0(0);
        }
        if (context == null) {
            FactoryMethodReferenceConverter.$$$reportNull$$$0(1);
        }
        if (expression.contains("#")) {
            int index = expression.lastIndexOf("#");
            Pair pair = Pair.create((Object)expression.substring(0, index), (Object)expression.substring(index + 1));
            if (pair == null) {
                FactoryMethodReferenceConverter.$$$reportNull$$$0(2);
            }
            return pair;
        }
        if (expression.contains(".")) {
            Pair pair = Pair.create((Object)expression, (Object)"");
            if (pair == null) {
                FactoryMethodReferenceConverter.$$$reportNull$$$0(3);
            }
            return pair;
        }
        PsiField field = (PsiField)PsiTreeUtil.getParentOfType((PsiElement)context.getPsiElement(), PsiField.class);
        PsiClass containingClass = field != null ? field.getContainingClass() : null;
        String qualifiedName = containingClass != null ? containingClass.getQualifiedName() : null;
        Pair pair = qualifiedName != null ? Pair.create((Object)qualifiedName, (Object)expression) : Pair.create((Object)"", (Object)expression);
        if (pair == null) {
            FactoryMethodReferenceConverter.$$$reportNull$$$0(4);
        }
        return pair;
    }

    public Collection<PsiMethod> getVariants(JamStringAttributeElement<PsiMethod> context) {
        PsiClass factoryClass = FactoryMethodReferenceConverter.findFactoryClass(null, context);
        if (factoryClass != null) {
            return ContainerUtil.filter((Object[])factoryClass.getAllMethods(), method -> FactoryMethodReferenceConverter.isStaticMethodWithoutParameters(method));
        }
        return Collections.emptyList();
    }

    private static boolean isStaticMethodWithoutParameters(PsiMethod method) {
        return method.hasModifierProperty("static") && method.getParameterList().getParametersCount() == 0;
    }

    protected JamSimpleReference<PsiMethod> createReference(JamStringAttributeElement<PsiMethod> context, @NotNull PsiElement injectionHost) {
        if (injectionHost == null) {
            FactoryMethodReferenceConverter.$$$reportNull$$$0(5);
        }
        return new DefaultFactoryMethodReference(context, injectionHost);
    }

    public PsiReference @NotNull [] createReferences(@NotNull JamStringAttributeElement<PsiMethod> context, @NotNull PsiLanguageInjectionHost injectionHost) {
        String stringValue;
        if (context == null) {
            FactoryMethodReferenceConverter.$$$reportNull$$$0(6);
        }
        if (injectionHost == null) {
            FactoryMethodReferenceConverter.$$$reportNull$$$0(7);
        }
        if ((stringValue = context.getStringValue()) != null && (stringValue.contains("#") || stringValue.contains("."))) {
            Pair<String, String> pair = FactoryMethodReferenceConverter.getClassAndMethod(stringValue, context);
            Object[] classReferences = new JavaClassReferenceSet((String)pair.first, (PsiElement)injectionHost, ElementManipulators.getOffsetInElement((PsiElement)injectionHost), false, PROVIDER).getAllReferences();
            if (stringValue.contains("#")) {
                int offset = stringValue.lastIndexOf("#") + 1 + ElementManipulators.getOffsetInElement((PsiElement)injectionHost);
                FactoryMethodReference methodReference = new FactoryMethodReference((PsiElement)injectionHost, TextRange.create((int)offset, (int)(offset + ((String)pair.second).length())), JavaPsiFacade.getInstance((Project)injectionHost.getProject()).findClass((String)pair.first, injectionHost.getResolveScope()));
                PsiReference[] psiReferenceArray = (PsiReference[])ArrayUtil.append((Object[])classReferences, (Object)((Object)methodReference), PsiReference.class);
                if (psiReferenceArray == null) {
                    FactoryMethodReferenceConverter.$$$reportNull$$$0(8);
                }
                return psiReferenceArray;
            }
            if (classReferences == null) {
                FactoryMethodReferenceConverter.$$$reportNull$$$0(9);
            }
            return classReferences;
        }
        PsiReference[] psiReferenceArray = super.createReferences(context, injectionHost);
        if (psiReferenceArray == null) {
            FactoryMethodReferenceConverter.$$$reportNull$$$0(10);
        }
        return psiReferenceArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 8, 9, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/model/jam/testContexts/override/testBean/references/FactoryMethodReferenceConverter";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "injectionHost";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/model/jam/testContexts/override/testBean/references/FactoryMethodReferenceConverter";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassAndMethod";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createReferences";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getClassAndMethod";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createReference";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createReferences";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 8, 9, 10 -> new IllegalStateException(string);
        };
    }

    public static final class DefaultFactoryMethodReference
    extends PsiMethodReference {
        public DefaultFactoryMethodReference(JamStringAttributeElement<PsiMethod> context, @NotNull PsiElement injectionHost) {
            if (injectionHost == null) {
                DefaultFactoryMethodReference.$$$reportNull$$$0(0);
            }
            super(context, injectionHost);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "injectionHost", "com/intellij/spring/model/jam/testContexts/override/testBean/references/FactoryMethodReferenceConverter$DefaultFactoryMethodReference", "<init>"));
        }
    }

    public static final class FactoryMethodReference
    extends PsiReferenceBase<PsiElement>
    implements PsiPolyVariantReference {
        @Nullable
        private final PsiClass myClass;

        private FactoryMethodReference(@NotNull PsiElement element, TextRange rangeInElement, @Nullable PsiClass aClass) {
            if (element == null) {
                FactoryMethodReference.$$$reportNull$$$0(0);
            }
            super(element, rangeInElement, false);
            this.myClass = aClass;
        }

        public PsiElement resolve() {
            ResolveResult[] resolveResults = this.multiResolve(false);
            return resolveResults.length == 1 ? resolveResults[0].getElement() : null;
        }

        public Object @NotNull [] getVariants() {
            Object[] objectArray = this.myClass == null ? EMPTY_ARRAY : Arrays.stream(this.myClass.getAllMethods()).filter(method -> FactoryMethodReferenceConverter.isStaticMethodWithoutParameters(method)).toArray();
            if (objectArray == null) {
                FactoryMethodReference.$$$reportNull$$$0(1);
            }
            return objectArray;
        }

        public ResolveResult @NotNull [] multiResolve(boolean incompleteCode) {
            if (this.myClass == null) {
                if (ResolveResult.EMPTY_ARRAY == null) {
                    FactoryMethodReference.$$$reportNull$$$0(2);
                }
                return ResolveResult.EMPTY_ARRAY;
            }
            ResolveResult[] resolveResultArray = (ResolveResult[])Arrays.stream(this.myClass.getAllMethods()).filter(method -> method.getName().equals(this.getValue())).map(PsiElementResolveResult::new).toArray(ResolveResult[]::new);
            if (resolveResultArray == null) {
                FactoryMethodReference.$$$reportNull$$$0(3);
            }
            return resolveResultArray;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/spring/model/jam/testContexts/override/testBean/references/FactoryMethodReferenceConverter$FactoryMethodReference";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/spring/model/jam/testContexts/override/testBean/references/FactoryMethodReferenceConverter$FactoryMethodReference";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getVariants";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "multiResolve";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2, 3 -> new IllegalStateException(string);
            };
        }
    }

    @ApiStatus.Internal
    public static class PsiMethodReference
    extends JamSimpleReference<PsiMethod>
    implements PsiMemberReference {
        private PsiMethodReference(JamStringAttributeElement<PsiMethod> context, @NotNull PsiElement host) {
            if (host == null) {
                PsiMethodReference.$$$reportNull$$$0(0);
            }
            super(context, host);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "host", "com/intellij/spring/model/jam/testContexts/override/testBean/references/FactoryMethodReferenceConverter$PsiMethodReference", "<init>"));
        }
    }
}

