/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.jam.utils;

import com.intellij.codeInsight.MetaAnnotationUtil;
import com.intellij.java.analysis.OuterModelsModificationTrackerManager;
import com.intellij.java.library.JavaLibraryModificationTracker;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.xml.XmlFile;
import com.intellij.spring.SpringLocalModelFactory;
import com.intellij.spring.SpringModificationTrackersManager;
import com.intellij.spring.contexts.model.LocalXmlModel;
import com.intellij.spring.contexts.model.LocalXmlModelImpl;
import com.intellij.spring.impl.SpringAutoConfiguredModels;
import com.intellij.spring.model.SpringModelSearchParameters;
import com.intellij.spring.model.jam.SpringSemContributorUtil;
import com.intellij.spring.model.jam.utils.JamAnnotationTypeUtil;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.model.utils.SpringPropertyUtils;
import com.intellij.spring.model.xml.beans.SpringProperty;
import com.intellij.spring.model.xml.beans.SpringPropertyDefinition;
import com.intellij.spring.search.SpringGlobalSearchScopes;
import com.intellij.uast.UastModificationTracker;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class JamAnnotationTypeUtilImpl
extends JamAnnotationTypeUtil {
    private final Module myModule;

    public JamAnnotationTypeUtilImpl(Module module) {
        this.myModule = module;
    }

    @Override
    @NotNull
    public List<PsiClass> getQualifierAnnotationTypesWithChildren() {
        SmartList list = new SmartList();
        list.addAll(this.getAnnotationTypesWithChildren("org.springframework.beans.factory.annotation.Qualifier"));
        list.addAll(this.getAnnotationTypesWithChildren("javax.inject.Qualifier"));
        list.addAll(this.getImplicitQualifierAnnotations());
        SmartList smartList = list;
        if (smartList == null) {
            JamAnnotationTypeUtilImpl.$$$reportNull$$$0(0);
        }
        return smartList;
    }

    @Override
    @NotNull
    public List<String> getQualifierAnnotationNamesWithChildren() {
        SmartList list = new SmartList();
        list.addAll(this.getAnnotationNamesWithChildren("org.springframework.beans.factory.annotation.Qualifier"));
        list.addAll(this.getAnnotationNamesWithChildren("javax.inject.Qualifier"));
        list.addAll(ContainerUtil.mapNotNull(this.getImplicitQualifierAnnotations(), PsiClass::getQualifiedName));
        SmartList smartList = list;
        if (smartList == null) {
            JamAnnotationTypeUtilImpl.$$$reportNull$$$0(1);
        }
        return smartList;
    }

    private Set<PsiClass> getImplicitQualifierAnnotations() {
        return (Set)CachedValuesManager.getManager((Project)this.myModule.getProject()).getCachedValue((UserDataHolder)this.myModule, () -> {
            Set<String> fqns = this.getImplicitQualifierAnnotationNames();
            if (fqns.isEmpty()) {
                return CachedValueProvider.Result.create(Collections.emptySet(), (Object[])new Object[]{UastModificationTracker.getInstance((Project)this.myModule.getProject())});
            }
            JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)this.myModule.getProject());
            GlobalSearchScope moduleSearchScope = SpringGlobalSearchScopes.runtime(this.myModule);
            Set types = ContainerUtil.map2SetNotNull(this.getImplicitQualifierAnnotationNames(), fqn -> {
                PsiClass psiClass = facade.findClass(fqn, moduleSearchScope);
                return psiClass != null && psiClass.isAnnotationType() ? psiClass : null;
            });
            return CachedValueProvider.Result.create((Object)types, (Object[])new Object[]{OuterModelsModificationTrackerManager.getTracker((Project)this.myModule.getProject()), JavaLibraryModificationTracker.getInstance((Project)this.myModule.getProject())});
        });
    }

    private Set<String> getImplicitQualifierAnnotationNames() {
        PsiClass customAutowireConfigurerClass = SpringCommonUtils.findLibraryClass(this.myModule, "org.springframework.beans.factory.annotation.CustomAutowireConfigurer");
        if (customAutowireConfigurerClass == null) {
            return Collections.emptySet();
        }
        HashSet<String> types = new HashSet<String>();
        Set<LocalXmlModel> models = SpringAutoConfiguredModels.getLocalXmlModelCandidates(this.myModule);
        for (LocalXmlModel model : models) {
            types.addAll(JamAnnotationTypeUtilImpl.getImplicitQualifierAnnotationNames((XmlFile)model.getConfig()));
        }
        return types;
    }

    private static Set<String> getImplicitQualifierAnnotationNames(XmlFile file) {
        return (Set)CachedValuesManager.getCachedValue((PsiElement)file, () -> {
            Module module = ModuleUtilCore.findModuleForFile((PsiFile)file);
            PsiClass customAutowireConfigurerClass = SpringCommonUtils.findLibraryClass(module, "org.springframework.beans.factory.annotation.CustomAutowireConfigurer");
            if (customAutowireConfigurerClass == null) {
                return CachedValueProvider.Result.create(Collections.emptySet(), (Object[])new Object[]{file, JavaLibraryModificationTracker.getInstance((Project)file.getProject())});
            }
            LocalXmlModel model = SpringLocalModelFactory.getInstance().getOrCreateLocalXmlModel(file, module, Collections.emptySet());
            if (model == null) {
                Object[] dependencies = SpringModificationTrackersManager.getInstance(module.getProject()).getOuterModelsDependencies();
                return CachedValueProvider.Result.create(Collections.emptySet(), (Object[])ArrayUtil.prepend((Object)file, (Object[])dependencies));
            }
            SpringModelSearchParameters.BeanClass params = SpringModelSearchParameters.byClass(customAutowireConfigurerClass).withInheritors();
            HashSet result2 = new HashSet();
            Processor processor2 = pointer -> {
                Object bean = pointer.getSpringBean();
                SpringPropertyDefinition propertyDefinition = SpringPropertyUtils.findPropertyByName(bean, "customQualifierTypes");
                if (!(propertyDefinition instanceof SpringProperty)) {
                    return true;
                }
                for (String value : SpringPropertyUtils.getListOrSetValues((SpringProperty)propertyDefinition)) {
                    if (StringUtil.isEmptyOrSpaces((String)value)) continue;
                    result2.add(value);
                }
                return true;
            };
            if (model instanceof LocalXmlModelImpl) {
                ((LocalXmlModelImpl)model).processLocalBeansByClass(params, processor2, true);
            } else {
                model.processLocalBeansByClass(params, processor2);
            }
            if (result2.isEmpty()) {
                return CachedValueProvider.Result.create(Collections.emptySet(), (Object[])new Object[]{file});
            }
            return CachedValueProvider.Result.create(result2, (Object[])new Object[]{file});
        });
    }

    @Override
    @NotNull
    public List<String> getUserDefinedCustomComponentAnnotations() {
        Collection<String> annotations = this.getCustomComponentAnnotations();
        HashSet<String> toRemove = new HashSet<String>();
        for (String defaultAnno : SpringSemContributorUtil.DEFAULT_SPRING_COMPONENTS) {
            if (defaultAnno.equals("org.springframework.stereotype.Component")) {
                toRemove.add(defaultAnno);
                continue;
            }
            toRemove.addAll(this.getAnnotationNamesWithChildren(defaultAnno));
        }
        List list = ContainerUtil.filter(annotations, a -> !toRemove.contains(a));
        if (list == null) {
            JamAnnotationTypeUtilImpl.$$$reportNull$$$0(2);
        }
        return list;
    }

    @NotNull
    private Collection<String> getCustomComponentAnnotations() {
        Collection<String> collection = this.getAnnotationNamesWithChildrenIncludingTests("org.springframework.stereotype.Component");
        if (collection == null) {
            JamAnnotationTypeUtilImpl.$$$reportNull$$$0(3);
        }
        return collection;
    }

    @Override
    @NotNull
    public Collection<PsiClass> getAnnotationTypesWithChildren(@NotNull String annotationName) {
        if (annotationName == null) {
            JamAnnotationTypeUtilImpl.$$$reportNull$$$0(4);
        }
        Collection<PsiClass> collection = this.getAnnotationTypes(annotationName, false);
        if (collection == null) {
            JamAnnotationTypeUtilImpl.$$$reportNull$$$0(5);
        }
        return collection;
    }

    @Override
    public Collection<PsiClass> getAnnotationTypesWithChildrenIncludingTests(@NotNull String annotationName) {
        if (annotationName == null) {
            JamAnnotationTypeUtilImpl.$$$reportNull$$$0(6);
        }
        return this.getAnnotationTypes(annotationName, true);
    }

    @Override
    public Collection<String> getAnnotationNamesWithChildren(@NotNull String annotationName) {
        if (annotationName == null) {
            JamAnnotationTypeUtilImpl.$$$reportNull$$$0(7);
        }
        if (this.myModule.isDisposed()) {
            return Collections.emptyList();
        }
        return MetaAnnotationUtil.getAnnotationNamesWithChildren((Module)this.myModule, (String)annotationName, (boolean)false);
    }

    @Override
    public Collection<String> getAnnotationNamesWithChildrenIncludingTests(@NotNull String annotationName) {
        if (annotationName == null) {
            JamAnnotationTypeUtilImpl.$$$reportNull$$$0(8);
        }
        if (this.myModule.isDisposed()) {
            return Collections.emptyList();
        }
        return MetaAnnotationUtil.getAnnotationNamesWithChildren((Module)this.myModule, (String)annotationName, (boolean)true);
    }

    private Collection<PsiClass> getAnnotationTypes(@NotNull String annotationName, boolean inTests) {
        if (annotationName == null) {
            JamAnnotationTypeUtilImpl.$$$reportNull$$$0(9);
        }
        if (this.myModule.isDisposed()) {
            return Collections.emptyList();
        }
        return MetaAnnotationUtil.getAnnotationTypesWithChildren((Module)this.myModule, (String)annotationName, (boolean)inTests);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 4, 6, 7, 8, 9 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/model/jam/utils/JamAnnotationTypeUtilImpl";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotationName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getQualifierAnnotationTypesWithChildren";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getQualifierAnnotationNamesWithChildren";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getUserDefinedCustomComponentAnnotations";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getCustomComponentAnnotations";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/model/jam/utils/JamAnnotationTypeUtilImpl";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getAnnotationTypesWithChildren";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getAnnotationTypesWithChildren";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getAnnotationTypesWithChildrenIncludingTests";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getAnnotationNamesWithChildren";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getAnnotationNamesWithChildrenIncludingTests";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getAnnotationTypes";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 4, 6, 7, 8, 9 -> new IllegalArgumentException(string);
        };
    }
}

