/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.jam.utils.filters;

import com.intellij.jam.JamService;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PackageScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.AnnotatedElementsSearch;
import com.intellij.spring.model.jam.JamPsiMemberSpringBean;
import com.intellij.spring.model.jam.stereotype.CustomSpringComponent;
import com.intellij.spring.model.jam.stereotype.SpringStereotypeElement;
import com.intellij.spring.model.jam.utils.filters.SpringContextFilter;
import com.intellij.spring.search.SpringGlobalSearchScopes;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringContextIncludeAnnotationFilter
extends SpringContextFilter.IncludeExpression {
    public SpringContextIncludeAnnotationFilter(@Nullable String expression) {
        super(expression);
    }

    @Override
    @NotNull
    public Set<SpringStereotypeElement> includeStereotypes(@NotNull Module module, @NotNull Set<PsiPackage> packages) {
        String annotation;
        if (module == null) {
            SpringContextIncludeAnnotationFilter.$$$reportNull$$$0(0);
        }
        if (packages == null) {
            SpringContextIncludeAnnotationFilter.$$$reportNull$$$0(1);
        }
        if (!StringUtil.isEmptyOrSpaces((String)(annotation = this.getExpression()))) {
            GlobalSearchScope searchScope = SpringGlobalSearchScopes.runtime(module);
            PsiClass annotationClass = JavaPsiFacade.getInstance((Project)module.getProject()).findClass(annotation, searchScope);
            return SpringContextIncludeAnnotationFilter.getAnnotatedStereotypes(annotationClass, searchScope, packages);
        }
        Set<SpringStereotypeElement> set = Collections.emptySet();
        if (set == null) {
            SpringContextIncludeAnnotationFilter.$$$reportNull$$$0(2);
        }
        return set;
    }

    @NotNull
    public static Set<SpringStereotypeElement> getAnnotatedStereotypes(@Nullable PsiClass annotationClass, @NotNull GlobalSearchScope searchScope, @NotNull Set<PsiPackage> packages) {
        if (searchScope == null) {
            SpringContextIncludeAnnotationFilter.$$$reportNull$$$0(3);
        }
        if (packages == null) {
            SpringContextIncludeAnnotationFilter.$$$reportNull$$$0(4);
        }
        if (annotationClass == null || !annotationClass.isAnnotationType()) {
            Set<SpringStereotypeElement> set = Collections.emptySet();
            if (set == null) {
                SpringContextIncludeAnnotationFilter.$$$reportNull$$$0(5);
            }
            return set;
        }
        LinkedHashSet<SpringStereotypeElement> components = new LinkedHashSet<SpringStereotypeElement>();
        Set<PsiClass> annotatedClasses = SpringContextIncludeAnnotationFilter.getAnnotatedClasses(annotationClass, packages, searchScope);
        for (PsiClass annotatedClass : annotatedClasses) {
            JamPsiMemberSpringBean bean = (JamPsiMemberSpringBean)JamService.getJamService((Project)annotatedClass.getProject()).getJamElement(JamPsiMemberSpringBean.PSI_MEMBER_SPRING_BEAN_JAM_KEY, (PsiElement)annotatedClass);
            if (bean instanceof SpringStereotypeElement) {
                components.add((SpringStereotypeElement)bean);
                continue;
            }
            components.add(new CustomSpringComponent(annotationClass.getQualifiedName(), annotatedClass));
        }
        LinkedHashSet<SpringStereotypeElement> linkedHashSet = components;
        if (linkedHashSet == null) {
            SpringContextIncludeAnnotationFilter.$$$reportNull$$$0(6);
        }
        return linkedHashSet;
    }

    private static Set<PsiClass> getAnnotatedClasses(@NotNull PsiClass annotationClass, @NotNull Set<PsiPackage> packages, @NotNull GlobalSearchScope searchScope) {
        if (annotationClass == null) {
            SpringContextIncludeAnnotationFilter.$$$reportNull$$$0(7);
        }
        if (packages == null) {
            SpringContextIncludeAnnotationFilter.$$$reportNull$$$0(8);
        }
        if (searchScope == null) {
            SpringContextIncludeAnnotationFilter.$$$reportNull$$$0(9);
        }
        LinkedHashSet<PsiClass> annotatedClasses = new LinkedHashSet<PsiClass>();
        CommonProcessors.CollectProcessor processor2 = new CommonProcessors.CollectProcessor(annotatedClasses);
        for (PsiPackage psiPackage : packages) {
            GlobalSearchScope scope = searchScope.intersectWith(PackageScope.packageScope((PsiPackage)psiPackage, (boolean)true));
            AnnotatedElementsSearch.searchPsiClasses((PsiClass)annotationClass, (SearchScope)scope).forEach((Processor)processor2);
        }
        return annotatedClasses;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: 
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packages";
                break;
            }
            case 2: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/model/jam/utils/filters/SpringContextIncludeAnnotationFilter";
                break;
            }
            case 3: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchScope";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotationClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/model/jam/utils/filters/SpringContextIncludeAnnotationFilter";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "includeStereotypes";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getAnnotatedStereotypes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "includeStereotypes";
                break;
            }
            case 2: 
            case 5: 
            case 6: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getAnnotatedStereotypes";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getAnnotatedClasses";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 5, 6 -> new IllegalStateException(string);
        };
    }
}

