/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.logical;

import com.intellij.ide.presentation.PresentationProvider;
import com.intellij.psi.PsiClass;
import com.intellij.psi.util.PsiUtil;
import com.intellij.spring.SpringApiIcons;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringQualifier;
import com.intellij.spring.model.jam.javaConfig.SpringJavaBean;
import com.intellij.spring.model.jam.stereotype.SpringConfiguration;
import com.intellij.spring.model.jam.stereotype.SpringController;
import com.intellij.spring.model.jam.stereotype.SpringMetaStereotypeComponent;
import com.intellij.spring.model.jam.stereotype.SpringRepository;
import com.intellij.spring.model.jam.stereotype.SpringService;
import com.intellij.spring.model.logical.SpringBeanLogicalModel;
import com.intellij.spring.model.scope.SpringBeanScope;
import java.util.Collection;
import java.util.Locale;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0002H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\u0007\u001a\u00020\u0002H\u0016J\u0012\u0010\n\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\u0002H\u0016\u00a8\u0006\u000b"}, d2={"Lcom/intellij/spring/model/logical/SpringBeanPresentationProvider;", "Lcom/intellij/ide/presentation/PresentationProvider;", "Lcom/intellij/spring/model/logical/SpringBeanLogicalModel;", "<init>", "()V", "getName", "", "t", "getIcon", "Ljavax/swing/Icon;", "getTypeName", "intellij.spring"})
@SourceDebugExtension(value={"SMAP\nSpringBeanLogicalModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpringBeanLogicalModel.kt\ncom/intellij/spring/model/logical/SpringBeanPresentationProvider\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,88:1\n1#2:89\n*E\n"})
public final class SpringBeanPresentationProvider
extends PresentationProvider<SpringBeanLogicalModel> {
    @NotNull
    public String getName(@NotNull SpringBeanLogicalModel t) {
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        Object object = t.getSpringBean().getBeanType();
        if ((object == null || (object = object.getPresentableText()) == null) && (object = t.getSpringBean().getBeanName()) == null) {
            object = "";
        }
        return object;
    }

    @NotNull
    public Icon getIcon(@NotNull SpringBeanLogicalModel t) {
        Icon icon;
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        CommonSpringBean commonSpringBean = t.getSpringBean();
        if (commonSpringBean instanceof SpringRepository) {
            Icon icon2 = SpringApiIcons.SpringData;
            icon = icon2;
            Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"SpringData");
        } else if (commonSpringBean instanceof SpringController) {
            Icon icon3 = SpringApiIcons.SpringWeb;
            icon = icon3;
            Intrinsics.checkNotNullExpressionValue((Object)icon3, (String)"SpringWeb");
        } else if (commonSpringBean instanceof SpringConfiguration) {
            Icon icon4 = SpringApiIcons.SpringJavaConfig;
            icon = icon4;
            Intrinsics.checkNotNullExpressionValue((Object)icon4, (String)"SpringJavaConfig");
        } else {
            Icon icon5 = SpringApiIcons.Spring;
            icon = icon5;
            Intrinsics.checkNotNullExpressionValue((Object)icon5, (String)"Spring");
        }
        return icon;
    }

    @Nullable
    public String getTypeName(@NotNull SpringBeanLogicalModel t) {
        String string;
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        Object result2 = null;
        Collection<SpringQualifier> collection = t.getSpringBean().getSpringQualifiers();
        Object it = collection;
        boolean bl = false;
        Collection<SpringQualifier> collection2 = it.size() == 1 ? collection : null;
        Object object = collection2 != null && (collection2 = (SpringQualifier)CollectionsKt.first((Iterable)collection2)) != null ? collection2.getQualifierValue() : (result2 = null);
        if (t.getSpringBean() instanceof SpringMetaStereotypeComponent) {
            String string2 = PsiUtil.getPackageName((PsiClass)((SpringMetaStereotypeComponent)t.getSpringBean()).getPsiElement());
            if (string2 != null) {
                it = string2;
                boolean bl2 = false;
                result2 = it;
            }
        }
        if ((string = result2) == null) {
            string = t.getSpringBean().getBeanName();
        }
        result2 = string;
        SpringBeanScope explicitScope = t.getSpringBean().getSpringScope();
        if (t.getSpringBean() instanceof SpringService || t.getSpringBean() instanceof SpringJavaBean || explicitScope != null) {
            SpringBeanScope scope;
            SpringBeanScope springBeanScope = explicitScope;
            if (springBeanScope == null) {
                springBeanScope = scope = SpringBeanScope.SINGLETON_SCOPE;
            }
            if (result2 != null) {
                result2 = result2 + " | ";
            }
            String string3 = scope.value();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"value(...)");
            String string4 = string3.toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toUpperCase(...)");
            result2 = result2 + string4;
        }
        return result2;
    }
}

