/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.scope;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.SpringModelSearchParameters;
import com.intellij.spring.model.scope.SpringBeanScope;
import com.intellij.spring.model.scope.SpringCustomBeanScope;
import com.intellij.spring.model.utils.SpringModelSearchers;
import com.intellij.spring.model.utils.SpringPropertyUtils;
import com.intellij.spring.model.xml.DomSpringBeanPointer;
import com.intellij.spring.model.xml.beans.SpringEntry;
import com.intellij.spring.model.xml.beans.SpringProperty;
import com.intellij.spring.model.xml.beans.SpringPropertyDefinition;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class SpringCustomScopeConfigurerBeanScope
extends SpringCustomBeanScope {
    @NonNls
    private static final String CUSTOM_SCOPE_CONFIGURER_CLASSNAME = "org.springframework.beans.factory.config.CustomScopeConfigurer";
    @NonNls
    private static final String CUSTOM_SCOPES_PROPERTY_NAME = "scopes";

    @Override
    public String getScopeClassName() {
        return CUSTOM_SCOPE_CONFIGURER_CLASSNAME;
    }

    @Override
    public boolean process(List<SpringBeanScope> scopes, Set<SpringModel> models, @NotNull PsiClass scopeClass, PsiElement psiElement) {
        if (scopeClass == null) {
            SpringCustomScopeConfigurerBeanScope.$$$reportNull$$$0(0);
        }
        SpringModelSearchParameters.BeanClass searchParameters = SpringModelSearchParameters.byClass(scopeClass);
        for (SpringModel model : models) {
            List<SpringBeanPointer<?>> springBeans = SpringModelSearchers.findBeans((CommonSpringModel)model, searchParameters);
            for (DomSpringBeanPointer springBean : ContainerUtil.findAll(springBeans, DomSpringBeanPointer.class)) {
                SpringPropertyDefinition property = SpringPropertyUtils.findPropertyByName(springBean.getSpringBean(), CUSTOM_SCOPES_PROPERTY_NAME);
                if (!(property instanceof SpringProperty)) continue;
                for (SpringEntry springEntry : ((SpringProperty)property).getMap().getEntries()) {
                    String keyValue = springEntry.getKeyAttr().getStringValue();
                    if (keyValue != null && !keyValue.isEmpty()) {
                        scopes.add(new SpringBeanScope(keyValue));
                        continue;
                    }
                    String keyValue2 = springEntry.getKey().getValue().getStringValue();
                    if (keyValue2 == null || keyValue2.isEmpty()) continue;
                    scopes.add(new SpringBeanScope(keyValue2));
                }
            }
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scopeClass", "com/intellij/spring/model/scope/SpringCustomScopeConfigurerBeanScope", "process"));
    }
}

