/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.structure.logical.services;

import com.intellij.ide.presentation.Presentation;
import com.intellij.ide.structureView.logical.ContainerElementsProvider;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.jam.stereotype.SpringComponent;
import com.intellij.spring.model.jam.stereotype.SpringService;
import com.intellij.spring.model.jam.stereotype.SpringStereotypeElement;
import com.intellij.spring.model.logical.SpringBeanLogicalModel;
import com.intellij.spring.model.structure.logical.services.SpringServiceMethodLogicalModel;
import com.intellij.spring.model.structure.logical.services.SpringServiceMethodsPresentationProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Presentation(provider=SpringServiceMethodsPresentationProvider.class)
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0002H\u0016J\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00030\n2\u0006\u0010\b\u001a\u00020\u0002H\u0016J\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\n2\u0006\u0010\b\u001a\u00020\u0002H\u0002\u00a8\u0006\r"}, d2={"Lcom/intellij/spring/model/structure/logical/services/SpringServiceMethodsProvider;", "Lcom/intellij/ide/structureView/logical/ContainerElementsProvider;", "Lcom/intellij/spring/model/logical/SpringBeanLogicalModel;", "Lcom/intellij/spring/model/structure/logical/services/SpringServiceMethodLogicalModel;", "<init>", "()V", "isApplicable", "", "parent", "getElements", "", "getPsiMethods", "Lcom/intellij/psi/PsiMethod;", "intellij.spring.core"})
@SourceDebugExtension(value={"SMAP\nSpringServiceMethodsProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpringServiceMethodsProvider.kt\ncom/intellij/spring/model/structure/logical/services/SpringServiceMethodsProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,68:1\n1563#2:69\n1634#2,3:70\n295#2,2:73\n*S KotlinDebug\n*F\n+ 1 SpringServiceMethodsProvider.kt\ncom/intellij/spring/model/structure/logical/services/SpringServiceMethodsProvider\n*L\n27#1:69\n27#1:70,3\n42#1:73,2\n*E\n"})
public final class SpringServiceMethodsProvider
implements ContainerElementsProvider<SpringBeanLogicalModel, SpringServiceMethodLogicalModel> {
    public boolean isApplicable(@NotNull SpringBeanLogicalModel parent) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        return !((Collection)this.getPsiMethods(parent)).isEmpty();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<SpringServiceMethodLogicalModel> getElements(@NotNull SpringBeanLogicalModel parent) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Iterable $this$map$iv = this.getPsiMethods(parent);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            PsiMethod psiMethod = (PsiMethod)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            CommonSpringBean commonSpringBean = parent.getSpringBean();
            Intrinsics.checkNotNull((Object)commonSpringBean, (String)"null cannot be cast to non-null type com.intellij.spring.model.jam.stereotype.SpringStereotypeElement");
            PsiClass psiClass = ((SpringStereotypeElement)commonSpringBean).getPsiElement();
            Intrinsics.checkNotNullExpressionValue((Object)psiClass, (String)"getPsiElement(...)");
            collection.add(new SpringServiceMethodLogicalModel(psiClass, (PsiMethod)it));
        }
        return (List)destination$iv$iv;
    }

    private final List<PsiMethod> getPsiMethods(SpringBeanLogicalModel parent) {
        CommonSpringBean commonSpringBean = parent.getSpringBean();
        SpringStereotypeElement springStereotypeElement = commonSpringBean instanceof SpringStereotypeElement ? (SpringStereotypeElement)commonSpringBean : null;
        if (springStereotypeElement == null) {
            return CollectionsKt.emptyList();
        }
        SpringStereotypeElement springService = springStereotypeElement;
        if (!(springService instanceof SpringService) && !(springService instanceof SpringComponent)) {
            return CollectionsKt.emptyList();
        }
        List result2 = new ArrayList();
        Set methodsNames = new LinkedHashSet();
        for (PsiMethod method : springService.getPsiElement().getAllMethods()) {
            if (method.isConstructor() || method.hasModifierProperty("private")) continue;
            PsiClass psiClass = method.getContainingClass();
            if (Intrinsics.areEqual((Object)(psiClass != null ? psiClass.getQualifiedName() : null), (Object)"java.lang.Object")) continue;
            if (methodsNames.contains(method.getName())) {
                Object v3;
                block5: {
                    Iterable $this$firstOrNull$iv = result2;
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        PsiClass childClass;
                        PsiClass superClass;
                        PsiMethod it = (PsiMethod)element$iv;
                        boolean bl = false;
                        boolean bl2 = method.getParameterList().getParametersCount() != it.getParameterList().getParametersCount() ? false : (method.getContainingClass() == null ? false : (it.getContainingClass() == null ? false : Intrinsics.areEqual((Object)it.getName(), (Object)method.getName()) && MethodSignatureUtil.areSignaturesEqual((MethodSignature)it.getSignature(PsiSubstitutor.EMPTY), (MethodSignature)method.getSignature(TypeConversionUtil.getSuperClassSubstitutor((PsiClass)superClass, (PsiClass)childClass, (PsiSubstitutor)PsiSubstitutor.EMPTY)))));
                        if (!bl2) continue;
                        v3 = element$iv;
                        break block5;
                    }
                    v3 = null;
                }
                PsiMethod overridingMethods = v3;
                if (overridingMethods != null) continue;
            }
            String string = method.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            methodsNames.add(string);
            Intrinsics.checkNotNull((Object)method);
            result2.add(method);
        }
        return result2;
    }
}

