/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.utils;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.SuggestedNameInfo;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.SpringManager;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.factories.SpringFactoryBeansManager;
import com.intellij.spring.model.BeanService;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.SpringModelSearchParameters;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.model.utils.SpringModelSearchers;
import com.intellij.spring.model.utils.SpringModelUtils;
import com.intellij.spring.model.utils.SpringPropertyUtils;
import com.intellij.spring.model.xml.DomSpringBean;
import com.intellij.spring.model.xml.beans.Beans;
import com.intellij.spring.model.xml.beans.SpringBean;
import com.intellij.spring.model.xml.beans.SpringEntry;
import com.intellij.spring.model.xml.beans.SpringProperty;
import com.intellij.spring.model.xml.beans.SpringPropertyDefinition;
import com.intellij.spring.search.SpringGlobalSearchScopes;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.UniqueNameGenerator;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.reflect.AbstractDomChildrenDescription;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SpringBeanCoreUtils {
    @Nullable
    public static String getReferencedName(@NotNull SpringBeanPointer<?> bean, @NotNull Collection<? extends SpringBeanPointer<?>> allBeans) {
        String beanName;
        if (bean == null) {
            SpringBeanCoreUtils.$$$reportNull$$$0(0);
        }
        if (allBeans == null) {
            SpringBeanCoreUtils.$$$reportNull$$$0(1);
        }
        if ((beanName = bean.getName()) != null) {
            return beanName;
        }
        for (PsiType psiType : bean.getEffectiveBeanTypes()) {
            List<SpringBeanPointer<?>> list;
            String className = null;
            if (psiType instanceof PsiClassType) {
                PsiClass psiClass = ((PsiClassType)psiType).resolve();
                if (psiClass == null) continue;
                className = psiClass.getQualifiedName();
            }
            if (className == null || (list = SpringBeanCoreUtils.findBeansByClassName(allBeans, className)).size() != 1) continue;
            return className;
        }
        return null;
    }

    public static boolean isEffectiveClassType(@NotNull List<? extends PsiType> psiTypes, @NotNull CommonSpringBean context) {
        if (psiTypes == null) {
            SpringBeanCoreUtils.$$$reportNull$$$0(2);
        }
        if (context == null) {
            SpringBeanCoreUtils.$$$reportNull$$$0(3);
        }
        for (PsiType psiType : psiTypes) {
            if (!SpringBeanCoreUtils.isEffectiveClassType(context, psiType, context.getModule())) continue;
            return true;
        }
        return false;
    }

    private static boolean isEffectiveClassType(CommonSpringBean context, PsiType requiredType, Module module) {
        Collection<PsiType> effectiveBeanTypes;
        SpringBean springBean;
        PsiMethod factoryMethod;
        if (context instanceof SpringBean && (factoryMethod = (PsiMethod)(springBean = (SpringBean)context).getFactoryMethod().getValue()) != null && SpringFactoryBeansManager.getInstance().isValidFactoryMethod(factoryMethod, springBean.getFactoryBean().getValue() != null)) {
            PsiType iterableType;
            PsiType returnType = factoryMethod.getReturnType();
            if (returnType != null && requiredType.isAssignableFrom(returnType)) {
                return true;
            }
            if (returnType instanceof PsiArrayType && (iterableType = PsiUtil.extractIterableTypeParameter((PsiType)requiredType, (boolean)false)) != null) {
                return TypeConversionUtil.isAssignable((PsiType)((PsiArrayType)returnType).getComponentType(), (PsiType)iterableType);
            }
        }
        if (!(effectiveBeanTypes = BeanService.getInstance().getEffectiveBeanTypes(context)).isEmpty()) {
            for (PsiType beanType : effectiveBeanTypes) {
                if (TypeConversionUtil.isAssignable((PsiType)requiredType, (PsiType)beanType)) {
                    return true;
                }
                PsiClass aClass = PsiTypesUtil.getPsiClass((PsiType)beanType);
                if (aClass == null) continue;
                for (PsiClass psiClass : SpringBeanCoreUtils.getRequiredClasses(requiredType, module)) {
                    if (!InheritanceUtil.isInheritorOrSelf((PsiClass)aClass, (PsiClass)psiClass, (boolean)true)) continue;
                    return true;
                }
                if (!"java.lang.String".equals(aClass.getQualifiedName()) || !SpringBeanCoreUtils.isCustomEditorRegistered(requiredType, module)) continue;
                return true;
            }
            return false;
        }
        return SpringBeanCoreUtils.isUnusualBeanFactoriesUsed(context);
    }

    @NotNull
    private static Collection<PsiClass> getRequiredClasses(PsiType requiredType, Module module) {
        PsiClass psiClass = SpringBeanCoreUtils.resolvePsiClass(requiredType, module);
        if (psiClass == null) {
            Set<PsiClass> set = Collections.emptySet();
            if (set == null) {
                SpringBeanCoreUtils.$$$reportNull$$$0(4);
            }
            return set;
        }
        if (psiClass instanceof PsiTypeParameter) {
            Collection collection = Arrays.stream(psiClass.getSuperTypes()).map(type -> type.resolve()).filter(Objects::nonNull).collect(Collectors.toSet());
            if (collection == null) {
                SpringBeanCoreUtils.$$$reportNull$$$0(5);
            }
            return collection;
        }
        Set<PsiClass> set = Collections.singleton(psiClass);
        if (set == null) {
            SpringBeanCoreUtils.$$$reportNull$$$0(6);
        }
        return set;
    }

    private static boolean isCustomEditorRegistered(PsiType requiredType, @NotNull Module module) {
        if (module == null) {
            SpringBeanCoreUtils.$$$reportNull$$$0(7);
        }
        for (PsiType psiType : SpringBeanCoreUtils.getCustomEditorConvertableClasses(module)) {
            if (!psiType.isAssignableFrom(requiredType)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    private static Set<PsiType> getCustomEditorConvertableClasses(Module module) {
        PsiClass customEditorConfigurer = SpringCommonUtils.findLibraryClass(module, "org.springframework.beans.factory.config.CustomEditorConfigurer");
        if (customEditorConfigurer == null) {
            Set<PsiType> set = Collections.emptySet();
            if (set == null) {
                SpringBeanCoreUtils.$$$reportNull$$$0(8);
            }
            return set;
        }
        HashSet<PsiType> customEditorConvertableClasses = new HashSet<PsiType>();
        SpringModelSearchParameters.BeanClass searchParameters = SpringModelSearchParameters.byClass(customEditorConfigurer).withInheritors();
        SpringModel springModel = SpringManager.getInstance(module.getProject()).getCombinedModel(module);
        for (SpringBeanPointer<?> configurer : SpringModelSearchers.findBeans((CommonSpringModel)springModel, searchParameters)) {
            SpringPropertyDefinition property = SpringPropertyUtils.findPropertyByName(configurer.getSpringBean(), "customEditors");
            if (!(property instanceof SpringProperty)) continue;
            for (SpringEntry entry : ((SpringProperty)property).getMap().getEntries()) {
                SpringBeanCoreUtils.addPsiClass(module, customEditorConvertableClasses, entry.getKeyAttr().getStringValue());
                SpringBeanCoreUtils.addPsiClass(module, customEditorConvertableClasses, entry.getKey().getValueAsString());
            }
        }
        HashSet<PsiType> hashSet = customEditorConvertableClasses;
        if (hashSet == null) {
            SpringBeanCoreUtils.$$$reportNull$$$0(9);
        }
        return hashSet;
    }

    private static boolean addPsiClass(@NotNull Module module, @NotNull Set<? super PsiType> customEditorClasses, @Nullable String fqn) {
        JavaPsiFacade facade;
        PsiClass aClass;
        if (module == null) {
            SpringBeanCoreUtils.$$$reportNull$$$0(10);
        }
        if (customEditorClasses == null) {
            SpringBeanCoreUtils.$$$reportNull$$$0(11);
        }
        if (!StringUtil.isEmptyOrSpaces((String)fqn) && (aClass = (facade = JavaPsiFacade.getInstance((Project)module.getProject())).findClass(fqn, GlobalSearchScope.moduleWithLibrariesScope((Module)module))) != null) {
            return customEditorClasses.add((PsiType)facade.getElementFactory().createType(aClass));
        }
        return false;
    }

    private static boolean isUnusualBeanFactoriesUsed(CommonSpringBean context) {
        PsiType beanType = context.getBeanType();
        if (beanType == null) {
            return false;
        }
        PsiClass beanClass = PsiTypesUtil.getPsiClass((PsiType)beanType);
        if (beanClass != null && SpringFactoryBeansManager.getInstance().isFactoryBeanClass(beanClass)) {
            SpringFactoryBeansManager manager = SpringFactoryBeansManager.getInstance();
            return !manager.isKnownBeanFactory(beanClass.getQualifiedName()) || manager.getObjectTypes(beanType, context).length == 0;
        }
        return false;
    }

    @Nullable
    private static PsiClass resolvePsiClass(PsiType psiType, Module module) {
        if (psiType instanceof PsiClassType) {
            return ((PsiClassType)psiType).resolve();
        }
        if (psiType instanceof PsiPrimitiveType && module != null) {
            GlobalSearchScope scope = SpringGlobalSearchScopes.runtime(module, false);
            PsiManager psiManager = PsiManager.getInstance((Project)module.getProject());
            PsiClassType boxedType = ((PsiPrimitiveType)psiType).getBoxedType(psiManager, scope);
            if (boxedType != null) {
                return boxedType.resolve();
            }
        }
        return null;
    }

    public static String[] suggestBeanNames(@Nullable CommonSpringBean springBean) {
        if (springBean == null) {
            return ArrayUtilRt.EMPTY_STRING_ARRAY;
        }
        PsiClass beanClass = PsiTypesUtil.getPsiClass((PsiType)springBean.getBeanType());
        if (beanClass == null) {
            return ArrayUtilRt.EMPTY_STRING_ARRAY;
        }
        JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)beanClass.getProject());
        LinkedHashSet<String> initialNames = new LinkedHashSet<String>();
        Collection<PsiType> productClasses = BeanService.getInstance().getEffectiveBeanTypes(springBean);
        for (PsiType productType : productClasses) {
            Set<String> suggestions = SpringBeanCoreUtils.getSanitizedBeanNameSuggestions(codeStyleManager, productType);
            initialNames.addAll(suggestions);
        }
        CommonSpringModel model = SpringModelUtils.getInstance().getSpringModelByBean(springBean);
        ArrayList<String> uniqueNames = new ArrayList<String>();
        for (String name : initialNames) {
            String suggestedName = UniqueNameGenerator.generateUniqueName((String)name, n -> !uniqueNames.contains(n) && SpringModelSearchers.findBean(model, n) == null);
            uniqueNames.add(suggestedName);
        }
        return ArrayUtilRt.toStringArray(uniqueNames);
    }

    public static Set<String> getSanitizedBeanNameSuggestions(JavaCodeStyleManager codeStyleManager, PsiType beanType) {
        SuggestedNameInfo nameInfo = codeStyleManager.suggestVariableName(VariableKind.PARAMETER, null, null, beanType);
        String prefix = codeStyleManager.getPrefixByVariableKind(VariableKind.PARAMETER);
        String suffix = codeStyleManager.getSuffixByVariableKind(VariableKind.PARAMETER);
        LinkedHashSet<String> sanitizedNames = new LinkedHashSet<String>();
        for (String name : nameInfo.names) {
            String stripPrefix = StringUtil.trimStart((String)name, (String)prefix);
            String stripSuffix = StringUtil.trimEnd((String)stripPrefix, (String)suffix);
            String lowercaseStrip = StringUtil.decapitalize((String)stripSuffix);
            sanitizedNames.add(lowercaseStrip);
        }
        return sanitizedNames;
    }

    @Nullable
    public static DomSpringBean getSpringBeanForCurrentCaretPosition(Editor editor, PsiFile file) {
        int offset = editor.getCaretModel().getOffset();
        PsiElement element = file.findElementAt(offset);
        return SpringBeanCoreUtils.findBeanByPsiElement(element);
    }

    @Nullable
    public static DomSpringBean findBeanByPsiElement(PsiElement element) {
        return (DomSpringBean)DomUtil.findDomElement((PsiElement)element, DomSpringBean.class);
    }

    @NotNull
    public static DomSpringBean getTopLevelBean(@NotNull DomSpringBean bean) {
        DomElement parent;
        if (bean == null) {
            SpringBeanCoreUtils.$$$reportNull$$$0(12);
        }
        if ((parent = bean.getParent()) instanceof Beans) {
            DomSpringBean domSpringBean = bean;
            if (domSpringBean == null) {
                SpringBeanCoreUtils.$$$reportNull$$$0(13);
            }
            return domSpringBean;
        }
        SpringBean parentBean = (SpringBean)bean.getParentOfType(SpringBean.class, true);
        assert (parentBean != null) : bean;
        return SpringBeanCoreUtils.getTopLevelBean(parentBean);
    }

    public static boolean visitParents(SpringBean springBean, boolean strict, Processor<? super SpringBean> processor2) {
        if (!processor2.process((Object)springBean)) {
            return false;
        }
        GenericAttributeValue<SpringBeanPointer<?>> parentBean = springBean.getParentBean();
        if (!DomUtil.hasXml(parentBean)) {
            return true;
        }
        SpringBeanPointer parent = (SpringBeanPointer)parentBean.getValue();
        if (parent == null) {
            return true;
        }
        HashSet<SpringBean> visited = new HashSet<SpringBean>(3);
        if (!strict) {
            visited.add(springBean);
        }
        Object bean = parent.getSpringBean();
        while (bean instanceof SpringBean) {
            if (!processor2.process((Object)((SpringBean)bean))) {
                return false;
            }
            GenericAttributeValue<SpringBeanPointer<?>> nextParentBean = ((SpringBean)bean).getParentBean();
            if (!DomUtil.hasXml(nextParentBean)) {
                return true;
            }
            parent = (SpringBeanPointer)nextParentBean.getValue();
            if (parent == null) {
                return true;
            }
            bean = parent.getSpringBean();
            if (visited.contains(bean)) {
                return true;
            }
            visited.add((SpringBean)bean);
        }
        return true;
    }

    public static <T extends GenericDomValue<?>> T getMergedValue(SpringBean springBean, T value) {
        AbstractDomChildrenDescription description = value.getChildDescription();
        Ref ref = new Ref(value);
        SpringBeanCoreUtils.visitParents(springBean, false, (Processor<? super SpringBean>)((Processor)parentSpringBean -> {
            GenericDomValue t;
            List list = description.getValues((DomElement)parentSpringBean);
            if (list.size() == 1 && DomUtil.hasXml((DomElement)(t = (GenericDomValue)list.get(0)))) {
                ref.set((Object)t);
                return false;
            }
            return true;
        }));
        return (T)((GenericDomValue)ref.get());
    }

    public static <T extends DomElement> Set<T> getMergedSet(SpringBean springBean, Function<? super SpringBean, ? extends Collection<T>> getter) {
        LinkedHashSet set = new LinkedHashSet();
        SpringBeanCoreUtils.visitParents(springBean, false, (Processor<? super SpringBean>)((Processor)parentSpringBean -> {
            set.addAll((Collection)getter.fun(parentSpringBean));
            return true;
        }));
        return set;
    }

    @NotNull
    public static List<SpringBeanPointer<?>> getBeansByType(PsiType type, CommonSpringModel model) {
        PsiClass psiClass = PsiTypesUtil.getPsiClass((PsiType)type);
        if (SpringCommonUtils.isSpringBeanCandidateClass(psiClass)) {
            List<SpringBeanPointer<?>> list = SpringModelSearchers.findBeans(model, SpringModelSearchParameters.byClass(psiClass).withInheritors().effectiveBeanTypes());
            if (list == null) {
                SpringBeanCoreUtils.$$$reportNull$$$0(14);
            }
            return list;
        }
        List<SpringBeanPointer<?>> list = Collections.emptyList();
        if (list == null) {
            SpringBeanCoreUtils.$$$reportNull$$$0(15);
        }
        return list;
    }

    @NotNull
    public static List<SpringBeanPointer<?>> findBeansByClassName(@NotNull Collection<? extends SpringBeanPointer<?>> beans, @NotNull String className) {
        if (beans == null) {
            SpringBeanCoreUtils.$$$reportNull$$$0(16);
        }
        if (className == null) {
            SpringBeanCoreUtils.$$$reportNull$$$0(17);
        }
        SmartList result2 = new SmartList();
        for (SpringBeanPointer<?> bean : beans) {
            PsiClass beanClass = bean.getBeanClass();
            if (beanClass == null || !className.equals(beanClass.getQualifiedName())) continue;
            result2.add(bean);
        }
        SmartList smartList = result2;
        if (smartList == null) {
            SpringBeanCoreUtils.$$$reportNull$$$0(18);
        }
        return smartList;
    }

    @NotNull
    public static Set<PsiType> getFactoryBeanTypes(@NotNull PsiType factoryBeanType, @Nullable CommonSpringBean bean) {
        PsiClass psiClass;
        if (factoryBeanType == null) {
            SpringBeanCoreUtils.$$$reportNull$$$0(19);
        }
        LinkedHashSet<PsiType> types = new LinkedHashSet<PsiType>();
        if (factoryBeanType instanceof PsiClassType && (psiClass = ((PsiClassType)factoryBeanType).resolve()) != null && SpringFactoryBeansManager.getInstance().isFactoryBeanClass(psiClass)) {
            if ("org.springframework.beans.factory.FactoryBean".equals(psiClass.getQualifiedName())) {
                ContainerUtil.addIfNotNull(types, (Object)PsiUtil.substituteTypeParameter((PsiType)factoryBeanType, (String)"org.springframework.beans.factory.FactoryBean", (int)0, (boolean)false));
            } else {
                ContainerUtil.addAllNotNull(types, (Object[])SpringFactoryBeansManager.getInstance().getObjectTypes(factoryBeanType, bean));
            }
        }
        LinkedHashSet<PsiType> linkedHashSet = types;
        if (linkedHashSet == null) {
            SpringBeanCoreUtils.$$$reportNull$$$0(20);
        }
        return linkedHashSet;
    }

    @NotNull
    public static Set<PsiType> convertToNonNullTypes(@NotNull String fqn, @Nullable CommonSpringBean context) {
        if (fqn == null) {
            SpringBeanCoreUtils.$$$reportNull$$$0(21);
        }
        return context == null ? Collections.emptySet() : SpringBeanCoreUtils.convertToNonNullTypes(Collections.singleton(fqn), context);
    }

    @NotNull
    public static Set<PsiType> convertToNonNullTypes(@NotNull Set<String> names2, @NotNull CommonSpringBean context) {
        PsiElement identifyingPsiElement;
        if (names2 == null) {
            SpringBeanCoreUtils.$$$reportNull$$$0(22);
        }
        if (context == null) {
            SpringBeanCoreUtils.$$$reportNull$$$0(23);
        }
        if ((identifyingPsiElement = context.getIdentifyingPsiElement()) == null || !identifyingPsiElement.isValid()) {
            Set<PsiType> set = Collections.emptySet();
            if (set == null) {
                SpringBeanCoreUtils.$$$reportNull$$$0(24);
            }
            return set;
        }
        Project project = identifyingPsiElement.getProject();
        Set<PsiType> set = names2.stream().map(s -> {
            if (StringUtil.isEmptyOrSpaces((String)s)) {
                return null;
            }
            PsiClass aClass = JavaPsiFacade.getInstance((Project)project).findClass(s, identifyingPsiElement.getContainingFile().getResolveScope());
            if (aClass != null) {
                return PsiTypesUtil.getClassType((PsiClass)aClass);
            }
            try {
                return JavaPsiFacade.getElementFactory((Project)project).createTypeFromText(s, identifyingPsiElement);
            }
            catch (IncorrectOperationException ignored) {
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toSet());
        if (set == null) {
            SpringBeanCoreUtils.$$$reportNull$$$0(25);
        }
        return set;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 6, 8, 9, 13, 14, 15, 18, 20, 24, 25 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bean";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allBeans";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiTypes";
                break;
            }
            case 3: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 13: 
            case 14: 
            case 15: 
            case 18: 
            case 20: 
            case 24: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/model/utils/SpringBeanCoreUtils";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "customEditorClasses";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "beans";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "className";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factoryBeanType";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqn";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "names";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/model/utils/SpringBeanCoreUtils";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getRequiredClasses";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getCustomEditorConvertableClasses";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getTopLevelBean";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getBeansByType";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "findBeansByClassName";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getFactoryBeanTypes";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "convertToNonNullTypes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getReferencedName";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isEffectiveClassType";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 13: 
            case 14: 
            case 15: 
            case 18: 
            case 20: 
            case 24: 
            case 25: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isCustomEditorRegistered";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "addPsiClass";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getTopLevelBean";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "findBeansByClassName";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getFactoryBeanTypes";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "convertToNonNullTypes";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 6, 8, 9, 13, 14, 15, 18, 20, 24, 25 -> new IllegalStateException(string);
        };
    }
}

