/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.values;

import com.intellij.codeInsight.highlighting.HighlightedReference;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixProvider;
import com.intellij.jam.JamService;
import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.lang.properties.psi.Property;
import com.intellij.lang.properties.psi.PropertyKeyIndex;
import com.intellij.lang.properties.references.CreatePropertyFix;
import com.intellij.lang.properties.references.PropertyReferenceBase;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.pom.references.PomService;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiTarget;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.SpringModelVisitorUtils;
import com.intellij.spring.SpringModificationTrackersManager;
import com.intellij.spring.contexts.model.LocalAnnotationModel;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.contexts.model.visitors.CommonSpringModelVisitorContext;
import com.intellij.spring.contexts.model.visitors.SpringModelVisitors;
import com.intellij.spring.facet.SpringFileSet;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.SpringModelSearchParameters;
import com.intellij.spring.model.jam.stereotype.SpringConfiguration;
import com.intellij.spring.model.jam.stereotype.SpringJamPropertySource;
import com.intellij.spring.model.jam.stereotype.SpringPropertySource;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.model.utils.SpringModelSearchers;
import com.intellij.spring.model.utils.SpringModelUtils;
import com.intellij.spring.model.utils.SpringPropertyUtils;
import com.intellij.spring.model.values.PlaceholderInfo;
import com.intellij.spring.model.values.PlaceholderUtils;
import com.intellij.spring.model.values.SpringPlaceholderPropertyReference;
import com.intellij.spring.model.values.SpringPlaceholderReferenceResolver;
import com.intellij.spring.model.xml.beans.Prop;
import com.intellij.spring.model.xml.beans.SpringEntry;
import com.intellij.spring.model.xml.beans.SpringProperty;
import com.intellij.spring.model.xml.beans.SpringPropertyDefinition;
import com.intellij.spring.model.xml.context.PropertyPlaceholder;
import com.intellij.util.ArrayUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomElement;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlaceholderPropertyReference
extends PropertyReferenceBase
implements LocalQuickFixProvider,
HighlightedReference,
SpringPlaceholderPropertyReference {
    private final PlaceholderInfo myInfo;
    @Nullable
    private final String myDefaultValue;

    private PlaceholderPropertyReference(@NotNull String key, PsiElement element, TextRange textRange, PlaceholderInfo info, @Nullable String defaultValue, boolean soft) {
        if (key == null) {
            PlaceholderPropertyReference.$$$reportNull$$$0(0);
        }
        super(key, soft, element, textRange);
        this.myInfo = info;
        this.myDefaultValue = defaultValue;
    }

    @Override
    @Nullable
    public String getDefaultValue() {
        return this.myDefaultValue;
    }

    public boolean isHighlightedWhenSoft() {
        return true;
    }

    static PlaceholderPropertyReference create(PsiElement element, TextRange textRange, PlaceholderInfo info, boolean soft) {
        String text = info.text;
        if (text.contains(":")) {
            int offset = textRange.getStartOffset();
            int endOffset = text.indexOf(":");
            String key = text.substring(0, endOffset);
            String defaultValue = text.substring(endOffset + 1);
            return new PlaceholderPropertyReference(key, element, TextRange.from((int)offset, (int)endOffset), info, defaultValue, soft);
        }
        return new PlaceholderPropertyReference(text, element, textRange, info, null, soft);
    }

    @NotNull
    private static Properties getValueProperties(SpringProperty property) {
        Properties props = new Properties();
        String value = property.getValue().getStringValue();
        if (!StringUtil.isEmptyOrSpaces((String)value)) {
            try {
                props.load(new StringReader(value));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        Properties properties = props;
        if (properties == null) {
            PlaceholderPropertyReference.$$$reportNull$$$0(1);
        }
        return properties;
    }

    public ResolveResult @NotNull [] multiResolve(boolean incompleteCode) {
        HashSet properties = new HashSet();
        Processor processor2 = propertiesFile -> {
            properties.addAll(propertiesFile.findPropertiesByKey(this.myKey));
            return true;
        };
        HashSet<DomElement> configurerProperties = new HashSet<DomElement>();
        CommonSpringModel springModel = SpringModelUtils.getInstance().getSpringModel(this.myElement);
        List<SpringBeanPointer<?>> placeholders = this.getPlaceholders(springModel);
        if (!placeholders.isEmpty()) {
            configurerProperties.addAll(this.getPlaceholderConfigurerProperties(this.myKey, placeholders));
            PlaceholderPropertyReference.processXmlProperties((Processor<? super PropertiesFile>)processor2, placeholders);
        }
        HashSet additionalProperties = new HashSet();
        HashSet processedFiles = new HashSet();
        for (SpringPlaceholderReferenceResolver placeholderReferenceResolver : SpringPlaceholderReferenceResolver.EP_NAME.getExtensionList()) {
            Pair<List<PsiElement>, List<VirtualFile>> resolveResult = placeholderReferenceResolver.resolve((PsiReference)this);
            additionalProperties.addAll((Collection)resolveResult.first);
            processedFiles.addAll((Collection)resolveResult.second);
        }
        for (PropertiesFile propertiesFile2 : PlaceholderPropertyReference.getPropertiesFiles(springModel)) {
            if (processedFiles.contains(propertiesFile2.getVirtualFile())) continue;
            processor2.process((Object)propertiesFile2);
        }
        ResolveResult[] result2 = new ResolveResult[properties.size() + configurerProperties.size() + additionalProperties.size()];
        if (!(properties.isEmpty() && configurerProperties.isEmpty() && additionalProperties.isEmpty())) {
            int i = 0;
            for (IProperty property : properties) {
                result2[i++] = new PsiElementResolveResult(property instanceof PsiElement ? (PsiElement)property : PomService.convertToPsi((PsiTarget)((PsiTarget)property)));
            }
            for (DomElement configurerProperty : configurerProperties) {
                result2[i++] = new PsiElementResolveResult((PsiElement)Objects.requireNonNull(configurerProperty.getXmlElement()));
            }
            for (PsiElement additionalProperty : additionalProperties) {
                result2[i++] = new PsiElementResolveResult(additionalProperty);
            }
        } else if (System.getProperties().getProperty(this.myKey) != null) {
            ResolveResult[] resolveResultArray = new ResolveResult[]{new PsiElementResolveResult(this.getElement())};
            if (resolveResultArray == null) {
                PlaceholderPropertyReference.$$$reportNull$$$0(2);
            }
            return resolveResultArray;
        }
        if (result2 == null) {
            PlaceholderPropertyReference.$$$reportNull$$$0(3);
        }
        return result2;
    }

    @NotNull
    private static Collection<PropertiesFile> getPropertiesFiles(CommonSpringModel springModel) {
        return springModel instanceof UserDataHolder ? PlaceholderPropertyReference.getCachedPropertiesFiles(springModel) : PlaceholderPropertyReference.getFiles(springModel);
    }

    @NotNull
    private static Collection<PropertiesFile> getCachedPropertiesFiles(@NotNull CommonSpringModel springModel) {
        Module module;
        if (springModel == null) {
            PlaceholderPropertyReference.$$$reportNull$$$0(4);
        }
        Collection<Object> collection = (module = springModel.getModule()) != null && springModel instanceof UserDataHolder ? (Collection)CachedValuesManager.getManager((Project)module.getProject()).getCachedValue((UserDataHolder)springModel, () -> CachedValueProvider.Result.create(PlaceholderPropertyReference.getFiles(springModel), (Object[])SpringModificationTrackersManager.getInstance(springModel.getModule().getProject()).getOuterModelsDependencies())) : Collections.emptyList();
        if (collection == null) {
            PlaceholderPropertyReference.$$$reportNull$$$0(5);
        }
        return collection;
    }

    @NotNull
    private static Collection<PropertiesFile> getFiles(@NotNull CommonSpringModel springModel) {
        if (springModel == null) {
            PlaceholderPropertyReference.$$$reportNull$$$0(6);
        }
        CommonProcessors.CollectProcessor processor2 = new CommonProcessors.CollectProcessor();
        PlaceholderPropertyReference.processEmbeddedPropertySources((Processor<? super PropertiesFile>)processor2, springModel);
        Module module = springModel.getModule();
        if (module != null) {
            PlaceholderPropertyReference.processCommonModel(module.getProject(), (Processor<? super PropertiesFile>)processor2, springModel);
        }
        Collection collection = processor2.getResults();
        if (collection == null) {
            PlaceholderPropertyReference.$$$reportNull$$$0(7);
        }
        return collection;
    }

    public static void processCommonModel(@NotNull Project project, @NotNull Processor<? super PropertiesFile> processor2, @NotNull CommonSpringModel springModel) {
        if (project == null) {
            PlaceholderPropertyReference.$$$reportNull$$$0(8);
        }
        if (processor2 == null) {
            PlaceholderPropertyReference.$$$reportNull$$$0(9);
        }
        if (springModel == null) {
            PlaceholderPropertyReference.$$$reportNull$$$0(10);
        }
        SpringModelVisitors.visitRelatedModels(springModel, CommonSpringModelVisitorContext.context(processor2, (model, params) -> {
            if (model instanceof SpringModel) {
                return PlaceholderPropertyReference.processFilesetCustomPropertiesFiles(processor2, ((SpringModel)model).getFileSet(), project);
            }
            if (model instanceof LocalAnnotationModel) {
                return PlaceholderPropertyReference.processLocalAnnotationModelPropertySources(project, processor2, (LocalAnnotationModel)model);
            }
            return true;
        }));
    }

    private static boolean processLocalAnnotationModelPropertySources(@NotNull Project project, @NotNull Processor<? super PropertiesFile> processor2, @NotNull LocalAnnotationModel model) {
        SpringConfiguration configuration;
        if (project == null) {
            PlaceholderPropertyReference.$$$reportNull$$$0(11);
        }
        if (processor2 == null) {
            PlaceholderPropertyReference.$$$reportNull$$$0(12);
        }
        if (model == null) {
            PlaceholderPropertyReference.$$$reportNull$$$0(13);
        }
        if ((configuration = (SpringConfiguration)JamService.getJamService((Project)project).getJamElement(SpringConfiguration.JAM_KEY, (PsiElement)model.getConfig())) != null) {
            for (SpringPropertySource source : configuration.getPropertySources()) {
                for (PropertiesFile propertiesFile : source.getPropertiesFiles()) {
                    if (processor2.process((Object)propertiesFile)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private static boolean processFilesetCustomPropertiesFiles(@NotNull Processor<? super PropertiesFile> processor2, @Nullable SpringFileSet fileSet, @NotNull Project project) {
        if (processor2 == null) {
            PlaceholderPropertyReference.$$$reportNull$$$0(14);
        }
        if (project == null) {
            PlaceholderPropertyReference.$$$reportNull$$$0(15);
        }
        if (fileSet == null) {
            return true;
        }
        Set<VirtualFilePointer> files = fileSet.getPropertiesFiles();
        for (VirtualFilePointer pointer : files) {
            PsiFile psiFile;
            VirtualFile virtualFile = pointer.getFile();
            if (virtualFile == null || !((psiFile = PsiManager.getInstance((Project)project).findFile(virtualFile)) instanceof PropertiesFile) || processor2.process((Object)((PropertiesFile)psiFile))) continue;
            return false;
        }
        return true;
    }

    static void processEmbeddedPropertySources(@NotNull Processor<? super PropertiesFile> processor2, @NotNull CommonSpringModel model) {
        if (processor2 == null) {
            PlaceholderPropertyReference.$$$reportNull$$$0(16);
        }
        if (model == null) {
            PlaceholderPropertyReference.$$$reportNull$$$0(17);
        }
        List<SpringJamPropertySource> propertySources = PlaceholderPropertyReference.getPropertySources(model);
        for (SpringJamPropertySource propertySource : propertySources) {
            for (PropertiesFile file : propertySource.getPropertiesFiles()) {
                processor2.process((Object)file);
            }
        }
    }

    @NotNull
    private static List<SpringJamPropertySource> getPropertySources(CommonSpringModel model) {
        List list = ContainerUtil.filter(SpringCommonUtils.getPropertySources(model.getModule()), source -> {
            PsiClass psiClass = (PsiClass)source.getPsiElement();
            return psiClass.isValid() && SpringCommonUtils.isSpringBeanCandidateClass(psiClass) && SpringModelSearchers.doesBeanExist(model, SpringModelSearchParameters.byClass(psiClass));
        });
        if (list == null) {
            PlaceholderPropertyReference.$$$reportNull$$$0(18);
        }
        return list;
    }

    static void processXmlProperties(@NotNull Processor<? super PropertiesFile> processor2, @NotNull List<? extends SpringBeanPointer<?>> placeholders) {
        if (processor2 == null) {
            PlaceholderPropertyReference.$$$reportNull$$$0(19);
        }
        if (placeholders == null) {
            PlaceholderPropertyReference.$$$reportNull$$$0(20);
        }
        for (PropertiesFile resource : PlaceholderUtils.getInstance().getResources(placeholders)) {
            if (!processor2.process((Object)resource)) break;
        }
    }

    @NotNull
    private Set<DomElement> getPlaceholderConfigurerProperties(@NotNull String key, @NotNull List<SpringBeanPointer<?>> placeholders) {
        Set set;
        if (key == null) {
            PlaceholderPropertyReference.$$$reportNull$$$0(21);
        }
        if (placeholders == null) {
            PlaceholderPropertyReference.$$$reportNull$$$0(22);
        }
        Set set2 = (set = (Set)RecursionManager.doPreventingRecursion((Object)this, (boolean)true, () -> PlaceholderPropertyReference.getAllPlaceholderConfigurerProperties(placeholders).get(key))) == null ? Collections.emptySet() : set;
        if (set2 == null) {
            PlaceholderPropertyReference.$$$reportNull$$$0(23);
        }
        return set2;
    }

    @NotNull
    static Map<String, Set<DomElement>> getAllPlaceholderConfigurerProperties(List<? extends SpringBeanPointer<?>> placeholders) {
        HashMap<String, Set<DomElement>> all = new HashMap<String, Set<DomElement>>();
        for (SpringBeanPointer<?> placeholder : placeholders) {
            PropertyPlaceholder propertyPlaceholder;
            SpringBeanPointer propertyBeanHolder;
            Object placeholderBean = placeholder.getSpringBean();
            PlaceholderPropertyReference.addProperties(all, placeholderBean);
            if (!(placeholderBean instanceof PropertyPlaceholder) || (propertyBeanHolder = (SpringBeanPointer)(propertyPlaceholder = (PropertyPlaceholder)placeholderBean).getPropertiesRef().getValue()) == null) continue;
            PlaceholderPropertyReference.addProperties(all, propertyBeanHolder.getSpringBean());
        }
        HashMap<String, Set<DomElement>> hashMap = all;
        if (hashMap == null) {
            PlaceholderPropertyReference.$$$reportNull$$$0(24);
        }
        return hashMap;
    }

    private static void addProperties(Map<String, Set<DomElement>> all, CommonSpringBean bean) {
        SpringPropertyDefinition propertyDefinition = SpringPropertyUtils.findPropertyByName(bean, "properties");
        if (propertyDefinition instanceof SpringProperty) {
            for (Prop prop : ((SpringProperty)propertyDefinition).getProps().getProps()) {
                String propKey = prop.getKey().getStringValue();
                if (StringUtil.isEmptyOrSpaces((String)propKey)) continue;
                if (!all.containsKey(propKey)) {
                    all.put(propKey, new HashSet());
                }
                all.get(propKey).add((DomElement)prop);
            }
            for (SpringEntry springEntry : ((SpringProperty)propertyDefinition).getMap().getEntries()) {
                String keyAttr = springEntry.getKeyAttr().getStringValue();
                if (StringUtil.isEmptyOrSpaces((String)keyAttr)) continue;
                if (!all.containsKey(keyAttr)) {
                    all.put(keyAttr, new HashSet());
                }
                all.get(keyAttr).add(springEntry);
            }
            for (Object object : PlaceholderPropertyReference.getValueProperties((SpringProperty)propertyDefinition).keySet()) {
                if (!(object instanceof String)) continue;
                if (!all.containsKey(object)) {
                    all.put((String)object, new HashSet());
                }
                all.get(object).add(((SpringProperty)propertyDefinition).getValue());
            }
        }
    }

    public @NotNull LocalQuickFix @Nullable [] getQuickFixes() {
        CommonSpringModel model = SpringModelUtils.getInstance().getSpringModel(this.myElement);
        List<SpringBeanPointer<?>> placeholders = this.getPlaceholders(model);
        Set<PropertiesFile> resources = PlaceholderUtils.getInstance().getResources(placeholders);
        return new LocalQuickFix[]{new CreatePropertyFix(this.getElement(), this.myKey, new ArrayList<PropertiesFile>(resources))};
    }

    public List<SpringBeanPointer<?>> getPlaceholders(@NotNull CommonSpringModel model) {
        if (model == null) {
            PlaceholderPropertyReference.$$$reportNull$$$0(25);
        }
        SmartList placeholders = new SmartList();
        for (SpringBeanPointer<?> pointer : PlaceholderPropertyReference.getConfigurers(model, this.myElement.getProject())) {
            Pair<String, String> pair;
            if (!pointer.isValid() || !this.myInfo.prefixAndSuffix.equals(pair = PlaceholderUtils.getInstance().getPlaceholderPrefixAndSuffixInner(pointer))) continue;
            placeholders.add(pointer);
        }
        return placeholders;
    }

    @NotNull
    private static Set<SpringBeanPointer<?>> getConfigurers(@NotNull CommonSpringModel model, @NotNull Project project) {
        if (model == null) {
            PlaceholderPropertyReference.$$$reportNull$$$0(26);
        }
        if (project == null) {
            PlaceholderPropertyReference.$$$reportNull$$$0(27);
        }
        if (model instanceof UserDataHolder) {
            Set set = (Set)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)model, () -> {
                Set<SpringBeanPointer<?>> configurers = SpringModelVisitorUtils.getPlaceholderConfigurers(model);
                return CachedValueProvider.Result.create(configurers, (Object[])PlaceholderPropertyReference.getDependencies(model.getModule(), configurers));
            });
            if (set == null) {
                PlaceholderPropertyReference.$$$reportNull$$$0(28);
            }
            return set;
        }
        Set<SpringBeanPointer<?>> set = SpringModelVisitorUtils.getPlaceholderConfigurers(model);
        if (set == null) {
            PlaceholderPropertyReference.$$$reportNull$$$0(29);
        }
        return set;
    }

    private static Object @NotNull [] getDependencies(@Nullable Module module, Collection<? extends SpringBeanPointer<?>> configurers) {
        Object[] objectArray;
        LinkedHashSet dependencies = new LinkedHashSet();
        ContainerUtil.addAllNotNull(dependencies, (Iterable)configurers.stream().map(pointer -> pointer.getContainingFile()).collect(Collectors.toSet()));
        if (module == null) {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = ModificationTracker.EVER_CHANGED;
        } else {
            objectArray = SpringModificationTrackersManager.getInstance(module.getProject()).getOuterModelsDependencies();
        }
        ContainerUtil.addAll(dependencies, (Object[])objectArray);
        Object[] objectArray3 = ArrayUtil.toObjectArray(dependencies);
        if (objectArray3 == null) {
            PlaceholderPropertyReference.$$$reportNull$$$0(30);
        }
        return objectArray3;
    }

    public TextRange getFullTextRange() {
        return this.myInfo.fullTextRange;
    }

    @Nullable
    protected List<PropertiesFile> getPropertiesFiles() {
        return null;
    }

    protected boolean isProperty(PsiElement element) {
        if (super.isProperty(element)) {
            return true;
        }
        for (SpringPlaceholderReferenceResolver placeholderReferenceResolver : SpringPlaceholderReferenceResolver.EP_NAME.getExtensionList()) {
            if (!placeholderReferenceResolver.isProperty(element)) continue;
            return true;
        }
        return false;
    }

    @Override
    @Nullable
    public String getFoldingValue() {
        for (SpringPlaceholderReferenceResolver placeholderReferenceResolver : SpringPlaceholderReferenceResolver.EP_NAME.getExtensionList()) {
            String value = placeholderReferenceResolver.getFoldingValue((PsiReference)this);
            if (value == null) continue;
            return value;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)this.myElement);
        if (module == null) {
            return null;
        }
        GlobalSearchScope scope = PlaceholderPropertyReference.getScope(module);
        Project project = this.myElement.getProject();
        String key = this.getCanonicalText();
        List<Property> properties = PlaceholderPropertyReference.sortProperties(PropertyKeyIndex.getInstance().getProperties(key, project, scope));
        for (Property property : properties) {
            String value = property.getUnescapedValue();
            if (value == null) continue;
            return value;
        }
        return null;
    }

    private static GlobalSearchScope getScope(Module module) {
        HashSet modules = new HashSet();
        ModuleUtilCore.collectModulesDependsOn((Module)module, modules);
        modules.remove(module);
        GlobalSearchScope moduleScope = module.getModuleWithDependenciesAndLibrariesScope(false);
        if (modules.isEmpty()) {
            return moduleScope;
        }
        return GlobalSearchScope.union((GlobalSearchScope[])new GlobalSearchScope[]{moduleScope, GlobalSearchScope.union((Collection)ContainerUtil.map(modules, m -> m.getModuleScope()))});
    }

    private static List<Property> sortProperties(Collection<Property> properties) {
        ArrayList<Property> sorted = new ArrayList<Property>(properties);
        Collections.sort(sorted, (p1, p2) -> {
            String path2;
            String path1 = PlaceholderPropertyReference.getContainingPath((PsiElement)p1);
            int result2 = StringUtil.compare((String)path1, (String)(path2 = PlaceholderPropertyReference.getContainingPath((PsiElement)p2)), (boolean)false);
            return result2 == 0 ? p1.getTextOffset() - p2.getTextOffset() : result2;
        });
        return sorted;
    }

    @Nullable
    private static String getContainingPath(@NotNull PsiElement psiElement) {
        PsiFile containingFile;
        if (psiElement == null) {
            PlaceholderPropertyReference.$$$reportNull$$$0(31);
        }
        if ((containingFile = psiElement.getContainingFile()) == null) {
            return null;
        }
        VirtualFile virtualFile = containingFile.getOriginalFile().getVirtualFile();
        if (virtualFile == null) {
            return null;
        }
        return virtualFile.getPath();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 5, 7, 18, 23, 24, 28, 29, 30 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 18: 
            case 23: 
            case 24: 
            case 28: 
            case 29: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/model/values/PlaceholderPropertyReference";
                break;
            }
            case 4: 
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "springModel";
                break;
            }
            case 8: 
            case 11: 
            case 15: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 9: 
            case 12: 
            case 14: 
            case 16: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 13: 
            case 17: 
            case 25: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "placeholders";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/model/values/PlaceholderPropertyReference";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueProperties";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "multiResolve";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getCachedPropertiesFiles";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getFiles";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getPropertySources";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getPlaceholderConfigurerProperties";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllPlaceholderConfigurerProperties";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurers";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getDependencies";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 18: 
            case 23: 
            case 24: 
            case 28: 
            case 29: 
            case 30: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getCachedPropertiesFiles";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getFiles";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "processCommonModel";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "processLocalAnnotationModelPropertySources";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "processFilesetCustomPropertiesFiles";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "processEmbeddedPropertySources";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "processXmlProperties";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getPlaceholderConfigurerProperties";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getPlaceholders";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getConfigurers";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getContainingPath";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 5, 7, 18, 23, 24, 28, 29, 30 -> new IllegalStateException(string);
        };
    }
}

