/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.persistence.integration.hibernate;

import com.intellij.hibernate.facet.HibernateFacet;
import com.intellij.openapi.module.Module;
import com.intellij.persistence.PersistenceHelper;
import com.intellij.persistence.model.manipulators.AbstractPersistenceManipulator;
import com.intellij.persistence.model.manipulators.ManipulatorsRegistry;
import com.intellij.persistence.model.manipulators.PersistenceAction;
import com.intellij.persistence.model.manipulators.PersistenceFacetManipulator;
import com.intellij.persistence.model.manipulators.PersistenceManipulator;
import com.intellij.psi.xml.XmlFile;
import com.intellij.spring.SpringManager;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.contexts.model.XmlSpringModel;
import com.intellij.spring.dom.SpringDomUtils;
import com.intellij.spring.model.xml.beans.Beans;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomFileElement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public final class HibernateFacetManipulator
extends AbstractPersistenceManipulator<HibernateFacet>
implements PersistenceFacetManipulator<HibernateFacet> {
    public HibernateFacetManipulator(HibernateFacet target) {
        super((Object)target);
    }

    public List<PersistenceAction> getCreateActions() {
        Module module = ((HibernateFacet)this.getManipulatorTarget()).getModule();
        HashSet<XmlFile> files = new HashSet<XmlFile>();
        for (SpringModel springModel : SpringManager.getInstance(module.getProject()).getAllModels(module)) {
            if (!(springModel instanceof XmlSpringModel)) continue;
            files.addAll(((XmlSpringModel)springModel).getXmlConfigFiles());
        }
        ArrayList<PersistenceAction> result2 = new ArrayList<PersistenceAction>();
        ManipulatorsRegistry manipulatorsRegistry = PersistenceHelper.getHelper().getManipulatorsRegistry();
        for (XmlFile file : files) {
            Class<PersistenceManipulator> aClass;
            DomElement element;
            PersistenceManipulator manipulator;
            DomFileElement<Beans> fileElement = SpringDomUtils.getSpringDomFileElement(file);
            if (fileElement == null || (manipulator = manipulatorsRegistry.getManipulator((Object)(element = fileElement.getRootElement()), aClass = PersistenceManipulator.class)) == null) continue;
            result2.addAll(manipulator.getCreateActions());
        }
        return result2;
    }
}

